/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class PixelMessageDigest {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/PixelMessageDigest.java,v 1.6 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(PixelMessageDigest.class);

    public byte[] computePixelMessageDigestFromFrames(File file) throws DicomException, IOException, NoSuchAlgorithmException {
        slf4jlogger.info("computePixelMessageDigestFromFrames(): inputFile = {}", file);
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(file);
        SourceImage sourceImage = new SourceImage(attributeList);
        int n = sourceImage.getNumberOfFrames();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = sourceImage.getBufferedImage(i, false);
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug(BufferedImageUtilities.describeImage(bufferedImage));
            }
            byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            messageDigest.update(byArray);
        }
        return messageDigest.digest();
    }

    public PixelMessageDigest(String string) throws DicomException, IOException, NoSuchAlgorithmException {
        byte[] byArray = this.computePixelMessageDigestFromFrames(new File(string));
        if (byArray != null) {
            slf4jlogger.info("Digest={}", DatatypeConverter.printHexBinary((byte[])byArray).toLowerCase());
        }
    }

    public static void main(String[] stringArray) {
        try {
            new PixelMessageDigest(stringArray[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

