/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompressedFrameEncoder;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.OtherByteAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherWordAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SignedLongAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TiledFramesIndex;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TiledPyramid {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/TiledPyramid.java,v 1.25 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TiledPyramid.class);
    protected UIDGenerator generator = new UIDGenerator();

    protected static void updateImageOrFrameType(AttributeList attributeList, AttributeList attributeList2, AttributeTag attributeTag) throws DicomException {
        String[] stringArray = null;
        int n = 0;
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null) {
            stringArray = attribute.getStringValues();
            n = stringArray.length;
        }
        if (n < 4) {
            n = 4;
        }
        attribute = new CodeStringAttribute(attributeTag);
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                attribute.addValue("DERIVED");
                continue;
            }
            if (i == 3) {
                attribute.addValue("RESAMPLED");
                continue;
            }
            if (i < stringArray.length) {
                attribute.addValue(stringArray[i]);
                continue;
            }
            if (i == 1) {
                attribute.addValue("PRIMARY");
                continue;
            }
            if (i == 2) {
                attribute.addValue("VOLUME");
                continue;
            }
            attribute.addValue("");
        }
        attributeList2.put(attribute);
    }

    protected static void copyFunctionalGroupsSequenceWithDownsampledValues(AttributeList attributeList, AttributeList attributeList2, TiledFramesIndex tiledFramesIndex, int n, int n2, int n3, int n4, int n5, int n6) throws DicomException {
        Object object;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        if (sequenceAttribute == null || sequenceAttribute.getNumberOfItems() != 1) {
            throw new DicomException("Missing SharedFunctionalGroupsSequence or incorrect number of items");
        }
        attributeList2.put(sequenceAttribute);
        Object object2 = sequenceAttribute.getItem(0).getAttributeList();
        Object object3 = (SequenceAttribute)((AttributeList)object2).get(TagFromName.PixelMeasuresSequence);
        if (object3 == null || ((SequenceAttribute)object3).getNumberOfItems() != 1) {
            throw new DicomException("Missing PixelMeasuresSequence in SharedFunctionalGroupsSequence or incorrect number of items");
        }
        AttributeList attributeList3 = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence((SequenceAttribute)object3, 0);
        Attribute attribute = attributeList3.get(TagFromName.PixelSpacing);
        if (attribute == null || attribute.getVM() != 2) {
            throw new DicomException("Missing PixelSpacing in PixelMeasuresSequence in SharedFunctionalGroupsSequence or incorrect number of values");
        }
        Object object4 = attribute.getDoubleValues();
        slf4jlogger.debug("copyFunctionalGroupsSequenceWithDownsampledValues(): PixelSpacing[0] = {}", object4[0]);
        slf4jlogger.debug("copyFunctionalGroupsSequenceWithDownsampledValues(): PixelSpacing[1] = {}", object4[1]);
        object4[0] = object4[0] * 2.0;
        object4[1] = object4[1] * 2.0;
        slf4jlogger.debug("copyFunctionalGroupsSequenceWithDownsampledValues(): new PixelSpacing[0] = {}", object4[0]);
        slf4jlogger.debug("copyFunctionalGroupsSequenceWithDownsampledValues(): new PixelSpacing[1] = {}", object4[1]);
        Object object5 = new DecimalStringAttribute(TagFromName.PixelSpacing);
        ((Attribute)object5).addValue(object4[0]);
        ((Attribute)object5).addValue(object4[1]);
        attributeList3.put((Attribute)object5);
        object3 = (SequenceAttribute)((AttributeList)object2).get(TagFromName.WholeSlideMicroscopyImageFrameTypeSequence);
        if (object3 == null || ((SequenceAttribute)object3).getNumberOfItems() != 1) {
            slf4jlogger.warn("Missing or bad WholeSlideMicroscopyImageFrameTypeSequence in SharedFunctionalGroupsSequence - adding it");
            object3 = new SequenceAttribute(TagFromName.WholeSlideMicroscopyImageFrameTypeSequence);
            ((AttributeList)object2).put((Attribute)object3);
            ((SequenceAttribute)object3).addItem(new AttributeList());
        }
        attributeList3 = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence((SequenceAttribute)object3, 0);
        TiledPyramid.updateImageOrFrameType(attributeList3, attributeList3, TagFromName.FrameType);
        object3 = new SequenceAttribute(TagFromName.DerivationImageSequence);
        ((AttributeList)object2).put((Attribute)object3);
        attributeList3 = new AttributeList();
        ((SequenceAttribute)object3).addItem(attributeList3);
        attribute = new ShortTextAttribute(TagFromName.DerivationDescription);
        attribute.addValue("Downsampled by 2 in row and column dimensions by arithmetic mean of adjacent pixels");
        attributeList3.put(attribute);
        CodedSequenceItem.putSingleCodedSequenceAttribute(attributeList3, TagFromName.DerivationCodeSequence, new CodedSequenceItem("113085", "DCM", "Spatial resampling"));
        attribute = new SequenceAttribute(TagFromName.SourceImageSequence);
        attributeList3.put(attribute);
        object4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
        object5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (((String)object4).length() > 0 && ((String)object5).length() > 0) {
            AttributeList attributeList4 = new AttributeList();
            ((SequenceAttribute)attribute).addItem(attributeList4);
            object = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
            ((Attribute)object).addValue((String)object4);
            attributeList4.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
            ((Attribute)object).addValue((String)object5);
            attributeList4.put((Attribute)object);
            CodedSequenceItem.putSingleCodedSequenceAttribute(attributeList4, TagFromName.PurposeOfReferenceCodeSequence, new CodedSequenceItem("121322", "DCM", "Source image for image processing operation"));
        } else {
            slf4jlogger.warn("Missing SOPInstanceUID or SOPClassUID for constructing DerivationImageSequence in SharedFunctionalGroupsSequence");
        }
        object2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (object2 == null) {
            object3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DimensionOrganizationType);
            if (object3 == null || !((String)object3).equals("TILED_FULL")) {
                throw new DicomException("Missing PerFrameFunctionalGroupsSequence or incorrect number of items");
            }
        } else {
            if (((SequenceAttribute)object2).getNumberOfItems() != n) {
                throw new DicomException("Incorrect number of items in PerFrameFunctionalGroupsSequence");
            }
            object3 = new SequenceAttribute(TagFromName.PerFrameFunctionalGroupsSequence);
            attributeList2.put((Attribute)object3);
            for (int i = 0; i < n4; ++i) {
                int n7 = i * 2;
                for (int j = 0; j < n3; ++j) {
                    int n8 = j * 2;
                    int n9 = tiledFramesIndex.getFrameNumber(n7, n8);
                    object = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence((SequenceAttribute)object2, n9 - 1);
                    ((SequenceAttribute)object3).addItem((AttributeList)object);
                    SequenceAttribute sequenceAttribute2 = (SequenceAttribute)((AttributeList)object).get(TagFromName.PlanePositionSlideSequence);
                    if (sequenceAttribute2 == null || sequenceAttribute2.getNumberOfItems() != 1) {
                        throw new DicomException("Missing PlanePositionSlideSequence in PerFrameFunctionalGroupsSequence item " + n9 + " or incorrect number of items");
                    }
                    AttributeList attributeList5 = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, 0);
                    SignedLongAttribute signedLongAttribute = new SignedLongAttribute(TagFromName.RowPositionInTotalImagePixelMatrix);
                    ((Attribute)signedLongAttribute).addValue(i * n6 + 1);
                    attributeList5.put(signedLongAttribute);
                    signedLongAttribute = new SignedLongAttribute(TagFromName.ColumnPositionInTotalImagePixelMatrix);
                    ((Attribute)signedLongAttribute).addValue(j * n5 + 1);
                    attributeList5.put(signedLongAttribute);
                }
            }
        }
    }

    public static void setClipRectForIncompletelyFilledTilesIfNecessary(SourceImage sourceImage, TiledFramesIndex tiledFramesIndex, AttributeList attributeList) throws DicomException {
        if (tiledFramesIndex == null) {
            slf4jlogger.info("setClipRectForIncompletelyFilledTilesIfNecessary(): constructing TiledFramesIndex since none supplied");
            tiledFramesIndex = new TiledFramesIndex(attributeList, false, false, false);
        }
        TiledPyramid.setClipRectForIncompletelyFilledTilesIfNecessary(sourceImage, tiledFramesIndex, tiledFramesIndex.getNumberOfColumnsOfTiles(), tiledFramesIndex.getNumberOfRowsOfTiles(), Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixColumns, 0), Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixRows, 0), Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0), Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0));
    }

    public static void setClipRectForIncompletelyFilledTilesIfNecessary(SourceImage sourceImage, TiledFramesIndex tiledFramesIndex, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): numberOfRowsOfTiles = {}", n2);
        slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): numberOfColumnsOfTiles = {}", n);
        int n9 = n3 % n5;
        if (n9 != 0) {
            slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): clipping right-most column at remainderRight = {}", n9);
            Rectangle rectangle = new Rectangle(0, 0, n9, n6);
            for (int i = 0; i < n2; ++i) {
                n8 = tiledFramesIndex.getFrameNumber(i, n - 1) - 1;
                slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): clipping right-most column frame = {}", n8);
                sourceImage.setClipRect(n8, rectangle);
            }
        }
        if ((n7 = n4 % n6) != 0) {
            slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): clipping bottom-most row at remainderBottom = {}", n7);
            Rectangle rectangle = new Rectangle(0, 0, n5, n7);
            for (n8 = 0; n8 < n; ++n8) {
                int n10 = tiledFramesIndex.getFrameNumber(n2 - 1, n8) - 1;
                slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): clipping bottom-most row frame = {}", n10);
                sourceImage.setClipRect(n10, rectangle);
            }
        }
        if (n9 != 0 && n7 != 0) {
            slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): clipping BRHC tile at remainderRight = {} and remainderBottom = {}", n9, n7);
            Rectangle rectangle = new Rectangle(0, 0, n9, n7);
            if (n2 > 0 && n > 0) {
                n8 = tiledFramesIndex.getFrameNumber(n2 - 1, n - 1) - 1;
                slf4jlogger.debug("setClipRectForIncompletelyFilledTilesIfNecessary(): clipping BRHC tile frame = {}", n8);
                sourceImage.setClipRect(n8, rectangle);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void downsamplePixelData(AttributeList attributeList, AttributeList attributeList2, TiledFramesIndex tiledFramesIndex, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, String string) throws DicomException, IOException {
        void var26_27;
        int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n12 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 8);
        int n13 = 0;
        int n14 = 0;
        if (n12 == 8) {
            n13 = 255;
            n14 = 255;
        } else {
            if (n12 != 16) throw new DicomException("Unsupported bit depth - BitsAllocated " + n12);
            n13 = 65535;
            n14 = 65535;
        }
        File[] fileArray = new File[n2];
        SourceImage sourceImage = new SourceImage(attributeList, false);
        TiledPyramid.setClipRectForIncompletelyFilledTilesIfNecessary(sourceImage, tiledFramesIndex, n5, n6, n3, n4, n9, n10);
        int[] nArray = new int[n10 * n9 * n11];
        int[] nArray2 = new int[n10 * n9 * n11];
        byte[] byArray = n12 == 8 ? new byte[n10 * n9 * n11] : null;
        short[] sArray = n12 == 16 ? new short[n10 * n9 * n11] : null;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int n15 = 0;
        boolean bl = false;
        while (var26_27 < n8) {
            void var27_29 = var26_27 * 2;
            for (int i = 0; i < n7; ++i) {
                Object object;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25 = i * 2;
                int n26 = var27_29 < n6 && n25 < n5 ? tiledFramesIndex.getFrameNumber((int)var27_29, n25) : 0;
                int n27 = var27_29 < n6 && n25 < n5 - 1 ? tiledFramesIndex.getFrameNumber((int)var27_29, n25 + 1) : 0;
                int n28 = var27_29 < n6 - 1 && n25 < n5 ? tiledFramesIndex.getFrameNumber((int)(var27_29 + true), n25) : 0;
                int n29 = var27_29 < n6 - 1 && n25 < n5 - 1 ? tiledFramesIndex.getFrameNumber((int)(var27_29 + true), n25 + 1) : 0;
                slf4jlogger.trace("downsamplePixelData(): Four old frames TLHC = {}, TRHC = {}, BLHC = {}, BRHC = {}", n26, n27, n28, n29);
                BufferedImage bufferedImage = n26 != 0 ? sourceImage.getBufferedImage(n26 - 1) : null;
                BufferedImage bufferedImage2 = n27 != 0 ? sourceImage.getBufferedImage(n27 - 1) : null;
                BufferedImage bufferedImage3 = n28 != 0 ? sourceImage.getBufferedImage(n28 - 1) : null;
                BufferedImage bufferedImage4 = n29 != 0 ? sourceImage.getBufferedImage(n29 - 1) : null;
                int n30 = bufferedImage != null ? bufferedImage.getHeight() : 0;
                int n31 = bufferedImage2 != null ? bufferedImage2.getHeight() : 0;
                int n32 = bufferedImage3 != null ? bufferedImage3.getHeight() : 0;
                int n33 = n24 = bufferedImage4 != null ? bufferedImage4.getHeight() : 0;
                if (bufferedImage != null && n30 != n10) {
                    slf4jlogger.warn("Top row (TLHC) height {} is less than expected {}", n30, n10);
                }
                if (bufferedImage2 != null && n31 != n10) {
                    slf4jlogger.warn("Top row (TRHC) height {} is less than expected {}", n31, n10);
                }
                if (bufferedImage3 != null && n32 != n10) {
                    slf4jlogger.warn("Bottom row (BLHC) height {} is less than expected {}", n32, n10);
                }
                if (bufferedImage4 != null && n24 != n10) {
                    slf4jlogger.warn("Bottom row (BRHC) height {} is less than expected {}", n24, n10);
                }
                int[] nArray3 = null;
                int[] nArray4 = null;
                int[] nArray5 = null;
                int[] nArray6 = null;
                nArray3 = bufferedImage != null ? bufferedImage.getSampleModel().getPixels(0, 0, n9, n30, nArray3, bufferedImage.getRaster().getDataBuffer()) : null;
                nArray4 = bufferedImage2 != null ? bufferedImage2.getSampleModel().getPixels(0, 0, n9, n31, nArray4, bufferedImage2.getRaster().getDataBuffer()) : null;
                nArray5 = bufferedImage3 != null ? bufferedImage3.getSampleModel().getPixels(0, 0, n9, n32, nArray5, bufferedImage3.getRaster().getDataBuffer()) : null;
                nArray6 = bufferedImage4 != null ? bufferedImage4.getSampleModel().getPixels(0, 0, n9, n24, nArray6, bufferedImage4.getRaster().getDataBuffer()) : null;
                for (n23 = 0; n23 < nArray.length; ++n23) {
                    nArray[n23] = 0;
                    nArray2[n23] = 0;
                }
                if (nArray3 != null) {
                    for (n23 = 0; n23 < n30; ++n23) {
                        n22 = n23 / 2;
                        for (n21 = 0; n21 < n9; ++n21) {
                            n20 = n21 / 2;
                            for (n19 = 0; n19 < n11; ++n19) {
                                n18 = nArray3[(n23 * n9 + n21) * n11 + n19] & n13;
                                int n34 = n17 = (n22 * n9 + n20) * n11 + n19;
                                nArray[n34] = nArray[n34] + 1;
                                int n35 = n17;
                                nArray2[n35] = nArray2[n35] + n18;
                            }
                        }
                    }
                }
                if (nArray4 != null) {
                    n23 = n9;
                    for (n22 = 0; n22 < n31; ++n22) {
                        n21 = n22 / 2;
                        for (n20 = 0; n20 < n9; ++n20) {
                            n19 = (n23 + n20) / 2;
                            for (n18 = 0; n18 < n11; ++n18) {
                                n17 = nArray4[(n22 * n9 + n20) * n11 + n18] & n13;
                                int n36 = n16 = (n21 * n9 + n19) * n11 + n18;
                                nArray[n36] = nArray[n36] + 1;
                                int n37 = n16;
                                nArray2[n37] = nArray2[n37] + n17;
                            }
                        }
                    }
                }
                if (nArray5 != null) {
                    n23 = n10;
                    for (n22 = 0; n22 < n32; ++n22) {
                        n21 = (n23 + n22) / 2;
                        for (n20 = 0; n20 < n9; ++n20) {
                            n19 = n20 / 2;
                            for (n18 = 0; n18 < n11; ++n18) {
                                n17 = nArray5[(n22 * n9 + n20) * n11 + n18] & n13;
                                int n38 = n16 = (n21 * n9 + n19) * n11 + n18;
                                nArray[n38] = nArray[n38] + 1;
                                int n39 = n16;
                                nArray2[n39] = nArray2[n39] + n17;
                            }
                        }
                    }
                }
                if (nArray6 != null) {
                    n23 = n9;
                    n22 = n10;
                    for (n21 = 0; n21 < n24; ++n21) {
                        n20 = (n22 + n21) / 2;
                        for (n19 = 0; n19 < n9; ++n19) {
                            n18 = (n23 + n19) / 2;
                            for (n17 = 0; n17 < n11; ++n17) {
                                int n40;
                                n16 = nArray6[(n21 * n9 + n19) * n11 + n17] & n13;
                                int n41 = n40 = (n20 * n9 + n18) * n11 + n17;
                                nArray[n41] = nArray[n41] + 1;
                                int n42 = n40;
                                nArray2[n42] = nArray2[n42] + n16;
                            }
                        }
                    }
                }
                if (byArray != null) {
                    for (n23 = 0; n23 < nArray.length; ++n23) {
                        byArray[n23] = (byte)(nArray[n23] == 0 ? n14 : nArray2[n23] / nArray[n23]);
                    }
                } else if (sArray != null) {
                    for (n23 = 0; n23 < nArray.length; ++n23) {
                        sArray[n23] = (short)(nArray[n23] == 0 ? n14 : nArray2[n23] / nArray[n23]);
                    }
                }
                File file = File.createTempFile("TiledPyramid_tmp", ".tmp");
                file.deleteOnExit();
                if (string == null) {
                    if (byArray != null) {
                        object = new BufferedOutputStream(new FileOutputStream(file));
                        ((OutputStream)object).write(byArray);
                        ((OutputStream)object).close();
                    } else {
                        if (sArray == null) throw new DicomException("Unsupported combination of BitsAllocated " + n12 + " and SamplesPerPixel " + n11);
                        object = new BinaryOutputStream(new BufferedOutputStream(new FileOutputStream(file)), false);
                        ((BinaryOutputStream)object).writeUnsigned16(sArray, sArray.length);
                        ((FilterOutputStream)object).close();
                    }
                } else {
                    object = null;
                    if (n11 == 3) {
                        if (byArray != null) {
                            object = SourceImage.createPixelInterleavedByteThreeComponentColorImage(n9, n10, byArray, 0, colorSpace, false);
                        } else if (sArray != null) {
                            object = SourceImage.createPixelInterleavedShortThreeComponentColorImage(n9, n10, sArray, 0, colorSpace);
                        }
                    } else if (n11 == 1) {
                        if (byArray != null) {
                            object = SourceImage.createByteGrayscaleImage(n9, n10, byArray, 0);
                        } else if (sArray != null) {
                            object = SourceImage.createUnsignedShortGrayscaleImage(n9, n10, sArray, 0);
                        }
                    }
                    if (object == null) {
                        throw new DicomException("Unsupported combination of BitsAllocated " + n12 + " and SamplesPerPixel " + n11);
                    }
                    CompressedFrameEncoder.getCompressedFrameAsFile(attributeList, (BufferedImage)object, string, file);
                }
                fileArray[n15++] = file;
            }
            ++var26_27;
        }
        Attribute attribute = string == null ? (n12 == 8 ? new OtherByteAttributeMultipleFilesOnDisk(TagFromName.PixelData, fileArray) : new OtherWordAttributeMultipleFilesOnDisk(TagFromName.PixelData, fileArray, false)) : new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
        attributeList2.put(attribute);
        if (n11 <= 1) return;
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
        ((Attribute)unsignedShortAttribute).addValue(0);
        attributeList2.put(unsignedShortAttribute);
    }

    public static void createDownsampledDICOMAttributes(AttributeList attributeList, AttributeList attributeList2, TiledFramesIndex tiledFramesIndex, String string, boolean bl, boolean bl2) throws DicomException, IOException {
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): rows = {}", n);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): columns = {}", n2);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixColumns, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixRows, 0);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): totalPixelMatrixColumns = {}", n3);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): totalPixelMatrixRows = {}", n4);
        int n5 = (n3 + 2) / 2 - 1;
        int n6 = (n4 + 2) / 2 - 1;
        slf4jlogger.debug("createDownsampledDICOMAttributes(): new TotalPixelMatrixColumns = {}", n5);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): new TotalPixelMatrixRows = {}", n6);
        if (n3 == n5 || n4 == n6) {
            slf4jlogger.debug("createDownsampledDICOMAttributes(): stopping because unchanged");
        } else if (n5 <= 0 || n6 <= 0) {
            slf4jlogger.error("createDownsampledDICOMAttributes(): stopping because matrix zero or less ... should not happen");
        }
        int n7 = tiledFramesIndex.getNumberOfColumnsOfTiles();
        int n8 = tiledFramesIndex.getNumberOfRowsOfTiles();
        slf4jlogger.debug("createDownsampledDICOMAttributes(): numberOfColumnsOfTiles = {}", n7);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): numberOfRowsOfTiles = {}", n8);
        int n9 = n5 / n2;
        if (n5 % n2 != 0) {
            slf4jlogger.debug("createDownsampledDICOMAttributes(): New TotalPixelMatrixColumns {} is not an exact multiple of Columns {}", n5, n2);
            ++n9;
        }
        slf4jlogger.debug("createDownsampledDICOMAttributes(): New numberOfColumnsOfTiles = {}", n9);
        int n10 = n6 / n;
        if (n6 % n != 0) {
            slf4jlogger.debug("createDownsampledDICOMAttributes(): New TotalPixelMatrixRows {} is not an exact multiple of Rows {}", n6, n);
            ++n10;
        }
        slf4jlogger.debug("createDownsampledDICOMAttributes(): New newNumberOfRowsOfTiles = {}", n10);
        int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): NumberOfFrames = {}", n11);
        int n12 = n9 * n10;
        slf4jlogger.debug("createDownsampledDICOMAttributes(): new NumberOfFrames = {}", n12);
        if (n12 == 0) {
            slf4jlogger.error("createDownsampledDICOMAttributes(): stopping because new NumberOfFrames zero or less ... should not happen");
        }
        Object object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
        ((Attribute)object).addValue(n12);
        attributeList2.put((Attribute)object);
        object = new UnsignedLongAttribute(TagFromName.TotalPixelMatrixColumns);
        ((Attribute)object).addValue(n5);
        attributeList2.put((Attribute)object);
        object = new UnsignedLongAttribute(TagFromName.TotalPixelMatrixRows);
        ((Attribute)object).addValue(n6);
        attributeList2.put((Attribute)object);
        if (bl) {
            attributeList2.put(attributeList.get(TagFromName.Rows));
            attributeList2.put(attributeList.get(TagFromName.Columns));
            attributeList2.put(attributeList.get(TagFromName.BitsStored));
            attributeList2.put(attributeList.get(TagFromName.BitsAllocated));
            attributeList2.put(attributeList.get(TagFromName.HighBit));
            attributeList2.put(attributeList.get(TagFromName.SamplesPerPixel));
            object = attributeList.get(TagFromName.PlanarConfiguration);
            if (object != null) {
                attributeList2.put((Attribute)object);
            }
        }
        slf4jlogger.debug("createDownsampledDICOMAttributes(): outputformat = {}", string);
        object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
        slf4jlogger.debug("createDownsampledDICOMAttributes(): source list PhotometricInterpretation = {}", object);
        if (string != null) {
            if (string.equals("jpeg")) {
                object = "YBR_FULL_422";
            } else if (string.equals("jpeg2000")) {
                object = "YBR_RCT";
            }
        }
        if (((String)object).length() == 0) {
            object = "RGB";
        }
        slf4jlogger.debug("createDownsampledDICOMAttributes(): new list PhotometricInterpretation = {}", object);
        Object object2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object2).addValue((String)object);
        attributeList2.put((Attribute)object2);
        TiledPyramid.updateImageOrFrameType(attributeList, attributeList2, TagFromName.ImageType);
        if (bl2) {
            TiledPyramid.copyFunctionalGroupsSequenceWithDownsampledValues(attributeList, attributeList2, tiledFramesIndex, n11, n12, n9, n10, n2, n);
        }
        object = new SequenceAttribute(TagFromName.ReferencedSeriesSequence);
        attributeList2.put((Attribute)object);
        object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
        if (((String)object2).length() > 0) {
            AttributeList attributeList3 = new AttributeList();
            ((SequenceAttribute)object).addItem(attributeList3);
            Attribute attribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            attribute.addValue((String)object2);
            attributeList3.put(attribute);
            attribute = new SequenceAttribute(TagFromName.ReferencedInstanceSequence);
            attributeList3.put(attribute);
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            if (string2.length() > 0 && string3.length() > 0) {
                AttributeList attributeList4 = new AttributeList();
                ((SequenceAttribute)attribute).addItem(attributeList4);
                UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
                ((Attribute)uniqueIdentifierAttribute).addValue(string2);
                attributeList4.put(uniqueIdentifierAttribute);
                uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
                ((Attribute)uniqueIdentifierAttribute).addValue(string3);
                attributeList4.put(uniqueIdentifierAttribute);
            } else {
                slf4jlogger.warn("Missing SOPInstanceUID or SOPClassUID for constructing ReferencedInstanceSequence in Common Instance Reference Module");
            }
        } else {
            slf4jlogger.warn("Missing SeriesInstanceUID for constructing ReferencedSeriesSequence in Common Instance Reference Module");
        }
        TiledPyramid.downsamplePixelData(attributeList, attributeList2, tiledFramesIndex, n11, n12, n3, n4, n7, n8, n9, n10, n2, n, string);
    }

    public File createDownsampledDICOMFile(File file, File file2) throws DicomException, IOException {
        slf4jlogger.info("createDownsampledDICOMFile(): inputFile = {}", file);
        File file3 = null;
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(file);
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        if (string.length() == 0) {
            throw new DicomException("Missing TransferSyntaxUID");
        }
        slf4jlogger.debug("transferSyntaxUID = {}", string);
        String string2 = CompressedFrameEncoder.chooseOutputFormatForTransferSyntax(string);
        slf4jlogger.debug("outputformat = {}", string2);
        attributeList.removePrivateAttributes();
        attributeList.removeGroupLengthAttributes();
        attributeList.remove(TagFromName.DataSetTrailingPadding);
        TiledFramesIndex tiledFramesIndex = new TiledFramesIndex(attributeList, false, false, false);
        int n = tiledFramesIndex.getNumberOfColumnsOfTiles();
        slf4jlogger.debug("createDownsampledDICOMFile(): numberOfColumnsOfTiles = {}", n);
        int n2 = tiledFramesIndex.getNumberOfRowsOfTiles();
        slf4jlogger.debug("createDownsampledDICOMFile(): numberOfRowsOfTiles = {}", n2);
        if (n > 1 || n2 > 1) {
            slf4jlogger.debug("createDownsampledDICOMFile(): creating downsampled file");
            AttributeList attributeList2 = new AttributeList();
            attributeList2.putAll(attributeList);
            attributeList2.remove(TagFromName.PixelData);
            TiledPyramid.createDownsampledDICOMAttributes(attributeList, attributeList2, tiledFramesIndex, string2, false, true);
            Attribute attribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)attribute).addValue(this.generator.getAnotherNewUID());
            attributeList2.put(attribute);
            ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList2, false, new CodedSequenceItem("109106", "DCM", "Enhanced Multi-frame Conversion Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "TiledPyramid", null, "Vers. " + VersionAndConstants.getBuildDate(), "Tiled pyramid created from single high resolution image");
            attributeList2.insertSuitableSpecificCharacterSetForAllStringValues();
            attributeList2.removeMetaInformationHeaderAttributes();
            FileMetaInformation.addFileMetaInformation(attributeList2, string, "OURAETITLE");
            file3 = new File(file2, Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.SOPInstanceUID, "NONAME"));
            attributeList2.write(file3, string, true, true);
            attribute = attributeList2.get(TagFromName.PixelData);
            if (attribute != null) {
                File[] fileArray = null;
                if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
                    fileArray = ((OtherByteAttributeMultipleCompressedFrames)attribute).getFiles();
                } else if (attribute instanceof OtherByteAttributeMultipleFilesOnDisk) {
                    fileArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute).getFiles();
                } else if (attribute instanceof OtherWordAttributeMultipleFilesOnDisk) {
                    fileArray = ((OtherWordAttributeMultipleFilesOnDisk)attribute).getFiles();
                }
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        slf4jlogger.debug("deleting = {}", string2);
                        fileArray[i].delete();
                        fileArray[i] = null;
                    }
                }
            }
        } else {
            slf4jlogger.debug("createDownsampledDICOMFile(): not creating downsampled file ... stopping");
        }
        return file3;
    }

    public TiledPyramid(String string, String string2) throws DicomException, IOException {
        File file = new File(string2);
        if (!file.isDirectory()) {
            throw new DicomException("Output folder " + file + " does not exist");
        }
        File file2 = new File(string);
        while ((file2 = this.createDownsampledDICOMFile(file2, file)) != null) {
        }
    }

    public static void main(String[] stringArray) {
        try {
            new TiledPyramid(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

