/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.AnalyzeException;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class AnalyzeHeader {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/AnalyzeHeader.java,v 1.11 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AnalyzeHeader.class);
    public static final int FIXED_HEADER_LENGTH = 348;
    public byte[] bytes;
    public boolean bigEndian;
    public int sizeof_hdr;
    public short[] dim = new short[8];
    public short unused8;
    public short unused9;
    public short unused10;
    public short unused11;
    public short unused12;
    public short unused13;
    public short unused14;
    public short datatype_code;
    public DataType datatype;
    public short bitpix;
    public short dim_un0;
    public float[] pixdim = new float[8];
    public float vox_offset;
    public float funused1;
    public float funused2;
    public float funused3;
    public float cal_max;
    public float cal_min;
    public float compressed;
    public float verified;
    public int glmax;
    public int glmin;
    public byte[] description = new byte[80];
    public byte[] aux_file = new byte[24];
    public byte orient_code;
    public Orient orient;
    public byte[] originator = new byte[10];
    public byte[] generated = new byte[10];
    public byte[] scannum = new byte[10];
    public byte[] patient_id = new byte[10];
    public byte[] exp_date = new byte[10];
    public byte[] exp_time = new byte[10];
    public byte[] hist_un0 = new byte[3];
    public int views;
    public int vols_added;
    public int start_field;
    public int field_skip;
    public int omax;
    public int omin;
    public int smax;
    public int smin;

    public static File getImageDataFile(File file) {
        return new File(file.getParent(), file.getName().replaceFirst("[.][^.]*$", ".img"));
    }

    public AnalyzeHeader(File file) throws IOException, AnalyzeException {
        int n;
        BinaryInputStream binaryInputStream = new BinaryInputStream(file, false);
        this.bytes = new byte[348];
        binaryInputStream.readInsistently(this.bytes, 0, 348);
        binaryInputStream.close();
        BinaryInputStream binaryInputStream2 = new BinaryInputStream(new ByteArrayInputStream(this.bytes), false);
        binaryInputStream2.mark(4);
        this.sizeof_hdr = (int)binaryInputStream2.readUnsigned32();
        if (this.sizeof_hdr != 348) {
            binaryInputStream2.setBigEndian();
            binaryInputStream2.reset();
            this.sizeof_hdr = (int)binaryInputStream2.readUnsigned32();
            if (this.sizeof_hdr != 348) {
                throw new AnalyzeException("Cannot determine Analyze endianness from sizeof_hdr byte order since does not match required size");
            }
            this.bigEndian = true;
            slf4jlogger.info("Is BigEndian");
        } else {
            this.bigEndian = false;
            slf4jlogger.info("Is LittleEndian");
        }
        slf4jlogger.info("Have Analyze header");
        binaryInputStream2.skip(36L);
        for (n = 0; n < this.dim.length; ++n) {
            this.dim[n] = (short)binaryInputStream2.readUnsigned16();
            slf4jlogger.info("dim[{}] = {}", n, this.dim[n]);
        }
        this.unused8 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused8 = {}", this.unused8 & 0xFFFF);
        this.unused9 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused9 = {}", this.unused9 & 0xFFFF);
        this.unused10 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused10 = {}", this.unused10 & 0xFFFF);
        this.unused11 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused11 = {}", this.unused11 & 0xFFFF);
        this.unused12 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused12 = {}", this.unused12 & 0xFFFF);
        this.unused13 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused13 = {}", this.unused13 & 0xFFFF);
        this.unused14 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("unused14 = {}", this.unused14 & 0xFFFF);
        this.datatype_code = (short)binaryInputStream2.readUnsigned16();
        this.datatype = DataType.getDataType(this.datatype_code);
        slf4jlogger.info("datatype = {} {}", new Object[]{this.datatype_code & 0xFFFF, this.datatype});
        this.bitpix = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("bitpix = {}", this.bitpix & 0xFFFF);
        this.dim_un0 = (short)binaryInputStream2.readUnsigned16();
        slf4jlogger.info("dim_un0 = {}", this.dim_un0 & 0xFFFF);
        for (n = 0; n < this.pixdim.length; ++n) {
            this.pixdim[n] = binaryInputStream2.readFloat();
            slf4jlogger.info("pixdim[{}] = {}", n, Float.valueOf(this.pixdim[n]));
        }
        this.vox_offset = binaryInputStream2.readFloat();
        slf4jlogger.info("vox_offset = {}", Float.valueOf(this.vox_offset));
        this.funused1 = binaryInputStream2.readFloat();
        slf4jlogger.info("funused1 = {}", Float.valueOf(this.funused1));
        this.funused2 = binaryInputStream2.readFloat();
        slf4jlogger.info("funused2 = {}", Float.valueOf(this.funused2));
        this.funused3 = binaryInputStream2.readFloat();
        slf4jlogger.info("funused3 = {}", Float.valueOf(this.funused3));
        this.cal_max = binaryInputStream2.readFloat();
        slf4jlogger.info("cal_max = {}", Float.valueOf(this.cal_max));
        this.cal_min = binaryInputStream2.readFloat();
        slf4jlogger.info("cal_min = {}", Float.valueOf(this.cal_min));
        this.compressed = binaryInputStream2.readFloat();
        slf4jlogger.info("compressed = {}", Float.valueOf(this.compressed));
        this.verified = binaryInputStream2.readFloat();
        slf4jlogger.info("verified = {}", Float.valueOf(this.verified));
        this.glmax = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("glmax = {}", (long)this.glmax & 0xFFFFFFFFL);
        this.glmin = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("glmin = {}", (long)this.glmin & 0xFFFFFFFFL);
        binaryInputStream2.readInsistently(this.description, 0, this.description.length);
        slf4jlogger.info("description = {}", new String(this.description, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.aux_file, 0, this.aux_file.length);
        slf4jlogger.info("aux_file = {}", new String(this.aux_file, Charset.forName("US-ASCII")));
        this.orient_code = (byte)binaryInputStream2.readUnsigned8();
        this.orient = Orient.getOrient(this.orient_code);
        slf4jlogger.info("orient = {} {}", new Object[]{this.orient_code & 0xFF, this.orient});
        binaryInputStream2.readInsistently(this.originator, 0, this.originator.length);
        slf4jlogger.info("originator = {}", new String(this.originator, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.generated, 0, this.generated.length);
        slf4jlogger.info("generated = {}", new String(this.generated, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.scannum, 0, this.scannum.length);
        slf4jlogger.info("scannum = {}", new String(this.scannum, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.patient_id, 0, this.patient_id.length);
        slf4jlogger.info("patient_id = {}", new String(this.patient_id, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.exp_date, 0, this.exp_date.length);
        slf4jlogger.info("exp_date = {}", new String(this.exp_date, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.exp_time, 0, this.exp_time.length);
        slf4jlogger.info("exp_time = {}", new String(this.exp_time, Charset.forName("US-ASCII")));
        binaryInputStream2.readInsistently(this.hist_un0, 0, this.hist_un0.length);
        slf4jlogger.info("hist_un0 = {}", new String(this.hist_un0, Charset.forName("US-ASCII")));
        this.views = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("views = {}", (long)this.views & 0xFFFFFFFFL);
        this.vols_added = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("vols_added = {}", (long)this.vols_added & 0xFFFFFFFFL);
        this.start_field = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("start_field = {}", (long)this.start_field & 0xFFFFFFFFL);
        this.field_skip = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("field_skip = {}", (long)this.field_skip & 0xFFFFFFFFL);
        this.omax = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("omax = {}", (long)this.omax & 0xFFFFFFFFL);
        this.omin = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("omin = {}", (long)this.omin & 0xFFFFFFFFL);
        this.smax = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("smax = {}", (long)this.smax & 0xFFFFFFFFL);
        this.smin = (int)binaryInputStream2.readUnsigned32();
        slf4jlogger.info("smin = {}", (long)this.smin & 0xFFFFFFFFL);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                new AnalyzeHeader(new File(stringArray[0]));
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: AnalyzeHeader inputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    static enum Orient {
        TRANSVERSE_UNFLIPPED(0),
        CORONAL_UNFLIPPED(1),
        SAGITTAL_UNFLIPPED(2),
        TRANSVERSE_FLIPPED(3),
        CORONAL_FLIPPED(4),
        SAGITTAL_FLIPPED(5);

        private short orient;
        static final Map<Short, Orient> map;

        private Orient(short s) {
            this.orient = s;
        }

        static final Orient getOrient(short s) {
            return map.get(new Short(s));
        }

        static {
            map = new HashMap<Short, Orient>();
            for (Orient orient : Orient.values()) {
                map.put(new Short(orient.orient), orient);
            }
        }
    }

    static enum DataType {
        NONE(0),
        BINARY(1),
        UNSIGNED_CHAR(2),
        SIGNED_SHORT(4),
        SIGNED_INT(8),
        FLOAT(16),
        COMPLEX(32),
        DOUBLE(64),
        RGB(128),
        ALL(255);

        private short datatype;
        static final Map<Short, DataType> map;

        private DataType(short s) {
            this.datatype = s;
        }

        static final DataType getDataType(short s) {
            return map.get(new Short(s));
        }

        static {
            map = new HashMap<Short, DataType>();
            for (DataType dataType : DataType.values()) {
                map.put(new Short(dataType.datatype), dataType);
            }
        }
    }
}

