/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.apps.SetCharacteristicsFromSummary;
import com.pixelmed.convert.CommonConvertedAttributeGeneration;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherAttributeOnDisk;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class EncapsulateData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/EncapsulateData.java,v 1.4 2019/05/10 16:41:30 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(EncapsulateData.class);

    public static String determineMediaTypeFromFile(String string) {
        String string2 = "";
        if (string.toLowerCase().endsWith(".pdf")) {
            string2 = "application/pdf";
        } else if (string.toLowerCase().endsWith(".cda")) {
            string2 = "text/xml";
        } else if (string.toLowerCase().endsWith(".stl")) {
            string2 = "model/stl";
        }
        return string2;
    }

    public static String determineSOPClassFromMediaType(String string) {
        String string2 = "";
        if (string.toLowerCase().equals("application/pdf")) {
            string2 = "1.2.840.10008.5.1.4.1.1.104.1";
        } else if (string.toLowerCase().equals("text/xml")) {
            string2 = "1.2.840.10008.5.1.4.1.1.104.2";
        } else if (string.toLowerCase().equals("model/stl")) {
            string2 = "1.2.840.10008.5.1.4.1.1.104.3";
        }
        return string2;
    }

    public static String determineModalityFromSOPClass(String string) {
        String string2 = "";
        if (string.equals("1.2.840.10008.5.1.4.1.1.104.1")) {
            string2 = "DOC";
        } else if (string.equals("1.2.840.10008.5.1.4.1.1.104.2")) {
            string2 = "DOC";
        } else if (string.equals("1.2.840.10008.5.1.4.1.1.104.3")) {
            string2 = "M3D";
        }
        return string2;
    }

    public EncapsulateData(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException, DicomException {
        String string5 = EncapsulateData.determineMediaTypeFromFile(string);
        String string6 = EncapsulateData.determineSOPClassFromMediaType(string5);
        if (string6.length() == 0) {
            throw new DicomException("Cannot deduce SOP Class UID for input file" + string);
        }
        String string7 = EncapsulateData.determineModalityFromSOPClass(string6);
        AttributeList attributeList = new AttributeList();
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList, "Nobody^Noname", "000000", "000000", "1", "1", string7, string6, false);
        Object object = new LongStringAttribute(TagFromName.MIMETypeOfEncapsulatedDocument);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)object).addValue(this.getClass().getName());
        attributeList.put((Attribute)object);
        object = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        attributeList.put((Attribute)object);
        object = new ShortTextAttribute(TagFromName.DocumentTitle);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(TagFromName.ConceptNameCodeSequence);
        attributeList.put((Attribute)object);
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        object = new OtherByteAttributeOnDisk(TagFromName.EncapsulatedDocument);
        Object object2 = new File(string);
        ((OtherAttributeOnDisk)object).setFile((File)object2, 0L);
        attributeList.put((Attribute)object);
        long l = ((File)object2).length();
        UnsignedLongAttribute unsignedLongAttribute = new UnsignedLongAttribute(TagFromName.EncapsulatedDocumentLength);
        ((Attribute)unsignedLongAttribute).addValue(l);
        attributeList.put(unsignedLongAttribute);
        if (string2 != null && string2.length() > 0) {
            new SetCharacteristicsFromSummary(string2, attributeList);
        }
        if (string3 != null && string3.length() > 0) {
            object = new AttributeList();
            ((AttributeList)object).read(string3);
            object2 = new CompositeInstanceContext((AttributeList)object, false);
            ((CompositeInstanceContext)object2).removeInstance();
            ((CompositeInstanceContext)object2).removeSeries();
            ((CompositeInstanceContext)object2).removeEquipment();
            attributeList.putAll(((CompositeInstanceContext)object2).getAttributeList());
        }
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string4, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (stringArray.length == 2) {
                string4 = stringArray[1];
            } else if (stringArray.length == 3) {
                string2 = stringArray[1];
                string4 = stringArray[2];
            } else if (stringArray.length == 4) {
                string2 = stringArray[1];
                string3 = stringArray[2];
                string4 = stringArray[3];
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: EncapsulateData inputFile [metadataFile [compositeContextFile]] outputFile");
                System.exit(1);
            }
            new EncapsulateData(string, string2, string3, string4);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

