/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RawRGBInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/RawRGBInformation.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RawRGBInformation.class);
    int imageWidthInPixels;
    int imageHeightInPixels;
    double pixelWidthInMillimetres;
    double pixelHeightInMillimetres;
    double pixelSeparationInMillimetres;
    String photometricInterpretation;
    int bitsPerPixel;
    String planarConfiguration;

    public RawRGBInformation(String string) throws IOException, NumberFormatException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Pattern pattern = Pattern.compile("Frame size:[ \t]*([0-9]+),[ \t]*([0-9]+).*");
        Pattern pattern2 = Pattern.compile("Pixel size:[ \t]*([0-9.]+)[ \t]*mm,[ \t]*([0-9.]+)[ \t]*mm,[ \t]*([0-9.]+)[ \t]*mm.*");
        Pattern pattern3 = Pattern.compile("Image format:[ \t]*(RGB)[ \t]*([0-9]+) BIT[ \t]*(NON INTERLEAVED|INTERLEAVED).*");
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            Matcher matcher = pattern.matcher(string2);
            if (matcher.matches()) {
                n = matcher.groupCount();
                if (n != 2) continue;
                this.imageWidthInPixels = Integer.parseInt(matcher.group(1));
                slf4jlogger.info("imageWidthInPixels = {}", this.imageWidthInPixels);
                this.imageHeightInPixels = Integer.parseInt(matcher.group(2));
                slf4jlogger.info("imageHeightInPixels = {}", this.imageHeightInPixels);
                continue;
            }
            matcher = pattern2.matcher(string2);
            if (matcher.matches()) {
                n = matcher.groupCount();
                if (n != 3) continue;
                this.pixelWidthInMillimetres = Double.parseDouble(matcher.group(1));
                slf4jlogger.info("pixelWidthInMillimetres = {}", this.pixelWidthInMillimetres);
                this.pixelHeightInMillimetres = Double.parseDouble(matcher.group(2));
                slf4jlogger.info("pixelHeightInMillimetres = {}", this.pixelHeightInMillimetres);
                this.pixelSeparationInMillimetres = Double.parseDouble(matcher.group(3));
                slf4jlogger.info("pixelSeparationInMillimetres = {}", this.pixelSeparationInMillimetres);
                continue;
            }
            matcher = pattern3.matcher(string2);
            if (!matcher.matches() || (n = matcher.groupCount()) != 3) continue;
            this.photometricInterpretation = matcher.group(1);
            slf4jlogger.info("photometricInterpretation = {}", this.photometricInterpretation);
            this.bitsPerPixel = Integer.parseInt(matcher.group(2));
            slf4jlogger.info("bitsPerPixel = {}", this.bitsPerPixel);
            this.planarConfiguration = matcher.group(3);
            slf4jlogger.info("planarConfiguration = {}", this.planarConfiguration);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                new RawRGBInformation(stringArray[0]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: RawRGBInformation inputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

