/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.TIFFException;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TIFFFile {
    protected RandomAccessFile raf;
    protected ByteOrder byteOrder;
    protected int version;
    protected boolean isBigTIFF;
    protected int byteSizeOfOffsets;
    protected String filename;
    private final byte[] buffer16 = new byte[2];
    private final byte[] buffer32 = new byte[4];
    private final byte[] buffer64 = new byte[8];

    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public int read(byte[] byArray) throws IOException {
        return this.raf.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.raf.read(byArray, n, n2);
    }

    public int read(short[] sArray) throws IOException {
        byte[] byArray = new byte[sArray.length * 2];
        int n = this.raf.read(byArray);
        ByteBuffer.wrap(byArray).order(this.byteOrder).asShortBuffer().get(sArray);
        return n / 2;
    }

    public int read(short[] sArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[n2 * 2];
        int n3 = this.raf.read(byArray);
        ByteBuffer.wrap(byArray).order(this.byteOrder).asShortBuffer().get(sArray, n, n2);
        return n3 / 2;
    }

    public int read(float[] fArray) throws IOException {
        byte[] byArray = new byte[fArray.length * 4];
        int n = this.raf.read(byArray);
        ByteBuffer.wrap(byArray).order(this.byteOrder).asFloatBuffer().get(fArray);
        return n / 4;
    }

    public int read(float[] fArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[n2 * 4];
        int n3 = this.raf.read(byArray);
        ByteBuffer.wrap(byArray).order(this.byteOrder).asFloatBuffer().get(fArray, n, n2);
        return n3 / 4;
    }

    public final int getUnsigned16() throws EOFException, IOException, TIFFException {
        this.raf.read(this.buffer16);
        return ByteBuffer.wrap(this.buffer16).order(this.byteOrder).getShort() & 0xFFFF;
    }

    public final long getUnsigned32() throws EOFException, IOException, TIFFException {
        this.raf.read(this.buffer32);
        return (long)ByteBuffer.wrap(this.buffer32).order(this.byteOrder).getInt() & 0xFFFFFFFFL;
    }

    public final long getUnsigned64() throws EOFException, IOException, TIFFException {
        this.raf.read(this.buffer64);
        return ByteBuffer.wrap(this.buffer64).order(this.byteOrder).getLong();
    }

    public final long getOffset() throws EOFException, IOException, TIFFException {
        long l = 0L;
        if (this.byteSizeOfOffsets == 4) {
            l = this.getUnsigned32();
        } else if (this.byteSizeOfOffsets == 8) {
            l = this.getUnsigned64();
        } else {
            throw new TIFFException("Unsupported byte size of offset " + this.byteSizeOfOffsets);
        }
        return l;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean isBigTIFF() {
        return this.isBigTIFF;
    }

    public TIFFFile(String string) throws IOException, TIFFException {
        this.filename = string;
        this.raf = new RandomAccessFile(string, "r");
        this.byteOrder = null;
        this.raf.read(this.buffer16);
        if (this.buffer16[0] == 73 && this.buffer16[1] == 73) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (this.buffer16[0] == 77 && this.buffer16[1] == 77) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            throw new TIFFException("Not a TIFF or BigTIFF file - byte order not II or MM");
        }
        this.version = this.getUnsigned16();
        if (this.version == 42) {
            this.isBigTIFF = false;
        } else if (this.version == 43) {
            this.isBigTIFF = true;
        } else {
            throw new TIFFException("Not a TIFF or BigTIFF file - version is not 42 or 43");
        }
        this.byteSizeOfOffsets = 4;
        if (this.isBigTIFF) {
            this.byteSizeOfOffsets = this.getUnsigned16();
            int n = this.getUnsigned16();
            if (n != 0) {
                throw new TIFFException("Reserved field after byte size of offsets is not zero");
            }
        }
        if (this.byteSizeOfOffsets != 4 && this.byteSizeOfOffsets != 8) {
            throw new TIFFException("Byte size of offsets of other than 4 or 8 not supported");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Magic: " + (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? "0x4949 <little-endian>" : "0x4d4d <big-endian>") + " Version: 0x" + Integer.toHexString(this.version) + (this.isBigTIFF ? " <BigTIFF>" : "") + "\n");
        stringBuffer.append("OffsetSize: 0x" + Integer.toHexString(this.byteSizeOfOffsets) + " Unused: 0\n");
        return stringBuffer.toString();
    }

    public String getFileName() {
        return this.filename;
    }
}

