/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.TIFFException;
import com.pixelmed.convert.TIFFFile;
import com.pixelmed.convert.TIFFImageFileDirectory;
import com.pixelmed.convert.TIFFImageFileDirectoryEntry;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;

public class TIFFImageFileDirectories {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/TIFFImageFileDirectories.java,v 1.3 2022/02/27 11:07:29 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TIFFImageFileDirectories.class);
    protected TIFFFile f = null;
    protected ArrayList<TIFFImageFileDirectory> ifdList = new ArrayList();

    public TIFFFile getFile() {
        return this.f;
    }

    public ArrayList<TIFFImageFileDirectory> getListOfImageFileDirectories() {
        return this.ifdList;
    }

    public void read(String string) throws EOFException, IOException, TIFFException {
        this.f = new TIFFFile(string);
        long l = this.f.getOffset();
        slf4jlogger.debug("read(): ifdOffset={}", l);
        while (l != 0L) {
            long[] lArray;
            TIFFImageFileDirectory tIFFImageFileDirectory = new TIFFImageFileDirectory();
            l = tIFFImageFileDirectory.read(this.f, l);
            this.ifdList.add(tIFFImageFileDirectory);
            TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = tIFFImageFileDirectory.getEntry(330);
            if (tIFFImageFileDirectoryEntry == null || tIFFImageFileDirectoryEntry.getNumberOfValues() <= 0L) continue;
            slf4jlogger.debug("read(): processing subIFDs");
            for (long l2 : lArray = tIFFImageFileDirectoryEntry.getValues().getNumericValues()) {
                slf4jlogger.debug("read(): subIFDOffset={}", l2);
                TIFFImageFileDirectory tIFFImageFileDirectory2 = new TIFFImageFileDirectory();
                tIFFImageFileDirectory2.read(this.f, l2);
                this.ifdList.add(tIFFImageFileDirectory2);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.f != null) {
            stringBuffer.append(this.f);
        }
        int n = 0;
        String string = "";
        for (TIFFImageFileDirectory tIFFImageFileDirectory : this.ifdList) {
            stringBuffer.append(string);
            stringBuffer.append("Directory ");
            stringBuffer.append(n++);
            stringBuffer.append(": ");
            stringBuffer.append(tIFFImageFileDirectory);
            string = "\n";
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                TIFFImageFileDirectories tIFFImageFileDirectories = new TIFFImageFileDirectories();
                tIFFImageFileDirectories.read(stringArray[0]);
                System.err.print(tIFFImageFileDirectories);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: TIFFImageFileDirectories filename");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

