/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import au.com.bytecode.opencsv.CSV;
import au.com.bytecode.opencsv.CSVReadProc;
import com.pixelmed.apps.SetCharacteristicsFromSummary;
import com.pixelmed.apps.TiledPyramid;
import com.pixelmed.convert.AddTIFFOrOffsetTables;
import com.pixelmed.convert.CommonConvertedAttributeGeneration;
import com.pixelmed.convert.Immunostaining;
import com.pixelmed.convert.TIFFException;
import com.pixelmed.convert.TIFFFile;
import com.pixelmed.convert.TIFFImageFileDirectories;
import com.pixelmed.convert.TIFFImageFileDirectory;
import com.pixelmed.convert.TIFFImageFileDirectoryEntry;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.CompressedFrameEncoder;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.LongTextAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.OtherByteAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherFloatAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherVeryLongAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TiledFramesIndex;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnlimitedTextAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.HexDump;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TIFFToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/TIFFToDicom.java,v 1.146 2025/02/11 14:12:34 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TIFFToDicom.class);
    private List<File> filesToDeleteAfterWritingDicomFile = null;
    private UIDGenerator u = new UIDGenerator();
    private static final String pixelmedPrivateCreator = "PixelMed Publishing";
    private static final int pixelmedPrivateOriginalFileNameDataGroup = 9;
    private static final AttributeTag pixelmedPrivateOriginalFileNameDataBlockReservation = new AttributeTag(9, 16);
    private static final AttributeTag pixelmedPrivateOriginalFileName = new AttributeTag(9, 4097);
    private static final AttributeTag pixelmedPrivateOriginalTIFFIFDIndex = new AttributeTag(9, 4098);
    private static final long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    private static byte[] AdobeAPP14_RGB = new byte[]{-1, -18, 0, 14, 65, 100, 111, 98, 101, 0, 101, 0, 0, 0, 0, 0};
    private static boolean encounteredZeroLengthTiles = false;
    private static boolean encounteredInvalidJPEGFamilyBitstreamTiles = false;
    private static final String pixelmedPrivateCreatorForPyramidData = "PixelMed Publishing";
    private static final int pixelmedPrivatePyramidDataGroup = 32735;
    private static final AttributeTag pixelmedPrivatePyramidDataBlockReservation = new AttributeTag(32735, 16);
    private static final AttributeTag pixelmedPrivatePyramidData = new AttributeTag(32735, 4097);

    private static boolean isValidJPEGFamilyBitstream(byte[] byArray) {
        int n = byArray.length;
        return n > 2 && (byArray[0] & 0xFF) == 255 && ((byArray[1] & 0xFF) == 216 || (byArray[1] & 0xFF) == 79);
    }

    private static byte[] stripSOIEOIMarkers(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        if (n >= 4 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216 && (byArray[n - 2] & 0xFF) == 255 && (byArray[n - 1] & 0xFF) == 217) {
            if (n > 4) {
                int n2 = n - 4;
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 2, byArray2, 0, n2);
            }
        } else {
            slf4jlogger.error("stripSOIEOIMarkers(): Unable to remove SOI and EOI markers");
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static byte[] insertJPEGTablesIntoAbbreviatedBitStream(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        int n = byArray.length;
        if (n > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            int n2 = byArray2.length;
            int n3 = n + n2;
            byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray3, 0, 2);
            System.arraycopy(byArray2, 0, byArray3, 2, n2);
            System.arraycopy(byArray, 2, byArray3, 2 + n2, n - 2);
        } else {
            slf4jlogger.error("insertJPEGTablesIntoAbbreviatedBitStream(): Unable to insert JPEG Tables");
            slf4jlogger.error("insertJPEGTablesIntoAbbreviatedBitStream(): Unable to insert JPEG Tables: l = {}", n);
            if (n >= 2) {
                slf4jlogger.error("insertJPEGTablesIntoAbbreviatedBitStream(): Unable to insert JPEG Tables: bytes[0]&0xff = {}", HexDump.byteToPaddedHexString(byArray[0] & 0xFF));
                slf4jlogger.error("insertJPEGTablesIntoAbbreviatedBitStream(): Unable to insert JPEG Tables: bytes[1]&0xff = {}", HexDump.byteToPaddedHexString(byArray[1] & 0xFF));
                if (slf4jlogger.isTraceEnabled()) {
                    try {
                        File file = File.createTempFile("TIFFToDicom_insertJPEGTablesIntoAbbreviatedBitStream_badframe", ".jpeg");
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                        bufferedOutputStream.write(byArray);
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                        slf4jlogger.trace("insertJPEGTablesIntoAbbreviatedBitStream(): wrote bad JPEG frame to {}", file.toString());
                    }
                    catch (IOException iOException) {
                        slf4jlogger.trace("insertJPEGTablesIntoAbbreviatedBitStream(): unable to write bad JPEG frame: {}", iOException);
                    }
                }
            }
            byArray3 = byArray;
        }
        return byArray3;
    }

    private static byte[] insertAdobeAPP14WithRGBTransformIntoBitStream(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        if (n > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            int n2 = AdobeAPP14_RGB.length;
            int n3 = n + n2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, 2);
            System.arraycopy(AdobeAPP14_RGB, 0, byArray2, 2, n2);
            System.arraycopy(byArray, 2, byArray2, 2 + n2, n - 2);
        } else {
            slf4jlogger.error("insertAdobeAPP14WithRGBTransformIntoBitStream(): Unable to insert APP14");
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static byte[] removeAPP0Segment(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        if (n >= 6 && (byArray[2] & 0xFF) == 255 && (byArray[3] & 0xFF) == 224) {
            int n2 = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
            slf4jlogger.trace("removeAPP0Segment(): lseg = {}", n2);
            if (n2 > 0) {
                int n3 = 2 + n2;
                slf4jlogger.trace("removeAPP0Segment(): remove = {}", n3);
                int n4 = n - n3;
                byArray2 = new byte[n4];
                int n5 = 2 + n3;
                int n6 = n4 - 2;
                System.arraycopy(byArray, 0, byArray2, 0, 2);
                System.arraycopy(byArray, n5, byArray2, 2, n6);
                slf4jlogger.trace("removeAPP0Segment(): Removed APP0 segment");
            } else {
                slf4jlogger.warn("removeAPP0Segment(): APP0 segment with zero length - not removing");
            }
        } else {
            slf4jlogger.trace("removeAPP0Segment(): No APP0 segment to remove");
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createCompressedImage(BufferedImage bufferedImage, String string, OutputStream outputStream) throws IOException, DicomException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator == null || !iterator.hasNext()) throw new DicomException("Cannot find writer for format " + string);
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) throw new DicomException("Cannot find writer for format " + string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("createCompressedImage(): Using writer {} {} {}", imageWriter.getOriginatingProvider().getDescription(Locale.US), imageWriter.getOriginatingProvider().getVendorName(), imageWriter.getOriginatingProvider().getVersion());
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        try {
            Class<?> clazz;
            boolean bl = false;
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            boolean bl2 = imageWriteParam.canWriteCompressed();
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("createCompressedImage(): ImageWriteParam.canWriteCompressed() = {}", bl2);
            }
            if (bl2) {
                if (string.equals("jpeg2000")) {
                    clazz = Class.forName("com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam");
                    if (imageWriteParam != null && clazz.isInstance(imageWriteParam)) {
                        Method method = clazz.getMethod("canWriteCompressed", new Class[0]);
                        if (method == null) {
                            throw new DicomException("Could not get J2KImageWriteParam.canWriteCompressed() method");
                        }
                        Method method2 = clazz.getMethod("setLossless", Boolean.TYPE);
                        if (method2 == null) {
                            throw new DicomException("Could not get J2KImageWriteParam.setLossless() method");
                        }
                        method2.invoke((Object)imageWriteParam, Boolean.TRUE);
                        Method method3 = clazz.getMethod("setComponentTransformation", Boolean.TYPE);
                        if (method3 == null) {
                            throw new DicomException("Could not get J2KImageWriteParam.setComponentTransformation() method");
                        }
                        method3.invoke((Object)imageWriteParam, Boolean.TRUE);
                        Method method4 = clazz.getMethod("setWriteCodeStreamOnly", Boolean.TYPE);
                        if (method4 == null) {
                            throw new DicomException("Could not get setWriteCodeStreamOnly() method");
                        }
                        method4.invoke((Object)imageWriteParam, Boolean.TRUE);
                        bl = true;
                    }
                } else if (string.equals("jpeg")) {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionQuality(1.0f);
                    bl = true;
                }
            }
            if (bl) {
                clazz = null;
                imageWriter.write((IIOMetadata)((Object)clazz), new IIOImage(bufferedImage, null, (IIOMetadata)((Object)clazz)), imageWriteParam);
                imageOutputStream.flush();
                imageOutputStream.close();
                try {
                    slf4jlogger.trace("createCompressedImage(): Calling dispose() on writer");
                    imageWriter.dispose();
                    return;
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
                return;
            }
            slf4jlogger.error("Could not setup writer with compression and necessary parameters");
            return;
        }
        catch (Exception exception) {
            slf4jlogger.error("Exception while setting parameters for writer", exception);
        }
    }

    private static byte[] createEmptyCompressedTile(long l, long l2, long l3, long l4, long l5) {
        byte[] byArray = null;
        String string = null;
        if (l3 == 7L) {
            string = "jpeg";
        } else if (l3 == 33003L || l3 == 33005L) {
            string = "jpeg2000";
        } else {
            slf4jlogger.error("Unrecognized compression " + l3 + " while trying to create empty compressed tile");
        }
        if (string != null) {
            try {
                if (l5 == 3L && (l4 == 2L || l4 == 6L)) {
                    BufferedImage bufferedImage = new BufferedImage((int)l, (int)l2, 1);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    TIFFToDicom.createCompressedImage(bufferedImage, string, byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                    if (byArray != null && byArray.length > 0) {
                        slf4jlogger.trace("Created empty {} compressed tile width {} length {} bytes {}", string, l, l2, byArray.length);
                        if (byArray.length >= 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
                            byArray = TIFFToDicom.removeAPP0Segment(byArray);
                        } else if (byArray.length < 2 || (byArray[0] & 0xFF) != 255 || (byArray[1] & 0xFF) != 79) {
                            slf4jlogger.error("Created empty compressed tile but does not start with SOI or SOC marker");
                        }
                    }
                } else {
                    slf4jlogger.error("Unsupported samplesPerPixel " + l5 + " or photometric " + l4 + " while trying to create empty compressed tile");
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("Attempt to use compressed writer to create empty compressed tile failed", exception);
            }
        }
        return byArray;
    }

    private static byte[] readJPEGFamilyCompressedPixelValuesAndFixAsNecessary(TIFFFile tIFFFile, int n, long l, long l2, byte[] byArray, long l3, long l4, long l5, long l6, long l7) throws IOException, TIFFException {
        byte[] byArray2 = null;
        if (l2 == 0L) {
            if (!encounteredZeroLengthTiles) {
                slf4jlogger.warn("Encountered tiles with pixelByteCount of zero - assume empty tile");
                encounteredZeroLengthTiles = true;
            }
            slf4jlogger.trace("For frame {}, pixelByteCount is zero - assume empty tile", n);
            byArray2 = TIFFToDicom.createEmptyCompressedTile(l3, l4, l5, l6, l7);
            if (byArray2 == null || byArray2.length == 0) {
                throw new TIFFException("For frame " + n + ", pixelByteCount is zero and could not create empty compressed tile");
            }
        } else {
            byArray2 = new byte[(int)l2];
            tIFFFile.seek(l);
            int n2 = tIFFFile.read(byArray2);
            slf4jlogger.trace("For frame {}, bytes read = {}, expected = {}", n, n2, l2);
            if (n2 != (int)l2) {
                throw new TIFFException("For frame " + n + ", bytes read " + n2 + " not equal to compressed pixelByteCount to be read " + l2);
            }
            if (TIFFToDicom.isValidJPEGFamilyBitstream(byArray2)) {
                if (l5 == 7L) {
                    byArray2 = TIFFToDicom.removeAPP0Segment(byArray2);
                    if (byArray != null) {
                        byArray2 = TIFFToDicom.insertJPEGTablesIntoAbbreviatedBitStream(byArray2, byArray);
                    }
                    if (l6 == 2L) {
                        slf4jlogger.trace("JPEG RGB so adding APP14");
                        byArray2 = TIFFToDicom.insertAdobeAPP14WithRGBTransformIntoBitStream(byArray2);
                    }
                }
            } else {
                if (!encounteredInvalidJPEGFamilyBitstreamTiles) {
                    slf4jlogger.warn("Encountered tiles with invalid JPEG family bitstream - assume empty tile");
                    encounteredInvalidJPEGFamilyBitstreamTiles = true;
                }
                slf4jlogger.trace("For frame {}, invalid JPEG family bitstream - assume empty tile", n);
                byArray2 = TIFFToDicom.createEmptyCompressedTile(l3, l4, l5, l6, l7);
                if (byArray2 == null || byArray2.length == 0) {
                    throw new TIFFException("For frame " + n + ", invalid JPEG family bitstream and could not create empty compressed tile");
                }
            }
        }
        return byArray2;
    }

    private void addTotalPixelMatrixOriginSequence(AttributeList attributeList, double d, double d2) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("TotalPixelMatrixOriginSequence"));
        attributeList.put(sequenceAttribute);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("XOffsetInSlideCoordinateSystem"));
        ((Attribute)decimalStringAttribute).addValue(d);
        attributeList2.put(decimalStringAttribute);
        decimalStringAttribute = new DecimalStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("YOffsetInSlideCoordinateSystem"));
        ((Attribute)decimalStringAttribute).addValue(d2);
        attributeList2.put(decimalStringAttribute);
    }

    private static byte[] convertPlanarConfigurationToColorByPixel(byte[] byArray, long l, long l2, long l3) {
        int n = (int)(l * l2);
        byte[] byArray2 = new byte[(int)((long)n * l3)];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            while ((long)n2 < l3) {
                int n3 = i * (int)l3 + n2;
                int n4 = i + n * n2;
                byArray2[n3] = byArray[n4];
                ++n2;
            }
        }
        return byArray2;
    }

    private static short[] convertPlanarConfigurationToColorByPixel(short[] sArray, long l, long l2, long l3) {
        int n = (int)(l * l2);
        short[] sArray2 = new short[(int)((long)n * l3)];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            while ((long)n2 < l3) {
                int n3 = i * (int)l3 + n2;
                int n4 = i + n * n2;
                sArray2[n3] = sArray[n4];
                ++n2;
            }
        }
        return sArray2;
    }

    private static void assertPixelDataEncodingIsCompatibleWithTransferSyntax(AttributeList attributeList, String string) throws DicomException {
        boolean bl = new TransferSyntax(string).isEncapsulated();
        Attribute attribute = attributeList.get(TagFromName.PixelData);
        if (attribute != null) {
            if (bl) {
                if (!(attribute instanceof OtherByteAttributeMultipleCompressedFrames)) {
                    throw new DicomException("Encapsulated TransferSyntax " + string + " inconsistent with non-encapsulated pixel data encoded in " + attribute.getClass().toString());
                }
            } else if (!(attribute instanceof OtherByteAttribute || attribute instanceof OtherWordAttribute || attribute instanceof OtherByteAttributeMultipleFilesOnDisk || attribute instanceof OtherWordAttributeMultipleFilesOnDisk)) {
                throw new DicomException("Non-encapsulated TransferSyntax " + string + " inconsistent with encapsulated pixel data encoded in " + attribute.getClass().toString());
            }
        } else {
            attribute = attributeList.get(TagFromName.FloatPixelData);
            if (attribute != null && bl) {
                throw new DicomException("Encapsulated TransferSyntax " + string + " inconsistent with float pixel data encoded in " + attribute.getClass().toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long generateDICOMPixelDataMultiFrameImageFromTIFFFile(TIFFFile tIFFFile, AttributeList attributeList, boolean bl, boolean bl2, int n, int n2, long[] lArray, long[] lArray2, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, byte[] byArray, byte[] byArray2, String string, boolean bl3) throws IOException, DicomException, TIFFException {
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): compression = {}", l5);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): predictor = {}", l9);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): planarConfig = {}", l8);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): samplesPerPixel = {}", l7);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): bitsPerSample = {}", l3);
        int n3 = (int)(l8 == 1L ? l7 * l3 / 8L : l3 / 8L);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): bytesPerPixelForHorizontalDifferencing = {}", n3);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): sampleFormat = {}", l4);
        boolean bl4 = l4 == 3L;
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): mergeSamplesPerPixelTiles = {}", bl);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): alwaysMakeColorByPixelPlanarConfig = {}", bl2);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): numberOfSourceTiles = {}", n);
        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): numberOfDestinationTiles = {}", n2);
        long l10 = l * l2 * (l3 / 8L) * l7;
        long l11 = l6;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if ((long)n2 > Integer.MAX_VALUE) {
            throw new TIFFException("Number of tiles exceeds maximum IS value for NumberOfFrames = " + n2);
        }
        if (l > 65535L || l2 > 65535L) {
            throw new TIFFException("tileWidth " + l + " and/or tileLength " + l2 + " exceeds maximum US value for Columns and/or Rows");
        }
        if (l5 == 0L || l5 == 1L || l5 == 5L) {
            if (string == null || string.length() == 0) {
                slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): no output compression requested");
                boolean bl5 = false;
                File[] fileArray = null;
                if (l5 == 5L) {
                    slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Decompressing LZW to write as uncompressed ");
                    if (bl) {
                        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Using LZW tiles as source merging separate tiles per channel into one tile");
                        long l12 = l * l2 * l7 * l3 / 8L;
                        byte[] byArray3 = new byte[(int)l12];
                        fileArray = new File[n2];
                        for (int i = 0; i < n2; ++i) {
                            File file;
                            void var44_68;
                            int n4 = 0;
                            boolean bl6 = false;
                            while ((long)var44_68 < l7) {
                                void var45_83 = var44_68 * n2 + i;
                                long l13 = lArray[var45_83];
                                long l14 = lArray2[var45_83];
                                byte[] byArray4 = new byte[(int)l14];
                                tIFFFile.seek(l13);
                                tIFFFile.read(byArray4);
                                byArray4 = this.lzwUncompress(byArray4);
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): decompressed LZW tile length = {}", byArray4.length);
                                }
                                if (l9 == 2L) {
                                    this.reverseHorizontalDifferencing(byArray4, n3, l);
                                }
                                if (l3 == 16L) {
                                    ByteArray.swapEndianness(byArray4, byArray4.length, 2);
                                }
                                System.arraycopy(byArray4, 0, byArray3, n4, byArray4.length);
                                n4 += byArray4.length;
                                ++var44_68;
                            }
                            if (bl2 && l8 == 2L) {
                                byArray3 = TIFFToDicom.convertPlanarConfigurationToColorByPixel(byArray3, l, l2, l7);
                            }
                            fileArray[i] = file = File.createTempFile("TIFFToDicom", ".raw");
                            file.deleteOnExit();
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Tile {} created uncompressed temporary file {}", i, file.toString());
                            }
                            if (this.filesToDeleteAfterWritingDicomFile == null) {
                                this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>();
                            } else {
                                this.filesToDeleteAfterWritingDicomFile.add(file);
                            }
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Tile {} writing {} bytes to temporary file {}", i, byArray3.length, file.toString());
                            }
                            bufferedOutputStream.write(byArray3);
                            bufferedOutputStream.flush();
                            bufferedOutputStream.close();
                            if (!slf4jlogger.isTraceEnabled()) continue;
                            slf4jlogger.trace("Tile {} after write, temporary file length = {}", i, file.length());
                        }
                    } else {
                        fileArray = new File[n2];
                        for (int i = 0; i < n2; ++i) {
                            File file;
                            long l15 = lArray[i];
                            long l16 = lArray2[i];
                            byte[] byArray5 = new byte[(int)l16];
                            tIFFFile.seek(l15);
                            tIFFFile.read(byArray5);
                            byte[] byArray6 = this.lzwUncompress(byArray5);
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): decompressed LZW tile length = {}", byArray6.length);
                            }
                            if (l9 == 2L) {
                                this.reverseHorizontalDifferencing(byArray6, n3, l);
                            }
                            if (l3 == 16L) {
                                ByteArray.swapEndianness(byArray6, byArray6.length, 2);
                            }
                            fileArray[i] = file = File.createTempFile("TIFFToDicom", ".raw");
                            file.deleteOnExit();
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Tile {} created uncompressed temporary file {}", i, file.toString());
                            }
                            if (this.filesToDeleteAfterWritingDicomFile == null) {
                                this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>();
                            } else {
                                this.filesToDeleteAfterWritingDicomFile.add(file);
                            }
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Tile {} writing {} bytes to temporary file {}", i, byArray6.length, file.toString());
                            }
                            bufferedOutputStream.write(byArray6);
                            bufferedOutputStream.flush();
                            bufferedOutputStream.close();
                            if (!slf4jlogger.isTraceEnabled()) continue;
                            slf4jlogger.trace("Tile {} after write, temporary file length = {}", i, file.length());
                        }
                    }
                } else {
                    slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Using uncompressed tiles as source");
                    if (bl) {
                        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Using uncompressed tiles as source merging separate tiles per channel into one tile");
                        long l17 = l * l2 * l7 * l3 / 8L;
                        byte[] byArray7 = new byte[(int)l17];
                        fileArray = new File[n2];
                        for (int i = 0; i < n2; ++i) {
                            File file;
                            void var44_73;
                            int n5 = 0;
                            boolean bl7 = false;
                            while ((long)var44_73 < l7) {
                                void var45_86 = var44_73 * n2 + i;
                                long l18 = lArray[var45_86];
                                long l19 = lArray2[var45_86];
                                byte[] byArray8 = new byte[(int)l19];
                                tIFFFile.seek(l18);
                                tIFFFile.read(byArray8);
                                System.arraycopy(byArray8, 0, byArray7, n5, (int)l19);
                                n5 = (int)((long)n5 + l19);
                                ++var44_73;
                            }
                            if (bl2 && l8 == 2L) {
                                byArray7 = TIFFToDicom.convertPlanarConfigurationToColorByPixel(byArray7, l, l2, l7);
                            }
                            fileArray[i] = file = File.createTempFile("TIFFToDicom", ".raw");
                            file.deleteOnExit();
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Tile {} created uncompressed temporary file {}", i, file.toString());
                            }
                            if (this.filesToDeleteAfterWritingDicomFile == null) {
                                this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>();
                            } else {
                                this.filesToDeleteAfterWritingDicomFile.add(file);
                            }
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Tile {} writing {} bytes to temporary file {}", i, byArray7.length, file.toString());
                            }
                            bufferedOutputStream.write(byArray7);
                            bufferedOutputStream.flush();
                            bufferedOutputStream.close();
                            if (!slf4jlogger.isTraceEnabled()) continue;
                            slf4jlogger.trace("Tile {} after write, temporary file length = {}", i, file.length());
                        }
                    } else {
                        slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Using uncompressed tiles as source with source tiles same as destination tiles");
                        bl5 = true;
                        File file = new File(tIFFFile.getFileName());
                        fileArray = new File[n];
                        for (int i = 0; i < n; ++i) {
                            long l20 = lArray2[i];
                            if (l20 != l10) {
                                slf4jlogger.warn("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Tile {} pixelByteCount {} != expected {}", i, l20, l10);
                            }
                            fileArray[i] = file;
                        }
                    }
                }
                if (l3 == 8L) {
                    if (bl4) throw new TIFFException("Unsupported 8 bit float pixel data");
                    slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): copying uncompressed or LZW decompressed 8 bit input to output");
                    OtherByteAttributeMultipleFilesOnDisk otherByteAttributeMultipleFilesOnDisk = new OtherByteAttributeMultipleFilesOnDisk(TagFromName.PixelData, fileArray, (long[])(bl5 ? lArray : null), (long[])(bl5 ? lArray2 : null));
                    long l21 = ((Attribute)otherByteAttributeMultipleFilesOnDisk).getPaddedVL();
                    if ((l21 & 0xFFFFFFFEL) != l21) {
                        throw new TIFFException("Value length of Pixel Data " + l21 + " exceeds maximum Value Length supported by DICOM");
                    }
                    attributeList.put(otherByteAttributeMultipleFilesOnDisk);
                    return l11;
                } else if (l3 == 16L) {
                    if (bl4) throw new TIFFException("Unsupported 16 bit float pixel data");
                    slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): copying uncompressed or LZW decompressed 16 bit input to output");
                    OtherWordAttributeMultipleFilesOnDisk otherWordAttributeMultipleFilesOnDisk = new OtherWordAttributeMultipleFilesOnDisk(TagFromName.PixelData, fileArray, (long[])(bl5 ? lArray : null), (long[])(bl5 ? lArray2 : null), tIFFFile.getByteOrder() == ByteOrder.BIG_ENDIAN);
                    long l22 = ((Attribute)otherWordAttributeMultipleFilesOnDisk).getPaddedVL();
                    if ((l22 & 0xFFFFFFFEL) != l22) {
                        throw new TIFFException("Value length of Pixel Data " + l22 + " exceeds maximum Value Length supported by DICOM");
                    }
                    attributeList.put(otherWordAttributeMultipleFilesOnDisk);
                    return l11;
                } else {
                    if (l3 != 32L) throw new TIFFException("Unsupported bitsPerSample = " + l3);
                    if (!bl4) {
                        throw new TIFFException("Unsupported 32 bit unsigned or signed integer or undefined pixel data");
                    }
                    slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): copying uncompressed or LZW decompressed 32 bit float input to output");
                    OtherFloatAttributeMultipleFilesOnDisk otherFloatAttributeMultipleFilesOnDisk = new OtherFloatAttributeMultipleFilesOnDisk(TagFromName.FloatPixelData, fileArray, (long[])(bl5 ? lArray : null), (long[])(bl5 ? lArray2 : null), tIFFFile.getByteOrder() == ByteOrder.BIG_ENDIAN);
                    long l23 = ((Attribute)otherFloatAttributeMultipleFilesOnDisk).getPaddedVL();
                    if ((l23 & 0xFFFFFFFEL) != l23) {
                        throw new TIFFException("Value length of Pixel Data " + l23 + " exceeds maximum Value Length supported by DICOM");
                    }
                    attributeList.put(otherFloatAttributeMultipleFilesOnDisk);
                }
                return l11;
            }
            slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): output compression requested");
            if (l3 == 8L) {
                slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): compressing uncompressed or LZW decompressed 8 bit input");
                File[] fileArray = new File[n2];
                for (int i = 0; i < n2; ++i) {
                    void var44_74;
                    File file;
                    byte[] byArray9;
                    long l24 = lArray[i];
                    long l25 = lArray2[i];
                    if (l25 != l10 && l25 != 0L) {
                        slf4jlogger.warn("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Tile {} pixelByteCount {} != expected {}", i, l25, l10);
                    }
                    if (l25 > 0L) {
                        byArray9 = new byte[(int)l25];
                        tIFFFile.seek(l24);
                        tIFFFile.read(byArray9);
                        if (l5 == 5L) {
                            byArray9 = this.lzwUncompress(byArray9);
                            slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): decompressed LZW tile length in bytes = {}", byArray9.length);
                            slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): expected tileWidth*tileLength*bytesPerPixelForHorizontalDifferencing = {}", l * l2 * (long)n3);
                            if (l9 == 2L) {
                                this.reverseHorizontalDifferencing(byArray9, n3, l);
                            }
                        }
                    } else {
                        slf4jlogger.warn("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): Tile {} pixelByteCount {} so creating empty tile", i, l25);
                        byArray9 = new byte[(int)l10];
                    }
                    Object var44_75 = null;
                    if (l7 == 1L) {
                        BufferedImage bufferedImage = SourceImage.createByteGrayscaleImage((int)l, (int)l2, byArray9, 0);
                    } else {
                        if (l7 != 3L) throw new TIFFException("Unsupported samplesPerPixel = " + l7 + " for re-compression");
                        if (l8 != 1L) throw new TIFFException("Unsupported planarConfig = " + l8 + " for re-compression");
                        BufferedImage bufferedImage = SourceImage.createPixelInterleavedByteThreeComponentColorImage((int)l, (int)l2, byArray9, 0, ColorSpace.getInstance(1000), false);
                    }
                    fileArray[i] = file = CompressedFrameEncoder.getCompressedFrameAsFile(new AttributeList(), (BufferedImage)var44_74, string, File.createTempFile("TIFFToDicom", "." + string));
                    file.deleteOnExit();
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Tile {} created compressed temporary file {}", i, file.toString());
                    }
                    if (l7 != 3L) continue;
                    l11 = 6L;
                }
                OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
                attributeList.put(otherByteAttributeMultipleCompressedFrames);
                if (this.filesToDeleteAfterWritingDicomFile == null) {
                    this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>(Arrays.asList(fileArray));
                    return l11;
                } else {
                    Collections.addAll(this.filesToDeleteAfterWritingDicomFile, fileArray);
                }
                return l11;
            } else {
                if (l3 != 16L || l7 != 1L || !string.equals("jpeg2000")) throw new TIFFException("Unsupported bitsPerSample = " + l3 + " and samplesPerPixel = " + l7 + " for recompression as " + string);
                slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): compressing uncompressed or LZW decompressed 16 bit grayscale input as jpeg2000");
                File[] fileArray = new File[n2];
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    long l26 = lArray[i];
                    long l27 = lArray2[i];
                    short[] sArray = null;
                    if (l5 == 0L || l5 == 1L) {
                        sArray = new short[(int)l27 / 2];
                        tIFFFile.seek(l26);
                        tIFFFile.read(sArray);
                    } else if (l5 == 5L) {
                        byte[] byArray10 = new byte[(int)l27];
                        tIFFFile.seek(l26);
                        tIFFFile.read(byArray10);
                        object = this.lzwUncompress(byArray10);
                        slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): decompressed LZW tile length in bytes = {}", ((byte[])object).length);
                        slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): expected tileWidth*tileLength*bytesPerPixelForHorizontalDifferencing = {}", l * l2 * (long)n3);
                        if (l9 == 2L) {
                            this.reverseHorizontalDifferencing((byte[])object, n3, l);
                        }
                        sArray = new short[(int)(l * l2)];
                        ByteBuffer.wrap((byte[])object).order(tIFFFile.getByteOrder()).asShortBuffer().get(sArray);
                    }
                    if ((long)sArray.length != l * l2) {
                        throw new TIFFException("Length of short pixel array " + sArray.length + " does not match tile size " + l * l2 + " from width " + l + " and length " + l2);
                    }
                    BufferedImage bufferedImage = SourceImage.createUnsignedShortGrayscaleImage((int)l, (int)l2, sArray, 0);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): BufferedImage for compression is \n{}\n", BufferedImageUtilities.describeImage(bufferedImage));
                    }
                    object = CompressedFrameEncoder.getCompressedFrameAsFile(new AttributeList(), bufferedImage, string, File.createTempFile("TIFFToDicom", "." + string));
                    fileArray[i] = object;
                    ((File)object).deleteOnExit();
                    if (!slf4jlogger.isTraceEnabled()) continue;
                    slf4jlogger.trace("Tile {} created compressed temporary file {}", i, ((File)object).toString());
                }
                OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
                attributeList.put(otherByteAttributeMultipleCompressedFrames);
                if (this.filesToDeleteAfterWritingDicomFile == null) {
                    this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>(Arrays.asList(fileArray));
                    return l11;
                } else {
                    Collections.addAll(this.filesToDeleteAfterWritingDicomFile, fileArray);
                }
            }
            return l11;
        }
        if (l5 == 7L && string.equals("jpeg") || (l5 == 33003L || l5 == 33005L) && string.equals("jpeg2000")) {
            slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): copying compressed bit stream from input to output without recompressing it");
            File[] fileArray = new File[n2];
            for (int i = 0; i < n2; ++i) {
                File file;
                long l28 = lArray[i];
                slf4jlogger.trace("For frame {}, pixelOffset = {}", i, l28);
                long l29 = lArray2[i];
                if (l29 > Integer.MAX_VALUE) {
                    throw new TIFFException("For frame " + i + ", compressed pixelByteCount to be read " + l29 + " exceeds maximum Java array size " + Integer.MAX_VALUE + " and fragmentation not yet supported");
                }
                byte[] byArray11 = TIFFToDicom.readJPEGFamilyCompressedPixelValuesAndFixAsNecessary(tIFFFile, i, l28, l29, byArray, l, l2, l5, l6, l7);
                if ((long)byArray11.length > 0xFFFFFFFEL) {
                    throw new TIFFException("For frame " + i + ", compressed pixelByteCount to be written " + byArray11.length + " exceeds maximum single fragment size 0xfffffffe and fragmentation not yet supported");
                }
                fileArray[i] = file = File.createTempFile("TIFFToDicom", ".jpeg");
                file.deleteOnExit();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(byArray11);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Tile {} wrote {} bytes to {}", i, byArray11.length, file.toString());
                }
                if (l5 != 33003L) continue;
                l11 = 6L;
            }
            OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
            attributeList.put(otherByteAttributeMultipleCompressedFrames);
            if (this.filesToDeleteAfterWritingDicomFile == null) {
                this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>(Arrays.asList(fileArray));
                return l11;
            } else {
                Collections.addAll(this.filesToDeleteAfterWritingDicomFile, fileArray);
            }
            return l11;
        } else {
            if (l5 != 7L && l5 != 33003L && l5 != 33005L || !string.equals("jpeg") && !string.equals("jpeg2000")) throw new TIFFException("Unsupported compression = " + l5 + " or unsupported transformation to " + string);
            if (l3 != 8L) throw new TIFFException("Unsupported bitsPerSample = " + l3 + " for compression");
            slf4jlogger.debug("generateDICOMPixelDataMultiFrameImageFromTIFFFile(): decompressing each 8 bit input frame and recompressing it");
            String string2 = l5 == 7L ? "1.2.840.10008.1.2.4.50" : "1.2.840.10008.1.2.4.91";
            CompressedFrameDecoder compressedFrameDecoder = new CompressedFrameDecoder(string2, 1, (int)l, (int)l2, 3, ColorSpace.getInstance(1000), l6 == 6L);
            File[] fileArray = new File[n2];
            for (int i = 0; i < n2; ++i) {
                File file;
                long l30 = lArray[i];
                long l31 = lArray2[i];
                if (l31 > Integer.MAX_VALUE) {
                    throw new TIFFException("For frame " + i + ", compressed pixelByteCount to be read " + l31 + " exceeds maximum Java array size " + Integer.MAX_VALUE + " and fragmentation not yet supported");
                }
                byte[] byArray12 = TIFFToDicom.readJPEGFamilyCompressedPixelValuesAndFixAsNecessary(tIFFFile, i, l30, l31, byArray, l, l2, l5, l6, l7);
                BufferedImage bufferedImage = compressedFrameDecoder.getDecompressedFrameAsBufferedImage(byArray12);
                fileArray[i] = file = CompressedFrameEncoder.getCompressedFrameAsFile(new AttributeList(), bufferedImage, string, File.createTempFile("TIFFToDicom", "." + string));
                file.deleteOnExit();
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Tile {} created compressed temporary file {}", i, file.toString());
                }
                l11 = 6L;
            }
            OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
            attributeList.put(otherByteAttributeMultipleCompressedFrames);
            if (this.filesToDeleteAfterWritingDicomFile == null) {
                this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>(Arrays.asList(fileArray));
                return l11;
            } else {
                Collections.addAll(this.filesToDeleteAfterWritingDicomFile, fileArray);
            }
        }
        return l11;
    }

    private byte[] lzwUncompress(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[][] byArray2 = new byte[4096][1];
        int n2 = 9;
        int n3 = 258;
        int n4 = -1;
        ByteVector byteVector = new ByteVector(8192);
        BitBuffer bitBuffer = new BitBuffer(byArray);
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        while ((n = bitBuffer.getBits(n2)) != 257 && n != -1) {
            ByteVector byteVector2;
            if (n == 256) {
                for (int i = 0; i < 256; ++i) {
                    byArray2[i][0] = (byte)i;
                }
                n3 = 258;
                n2 = 9;
                n = bitBuffer.getBits(n2);
                if (n == 257 || n == -1) break;
                byteVector.add(byArray2[n]);
                n4 = n;
                continue;
            }
            if (n < n3) {
                byteVector.add(byArray2[n]);
                byteVector2 = new ByteVector(byArray3);
                byteVector2.add(byArray2[n4]);
                byteVector2.add(byArray2[n][0]);
                byArray2[n3] = byteVector2.toByteArray();
                n4 = n;
                ++n3;
            } else {
                byteVector2 = new ByteVector(byArray4);
                byteVector2.add(byArray2[n4]);
                byteVector2.add(byArray2[n4][0]);
                byte[] byArray5 = byteVector2.toByteArray();
                byteVector.add(byArray5);
                byArray2[n3] = byArray5;
                n4 = n;
                ++n3;
            }
            if (n3 == 511) {
                n2 = 10;
            }
            if (n3 == 1023) {
                n2 = 11;
            }
            if (n3 != 2047) continue;
            n2 = 12;
        }
        return byteVector.toByteArray();
    }

    private void reverseHorizontalDifferencing(byte[] byArray, int n, long l) {
        slf4jlogger.trace("reverseHorizontalDifferencing(): reversing horizontal differencing");
        for (int i = 0; i < byArray.length; ++i) {
            if ((long)(i / n) % l == 0L) {
                slf4jlogger.trace("reverseHorizontalDifferencing(): start of row byte index = {}", i);
                continue;
            }
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] + byArray[i - n]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(TIFFFile tIFFFile, AttributeList attributeList, boolean bl, long l, long l2, long[] lArray, long[] lArray2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, byte[] byArray, byte[] byArray2, String string, boolean bl2) throws IOException, DicomException, TIFFException {
        long l12 = l8;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): compression = {}", l7);
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): predictor = {}", l11);
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): planarConfig = {}", l10);
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): samplesPerPixel = {}", l9);
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): bitsPerSample = {}", l5);
        int n = (int)(l10 == 1L ? l9 * l5 / 8L : l5 / 8L);
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): bytesPerPixelForHorizontalDifferencing = {}", n);
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): alwaysMakeColorByPixelPlanarConfig = {}", bl);
        if (l7 == 0L || l7 == 1L || l7 == 5L) {
            if (string != null && string.length() != 0) throw new TIFFException("Compression as " + (bl2 ? "lossy" : "lossless") + " " + string + " not supported");
            if (l5 == 8L) {
                slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): merging uncompressed or LZW compressed 8 bit strips");
                long l13 = l * l2 * l9;
                if (l13 % 2L != 0L) {
                    ++l13;
                }
                slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): totalLength = {}", l13);
                if (l13 > Integer.MAX_VALUE) {
                    throw new TIFFException("Uncompressed image too large to allocate = " + l13);
                }
                byte[] byArray3 = new byte[(int)l13];
                int n2 = 0;
                for (int i = 0; i < lArray.length; ++i) {
                    slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): doing strip = {} of {}", i, lArray.length);
                    slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): offsetIntoValue = {}", n2);
                    long l14 = lArray[i];
                    slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): pixelOffset[{}] = {}", i, l14);
                    tIFFFile.seek(l14);
                    int n3 = (int)lArray2[i];
                    slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): pixelByteCount[{}] = {}", i, n3);
                    if (l7 == 5L) {
                        byte[] byArray4 = new byte[n3];
                        tIFFFile.read(byArray4, 0, n3);
                        byte[] byArray5 = this.lzwUncompress(byArray4);
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): decompressed LZW strip length = {}", byArray5.length);
                        if (l11 == 2L) {
                            this.reverseHorizontalDifferencing(byArray5, n, l);
                        }
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): values.length = {} offsetIntoValues+decompressedStrip.length = {}", byArray3.length, n2 + byArray5.length);
                        int n4 = byArray3.length - n2;
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): spaceremaininginvalues = {}", n4);
                        int n5 = 0;
                        if (byArray5.length > n4) {
                            slf4jlogger.warn("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): decompressed LZW strip is too long for size of pixel matrix - have {} bytes, space remaining is only {} bytes for strip {} (from 0) of {}", byArray5.length, n4, i, lArray.length);
                            n5 = n4;
                        } else {
                            n5 = byArray5.length;
                        }
                        System.arraycopy(byArray5, 0, byArray3, n2, n5);
                        n2 += n5;
                        continue;
                    }
                    tIFFFile.read(byArray3, n2, n3);
                    n2 += n3;
                }
                if (bl && l10 == 2L) {
                    byArray3 = TIFFToDicom.convertPlanarConfigurationToColorByPixel(byArray3, l, l2, l9);
                }
                OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
                ((Attribute)otherByteAttribute).setValues(byArray3);
                attributeList.put(otherByteAttribute);
                return l12;
            } else {
                if (l5 != 16L) throw new TIFFException("Unsupported bitsPerSample = " + l5);
                long l15 = l * l2 * l9;
                slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): totalLength = {}", l15);
                if (l15 > Integer.MAX_VALUE) {
                    throw new TIFFException("Uncompressed image too large to allocate = " + l15 + " 16-bit words");
                }
                short[] sArray = new short[(int)l15];
                if (l7 == 5L) {
                    slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): merging LZW compressed 16 bit strips");
                    long l16 = l15 * 2L;
                    if (l16 > Integer.MAX_VALUE) {
                        throw new TIFFException("Uncompressed image too large to allocate = " + l16 + " bytes");
                    }
                    byte[] byArray6 = new byte[(int)l16];
                    int n6 = 0;
                    for (int i = 0; i < lArray.length; ++i) {
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): doing strip = {} of {}", i, lArray.length);
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): offsetIntoValue = {}", n6);
                        long l17 = lArray[i];
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): pixelOffset[{}] = {}", i, l17);
                        tIFFFile.seek(l17);
                        int n7 = (int)lArray2[i];
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): pixelByteCount[{}] = {}", i, n7);
                        byte[] byArray7 = new byte[n7];
                        tIFFFile.read(byArray7, 0, n7);
                        byte[] byArray8 = this.lzwUncompress(byArray7);
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): decompressed LZW strip length = {}", byArray8.length);
                        if (l11 == 2L) {
                            this.reverseHorizontalDifferencing(byArray8, n, l);
                        }
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): byteValues.length = {} offsetIntoValues+decompressedStrip.length = {}", byArray6.length, n6 + byArray8.length);
                        int n8 = byArray6.length - n6;
                        slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): spaceremaininginvalues = {}", n8);
                        int n9 = 0;
                        if (byArray8.length > n8) {
                            slf4jlogger.warn("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): decompressed LZW strip is too long for size of pixel matrix - have {} bytes, space remaining is only {} bytes for strip {} (from 0) of {}", byArray8.length, n8, i, lArray.length);
                            n9 = n8;
                        } else {
                            n9 = byArray8.length;
                        }
                        System.arraycopy(byArray8, 0, byArray6, n6, n9);
                        n6 += n9;
                    }
                    ByteBuffer.wrap(byArray6).order(tIFFFile.getByteOrder()).asShortBuffer().get(sArray);
                } else {
                    slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): merging uncompressed 16 bit strips");
                    int n10 = 0;
                    for (int i = 0; i < lArray.length; ++i) {
                        long l18 = lArray[i];
                        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): pixelOffset[{}] = {}", i, l18);
                        tIFFFile.seek(l18);
                        int n11 = (int)(lArray2[i] / 2L);
                        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): pixelByteCount[{}] = {}, shortsToRead = {}", i, lArray2[i], n11);
                        tIFFFile.read(sArray, n10, n11);
                        n10 += n11;
                    }
                }
                if (bl && l10 == 2L) {
                    sArray = TIFFToDicom.convertPlanarConfigurationToColorByPixel(sArray, l, l2, l9);
                }
                OtherWordAttribute otherWordAttribute = new OtherWordAttribute(TagFromName.PixelData);
                ((Attribute)otherWordAttribute).setValues(sArray);
                attributeList.put(otherWordAttribute);
            }
            return l12;
        } else {
            if (l7 != 7L) throw new TIFFException("Unsupported compression = " + l7);
            if (string != null && string.length() != 0) throw new TIFFException("Compression as " + (bl2 ? "lossy" : "lossless") + " " + string + " not supported");
            if (l5 != 8L) throw new TIFFException("Unsupported bitsPerSample = " + l5);
            slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): decompressing each 8 bit input strip");
            CompressedFrameDecoder compressedFrameDecoder = new CompressedFrameDecoder("1.2.840.10008.1.2.4.50", 1, (int)l3, (int)l4, 3, ColorSpace.getInstance(1000), l8 == 6L);
            long l19 = l * l2 * l9;
            if (l19 % 2L != 0L) {
                ++l19;
            }
            slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): totalLength = {}", l19);
            if (l19 > Integer.MAX_VALUE) {
                throw new TIFFException("Uncompressed image too large to allocate = " + l19);
            }
            byte[] byArray9 = new byte[(int)l19];
            int n12 = 0;
            for (int i = 0; i < lArray.length; ++i) {
                slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} offsetIntoValues = {}", i, n12);
                byte[] byArray10 = TIFFToDicom.readJPEGFamilyCompressedPixelValuesAndFixAsNecessary(tIFFFile, 0, lArray[i], lArray2[i], byArray, l3, l4, l7, l8, l9);
                BufferedImage bufferedImage = compressedFrameDecoder.getDecompressedFrameAsBufferedImage(byArray10);
                int n13 = bufferedImage.getWidth();
                slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} decompressedWidth = {}", i, n13);
                int n14 = bufferedImage.getHeight();
                slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} decompressedHeight = {}", i, n14);
                Raster raster = bufferedImage.getData();
                if (raster.getTransferType() != 0) continue;
                byte[] byArray11 = (byte[])raster.getDataElements(0, 0, n13, n14, null);
                slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} decompressedStrip.length = {}", i, byArray11.length);
                int n15 = (int)l19 - n12;
                slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} bytesWanted = {}", i, n15);
                if (byArray11.length <= n15) {
                    n15 = byArray11.length;
                } else {
                    slf4jlogger.warn("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} using only {} bytes from {} available in last strip ", i, n15, byArray11.length);
                }
                slf4jlogger.trace("generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(): strip {} using {} bytes", i, n15);
                System.arraycopy(byArray11, 0, byArray9, n12, n15);
                n12 += n15;
            }
            OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
            ((Attribute)otherByteAttribute).setValues(byArray9);
            attributeList.put(otherByteAttribute);
        }
        return l12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long generateDICOMPixelDataSingleFrameImageFromTIFFFile(TIFFFile tIFFFile, AttributeList attributeList, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, byte[] byArray, byte[] byArray2, String string, boolean bl) throws IOException, DicomException, TIFFException {
        slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFile(): sampleFormat = {}", l6);
        boolean bl2 = l6 == 3L;
        long l10 = l8;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        tIFFFile.seek(l);
        if (l7 == 0L || l7 == 1L) {
            if (string != null && string.length() != 0) throw new TIFFException("Compression as " + (bl ? "lossy" : "lossless") + " " + string + " not supported");
            if (l5 == 8L) {
                if (bl2) throw new TIFFException("Unsupported 8 bit float pixel data");
                slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFile(): copying uncompressed 8 bit input to output");
                if (l2 > 0x7FFFFFFEL) {
                    throw new DicomException("Size of uncompressed 8 bit stream " + l2 + " bytes exceeds maximum supported " + 0x7FFFFFFE + " bytes");
                }
                byte[] byArray3 = new byte[(int)l2];
                tIFFFile.read(byArray3);
                OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
                ((Attribute)otherByteAttribute).setValues(byArray3);
                attributeList.put(otherByteAttribute);
                return l10;
            } else if (l5 == 16L) {
                if (bl2) throw new TIFFException("Unsupported 16 bit float pixel data");
                slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFile(): copying uncompressed 16 bit input to output");
                if (l2 / 2L > 0x7FFFFFFEL) {
                    throw new DicomException("Size of uncompressed 16 bit stream " + l2 + " bytes exceeds maximum supported " + -4 + " bytes");
                }
                short[] sArray = new short[(int)(l2 / 2L)];
                tIFFFile.read(sArray);
                OtherWordAttribute otherWordAttribute = new OtherWordAttribute(TagFromName.PixelData);
                ((Attribute)otherWordAttribute).setValues(sArray);
                attributeList.put(otherWordAttribute);
                return l10;
            } else {
                if (l5 != 32L) throw new TIFFException("Unsupported bitsPerSample = " + l5);
                if (!bl2) {
                    throw new TIFFException("Unsupported 32 bit unsigned or signed integer or undefined pixel data");
                }
                slf4jlogger.debug("generateDICOMPixelDataSingleFrameImageFromTIFFFile(): copying uncompressed 32 bit float input to output");
                if (l2 / 4L > 0x7FFFFFFEL) {
                    throw new DicomException("Size of uncompressed 32 bit stream " + l2 + " bytes exceeds maximum supported " + -8 + " bytes");
                }
                float[] fArray = new float[(int)(l2 / 4L)];
                tIFFFile.read(fArray);
                OtherFloatAttribute otherFloatAttribute = new OtherFloatAttribute(TagFromName.FloatPixelData);
                ((Attribute)otherFloatAttribute).setValues(fArray);
                attributeList.put(otherFloatAttribute);
            }
            return l10;
        } else {
            if (l7 != 7L && l7 != 33003L) {
                if (l7 != 33005L) throw new TIFFException("Unsupported compression = " + l7);
            }
            byte[] byArray4 = TIFFToDicom.readJPEGFamilyCompressedPixelValuesAndFixAsNecessary(tIFFFile, 0, l, l2, byArray, l3, l4, l7, l8, l9);
            byte[][] byArrayArray = new byte[][]{byArray4};
            OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, byArrayArray);
            attributeList.put(otherByteAttributeMultipleCompressedFrames);
            if (l7 != 33003L) return l10;
            return 6L;
        }
    }

    private static AttributeList generateDICOMPixelDataModuleAttributes(AttributeList attributeList, int n, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, String string, boolean bl, String string2) throws IOException, DicomException, TIFFException {
        Attribute attribute;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        String string3 = "";
        switch ((int)l5) {
            case 0: {
                string3 = "MONOCHROME1";
                break;
            }
            case 1: {
                string3 = "MONOCHROME2";
                break;
            }
            case 2: {
                string3 = "RGB";
                break;
            }
            case 3: {
                string3 = "PALETTE COLOR";
                break;
            }
            case 4: {
                string3 = "TRANSPARENCY";
                break;
            }
            case 5: {
                string3 = "CMYK";
                break;
            }
            case 6: {
                string3 = string != null && string.equals("jpeg2000") ? (bl ? "YBR_ICT" : "YBR_RCT") : "YBR_FULL_422";
                break;
            }
            case 8: {
                string3 = "CIELAB";
            }
        }
        Attribute attribute2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        attribute2.addValue(string3);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        attribute2.addValue((int)l3);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.Rows);
        attribute2.addValue((int)l2);
        attributeList.put(attribute2);
        attribute2 = new UnsignedShortAttribute(TagFromName.Columns);
        attribute2.addValue((int)l);
        attributeList.put(attribute2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (l8 == 2L) {
            bl2 = true;
        } else if (l8 == 3L) {
            bl3 = true;
        }
        if (!bl3) {
            attribute = new UnsignedShortAttribute(TagFromName.BitsStored);
            attribute.addValue((int)l3);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.HighBit);
            attribute.addValue((int)l3 - 1);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
            attribute.addValue(bl2 ? 1 : 0);
            attributeList.put(attribute);
        }
        attributeList.remove(TagFromName.NumberOfFrames);
        if (SOPClass.isMultiframeImageStorage(string2)) {
            attribute = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            attribute.addValue(n);
            attributeList.put(attribute);
        }
        attribute = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        attribute.addValue((int)l6);
        attributeList.put(attribute);
        attributeList.remove(TagFromName.PlanarConfiguration);
        if (l6 > 1L) {
            attribute = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            attribute.addValue((int)l7 - 1);
            attributeList.put(attribute);
        }
        return attributeList;
    }

    private static AttributeList addWholeSlideMicroscopyImageFrameTypeSharedFunctionalGroup(AttributeList attributeList, String string, String string2) throws DicomException {
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.FrameType);
        ((Attribute)codeStringAttribute).addValue("DERIVED");
        ((Attribute)codeStringAttribute).addValue("PRIMARY");
        ((Attribute)codeStringAttribute).addValue(string);
        ((Attribute)codeStringAttribute).addValue(string2);
        attributeList = FunctionalGroupUtilities.generateFrameTypeSharedFunctionalGroup(attributeList, DicomDictionary.StandardDictionary.getTagFromName("WholeSlideMicroscopyImageFrameTypeSequence"), codeStringAttribute);
        return attributeList;
    }

    private byte[] addICCProfileToOpticalPathSequence(AttributeList attributeList, byte[] byArray) throws DicomException {
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, DicomDictionary.StandardDictionary.getTagFromName("OpticalPathSequence"));
        if (attributeList2 != null) {
            Object object;
            if (byArray == null || byArray.length == 0) {
                object = this.getClass().getResourceAsStream("/com/pixelmed/dicom/sRGBColorSpaceProfileInputDevice.icc");
                try {
                    byArray = FileUtilities.readAllBytes((InputStream)object);
                    int n = byArray.length;
                    if (n % 2 != 0) {
                        byte[] byArray2 = new byte[n + 1];
                        System.arraycopy(byArray, 0, byArray2, 0, n);
                        byArray = byArray2;
                        n = byArray.length;
                    }
                }
                catch (IOException iOException) {
                    throw new DicomException("Failed to read ICC profile resource: " + iOException);
                }
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ColorSpace"));
                ((Attribute)codeStringAttribute).addValue("SRGB");
                attributeList2.put(codeStringAttribute);
            } else {
                slf4jlogger.debug("Using ICC Profile from TIFF IFD");
            }
            if (byArray != null && byArray.length > 0) {
                object = new OtherByteAttribute(TagFromName.ICCProfile);
                ((Attribute)object).setValues(byArray);
                attributeList2.put((Attribute)object);
                slf4jlogger.debug("addICCProfileToOpticalPathSequence(): Created ICC Profile attribute of length {}", byArray.length);
            }
        }
        return byArray;
    }

    private void addObjectiveLensPowerToOpticalPathSequence(AttributeList attributeList, double d) throws DicomException {
        if (d != 0.0) {
            AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, DicomDictionary.StandardDictionary.getTagFromName("OpticalPathSequence"));
            if (attributeList2 != null) {
                double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, DicomDictionary.StandardDictionary.getTagFromName("ObjectiveLensPower"), 0.0);
                if (d2 == 0.0) {
                    DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ObjectiveLensPower"));
                    ((Attribute)decimalStringAttribute).addValue(d);
                    attributeList2.put(decimalStringAttribute);
                    slf4jlogger.debug("addObjectiveLensPowerToOpticalPathSequence(): added ObjectiveLensPower {}", d);
                } else {
                    slf4jlogger.debug("addObjectiveLensPowerToOpticalPathSequence(): not overriding non-zero ObjectiveLensPower {} with replacement {}", d2, d);
                }
            } else {
                slf4jlogger.debug("addObjectiveLensPowerToOpticalPathSequence(): no opticalPathSequenceItemList to add to - not trying to create it now (too late)");
            }
        } else {
            slf4jlogger.debug("addObjectiveLensPowerToOpticalPathSequence(): no ObjectiveLensPower value to use, so nothing to do");
        }
    }

    private void addObjectiveLensNumericalApertureToOpticalPathSequence(AttributeList attributeList, double d) throws DicomException {
        if (d != 0.0) {
            AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, DicomDictionary.StandardDictionary.getTagFromName("OpticalPathSequence"));
            if (attributeList2 != null) {
                double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, DicomDictionary.StandardDictionary.getTagFromName("ObjectiveLensNumericalAperture"), 0.0);
                if (d2 == 0.0) {
                    DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ObjectiveLensNumericalAperture"));
                    ((Attribute)decimalStringAttribute).addValue(d);
                    attributeList2.put(decimalStringAttribute);
                    slf4jlogger.debug("addObjectiveLensNumericalApertureToOpticalPathSequence(): added ObjectiveLensNumericalAperture {}", d);
                } else {
                    slf4jlogger.debug("addObjectiveLensNumericalApertureToOpticalPathSequence(): not overriding non-zero ObjectiveLensNumericalAperture {} with replacement {}", d2, d);
                }
            } else {
                slf4jlogger.debug("addObjectiveLensNumericalApertureToOpticalPathSequence(): no opticalPathSequenceItemList to add to - not trying to create it now (too late)");
            }
        } else {
            slf4jlogger.debug("addObjectiveLensNumericalApertureToOpticalPathSequence(): no ObjectiveLensNumericalAperture value to use, so nothing to do");
        }
    }

    private void addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(AttributeList attributeList, String string, String string2) throws DicomException {
        if (string != null && string.length() > 0 || string2 != null && string2.length() > 0) {
            AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, DicomDictionary.StandardDictionary.getTagFromName("OpticalPathSequence"));
            if (attributeList2 != null) {
                Attribute attribute;
                if (string != null && string.length() > 0) {
                    attribute = new ShortStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("OpticalPathIdentifier"));
                    attribute.addValue(string);
                    attributeList2.put(attribute);
                    slf4jlogger.debug("addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(): added or replacing opticalPathIdentifier {}", string);
                }
                if (string2 != null && string2.length() > 0) {
                    attribute = new ShortTextAttribute(DicomDictionary.StandardDictionary.getTagFromName("OpticalPathDescription"));
                    attribute.addValue(string2);
                    attributeList2.put(attribute);
                    slf4jlogger.debug("addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(): added or replacing opticalPathDescription {}", string2);
                }
            } else {
                slf4jlogger.debug("addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(): no opticalPathSequenceItemList to add to - not trying to create it now (too late)");
            }
        } else {
            slf4jlogger.debug("addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(): no OpticalPathIdentifier or OpticalPathDescription value to use, so nothing to do");
        }
    }

    private void addOpticalPathAttributesForChannel(AttributeList attributeList, AttributeList attributeList2) {
        if (attributeList2 != null) {
            AttributeList attributeList3 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, DicomDictionary.StandardDictionary.getTagFromName("OpticalPathSequence"));
            if (attributeList3 != null) {
                attributeList3.putAll(attributeList2);
            } else {
                slf4jlogger.debug("addOpticalPathAttributesForChannel(): no opticalPathSequenceItemList to add to - not trying to create it now (too late)");
            }
        } else {
            slf4jlogger.debug("addOpticalPathAttributesForChannel(): no opticalPathAttributesForChannel, so nothing to do");
        }
    }

    private final long totalArrayValues(long[] lArray) {
        long l = 0L;
        if (lArray != null) {
            for (long l2 : lArray) {
                l += l2;
            }
        }
        return l;
    }

    private AttributeList insertLossyImageCompressionHistory(AttributeList attributeList, long l, long l2, boolean bl, String string, long l3, long l4, long l5, long l6, long l7) throws DicomException {
        Object object;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        String string2 = "00";
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null && string.length() > 0) {
            string2 = "01";
            object = string.toUpperCase().trim();
            if (((String)object).equals("JPEG")) {
                hashSet.add("ISO_10918_1");
            } else if (((String)object).equals("JPEG-2000")) {
                hashSet.add("ISO_15444_1");
            }
        }
        if (l == 7L) {
            bl2 = true;
            string2 = "01";
            hashSet.add("ISO_10918_1");
        } else if (l == 33003L || l == 33005L) {
            bl2 = true;
            string2 = "01";
            hashSet.add("ISO_15444_1");
        }
        if (l2 == 7L) {
            string2 = "01";
            hashSet.add("ISO_10918_1");
            if (bl2 && l != l2) {
                bl3 = true;
            }
        } else if ((l2 == 33003L || l2 == 33005L) && bl) {
            string2 = "01";
            hashSet.add("ISO_15444_1");
            if (bl2 && l != l2) {
                bl3 = true;
            }
        }
        object = new CodeStringAttribute(TagFromName.LossyImageCompression);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        if (!hashSet.isEmpty()) {
            object = new CodeStringAttribute(TagFromName.LossyImageCompressionMethod);
            for (String string3 : hashSet) {
                ((Attribute)object).addValue(string3);
            }
            attributeList.put((Attribute)object);
        }
        if (bl2) {
            long l8 = (l6 - 1L) / 8L + 1L;
            long l9 = l4 * l5 * l7 * l8;
            double d = l9 * 1000L / l3;
            slf4jlogger.debug("insertLossyImageCompressionHistory(): decompressedByteCount = {}", l9);
            slf4jlogger.debug("insertLossyImageCompressionHistory(): wasOriginallyCompressed with originalCompressedByteCount = {}", l3);
            slf4jlogger.debug("insertLossyImageCompressionHistory(): wasOriginallyCompressed with compressionRatio = {}", d /= 1000.0);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.LossyImageCompressionRatio);
            ((Attribute)decimalStringAttribute).addValue(d);
            attributeList.put(decimalStringAttribute);
        }
        if (bl3) {
            // empty if block
        }
        return attributeList;
    }

    private AttributeList generateDICOMWholeSlideMicroscopyImageAttributes(AttributeList attributeList, long l, long l2, String string, double d, double d2, double d3, double d4, double d5, String string2, String string3, double d6, double d7, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        DecimalStringAttribute decimalStringAttribute;
        boolean bl;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        boolean bl2 = (bl = "LABEL".equals(string7)) || "OVERVIEW".equals(string7);
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.FrameOfReferenceUID);
        ((Attribute)uniqueIdentifierAttribute).addValue(string);
        attributeList.put(uniqueIdentifierAttribute);
        boolean bl3 = d6 != 0.0 || d7 != 0.0;
        Object object = new LongStringAttribute(TagFromName.PositionReferenceIndicator);
        ((Attribute)object).addValue(bl3 ? "SLIDE_CORNER" : "UNKNOWN");
        attributeList.put((Attribute)object);
        TIFFToDicom.addWholeSlideMicroscopyImageFrameTypeSharedFunctionalGroup(attributeList, string7, string8);
        object = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        Object object2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem((SequenceAttribute)object);
        Object object3 = new SequenceAttribute(TagFromName.PixelMeasuresSequence);
        ((AttributeList)object2).put((Attribute)object3);
        Object object4 = new AttributeList();
        ((SequenceAttribute)object3).addItem((AttributeList)object4);
        if (!bl) {
            decimalStringAttribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
            ((Attribute)decimalStringAttribute).addValue(d2);
            ((Attribute)decimalStringAttribute).addValue(d);
            ((AttributeList)object4).put(decimalStringAttribute);
        }
        if (!bl2) {
            decimalStringAttribute = new DecimalStringAttribute(TagFromName.SliceThickness);
            ((Attribute)decimalStringAttribute).addValue(d3);
            ((AttributeList)object4).put(decimalStringAttribute);
        }
        object = this.u.getAnotherNewUID();
        object2 = new SequenceAttribute(TagFromName.DimensionOrganizationSequence);
        attributeList.put((Attribute)object2);
        object3 = new AttributeList();
        ((SequenceAttribute)object2).addItem((AttributeList)object3);
        object4 = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        ((Attribute)object4).addValue((String)object);
        ((AttributeList)object3).put((Attribute)object4);
        object2 = new CodeStringAttribute(TagFromName.DimensionOrganizationType);
        ((Attribute)object2).addValue("TILED_FULL");
        attributeList.put((Attribute)object2);
        object2 = new SequenceAttribute(TagFromName.DimensionIndexSequence);
        attributeList.put((Attribute)object2);
        object3 = new AttributeList();
        ((SequenceAttribute)object2).addItem((AttributeList)object3);
        object4 = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)object4).addValue(TagFromName.RowPositionInTotalImagePixelMatrix);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)object4).addValue(TagFromName.PlanePositionSlideSequence);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        ((Attribute)object4).addValue((String)object);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        ((Attribute)object4).addValue("Row Position");
        ((AttributeList)object3).put((Attribute)object4);
        object3 = new AttributeList();
        ((SequenceAttribute)object2).addItem((AttributeList)object3);
        object4 = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)object4).addValue(TagFromName.ColumnPositionInTotalImagePixelMatrix);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)object4).addValue(TagFromName.PlanePositionSlideSequence);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        ((Attribute)object4).addValue((String)object);
        ((AttributeList)object3).put((Attribute)object4);
        object4 = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        ((Attribute)object4).addValue("Column Position");
        ((AttributeList)object3).put((Attribute)object4);
        object = new LongStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ContainerIdentifier"));
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("IssuerOfTheContainerIdentifierSequence"));
        attributeList.put((Attribute)object);
        CodedSequenceItem.putSingleCodedSequenceItem(attributeList, DicomDictionary.StandardDictionary.getTagFromName("ContainerTypeCodeSequence"), "433466003", "SCT", "Microscope slide");
        object = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("SpecimenDescriptionSequence"));
        attributeList.put((Attribute)object);
        object2 = new AttributeList();
        ((SequenceAttribute)object).addItem((AttributeList)object2);
        object3 = new LongStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("SpecimenIdentifier"));
        ((Attribute)object3).addValue(string5);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("IssuerOfTheSpecimenIdentifierSequence"));
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new UniqueIdentifierAttribute(TagFromName.SpecimenUID);
        ((Attribute)object3).addValue(string6);
        ((AttributeList)object2).put((Attribute)object3);
        object3 = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("SpecimenPreparationSequence"));
        ((AttributeList)object2).put((Attribute)object3);
        if (string9 != null && string9.length() > 0 && !bl2) {
            object = new UniqueIdentifierAttribute(TagFromName.PyramidUID);
            ((Attribute)object).addValue(string9);
            attributeList.put((Attribute)object);
        }
        if (string10 != null && string10.length() > 0) {
            object = new UniqueIdentifierAttribute(TagFromName.AcquisitionUID);
            ((Attribute)object).addValue(string10);
            attributeList.put((Attribute)object);
        }
        object = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object).addValue("DERIVED");
        ((Attribute)object).addValue("PRIMARY");
        ((Attribute)object).addValue(string7);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        if (!bl) {
            object = new FloatSingleAttribute(DicomDictionary.StandardDictionary.getTagFromName("ImagedVolumeWidth"));
            ((Attribute)object).addValue((double)l * d);
            attributeList.put((Attribute)object);
        }
        if (!bl) {
            object = new FloatSingleAttribute(DicomDictionary.StandardDictionary.getTagFromName("ImagedVolumeHeight"));
            ((Attribute)object).addValue((double)l2 * d2);
            attributeList.put((Attribute)object);
        }
        if (!bl2) {
            object = new FloatSingleAttribute(DicomDictionary.StandardDictionary.getTagFromName("ImagedVolumeDepth"));
            ((Attribute)object).addValue(d3 * 1000.0);
            attributeList.put((Attribute)object);
        }
        object = new UnsignedLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("TotalPixelMatrixColumns"));
        ((Attribute)object).addValue(l);
        attributeList.put((Attribute)object);
        object = new UnsignedLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("TotalPixelMatrixRows"));
        ((Attribute)object).addValue(l2);
        attributeList.put((Attribute)object);
        object = new UnsignedLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("TotalPixelMatrixFocalPlanes"));
        ((Attribute)object).addValue(1);
        attributeList.put((Attribute)object);
        this.addTotalPixelMatrixOriginSequence(attributeList, d6, d7);
        if (bl) {
            object = new DecimalStringAttribute(TagFromName.ImageOrientationSlide);
            ((Attribute)object).addValue(1.0);
            ((Attribute)object).addValue(0.0);
            ((Attribute)object).addValue(0.0);
            ((Attribute)object).addValue(0.0);
            ((Attribute)object).addValue(-1.0);
            ((Attribute)object).addValue(0.0);
            attributeList.put((Attribute)object);
        } else {
            object = new DecimalStringAttribute(TagFromName.ImageOrientationSlide);
            ((Attribute)object).addValue(0.0);
            ((Attribute)object).addValue(-1.0);
            ((Attribute)object).addValue(0.0);
            ((Attribute)object).addValue(-1.0);
            ((Attribute)object).addValue(0.0);
            ((Attribute)object).addValue(0.0);
            attributeList.put((Attribute)object);
        }
        object = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        attributeList.put((Attribute)object);
        if (Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 0) == 1) {
            object = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)object).addValue("IDENTITY");
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)object).addValue(0);
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)object).addValue(1);
            attributeList.put((Attribute)object);
        }
        object = new CodeStringAttribute(TagFromName.VolumetricProperties);
        ((Attribute)object).addValue("VOLUME");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("SpecimenLabelInImage"));
        ((Attribute)object).addValue("LABEL".equals(string7) || "OVERVIEW".equals(string7) ? "YES" : "NO");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("FocusMethod"));
        ((Attribute)object).addValue("AUTO");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ExtendedDepthOfField"));
        ((Attribute)object).addValue("NO");
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(DicomDictionary.StandardDictionary.getTagFromName("RecommendedAbsentPixelCIELabValue"));
        ((Attribute)object).addValue(65535);
        ((Attribute)object).addValue(0);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new UnsignedLongAttribute(DicomDictionary.StandardDictionary.getTagFromName("NumberOfOpticalPaths"));
        ((Attribute)object).addValue(1);
        attributeList.put((Attribute)object);
        object = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("OpticalPathSequence"));
        attributeList.put((Attribute)object);
        object2 = new AttributeList();
        ((SequenceAttribute)object).addItem((AttributeList)object2);
        object3 = new ShortStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("OpticalPathIdentifier"));
        ((Attribute)object3).addValue("0");
        ((AttributeList)object2).put((Attribute)object3);
        CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object2, DicomDictionary.StandardDictionary.getTagFromName("IlluminationColorCodeSequence"), "414298005", "SCT", "Full Spectrum");
        CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object2, DicomDictionary.StandardDictionary.getTagFromName("IlluminationTypeCodeSequence"), "111744", "DCM", "Brightfield illumination");
        if (d4 != 0.0) {
            object3 = new DecimalStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ObjectiveLensPower"));
            ((Attribute)object3).addValue(d4);
            ((AttributeList)object2).put((Attribute)object3);
        }
        if (d5 != 0.0) {
            object3 = new DecimalStringAttribute(DicomDictionary.StandardDictionary.getTagFromName("ObjectiveLensNumericalAperture"));
            ((Attribute)object3).addValue(d5);
            ((AttributeList)object2).put((Attribute)object3);
        }
        if ("LABEL".equals(string7)) {
            if (attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("BarcodeValue")) == null) {
                object = new LongTextAttribute(DicomDictionary.StandardDictionary.getTagFromName("BarcodeValue"));
                attributeList.put((Attribute)object);
            }
            if (attributeList.get(DicomDictionary.StandardDictionary.getTagFromName("LabelText")) == null) {
                object = new UnlimitedTextAttribute(DicomDictionary.StandardDictionary.getTagFromName("LabelText"));
                attributeList.put((Attribute)object);
            }
        }
        return attributeList;
    }

    private void queueTemporaryPixelDataFilesForDeletion(Attribute attribute) {
        if (attribute != null) {
            File[] fileArray = null;
            if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
                fileArray = ((OtherByteAttributeMultipleCompressedFrames)attribute).getFiles();
            } else if (attribute instanceof OtherByteAttributeMultipleFilesOnDisk) {
                fileArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute).getFiles();
            } else if (attribute instanceof OtherWordAttributeMultipleFilesOnDisk) {
                fileArray = ((OtherWordAttributeMultipleFilesOnDisk)attribute).getFiles();
            }
            if (fileArray != null) {
                if (this.filesToDeleteAfterWritingDicomFile == null) {
                    this.filesToDeleteAfterWritingDicomFile = new ArrayList<File>(Arrays.asList(fileArray));
                } else {
                    Collections.addAll(this.filesToDeleteAfterWritingDicomFile, fileArray);
                }
            }
        }
    }

    private int generateDICOMPyramidPixelDataModule(AttributeList attributeList, String string, String string2) throws DicomException, IOException {
        int n = 1;
        Attribute attribute = new LongStringAttribute(pixelmedPrivatePyramidDataBlockReservation);
        attribute.addValue("PixelMed Publishing");
        attributeList.put(attribute);
        attribute = new SequenceAttribute(pixelmedPrivatePyramidData);
        attributeList.put(attribute);
        boolean bl = true;
        AttributeList attributeList2 = attributeList;
        while (true) {
            TiledFramesIndex tiledFramesIndex = new TiledFramesIndex(attributeList2, true, false, true);
            int n2 = tiledFramesIndex.getNumberOfColumnsOfTiles();
            int n3 = tiledFramesIndex.getNumberOfRowsOfTiles();
            if (n2 <= 1 && n3 <= 1) break;
            ++n;
            slf4jlogger.debug("generateDICOMPyramidPixelDataModule(): downsampling from numberOfColumnsOfTiles = {}, numberOfRowsOfTiles = {}", n2, n3);
            AttributeList attributeList3 = new AttributeList();
            if (!bl) {
                UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.TransferSyntaxUID);
                ((Attribute)uniqueIdentifierAttribute).addValue(string2);
                attributeList2.put(uniqueIdentifierAttribute);
            }
            TiledPyramid.createDownsampledDICOMAttributes(attributeList2, attributeList3, tiledFramesIndex, string, true, false);
            if (!bl) {
                attributeList2.remove(TagFromName.TransferSyntaxUID);
            }
            ((SequenceAttribute)attribute).addItem(attributeList3);
            this.queueTemporaryPixelDataFilesForDeletion(attributeList3.get(TagFromName.PixelData));
            attributeList2 = attributeList3;
            bl = false;
        }
        return n;
    }

    private String mergeImageDescription(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            slf4jlogger.debug("mergeImageDescription(): description.length = {}", stringArray.length);
            for (String string : stringArray) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    private void getEquipmentFromTIFFImageDescription(String[] stringArray, AttributeList attributeList) throws DicomException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (stringArray != null && stringArray.length > 0) {
            Object object;
            slf4jlogger.trace("getEquipmentFromTIFFImageDescription(): description.length = {}", stringArray.length);
            for (String string6 : stringArray) {
                Object object2;
                Object object3;
                Object object4;
                slf4jlogger.trace("getEquipmentFromTIFFImageDescription(): String = {}", string6);
                if (string6.contains("DPUfsImport")) {
                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): Parsing DPUfsImport XML metadata");
                    try {
                        object4 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string6)));
                        object3 = XPathFactory.newInstance();
                        string = ((XPathFactory)object3).newXPath().evaluate("/DataObject[@ObjectType='DPUfsImport']/Attribute[@Name='DICOM_MANUFACTURER']", object4).replaceAll("\"", "");
                        slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found manufacturer {}", string);
                        string3 = ((XPathFactory)object3).newXPath().evaluate("/DataObject[@ObjectType='DPUfsImport']/Attribute[@Name='DICOM_SOFTWARE_VERSIONS']", object4).replaceAll("\"", "");
                        slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found softwareVersions {}", string3);
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to parse DPUfsImport XML metadata in ImageDescription ", exception);
                    }
                    continue;
                }
                if (string6.contains("<OME")) {
                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): Parsing OME-TIFF XML metadata");
                    try {
                        object4 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string6)));
                        object3 = XPathFactory.newInstance();
                        string = ((XPathFactory)object3).newXPath().evaluate("/OME/Instrument/Microscope/@Manufacturer", object4);
                        string2 = ((XPathFactory)object3).newXPath().evaluate("/OME/Instrument/Microscope/@Model", object4);
                        slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found manufacturer {}", string);
                        slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found manufacturerModelName {}", string2);
                        object2 = ((XPathFactory)object3).newXPath().evaluate("/OME/Image/Description", object4);
                        Pattern pattern = Pattern.compile(".*Aperio Image Library (v[A-Z0-9][A-Z0-9. ]*[0-9]).*");
                        Object object5 = pattern.matcher((CharSequence)object2);
                        if (((Matcher)object5).matches()) {
                            slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Aperio Image Library match");
                            int n = ((Matcher)object5).groupCount();
                            if (n == 1) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Aperio Image Library correct groupCount");
                                string3 = ((Matcher)object5).group(1);
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found softwareVersions (Aperio Image Library) {}", string3);
                            }
                        }
                        if ((object2 = (NodeList)((XPathFactory)object3).newXPath().evaluate("//OriginalMetadata", object4, XPathConstants.NODESET)) != null && object2.getLength() > 0) {
                            for (int i = 0; i < object2.getLength(); ++i) {
                                object5 = object2.item(i);
                                String string7 = ((XPathFactory)object3).newXPath().evaluate("Key", object5);
                                String string8 = ((XPathFactory)object3).newXPath().evaluate("Value", object5);
                                if (string7 != null && string7.length() > 0 && string8 != null && string8.length() > 0) {
                                    slf4jlogger.trace("getEquipmentFromTIFFImageDescription(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Key {} Value {}", string7, string8);
                                    if (!string7.matches("^Series [0-9]+ ScanScope ID$")) continue;
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata ScanScope ID {}", string8);
                                    string4 = string8;
                                    if (string == null || string.length() == 0) {
                                        string = "Leica Biosystems";
                                        slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): because ScanScope ID is present, using manufacturer {}", string);
                                    }
                                    if (string2 != null && string2.length() != 0) continue;
                                    string2 = "Aperio";
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): because ScanScope ID is present, using manufacturerModelName {}", string2);
                                    continue;
                                }
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): Cannot find Key and Value for OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata ", object5.toString());
                            }
                            continue;
                        }
                        slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): no OME-TIFF XML OriginalMetadata");
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to parse OME-TIFF XML metadata in ImageDescription ", exception);
                    }
                    continue;
                }
                if (string6.contains("Aperio")) {
                    try {
                        object4 = new BufferedReader(new StringReader(string6));
                        object3 = null;
                        while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                            int n;
                            object2 = Pattern.compile(".*Aperio Leica Biosystems GT450 (v[0-9][0-9.]*[0-9]).*");
                            Matcher matcher = ((Pattern)object2).matcher((CharSequence)object3);
                            if (matcher.matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Aperio Leica Biosystems GT450 match");
                                string2 = "GT450";
                                n = matcher.groupCount();
                                if (n == 1) {
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Aperio Leica Biosystems GT450 correct groupCount");
                                    string3 = matcher.group(1);
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found softwareVersions (Aperio Leica Biosystems GT450) {}", string3);
                                }
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*[|]ScanScope ID[ ]*=[ ]*([^|]*)[|].*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have ScanScope ID match");
                                n = matcher.groupCount();
                                if (n == 1) {
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have ScanScope ID correct groupCount");
                                    string4 = matcher.group(1);
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found deviceSerialNumber (ScanScope ID) {}", string4);
                                }
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*[|]Scanner ID[ ]*=[ ]*([^|]*)[|].*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Scanner ID match");
                                n = matcher.groupCount();
                                if (n == 1) {
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Scanner ID correct groupCount");
                                    string4 = matcher.group(1);
                                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found deviceSerialNumber (Scanner ID) {}", string4);
                                }
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*;BioImagene iScan[|].*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have BioImagene iScan match");
                                string = "BioImagene";
                                string2 = "iScan";
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*;NanoZoomer Digital Pathology Image[|].*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have NanoZoomer Digital Pathology Image match");
                                string = "Hamamatsu";
                                string2 = "NanoZoomer";
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*;Mirax Digital Slide[|].*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Mirax Digital Slide match");
                                string = "Carl Zeiss";
                                string2 = "Mirax";
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*[|]Copyright=Hamamatsu Photonics KK[|].*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Hamamatsu Photonics KK match");
                                string = "Hamamatsu";
                                string2 = "";
                            }
                            if ((matcher = ((Pattern)(object2 = Pattern.compile(".*Scanned By Sunny.*"))).matcher((CharSequence)object3)).matches()) {
                                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Scanned By Sunny match");
                                string = "Sunny";
                                string2 = "";
                            }
                            if (!(matcher = ((Pattern)(object2 = Pattern.compile(".*Aperio Image Library (v[A-Z0-9][A-Z0-9. ]*[0-9]).*"))).matcher((CharSequence)object3)).matches()) continue;
                            slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Aperio Image Library match");
                            n = matcher.groupCount();
                            if (n != 1) continue;
                            slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): have Aperio Image Library correct groupCount");
                            string5 = matcher.group(1);
                            slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): found Aperio Image Library version {}", string5);
                        }
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("Failed to parse ImageDescription ", iOException);
                    }
                    if (string.length() != 0) continue;
                    string = "Leica Biosystems";
                    string2 = "Aperio";
                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): SVS so assuming manufacturer {}", string);
                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): SVS so assuming  manufacturerModelName {}", string2);
                    continue;
                }
                if (string6.contains("X scan size")) {
                    string = "3D Histech";
                    slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): guessing manufacturer {}", string);
                    continue;
                }
                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): nothing recognized in ImageDescription");
            }
            if (string3.length() == 0 && string.equals("Leica Biosystems")) {
                string3 = string5;
            }
            if (string.length() > 0) {
                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): setting DICOM Manufacturer to {}", string);
                object = new LongStringAttribute(TagFromName.Manufacturer);
                ((Attribute)object).addValue(string);
                attributeList.put((Attribute)object);
            }
            if (string2.length() > 0) {
                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): setting DICOM ManufacturerModelName to {}", string2);
                object = new LongStringAttribute(TagFromName.ManufacturerModelName);
                ((Attribute)object).addValue(string2);
                attributeList.put((Attribute)object);
            }
            if (string3.length() > 0) {
                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): setting DICOM SoftwareVersions to {}", string3);
                object = new LongStringAttribute(TagFromName.SoftwareVersions);
                ((Attribute)object).addValue(string3);
                attributeList.put((Attribute)object);
            }
            if (string4.length() > 0) {
                slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): setting DICOM DeviceSerialNumber to {}", string4);
                object = new LongStringAttribute(TagFromName.DeviceSerialNumber);
                ((Attribute)object).addValue(string4);
                attributeList.put((Attribute)object);
            }
        } else {
            slf4jlogger.debug("getEquipmentFromTIFFImageDescription(): no ImageDescription");
        }
    }

    private void parseTIFFImageDescription(String[] stringArray, AttributeList attributeList) throws DicomException {
        String string = "";
        String string2 = "";
        if (stringArray != null && stringArray.length > 0) {
            Object object;
            slf4jlogger.trace("parseTIFFImageDescription(): description.length = {}", stringArray.length);
            for (String string3 : stringArray) {
                slf4jlogger.trace("parseTIFFImageDescription(): String = {}", string3);
                if (string3.contains("DPUfsImport")) {
                    slf4jlogger.debug("parseTIFFImageDescription(): Parsing DPUfsImport XML metadata");
                    try {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string3)));
                        XPathFactory xPathFactory = XPathFactory.newInstance();
                        string2 = xPathFactory.newXPath().evaluate("/DataObject[@ObjectType='DPUfsImport']/Attribute[@Name='PIM_DP_UFS_BARCODE']", document);
                        slf4jlogger.debug("parseTIFFImageDescription(): found barcodeValue {}", string2);
                        string = xPathFactory.newXPath().evaluate("/DataObject[@ObjectType='DPUfsImport']/Attribute[@Name='PIM_DP_SCANNED_IMAGES']/Array/DataObject[@ObjectType='DPScannedImage']/Attribute[@Name='DICOM_DERIVATION_DESCRIPTION']", document);
                        slf4jlogger.debug("parseTIFFImageDescription(): found derivationDescription {}", string);
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to parse DPUfsImport XML metadata in ImageDescription ", exception);
                    }
                    continue;
                }
                if (string3.contains("<OME")) {
                    slf4jlogger.debug("parseTIFFImageDescription(): Parsing OME-TIFF XML metadata");
                    continue;
                }
                if (string3.contains("Aperio") || string3.contains("X scan size")) continue;
                slf4jlogger.debug("parseTIFFImageDescription(): nothing recognized in ImageDescription");
            }
            if (string.length() > 0) {
                slf4jlogger.debug("parseTIFFImageDescription(): setting DICOM DerivationDescription to {}", string);
                object = new ShortTextAttribute(TagFromName.DerivationDescription);
                ((Attribute)object).addValue(string);
                attributeList.put((Attribute)object);
            }
            if (string2.length() > 0) {
                slf4jlogger.debug("parseTIFFImageDescription(): setting DICOM BarcodeValue to {}", string2);
                object = new LongTextAttribute(DicomDictionary.StandardDictionary.getTagFromName("BarcodeValue"));
                ((Attribute)object).addValue(string2);
                attributeList.put((Attribute)object);
            }
        } else {
            slf4jlogger.debug("parseTIFFImageDescription(): no ImageDescription");
        }
    }

    private String selectSOPClassBasedOnTIFFCharacteristics(TIFFImageFileDirectories tIFFImageFileDirectories) {
        TIFFImageFileDirectory tIFFImageFileDirectory;
        String[] stringArray;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<TIFFImageFileDirectory> arrayList = tIFFImageFileDirectories.getListOfImageFileDirectories();
        if (arrayList.size() > 0 && (stringArray = (tIFFImageFileDirectory = arrayList.get(0)).getStringValues(270)) != null && stringArray.length > 0) {
            slf4jlogger.trace("selectSOPClassBasedOnTIFFCharacteristics(): description.length = {}", stringArray.length);
            for (String string2 : stringArray) {
                slf4jlogger.trace("selectSOPClassBasedOnTIFFCharacteristics(): String = {}", string2);
                if (string2.contains("Aperio")) {
                    bl = true;
                    continue;
                }
                if (!string2.contains("DPUfsImport")) continue;
                bl2 = true;
            }
        }
        slf4jlogger.debug("selectSOPClassBasedOnTIFFCharacteristics(): isAperioSVS={}", bl);
        if (bl) {
            slf4jlogger.info("selectSOPClassBasedOnTIFFCharacteristics(): isAperioSVS so selecting VL Whole Slide Microscopy Image Storage SOP Class");
            string = "1.2.840.10008.5.1.4.1.1.77.1.6";
        } else if (bl2) {
            slf4jlogger.info("selectSOPClassBasedOnTIFFCharacteristics(): isDPUfsImport so selecting VL Whole Slide Microscopy Image Storage SOP Class");
            string = "1.2.840.10008.5.1.4.1.1.77.1.6";
        }
        return string;
    }

    private String getPastHistoryOfLossyCompression(ArrayList<TIFFImageFileDirectory> arrayList) {
        TIFFImageFileDirectory tIFFImageFileDirectory;
        String[] stringArray;
        String string = "";
        if (arrayList.size() > 0 && (stringArray = (tIFFImageFileDirectory = arrayList.get(0)).getStringValues(270)) != null && stringArray.length > 0) {
            slf4jlogger.trace("getPastHistoryOfLossyCompression(): description.length = {}", stringArray.length);
            for (String string2 : stringArray) {
                slf4jlogger.trace("getPastHistoryOfLossyCompression(): String = {}", string2);
                if (string2.startsWith("<?xml") || string2.startsWith("<OME")) {
                    slf4jlogger.debug("getPastHistoryOfLossyCompression(): Parsing OME-TIFF XML metadata");
                    try {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string2)));
                        XPathFactory xPathFactory = XPathFactory.newInstance();
                        NodeList nodeList = (NodeList)xPathFactory.newXPath().evaluate("//OriginalMetadata", document, XPathConstants.NODESET);
                        if (nodeList != null && nodeList.getLength() > 0) {
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                Node node = nodeList.item(i);
                                String string3 = xPathFactory.newXPath().evaluate("Key", node);
                                String string4 = xPathFactory.newXPath().evaluate("Value", node);
                                if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                                    slf4jlogger.trace("getPastHistoryOfLossyCompression(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Key {} Value {}", string3, string4);
                                    if (!string3.matches("^Compression$")) continue;
                                    slf4jlogger.debug("getPastHistoryOfLossyCompression(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Compression {}", string4);
                                    string = string4;
                                    continue;
                                }
                                slf4jlogger.debug("getPastHistoryOfLossyCompression(): Cannot find Key and Value for OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata ", node.toString());
                            }
                            continue;
                        }
                        slf4jlogger.debug("getPastHistoryOfLossyCompression(): no OME-TIFF XML OriginalMetadata");
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to parse OME-TIFF XML metadata in ImageDescription ", exception);
                    }
                    continue;
                }
                if (!string2.contains("Aperio")) continue;
            }
        }
        return string;
    }

    /*
     * Could not resolve type clashes
     */
    private String[][] getImageFlavorAndDerivationByIFD(ArrayList<TIFFImageFileDirectory> arrayList) {
        int n = arrayList.size();
        String[][] stringArray = new String[n][];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        for (TIFFImageFileDirectory tIFFImageFileDirectory : arrayList) {
            int n3;
            String[] stringArray2;
            slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): Directory={}", n2);
            boolean bl4 = tIFFImageFileDirectory.getSingleNumericValue(254, 0, 0L) == 1L;
            slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): based on Subfile Type: reduced-resolution image, downsampled = {}", bl4);
            stringArray[n2] = new String[2];
            stringArray[n2][0] = "VOLUME";
            String string = stringArray[n2][1] = bl4 ? "RESAMPLED" : "NONE";
            if (n2 == 0) {
                String[] stringArray3 = tIFFImageFileDirectory.getStringValues(270);
                if (stringArray3 != null && stringArray3.length > 0) {
                    slf4jlogger.trace("getImageFlavorAndDerivationByIFD(): description.length = {}", stringArray3.length);
                    stringArray2 = stringArray3;
                    int n4 = stringArray2.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        String string2 = stringArray2[n3];
                        slf4jlogger.trace("getImageFlavorAndDerivationByIFD(): String = {}", string2);
                        if (string2.contains("<DataObject ObjectType=\"DPUfsImport\"")) {
                            bl = true;
                            continue;
                        }
                        if (string2.contains("<OME")) {
                            bl2 = true;
                            continue;
                        }
                        if (!string2.contains("Aperio")) continue;
                        bl3 = true;
                    }
                }
                slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): isDPUfsImport={}", bl);
                slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): isOMETIFFXML={}", bl2);
                slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): isAperioSVS={}", bl3);
            }
            if (bl) {
                boolean bl5 = false;
                stringArray2 = tIFFImageFileDirectory.getStringValues(270);
                if (stringArray2 != null && stringArray2.length > 0) {
                    slf4jlogger.trace("getImageFlavorAndDerivationByIFD(): description.length = {}", stringArray2.length);
                    String[] stringArray4 = stringArray2;
                    n3 = stringArray4.length;
                    for (int i = 0; i < n3; ++i) {
                        String string3 = stringArray4[i];
                        slf4jlogger.trace("getImageFlavorAndDerivationByIFD(): String = {}", string3);
                        if (!string3.contains("Macro")) continue;
                        bl5 = true;
                    }
                }
                if (bl5) {
                    slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is macro based on IMAGEDESCRIPTION so using OVERVIEW flavor");
                    stringArray[n2][0] = "OVERVIEW";
                    stringArray[n2][1] = "NONE";
                } else {
                    stringArray[n2][0] = "VOLUME";
                    stringArray[n2][1] = n2 == 0 ? "NONE" : "RESAMPLED";
                }
            } else if (!bl2 && bl3) {
                boolean bl6 = false;
                boolean bl7 = false;
                Object[] objectArray = tIFFImageFileDirectory.getStringValues(270);
                if (objectArray != null && objectArray.length > 0) {
                    slf4jlogger.trace("getImageFlavorAndDerivationByIFD(): description.length = {}", objectArray.length);
                    for (String string4 : objectArray) {
                        slf4jlogger.trace("getImageFlavorAndDerivationByIFD(): String = {}", string4);
                        if (string4.contains("macro")) {
                            bl6 = true;
                            continue;
                        }
                        if (!string4.contains("label")) continue;
                        bl7 = true;
                    }
                }
                if (bl6) {
                    slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is macro based on IMAGEDESCRIPTION so using OVERVIEW flavor");
                    stringArray[n2][0] = "OVERVIEW";
                    stringArray[n2][1] = "NONE";
                } else if (bl7) {
                    slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is label based on IMAGEDESCRIPTION so using LABEL flavor");
                    stringArray[n2][0] = "LABEL";
                    stringArray[n2][1] = "NONE";
                } else {
                    objectArray = tIFFImageFileDirectory.getNumericValues(324);
                    int n5 = n3 = objectArray != null ? 1 : 0;
                    if (n3 != 0) {
                        slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is tiled so using VOLUME flavor");
                        stringArray[n2][0] = "VOLUME";
                        stringArray[n2][1] = n2 == 0 ? "NONE" : "RESAMPLED";
                    } else if (n2 == 1) {
                        slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is not tiled and 2nd IFD entry so using THUMBNAIL flavor");
                        stringArray[n2][0] = "THUMBNAIL";
                        stringArray[n2][1] = "RESAMPLED";
                    } else if (n2 == n - 1 || n2 == n - 2) {
                        long l = tIFFImageFileDirectory.getSingleNumericValue(259, 0, 0L);
                        slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): compression={}", l);
                        if (l == 5L) {
                            slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is not tiled and last or 2nd last IFD entry and LZW so using THUMBNAIL flavor");
                            stringArray[n2][0] = "LABEL";
                            stringArray[n2][1] = "NONE";
                        } else if (l == 7L) {
                            slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): is not tiled and last or 2nd last IFD entry and JPEG so using OVERVIEW flavor");
                            stringArray[n2][0] = "OVERVIEW";
                            stringArray[n2][1] = "NONE";
                        }
                    }
                }
            }
            slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): imageFlavorAndDerivationByIFD[{}] flavor={}", n2, stringArray[n2][0]);
            slf4jlogger.debug("getImageFlavorAndDerivationByIFD(): imageFlavorAndDerivationByIFD[{}] derivation={}", n2, stringArray[n2][1]);
            ++n2;
        }
        return stringArray;
    }

    private String chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(String string, long l) throws TIFFException {
        slf4jlogger.debug("chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(): transferSyntax specified as = {}", string);
        slf4jlogger.debug("chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(): compression = {}", l);
        if (string == null || string.length() == 0) {
            if (l == 0L || l == 1L || l == 5L) {
                string = "1.2.840.10008.1.2.1";
            } else if (l == 7L) {
                string = "1.2.840.10008.1.2.4.50";
            } else if (l == 33003L || l == 33005L) {
                string = "1.2.840.10008.1.2.4.91";
            } else {
                throw new TIFFException("Unsupported compression = " + l);
            }
        }
        slf4jlogger.debug("chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(): transferSyntax now = {}", string);
        return string;
    }

    private String chooseRecompressAsFormatFromTransferSyntax(String string) throws TIFFException {
        String string2 = null;
        if (string != null && string.length() > 0) {
            string2 = CompressedFrameEncoder.chooseOutputFormatForTransferSyntax(string);
        }
        slf4jlogger.debug("chooseRecompressAsFormatFromTransferSyntax(): recompressAsFormat = {}", string2);
        return string2;
    }

    private long chooseOutputCompressionForRecompressAsFormatGivenInputCompression(String string, long l) throws TIFFException {
        slf4jlogger.debug("chooseOutputCompressionForRecompressAsFormatGivenInputCompression(): recompressAsFormat = {}", string);
        slf4jlogger.debug("chooseOutputCompressionForRecompressAsFormatGivenInputCompression(): compression = {}", l);
        long l2 = l;
        if (string == null || string.length() == 0) {
            l2 = 1L;
        } else if (string.equals("jpeg")) {
            l2 = 7L;
        } else if (string.equals("jpeg2000") && l != 33003L && l != 33005L) {
            l2 = 33003L;
        }
        slf4jlogger.debug("chooseOutputCompressionForRecompressAsFormatGivenInputCompression(): outputCompression = {}", l2);
        return l2;
    }

    private void createOrAppendToManufacturerModelNameAndInsertOrReplace(AttributeList attributeList) throws DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ManufacturerModelName);
        if (string.length() > 0) {
            string = string + " converted by ";
        }
        string = string + this.getClass().getName();
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(longStringAttribute);
    }

    private void createOrAppendToSoftwareVersionsAndInsertOrReplace(AttributeList attributeList) throws DicomException {
        Attribute attribute = attributeList.get(TagFromName.SoftwareVersions);
        if (attribute == null) {
            attribute = new LongStringAttribute(TagFromName.SoftwareVersions);
            attributeList.put(attribute);
        }
        if (!attribute.getDelimitedStringValuesOrEmptyString().contains(VersionAndConstants.getBuildDate())) {
            attribute.addValue(VersionAndConstants.getBuildDate());
        }
    }

    private void addContributingEquipmentSequence(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, this.getClass().getName(), null, "Vers. " + VersionAndConstants.getBuildDate(), "TIFF to DICOM conversion");
    }

    private void addSpecimenPreparationStepContentItemSequence(SequenceAttribute sequenceAttribute, String string, AttributeList attributeList) throws DicomException {
        if (sequenceAttribute != null) {
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SpecimenDescriptionSequence, DicomDictionary.StandardDictionary.getTagFromName("SpecimenPreparationSequence"));
            if (sequenceAttribute2 != null) {
                slf4jlogger.debug("addSpecimenPreparationStepContentItemSequence(): Merging in channel-specific SpecimenPreparationStepContentItemSequence information");
                String string2 = SequenceAttribute.getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(attributeList, TagFromName.SpecimenDescriptionSequence, TagFromName.SpecimenIdentifier, string);
                slf4jlogger.debug("addSpecimenPreparationStepContentItemSequence(): Using slide-specific SpecimenIdentifier {}", string2);
                SequenceAttribute sequenceAttribute3 = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("SpecimenPreparationStepContentItemSequence"));
                Object object = new AttributeList();
                Attribute attribute = new CodeStringAttribute(TagFromName.ValueType);
                attribute.addValue("TEXT");
                ((AttributeList)object).put(attribute);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "121041", "DCM", "Specimen Identifier");
                attribute = new UnlimitedTextAttribute(TagFromName.TextValue);
                attribute.addValue(string2);
                ((AttributeList)object).put(attribute);
                sequenceAttribute3.addItem((AttributeList)object);
                object = sequenceAttribute.iterator();
                while (object.hasNext()) {
                    sequenceAttribute3.addItem((SequenceItem)object.next());
                }
                object = new AttributeList();
                ((AttributeList)object).put(sequenceAttribute3);
                sequenceAttribute2.addItem((AttributeList)object);
            } else {
                slf4jlogger.error("addSpecimenPreparationStepContentItemSequence(): Could not get SpecimenPreparationSequence into which to merge supplied channel-specific SpecimenPreparationStepContentItemSequence");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertTIFFPixelsToDicomMultiFrame(String string, UIDMap uIDMap, TIFFFile tIFFFile, int n, String string2, int n2, long l, long l2, long[] lArray, long[] lArray2, long l3, long l4, long l5, long l6, byte[] byArray, byte[] byArray2, long l7, long l8, long l9, long l10, long l11, String string3, double d, double d2, double d3, double d4, double d5, String string4, String string5, AttributeList attributeList, double d6, double d7, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, AttributeList attributeList2, boolean bl, boolean bl2, boolean bl3, boolean bl4, SequenceAttribute sequenceAttribute, String string15, String string16, boolean bl5, String string17, boolean bl6, boolean bl7) throws IOException, DicomException, TIFFException {
        Attribute attribute;
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): instanceNumber = {}", n2);
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): transferSyntax supplied = {}", string8);
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): photometric in TIFF file = {}", l7);
        string8 = this.chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(string8, l6);
        String string18 = this.chooseRecompressAsFormatFromTransferSyntax(string8);
        boolean bl8 = new TransferSyntax(string8).isLossy();
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): recompressLossy = {}", bl8);
        AttributeList attributeList3 = new AttributeList();
        boolean bl9 = l9 == 2L && l8 > 1L;
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): mergeSamplesPerPixelTiles = {}", bl9);
        if (bl9 && l6 != 0L && l6 != 1L && l6 != 5L) {
            throw new DicomException("Merging of separately compressed color planes not supported");
        }
        int n3 = lArray.length;
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): numberOfSourceTiles = {}", n3);
        int n4 = (int)(bl9 ? (long)n3 / l8 : (long)n3);
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): numberOfDestinationTiles = {}", n4);
        boolean bl10 = bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7);
        long l12 = bl10 ? 1L : l9;
        long l13 = this.generateDICOMPixelDataMultiFrameImageFromTIFFFile(tIFFFile, attributeList3, bl9, bl10, n3, n4, lArray, lArray2, l3, l4, l5, l10, l6, l7, l8, l9, l11, byArray, byArray2, string18, bl8);
        long l14 = this.chooseOutputCompressionForRecompressAsFormatGivenInputCompression(string18, l6);
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): planarConfig {}changed from {} to {}", l9 == l12 ? "un" : "", l9, l12);
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): photometric {}changed from {} to {}", l7 == l13 ? "un" : "", l7, l13);
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): compression {}changed from {} to {}", l6 == l14 ? "un" : "", l6, l14);
        TIFFToDicom.generateDICOMPixelDataModuleAttributes(attributeList3, n4, l3, l4, l5, l14, l13, l8, l12, l10, string18, bl8, string7);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList3, "", "", "", "", Integer.toString(n2), string6, string7, false);
        attributeList3.remove(TagFromName.SoftwareVersions);
        attributeList3.remove(TagFromName.DeviceSerialNumber);
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            this.generateDICOMWholeSlideMicroscopyImageAttributes(attributeList3, l, l2, string3, d, d2, d3, d4, d5, string4, string5, d6, d7, string9, string10, string11, string12, string13, string15, string16);
        }
        this.insertLossyImageCompressionHistory(attributeList3, l6, l14, bl8, string17, this.totalArrayValues(lArray2), l, l2, l5, l8);
        if (bl5 && string14 != null && string14.length() > 0) {
            if (string14.length() <= 10240) {
                attribute = new LongTextAttribute(TagFromName.ImageComments);
                attribute.addValue(string14);
                attributeList3.put(attribute);
            } else {
                attribute = new UnlimitedTextAttribute(TagFromName.TextValue);
                attribute.addValue(string14);
                attributeList3.put(attribute);
            }
        }
        if (attributeList2 != null) {
            attributeList3.putAll(attributeList2);
        }
        this.createOrAppendToManufacturerModelNameAndInsertOrReplace(attributeList3);
        this.createOrAppendToSoftwareVersionsAndInsertOrReplace(attributeList3);
        this.addContributingEquipmentSequence(attributeList3);
        new SetCharacteristicsFromSummary(string, attributeList3);
        this.addSpecimenPreparationStepContentItemSequence(sequenceAttribute, string10, attributeList3);
        if (uIDMap != null) {
            uIDMap.replaceUIDs(attributeList3, tIFFFile.getFileName(), n);
        }
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            if (l8 > 1L) {
                byArray2 = this.addICCProfileToOpticalPathSequence(attributeList3, byArray2);
            }
        } else if (byArray2 != null && byArray2.length > 0) {
            attribute = new OtherByteAttribute(TagFromName.ICCProfile);
            attribute.setValues(byArray2);
            attributeList3.put(attribute);
            slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): Created ICC Profile attribute of length {}", byArray2.length);
        }
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            this.addObjectiveLensPowerToOpticalPathSequence(attributeList3, d4);
            this.addObjectiveLensNumericalApertureToOpticalPathSequence(attributeList3, d5);
            this.addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(attributeList3, string4, string5);
            this.addOpticalPathAttributesForChannel(attributeList3, attributeList);
        }
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList3);
        attributeList3.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList3, string8, "OURAETITLE");
        int n5 = 1;
        if (bl4) {
            try {
                n5 = this.generateDICOMPyramidPixelDataModule(attributeList3, string18, string8);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        byte[] byArray3 = null;
        if (bl || bl6 || bl7) {
            long l15 = string8.equals("1.2.840.10008.1.2.4.50") || string8.equals("1.2.840.10008.1.2.4.91") ? 6L : l7;
            slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): lowerPhotometric = {}", l15);
            long[][] lArrayArray = new long[n5][];
            long[][] lArrayArray2 = new long[n5][];
            long[] lArray3 = new long[n5];
            long[] lArray4 = new long[n5];
            try {
                long l16;
                Object object;
                int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList3, TagFromName.NumberOfFrames, 1);
                int[] nArray = null;
                if (bl7) {
                    if (bl6) {
                        slf4jlogger.warn("convertTIFFPixelsToDicomMultiFrame(): Basic Offset Table Item Value is not permitted if Extended Offset Table is present - inserting anyway assuming creating test invalid object");
                    }
                    nArray = new int[n6];
                    object = attributeList3.get(TagFromName.PixelData);
                    if (object == null) throw new DicomException("Unable to find PixelData attribute into which to insert BOT");
                    if (object instanceof OtherByteAttributeMultipleCompressedFrames) {
                        ((OtherByteAttributeMultipleCompressedFrames)object).setBasicOffsetTable(nArray);
                    } else {
                        if (!(object instanceof OtherByteAttributeCompressedSeparateFramesOnDisk)) throw new DicomException("Not yet implemented - inserting BOT into " + object.getClass());
                        ((OtherByteAttributeCompressedSeparateFramesOnDisk)object).setBasicOffsetTable(nArray);
                    }
                }
                object = null;
                long[] lArray5 = null;
                if (bl6) {
                    object = new long[n6];
                    lArray5 = new long[n6];
                    OtherVeryLongAttribute otherVeryLongAttribute = new OtherVeryLongAttribute(TagFromName.ExtendedOffsetTable);
                    ((Attribute)otherVeryLongAttribute).setValues((long[])object);
                    attributeList3.put(otherVeryLongAttribute);
                    otherVeryLongAttribute = new OtherVeryLongAttribute(TagFromName.ExtendedOffsetTableLengths);
                    ((Attribute)otherVeryLongAttribute).setValues(lArray5);
                    attributeList3.put(otherVeryLongAttribute);
                }
                long l17 = AddTIFFOrOffsetTables.getByteOffsetsAndLengthsOfTileDataFromStartOfFile(attributeList3, string8, lArrayArray, lArrayArray2, lArray3, lArray4, bl9, l8, bl7);
                if (bl7) {
                    l16 = lArrayArray[0][0];
                    for (int i = 0; i < n6; ++i) {
                        long l18 = lArrayArray[0][i] - l16;
                        if (l18 > 0xFFFFFFFFL) {
                            throw new DicomException("Offset for frame is too large to fit in 32 bits 0x" + Long.toHexString(l18) + " (" + l18 + " dec) - cannot create Basic Offset Table");
                        }
                        nArray[i] = (int)l18;
                        if (!slf4jlogger.isTraceEnabled() || i >= 10 && i <= n6 - 10) continue;
                        slf4jlogger.trace("convertTIFFPixelsToDicomMultiFrame(): frame[{}] BOT offset {}", i, nArray[i]);
                    }
                    Attribute attribute2 = attributeList3.get(TagFromName.PixelData);
                    if (attribute2 != null) {
                        if (attribute2 instanceof OtherByteAttributeMultipleCompressedFrames) {
                            ((OtherByteAttributeMultipleCompressedFrames)attribute2).setBasicOffsetTable(nArray);
                        } else if (attribute2 instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                            ((OtherByteAttributeCompressedSeparateFramesOnDisk)attribute2).setBasicOffsetTable(nArray);
                        }
                    }
                }
                if (bl6) {
                    l16 = lArrayArray[0][0];
                    for (int i = 0; i < n6; ++i) {
                        object[i] = lArrayArray[0][i] - l16;
                        lArray5[i] = lArrayArray2[0][i];
                        if (!slf4jlogger.isTraceEnabled() || i >= 10 && i <= n6 - 10) continue;
                        slf4jlogger.trace("convertTIFFPixelsToDicomMultiFrame(): frame[{}] EOT offset {} length {}", i, (long)object[i], lArray5[i]);
                    }
                    attributeList3.get(TagFromName.ExtendedOffsetTable).setValues((long[])object);
                    attributeList3.get(TagFromName.ExtendedOffsetTableLengths).setValues(lArray5);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("convertTIFFPixelsToDicomMultiFrame(): {}", attributeList3.toString());
                    }
                }
                if (bl) {
                    byArray3 = AddTIFFOrOffsetTables.makeTIFFInPreambleAndAddDataSetTrailingPadding(l17, n5, lArrayArray, lArrayArray2, lArray3, lArray4, attributeList3, l3, l4, l5, l14, l13, l15, l8, l12, l10, byArray2, d, d2, bl2);
                }
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        TIFFToDicom.assertPixelDataEncodingIsCompatibleWithTransferSyntax(attributeList3, string8);
        attributeList3.write(string2, string8, true, true, byArray3);
        if (this.filesToDeleteAfterWritingDicomFile == null) return;
        for (File file : this.filesToDeleteAfterWritingDicomFile) {
            file.delete();
        }
        this.filesToDeleteAfterWritingDicomFile = null;
    }

    private void convertTIFFPixelsToDicomSingleFrameMergingStrips(String string, UIDMap uIDMap, TIFFFile tIFFFile, int n, String string2, int n2, long l, long l2, long[] lArray, long[] lArray2, long l3, long l4, long l5, long l6, byte[] byArray, byte[] byArray2, long l7, long l8, long l9, long l10, long l11, String string3, double d, double d2, double d3, double d4, double d5, String string4, String string5, AttributeList attributeList, double d6, double d7, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, AttributeList attributeList2, boolean bl, boolean bl2, boolean bl3, SequenceAttribute sequenceAttribute, String string15, String string16, boolean bl4, String string17) throws IOException, DicomException, TIFFException {
        Object object;
        Object object2;
        Object object3;
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): instanceNumber = {}", n2);
        string8 = this.chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(string8, l6);
        String string18 = this.chooseRecompressAsFormatFromTransferSyntax(string8);
        boolean bl5 = new TransferSyntax(string8).isLossy();
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): recompressLossy = {}", bl5);
        AttributeList attributeList3 = new AttributeList();
        boolean bl6 = bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7);
        long l12 = bl6 ? 1L : l9;
        long l13 = this.generateDICOMPixelDataSingleFrameImageFromTIFFFileMergingStrips(tIFFFile, attributeList3, bl6, l, l2, lArray, lArray2, l3, l4, l5, l10, l6, l7, l8, l9, l11, byArray, byArray2, string18, bl5);
        long l14 = this.chooseOutputCompressionForRecompressAsFormatGivenInputCompression(string18, l6);
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): planarConfig {}changed from {} to {}", l9 == l12 ? "un" : "", l9, l12);
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): photometric {}changed from {} to {}", l7 == l13 ? "un" : "", l7, l13);
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): compression {}changed from {} to {}", l6 == l14 ? "un" : "", l6, l14);
        TIFFToDicom.generateDICOMPixelDataModuleAttributes(attributeList3, 1, l, l2, l5, l14, l13, l8, l12, l10, string18, bl5, string7);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList3, "", "", "", "", Integer.toString(n2), string6, string7, false);
        attributeList3.remove(TagFromName.SoftwareVersions);
        attributeList3.remove(TagFromName.DeviceSerialNumber);
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            this.generateDICOMWholeSlideMicroscopyImageAttributes(attributeList3, l, l2, string3, d, d2, d3, d4, d5, string4, string5, d6, d7, string9, string10, string11, string12, string13, string15, string16);
        }
        this.insertLossyImageCompressionHistory(attributeList3, l6, l14, bl5, string17, this.totalArrayValues(lArray2), l, l2, l5, l8);
        if (bl4 && string14 != null && string14.length() > 0) {
            if (string14.length() <= 10240) {
                object3 = new LongTextAttribute(TagFromName.ImageComments);
                ((Attribute)object3).addValue(string14);
                attributeList3.put((Attribute)object3);
            } else {
                object3 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object3).addValue(string14);
                attributeList3.put((Attribute)object3);
            }
        }
        if (attributeList2 != null) {
            attributeList3.putAll(attributeList2);
        }
        this.createOrAppendToManufacturerModelNameAndInsertOrReplace(attributeList3);
        this.createOrAppendToSoftwareVersionsAndInsertOrReplace(attributeList3);
        this.addContributingEquipmentSequence(attributeList3);
        new SetCharacteristicsFromSummary(string, attributeList3);
        this.addSpecimenPreparationStepContentItemSequence(sequenceAttribute, string10, attributeList3);
        if (uIDMap != null) {
            uIDMap.replaceUIDs(attributeList3, tIFFFile.getFileName(), n);
        }
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            if (l8 > 1L) {
                byArray2 = this.addICCProfileToOpticalPathSequence(attributeList3, byArray2);
            }
        } else if (byArray2 != null && byArray2.length > 0) {
            object3 = new OtherByteAttribute(TagFromName.ICCProfile);
            ((Attribute)object3).setValues(byArray2);
            attributeList3.put((Attribute)object3);
            slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): Created ICC Profile attribute of length {}", byArray2.length);
        }
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            this.addObjectiveLensPowerToOpticalPathSequence(attributeList3, d4);
            this.addObjectiveLensNumericalApertureToOpticalPathSequence(attributeList3, d5);
            this.addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(attributeList3, string4, string5);
            this.addOpticalPathAttributesForChannel(attributeList3, attributeList);
        }
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList3);
        attributeList3.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList3, string8, "OURAETITLE");
        object3 = null;
        if (bl) {
            try {
                object2 = new long[1][];
                object = new long[1][];
                long[] lArray3 = new long[1];
                long[] lArray4 = new long[1];
                long l15 = AddTIFFOrOffsetTables.getByteOffsetsAndLengthsOfTileDataFromStartOfFile(attributeList3, string8, (long[][])object2, (long[][])object, lArray3, lArray4, false, l8, false);
                object3 = AddTIFFOrOffsetTables.makeTIFFInPreambleAndAddDataSetTrailingPadding(l15, 1, (long[][])object2, (long[][])object, lArray3, lArray4, attributeList3, l, l2, l5, l14, l13, l13, l8, l12, l10, byArray2, d, d2, bl2);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        TIFFToDicom.assertPixelDataEncodingIsCompatibleWithTransferSyntax(attributeList3, string8);
        attributeList3.write(string2, string8, true, true, (byte[])object3);
        if (this.filesToDeleteAfterWritingDicomFile != null) {
            object2 = this.filesToDeleteAfterWritingDicomFile.iterator();
            while (object2.hasNext()) {
                object = (File)object2.next();
                ((File)object).delete();
            }
            this.filesToDeleteAfterWritingDicomFile = null;
        }
    }

    private void convertTIFFPixelsToDicomSingleFrame(String string, UIDMap uIDMap, TIFFFile tIFFFile, int n, String string2, int n2, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, byte[] byArray, byte[] byArray2, long l9, long l10, long l11, long l12, long l13, String string3, double d, double d2, double d3, double d4, double d5, String string4, String string5, AttributeList attributeList, double d6, double d7, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, AttributeList attributeList2, boolean bl, boolean bl2, boolean bl3, SequenceAttribute sequenceAttribute, String string15, String string16, boolean bl4, String string17) throws IOException, DicomException, TIFFException {
        Object object;
        Object object2;
        Object object3;
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrame(): instanceNumber = {}", n2);
        string8 = this.chooseTransferSyntaxForCompressionSchemeIfNotSpecifiedExplicitly(string8, l8);
        String string18 = this.chooseRecompressAsFormatFromTransferSyntax(string8);
        boolean bl5 = new TransferSyntax(string8).isLossy();
        slf4jlogger.debug("convertTIFFPixelsToDicomMultiFrame(): recompressLossy = {}", bl5);
        AttributeList attributeList3 = new AttributeList();
        long l14 = this.generateDICOMPixelDataSingleFrameImageFromTIFFFile(tIFFFile, attributeList3, l3, l4, l5, l6, l7, l12, l8, l9, l10, byArray, byArray2, string18, bl5);
        long l15 = this.chooseOutputCompressionForRecompressAsFormatGivenInputCompression(string18, l8);
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrame(): photometric {}changed from {} to {}", l9 == l14 ? "un" : "", l9, l14);
        slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrame(): compression {}changed from {} to {}", l8 == l15 ? "un" : "", l8, l15);
        TIFFToDicom.generateDICOMPixelDataModuleAttributes(attributeList3, 1, l5, l6, l7, l15, l14, l10, l11, l12, string18, bl5, string7);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList3, "", "", "", "", Integer.toString(n2), string6, string7, false);
        attributeList3.remove(TagFromName.SoftwareVersions);
        attributeList3.remove(TagFromName.DeviceSerialNumber);
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            this.generateDICOMWholeSlideMicroscopyImageAttributes(attributeList3, l, l2, string3, d, d2, d3, d4, d5, string4, string5, d6, d7, string9, string10, string11, string12, string13, string15, string16);
        }
        this.insertLossyImageCompressionHistory(attributeList3, l8, l15, bl5, string17, l4, l, l2, l7, l10);
        if (bl4 && string14 != null && string14.length() > 0) {
            if (string14.length() <= 10240) {
                object3 = new LongTextAttribute(TagFromName.ImageComments);
                ((Attribute)object3).addValue(string14);
                attributeList3.put((Attribute)object3);
            } else {
                object3 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object3).addValue(string14);
                attributeList3.put((Attribute)object3);
            }
        }
        if (attributeList2 != null) {
            attributeList3.putAll(attributeList2);
        }
        this.createOrAppendToManufacturerModelNameAndInsertOrReplace(attributeList3);
        this.createOrAppendToSoftwareVersionsAndInsertOrReplace(attributeList3);
        this.addContributingEquipmentSequence(attributeList3);
        new SetCharacteristicsFromSummary(string, attributeList3);
        this.addSpecimenPreparationStepContentItemSequence(sequenceAttribute, string10, attributeList3);
        if (uIDMap != null) {
            uIDMap.replaceUIDs(attributeList3, tIFFFile.getFileName(), n);
        }
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            if (l10 > 1L) {
                byArray2 = this.addICCProfileToOpticalPathSequence(attributeList3, byArray2);
            }
        } else if (byArray2 != null && byArray2.length > 0) {
            object3 = new OtherByteAttribute(TagFromName.ICCProfile);
            ((Attribute)object3).setValues(byArray2);
            attributeList3.put((Attribute)object3);
            slf4jlogger.debug("convertTIFFPixelsToDicomSingleFrameMergingStrips(): Created ICC Profile attribute of length {}", byArray2.length);
        }
        if (bl3 || "1.2.840.10008.5.1.4.1.1.77.1.6".equals(string7)) {
            this.addObjectiveLensPowerToOpticalPathSequence(attributeList3, d4);
            this.addObjectiveLensNumericalApertureToOpticalPathSequence(attributeList3, d5);
            this.addOpticalPathIdentifierAndDescriptionToOpticalPathSequence(attributeList3, string4, string5);
            this.addOpticalPathAttributesForChannel(attributeList3, attributeList);
        }
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList3);
        attributeList3.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList3, string8, "OURAETITLE");
        object3 = null;
        if (bl) {
            try {
                object2 = new long[1][];
                object = new long[1][];
                long[] lArray = new long[1];
                long[] lArray2 = new long[1];
                long l16 = AddTIFFOrOffsetTables.getByteOffsetsAndLengthsOfTileDataFromStartOfFile(attributeList3, string8, (long[][])object2, (long[][])object, lArray, lArray2, false, l10, false);
                object3 = AddTIFFOrOffsetTables.makeTIFFInPreambleAndAddDataSetTrailingPadding(l16, 1, (long[][])object2, (long[][])object, lArray, lArray2, attributeList3, l, l2, l7, l15, l14, l14, l10, l11, l12, byArray2, d, d2, bl2);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        TIFFToDicom.assertPixelDataEncodingIsCompatibleWithTransferSyntax(attributeList3, string8);
        attributeList3.write(string2, string8, true, true, (byte[])object3);
        if (this.filesToDeleteAfterWritingDicomFile != null) {
            object2 = this.filesToDeleteAfterWritingDicomFile.iterator();
            while (object2.hasNext()) {
                object = (File)object2.next();
                ((File)object).delete();
            }
            this.filesToDeleteAfterWritingDicomFile = null;
        }
    }

    private String getDateTimeStringForIFDTIFFTagOrImageDescription(TIFFImageFileDirectory tIFFImageFileDirectory) {
        String string = null;
        return string;
    }

    private String[] addCommonDateTimeInformation(ArrayList<TIFFImageFileDirectory> arrayList, AttributeList attributeList) throws DicomException {
        String[] stringArray = new String[arrayList.size()];
        Object object = null;
        String string = null;
        int n = 0;
        for (TIFFImageFileDirectory tIFFImageFileDirectory : arrayList) {
            Object object2;
            String string2;
            String string3;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            slf4jlogger.debug("addCommonDateTimeInformation(): Directory={}", n);
            Object object7 = null;
            String string4 = null;
            Object object8 = tIFFImageFileDirectory.getStringValues(270);
            if (object8 != null && ((String[])object8).length > 0) {
                slf4jlogger.trace("addCommonDateTimeInformation(): description.length = {}", ((String[])object8).length);
                for (String string5 : object8) {
                    String string6;
                    String string7;
                    Object object9;
                    Object object10;
                    slf4jlogger.trace("addCommonDateTimeInformation(): String = {}", string5);
                    if (string5.startsWith("<?xml") || string5.startsWith("<OME")) {
                        slf4jlogger.debug("addCommonDateTimeInformation(): Parsing OME-TIFF XML metadata");
                        try {
                            object6 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string5)));
                            object5 = XPathFactory.newInstance();
                            object4 = (NodeList)((XPathFactory)object5).newXPath().evaluate("//OriginalMetadata", object6, XPathConstants.NODESET);
                            if (object4 != null && object4.getLength() > 0) {
                                for (int i = 0; i < object4.getLength(); ++i) {
                                    object3 = object4.item(i);
                                    string3 = ((XPathFactory)object5).newXPath().evaluate("Key", object3);
                                    string2 = ((XPathFactory)object5).newXPath().evaluate("Value", object3);
                                    if (string3 != null && string3.length() > 0 && string2 != null && string2.length() > 0) {
                                        String string8;
                                        int n2;
                                        slf4jlogger.trace("addCommonDateTimeInformation(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Key {} Value {}", string3, string2);
                                        if (string3.matches("^Series [0-9]+ Date$")) {
                                            slf4jlogger.debug("addCommonDateTimeInformation(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Date {}", string2);
                                            object10 = Pattern.compile("([0-9][0-9])/([0-9][0-9])/([0-9][0-9])");
                                            object9 = ((Pattern)object10).matcher(string2);
                                            if (((Matcher)object9).matches()) {
                                                slf4jlogger.debug("addCommonDateTimeInformation(): have OME-TIFF XML OriginalMetadata SVS-style Date match");
                                                n2 = ((Matcher)object9).groupCount();
                                                if (n2 != 3) continue;
                                                slf4jlogger.debug("addCommonDateTimeInformation(): have OME-TIFF XML OriginalMetadata SVS-style Date correct groupCount");
                                                string7 = ((Matcher)object9).group(1);
                                                string6 = ((Matcher)object9).group(2);
                                                string8 = ((Matcher)object9).group(3);
                                                object7 = "20" + string8 + string7 + string6;
                                                slf4jlogger.debug("addCommonDateTimeInformation(): found OME-TIFF XML OriginalMetadata SVS-style Date {}", object7);
                                                continue;
                                            }
                                            object10 = Pattern.compile("([0-9][0-9])/([0-9][0-9])/([0-9][0-9][0-9][0-9])");
                                            object9 = ((Pattern)object10).matcher(string2);
                                            if (((Matcher)object9).matches()) {
                                                slf4jlogger.debug("addCommonDateTimeInformation(): have OME-TIFF XML OriginalMetadata SVS-style Date four digit year match");
                                                n2 = ((Matcher)object9).groupCount();
                                                if (n2 != 3) continue;
                                                slf4jlogger.debug("addCommonDateTimeInformation(): have OME-TIFF XML OriginalMetadata SVS-style Date correct groupCount");
                                                string7 = ((Matcher)object9).group(1);
                                                string6 = ((Matcher)object9).group(2);
                                                string8 = ((Matcher)object9).group(3);
                                                object7 = string8 + string7 + string6;
                                                slf4jlogger.debug("addCommonDateTimeInformation(): found OME-TIFF XML OriginalMetadata SVS-style Date {}", object7);
                                                continue;
                                            }
                                            slf4jlogger.warn("addCommonDateTimeInformation(): Unrecognized value format OME-TIFF XML OriginalMetadata SVS-style Date Key \"{}\" Value \"{}\"", string3, string2);
                                            continue;
                                        }
                                        if (!string3.matches("^Series [0-9]+ Time$")) continue;
                                        slf4jlogger.debug("addCommonDateTimeInformation(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Time {}", string2);
                                        object10 = Pattern.compile("([0-9][0-9]):([0-9][0-9]):([0-9][0-9])");
                                        object9 = ((Pattern)object10).matcher(string2);
                                        if (((Matcher)object9).matches()) {
                                            slf4jlogger.debug("addCommonDateTimeInformation(): have OME-TIFF XML OriginalMetadata SVS-style Time match");
                                            n2 = ((Matcher)object9).groupCount();
                                            if (n2 != 3) continue;
                                            slf4jlogger.debug("addCommonDateTimeInformation(): have OME-TIFF XML OriginalMetadata SVS-style Time correct groupCount");
                                            string7 = ((Matcher)object9).group(1);
                                            string6 = ((Matcher)object9).group(2);
                                            string8 = ((Matcher)object9).group(3);
                                            string4 = string7 + string6 + string8;
                                            slf4jlogger.debug("addCommonDateTimeInformation(): found OME-TIFF XML OriginalMetadata SVS-style Time {}", string4);
                                            continue;
                                        }
                                        slf4jlogger.warn("addCommonDateTimeInformation(): Unrecognized value format OME-TIFF XML OriginalMetadata SVS-style Time Key \"{}\" Value \"{}\"", string3, string2);
                                        continue;
                                    }
                                    slf4jlogger.debug("addCommonDateTimeInformation(): Cannot find Key and Value for OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata ", object3.toString());
                                }
                                continue;
                            }
                            slf4jlogger.debug("addCommonDateTimeInformation(): no OME-TIFF XML OriginalMetadata");
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("Failed to parse OME-TIFF XML metadata in ImageDescription ", exception);
                        }
                        continue;
                    }
                    if (!string5.contains("Aperio")) continue;
                    slf4jlogger.debug("addCommonDateTimeInformation(): processing SVS ImageDescription {}");
                    try {
                        object6 = new BufferedReader(new StringReader(string5));
                        object5 = null;
                        while ((object5 = ((BufferedReader)object6).readLine()) != null) {
                            int n3;
                            object4 = Pattern.compile(".*[|]Date[ ]*=[ ]*([0-9][0-9])/([0-9][0-9])/([0-9][0-9][0-9][0-9])[|].*");
                            Matcher matcher = ((Pattern)object4).matcher((CharSequence)object5);
                            if (matcher.matches()) {
                                slf4jlogger.debug("addCommonDateTimeInformation(): have SVS four digit year date match");
                                n3 = matcher.groupCount();
                                if (n3 == 3) {
                                    slf4jlogger.debug("addCommonDateTimeInformation(): have SVS date correct groupCount");
                                    string3 = matcher.group(1);
                                    string2 = matcher.group(2);
                                    object10 = matcher.group(3);
                                    object7 = (String)object10 + string3 + string2;
                                    slf4jlogger.debug("addCommonDateTimeInformation(): found SVS date {}", object7);
                                }
                            }
                            if ((matcher = ((Pattern)(object4 = Pattern.compile(".*[|]Date[ ]*=[ ]*([0-9][0-9])/([0-9][0-9])/([0-9][0-9])[|].*"))).matcher((CharSequence)object5)).matches()) {
                                slf4jlogger.debug("addCommonDateTimeInformation(): have SVS date match");
                                n3 = matcher.groupCount();
                                if (n3 == 3) {
                                    slf4jlogger.debug("addCommonDateTimeInformation(): have SVS date correct groupCount");
                                    string3 = matcher.group(1);
                                    string2 = matcher.group(2);
                                    object10 = matcher.group(3);
                                    object7 = "20" + (String)object10 + string3 + string2;
                                    slf4jlogger.debug("addCommonDateTimeInformation(): found SVS date {}", object7);
                                }
                            }
                            if ((matcher = ((Pattern)(object4 = Pattern.compile(".*[|]Time[ ]*=[ ]*([0-9][0-9]):([0-9][0-9]):([0-9][0-9])[|].*"))).matcher((CharSequence)object5)).matches()) {
                                slf4jlogger.debug("addCommonDateTimeInformation(): have SVS time match");
                                n3 = matcher.groupCount();
                                if (n3 == 3) {
                                    slf4jlogger.debug("addCommonDateTimeInformation(): have SVS time correct groupCount");
                                    string3 = matcher.group(1);
                                    string2 = matcher.group(2);
                                    object10 = matcher.group(3);
                                    string4 = string3 + string2 + (String)object10;
                                    slf4jlogger.debug("addCommonDateTimeInformation(): found SVS time {}", string4);
                                }
                            }
                            if (!(matcher = ((Pattern)(object4 = Pattern.compile(".*[|]Date[ ]*=[ ]*([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])T([0-9][0-9]):([0-9][0-9]):([0-9][0-9])[.]([0-9][0-9])Z[|].*"))).matcher((CharSequence)object5)).matches()) continue;
                            slf4jlogger.debug("addCommonDateTimeInformation(): have SVS SCN style datetime match");
                            n3 = matcher.groupCount();
                            if (n3 != 7) continue;
                            slf4jlogger.debug("addCommonDateTimeInformation(): have SVS SCN style datetime correct groupCount");
                            string3 = matcher.group(1);
                            string2 = matcher.group(2);
                            object10 = matcher.group(3);
                            object7 = string3 + string2 + (String)object10;
                            object9 = matcher.group(4);
                            String string9 = matcher.group(5);
                            string7 = matcher.group(6);
                            string6 = matcher.group(7);
                            string4 = (String)object9 + string9 + string7 + "." + string6;
                            slf4jlogger.debug("addCommonDateTimeInformation(): found SVS SCN style date {}", object7);
                            slf4jlogger.debug("addCommonDateTimeInformation(): found SVS SCN style time {}", string4);
                        }
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("Failed to parse SVS ImageDescription ", iOException);
                    }
                }
            }
            if (object7 != null && object7.length() > 0 && string4 != null && string4.length() > 0) {
                object2 = (String)object7 + string4;
                slf4jlogger.debug("addCommonDateTimeInformation(): found SVS date and time for IFD {} {}", n, object2);
                stringArray[n] = object2;
            }
            if (object7 != null && object7.length() > 0) {
                if (object == null || object.length() == 0) {
                    slf4jlogger.debug("addCommonDateTimeInformation(): first encounter, so setting useCommonDate from SVS date to {}", object7);
                    object = object7;
                } else if (!object.equals(object7)) {
                    slf4jlogger.warn("addCommonDateTimeInformation(): different SVS date {} than previously encountered useCommonDate {}", object7, object);
                }
            }
            if (string4 != null && string4.length() > 0) {
                if (string == null || string.length() == 0) {
                    slf4jlogger.debug("addCommonDateTimeInformation(): first encounter, so setting useCommonTime from SVS time to {}", string4);
                    string = string4;
                } else if (!string.equals(string4)) {
                    slf4jlogger.warn("addCommonDateTimeInformation(): different SVS time {} than previously encountered useCommonTime {}", string4, string);
                }
            }
            if ((object7 = tIFFImageFileDirectory.getStringValues(306)) != null && ((String[])object7).length > 0) {
                if (object7[0] != null && object7[0].length() > 0) {
                    string4 = object7[0].trim();
                    slf4jlogger.debug("addCommonDateTimeInformation(): TIFF DATETIME = {}", string4);
                    object8 = Pattern.compile("([0-9][0-9][0-9][0-9]):([0-9][0-9]):([0-9][0-9]) ([0-9][0-9]):([0-9][0-9]):([0-9][0-9]).*");
                    object2 = ((Pattern)object8).matcher(string4);
                    if (((Matcher)object2).matches()) {
                        String string5;
                        slf4jlogger.debug("addCommonDateTimeInformation(): have TIFF DATETIME match");
                        int n4 = ((Matcher)object2).groupCount();
                        if (n4 != 6) continue;
                        slf4jlogger.debug("addCommonDateTimeInformation(): have TIFF DATETIME correct groupCount");
                        String string10 = ((Matcher)object2).group(1);
                        string5 = ((Matcher)object2).group(2);
                        object6 = ((Matcher)object2).group(3);
                        object5 = ((Matcher)object2).group(4);
                        object4 = ((Matcher)object2).group(5);
                        String string11 = ((Matcher)object2).group(6);
                        object3 = string10 + string5 + (String)object6;
                        string3 = (String)object5 + (String)object4 + string11;
                        string2 = (String)object3 + string3;
                        slf4jlogger.debug("addCommonDateTimeInformation(): found TIFF DATETIME for IFD {} {}", n, string2);
                        stringArray[n] = string2;
                        if (object == null || object.length() == 0) {
                            slf4jlogger.debug("addCommonDateTimeInformation(): first encounter, so setting useCommonDate to {}", object3);
                            object = object3;
                        } else if (!object.equals(object3)) {
                            slf4jlogger.warn("addCommonDateTimeInformation(): different TIFF DATETIME date {} than previously encountered useCommonDate {}", object3, object);
                        }
                        if (string == null || string.length() == 0) {
                            slf4jlogger.debug("addCommonDateTimeInformation(): first encounter, so setting useCommonTime to {}", string3);
                            string = string3;
                            continue;
                        }
                        if (string.equals(string3)) continue;
                        slf4jlogger.warn("addCommonDateTimeInformation(): different TIFF DATETIME time {} than previously encountered useCommonTime {}", string3, string);
                        continue;
                    }
                    slf4jlogger.warn("addCommonDateTimeInformation(): unrecognized format for TIFF DATETIME {} - ignoring", string4);
                    continue;
                }
                slf4jlogger.warn("addCommonDateTimeInformation(): missing value for TIFF DATETIME - ignoring");
                continue;
            }
            slf4jlogger.debug("addCommonDateTimeInformation(): no TIFF DATETIME present");
        }
        Object object11 = new Date();
        if (object == null || object.length() == 0) {
            object = new SimpleDateFormat("yyyyMMdd").format((Date)object11);
            slf4jlogger.debug("addCommonDateTimeInformation(): using default current date for StudyDate, etc. since nothing found within TIFF {}", object);
        } else {
            slf4jlogger.debug("addCommonDateTimeInformation(): using extracted date from TIFF for StudyDate, etc. {}", object);
        }
        if (string == null || string.length() == 0) {
            string = new SimpleDateFormat("HHmmss.SSS").format((Date)object11);
            slf4jlogger.debug("addCommonDateTimeInformation(): using default current time for StudyTime, etc. since nothing found within TIFF {}", string);
        } else {
            slf4jlogger.debug("addCommonDateTimeInformation(): using extracted time from TIFF for StudyTime, etc. {}", string);
        }
        object11 = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object11).addValue((String)object);
        attributeList.put((Attribute)object11);
        object11 = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object11).addValue((String)object);
        attributeList.put((Attribute)object11);
        object11 = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object11).addValue((String)object);
        attributeList.put((Attribute)object11);
        object11 = new DateAttribute(TagFromName.AcquisitionDate);
        ((Attribute)object11).addValue((String)object);
        attributeList.put((Attribute)object11);
        object11 = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object11).addValue(string);
        attributeList.put((Attribute)object11);
        object11 = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object11).addValue(string);
        attributeList.put((Attribute)object11);
        object11 = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object11).addValue(string);
        attributeList.put((Attribute)object11);
        object11 = new TimeAttribute(TagFromName.AcquisitionTime);
        ((Attribute)object11).addValue(string);
        attributeList.put((Attribute)object11);
        object11 = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        ((Attribute)object11).addValue((String)object + string);
        attributeList.put((Attribute)object11);
        return stringArray;
    }

    public TIFFToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string8, boolean bl7, double d, double d2, double d3, boolean bl8, String string9, boolean bl9, boolean bl10) throws IOException, DicomException, TIFFException, NumberFormatException {
        Object object;
        TIFFImageFileDirectories tIFFImageFileDirectories = new TIFFImageFileDirectories();
        tIFFImageFileDirectories.read(string2);
        ArrayList<TIFFImageFileDirectory> arrayList = tIFFImageFileDirectories.getListOfImageFileDirectories();
        if (bl6) {
            if (string6 == null || string6.length() == 0) {
                String string10 = this.selectSOPClassBasedOnTIFFCharacteristics(tIFFImageFileDirectories);
                if (string10 != null && string10.length() > 0) {
                    string6 = string10;
                    slf4jlogger.info("autoRecognize SOP Class {}", string6);
                    if (string5 == null || string5.length() == 0) {
                        string5 = SOPClass.selectModalityForSOPClass(string6);
                        slf4jlogger.info("autoRecognize Modality {} for SOP Class {}", string5, string6);
                    }
                } else {
                    slf4jlogger.warn("autoRecognize SOP Class failed to find any hints");
                }
            } else {
                slf4jlogger.warn("autoRecognize requested but not performed since overridden by supplied SOP Class");
            }
        }
        boolean bl11 = bl3 || string6 != null && string6.equals("1.2.840.10008.5.1.4.1.1.77.1.6");
        slf4jlogger.debug("isWSI={}", bl11);
        String string11 = null;
        String string12 = null;
        if (bl11) {
            string11 = this.u.getAnotherNewUID();
            string12 = this.u.getAnotherNewUID();
        }
        byte[] byArray = null;
        AttributeList attributeList = new AttributeList();
        String[] stringArray = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        stringArray.addValue(this.u.getAnotherNewUID());
        attributeList.put((Attribute)stringArray);
        stringArray = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        stringArray.addValue(this.u.getAnotherNewUID());
        attributeList.put((Attribute)stringArray);
        stringArray = this.addCommonDateTimeInformation(arrayList, attributeList);
        String string13 = "SLIDE_1";
        String string14 = "SPECIMEN_1";
        String string15 = this.u.getAnotherNewUID();
        String[][] stringArray2 = this.getImageFlavorAndDerivationByIFD(arrayList);
        WSIFrameOfReference wSIFrameOfReference = new WSIFrameOfReference(arrayList, stringArray2, d, d2, d3);
        double d4 = wSIFrameOfReference.getSliceThickness();
        String string16 = this.getPastHistoryOfLossyCompression(arrayList);
        SortedMap<String, AttributeList> sortedMap = null;
        SortedMap<String, SequenceAttribute> sortedMap2 = null;
        Object object2 = null;
        if (string8 != null && string8.length() > 0) {
            try {
                object2 = new Immunostaining(new File(string8));
            }
            catch (Exception exception) {
                slf4jlogger.error("Failed to read and process Immunostaining channel file " + string8 + ": ", exception);
            }
        }
        if (object2 == null) {
            object2 = new Immunostaining(wSIFrameOfReference.getChannelNamesByChannelID());
        }
        if (object2 != null) {
            sortedMap = ((Immunostaining)object2).getMapOfOpticalPathAttributesByChannelID();
            sortedMap2 = ((Immunostaining)object2).getMapOfSpecimenPreparationStepContentItemSequenceByChannelID();
        }
        if ((object2 = arrayList.get(0)) != null) {
            object = ((TIFFImageFileDirectory)object2).getStringValues(270);
            this.getEquipmentFromTIFFImageDescription((String[])object, attributeList);
        }
        if (Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DeviceSerialNumber).length() == 0) {
            object = new VMID().toString();
            slf4jlogger.debug("No deviceSerialNumber found so synthesizing = {}", object);
            LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.DeviceSerialNumber);
            ((Attribute)longStringAttribute).addValue((String)object);
            attributeList.put(longStringAttribute);
        }
        object2 = string9 == null ? null : new UIDMap(string9);
        int n = 0;
        for (TIFFImageFileDirectory tIFFImageFileDirectory : arrayList) {
            block47: {
                byte[] byArray2;
                slf4jlogger.debug("Directory={}", n);
                long l = tIFFImageFileDirectory.getSingleNumericValue(256, 0, 0L);
                slf4jlogger.debug("imageWidth={}", l);
                long l2 = tIFFImageFileDirectory.getSingleNumericValue(257, 0, 0L);
                slf4jlogger.debug("imageLength={}", l2);
                long l3 = tIFFImageFileDirectory.getSingleNumericValue(258, 0, 0L);
                slf4jlogger.debug("bitsPerSample={}", l3);
                long l4 = tIFFImageFileDirectory.getSingleNumericValue(259, 0, 0L);
                slf4jlogger.debug("compression={}", l4);
                long l5 = tIFFImageFileDirectory.getSingleNumericValue(262, 0, 0L);
                slf4jlogger.debug("photometric={}", l5);
                long l6 = tIFFImageFileDirectory.getSingleNumericValue(277, 0, 0L);
                slf4jlogger.debug("samplesPerPixel={}", l6);
                long l7 = tIFFImageFileDirectory.getSingleNumericValue(284, 0, 1L);
                slf4jlogger.debug("planarConfig={}", l7);
                long l8 = tIFFImageFileDirectory.getSingleNumericValue(339, 0, 1L);
                slf4jlogger.debug("sampleFormat={}", l8);
                byte[] byArray3 = null;
                if (l4 == 7L && (byArray3 = tIFFImageFileDirectory.getByteValues(347)) != null) {
                    slf4jlogger.debug("jpegTables present");
                    byArray3 = TIFFToDicom.stripSOIEOIMarkers(byArray3);
                }
                if ((byArray2 = tIFFImageFileDirectory.getByteValues(34675)) != null) {
                    slf4jlogger.debug("ICC profile present, of length {}", byArray2.length);
                }
                if (byArray2 != null && byArray2.length > 0) {
                    if (n == 0) {
                        byArray = byArray2;
                    }
                } else if (bl11 && byArray != null && byArray.length > 0) {
                    slf4jlogger.debug("ICC profile absent or empty so using profile of base layer");
                    byArray2 = byArray;
                }
                boolean bl12 = SOPClass.isMultiframeImageStorage(string6);
                slf4jlogger.debug("makeMultiFrame={}", bl12);
                long l9 = tIFFImageFileDirectory.getSingleNumericValue(322, 0, 0L);
                slf4jlogger.debug("tileWidth={}", l9);
                long l10 = tIFFImageFileDirectory.getSingleNumericValue(323, 0, 0L);
                slf4jlogger.debug("tileLength={}", l10);
                long l11 = tIFFImageFileDirectory.getSingleNumericValue(317, 0, 0L);
                slf4jlogger.debug("predictor={}", l11);
                String string17 = null;
                Object object3 = tIFFImageFileDirectory.getStringValues(270);
                this.parseTIFFImageDescription((String[])object3, attributeList);
                string17 = this.mergeImageDescription((String[])object3);
                object3 = tIFFImageFileDirectory.getStringValues(305);
                if (object3 != null && ((String[])object3).length > 0 && attributeList.get(TagFromName.ManufacturerModelName) == null) {
                    slf4jlogger.debug("Using software[{}] as ManufacturerModelName {}", n, object3[0]);
                    LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ManufacturerModelName);
                    ((Attribute)longStringAttribute).addValue((String)object3[0]);
                    attributeList.put(longStringAttribute);
                }
                if (bl7) {
                    object3 = new LongStringAttribute(pixelmedPrivateOriginalFileNameDataBlockReservation);
                    ((Attribute)object3).addValue("PixelMed Publishing");
                    attributeList.put((Attribute)object3);
                    object3 = new UnlimitedTextAttribute(pixelmedPrivateOriginalFileName);
                    ((Attribute)object3).addValue(string2);
                    attributeList.put((Attribute)object3);
                    object3 = new UnsignedShortAttribute(pixelmedPrivateOriginalTIFFIFDIndex);
                    ((Attribute)object3).addValue(n);
                    attributeList.put((Attribute)object3);
                }
                object3 = wSIFrameOfReference.getFrameOfReferenceUIDForIFD(n);
                slf4jlogger.debug("Using frameOfReferenceUID[{}] from WSI Frame of Reference {} to make DICOM file", n, object3);
                double d5 = wSIFrameOfReference.getmmPerPixelXForIFD(n);
                slf4jlogger.debug("Using mmPerPixelX[{}] from WSI Frame of Reference {} to make DICOM file", n, d5);
                double d6 = wSIFrameOfReference.getmmPerPixelYForIFD(n);
                slf4jlogger.debug("Using mmPerPixelX[{}] from WSI Frame of Reference {} to make DICOM file", n, d6);
                double d7 = wSIFrameOfReference.getObjectiveLensPower();
                slf4jlogger.debug("Using objectiveLensPower from WSI Frame of Reference {} to make DICOM file", d7);
                double d8 = wSIFrameOfReference.getObjectiveLensNumericalAperture();
                slf4jlogger.debug("Using objectiveLensNumericalAperture from WSI Frame of Reference {} to make DICOM file", d8);
                String string18 = null;
                String string19 = null;
                AttributeList attributeList2 = null;
                SequenceAttribute sequenceAttribute = null;
                int n2 = wSIFrameOfReference.getChannelForIFD(n);
                if (n2 != -1) {
                    string18 = wSIFrameOfReference.getChannelIDForChannel(n2);
                    slf4jlogger.debug("Using opticalPathIdentifier from WSI Frame of Reference {} to make DICOM file", string18);
                    if (string18 == null || string18.length() == 0) {
                        string18 = Integer.toString(n2);
                        slf4jlogger.debug("In absence of opticalPathIdentifier from WSI Frame of Reference, using sequential channel index value", string18);
                    }
                    string19 = wSIFrameOfReference.getChannelNameForChannel(n2);
                    slf4jlogger.debug("Using opticalPathDescription from WSI Frame of Reference {} to make DICOM file", string19);
                    if (sortedMap != null && (attributeList2 = (AttributeList)sortedMap.get(string18)) == null) {
                        slf4jlogger.debug("Could not find Optical Path attributes for opticalPathIdentifier {}", string18);
                    }
                    if (sortedMap2 != null && (sequenceAttribute = (SequenceAttribute)sortedMap2.get(string18)) == null) {
                        slf4jlogger.debug("Could not find SpecimenPreparationStepContentItemSequence for opticalPathIdentifier {}", string18);
                    }
                } else {
                    slf4jlogger.debug("Could not find channel to use for opticalPathIdentifier from WSI Frame of Reference {}", string18);
                }
                double d9 = wSIFrameOfReference.getXOffsetInSlideCoordinateSystemForIFD(n);
                slf4jlogger.debug("Using xOffsetInSlideCoordinateSystem[{}] from WSI Frame of Reference {} to make DICOM file", n, d9);
                double d10 = wSIFrameOfReference.getYOffsetInSlideCoordinateSystemForIFD(n);
                slf4jlogger.debug("Using yOffsetInSlideCoordinateSystem[{}] from WSI Frame of Reference {} to make DICOM file", n, d10);
                try {
                    long[] lArray = tIFFImageFileDirectory.getNumericValues(324);
                    long[] lArray2 = tIFFImageFileDirectory.getNumericValues(325);
                    if (lArray != null) {
                        int n3 = lArray.length;
                        if (lArray2.length != n3) {
                            throw new TIFFException("Number of tiles uncertain: tileOffsets length = " + lArray.length + " different from tileByteCounts length " + lArray2.length);
                        }
                        slf4jlogger.debug("numberOfTiles={}", n3);
                        if (bl12) {
                            String string20 = string3 + "_" + n + string4;
                            slf4jlogger.info("outputFileName={}", string20);
                            int n4 = n + 1;
                            this.convertTIFFPixelsToDicomMultiFrame(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string20, n4, l, l2, lArray, lArray2, l9, l10, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, string7, string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, bl4, sequenceAttribute, string11, string12, bl8, string16, bl9, bl10);
                        } else {
                            for (int i = 0; i < n3; ++i) {
                                String string21 = string3 + "_" + n + "_" + i + string4;
                                slf4jlogger.info("outputFileName={}", string21);
                                int n5 = (n + 1) * 100000 + (i + 1);
                                this.convertTIFFPixelsToDicomSingleFrame(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string21, n5, l, l2, lArray[i], lArray2[i], l9, l10, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, string7, string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, sequenceAttribute, string11, string12, bl8, string16);
                            }
                        }
                        break block47;
                    }
                    long l12 = tIFFImageFileDirectory.getSingleNumericValue(278, 0, 0L);
                    slf4jlogger.debug("rowsPerStrip={}", l12);
                    long[] lArray3 = tIFFImageFileDirectory.getNumericValues(273);
                    long[] lArray4 = tIFFImageFileDirectory.getNumericValues(279);
                    if (lArray4 != null) {
                        int n6;
                        slf4jlogger.debug("Strips rather than tiled");
                        int n7 = lArray3.length;
                        slf4jlogger.debug("numberOfStrips={}", n7);
                        if (lArray4.length != n7) {
                            throw new TIFFException("Number of strips uncertain: stripOffsets length = " + lArray3.length + " different from stripByteCounts length " + lArray4.length);
                        }
                        if (l12 == l2) {
                            slf4jlogger.debug("Single strip for entire image");
                            if (n7 != 1) {
                                throw new TIFFException("Number of strips uncertain: stripOffsets length = " + lArray3.length + " > 1 but rowsPerStrip == imageLength of " + l12);
                            }
                            String string22 = string3 + "_" + n + string4;
                            slf4jlogger.info("outputFileName={}", string22);
                            n6 = n + 1;
                            if (l4 == 5L) {
                                this.convertTIFFPixelsToDicomSingleFrameMergingStrips(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string22, n6, l, l2, lArray3, lArray4, l, l12, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, "1.2.840.10008.1.2.1", string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, sequenceAttribute, string11, string12, bl8, string16);
                            } else {
                                this.convertTIFFPixelsToDicomSingleFrame(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string22, n6, l, l2, lArray3[0], lArray4[0], l, l12, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, string7, string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, sequenceAttribute, string11, string12, bl8, string16);
                            }
                        } else if (bl5 && n7 > 1) {
                            slf4jlogger.debug("Merging strips into single image");
                            String string23 = string3 + "_" + n + string4;
                            slf4jlogger.info("outputFileName={}", string23);
                            n6 = n + 1;
                            this.convertTIFFPixelsToDicomSingleFrameMergingStrips(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string23, n6, l, l2, lArray3, lArray4, l, l12, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, "1.2.840.10008.1.2.1", string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, sequenceAttribute, string11, string12, bl8, string16);
                        } else {
                            slf4jlogger.debug("Not merging strips or was only one strip anyway - each becomes single frame or image");
                            if (bl12) {
                                String string24 = string3 + "_" + n + string4;
                                slf4jlogger.info("outputFileName={}", string24);
                                n6 = n + 1;
                                this.convertTIFFPixelsToDicomMultiFrame(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string24, n6, l, l2, lArray3, lArray4, l, l12, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, string7, string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, bl4, sequenceAttribute, string11, string12, bl8, string16, bl9, bl10);
                            } else {
                                for (int i = 0; i < n7; ++i) {
                                    String string25 = string3 + "_" + n + "_" + i + string4;
                                    slf4jlogger.info("outputFileName={}", string25);
                                    int n8 = (n + 1) * 100000 + (i + 1);
                                    this.convertTIFFPixelsToDicomSingleFrame(string, (UIDMap)object2, tIFFImageFileDirectories.getFile(), n, string25, n8, l, l2, lArray3[i], lArray4[i], l, l12, l3, l4, byArray3, byArray2, l5, l6, l7, l8, l11, (String)object3, d5, d6, d4, d7, d8, string18, string19, attributeList2, d9, d10, string5, string6, string7, string13, string14, string15, stringArray2[n][0], stringArray2[n][1], string17, attributeList, bl, bl2, bl3, sequenceAttribute, string11, string12, bl8, string16);
                                }
                            }
                        }
                        break block47;
                    }
                    throw new TIFFException("Unsupported encoding");
                }
                catch (Exception exception) {
                    slf4jlogger.error("Failed to construct DICOM image: ", exception);
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = true;
            boolean bl8 = true;
            boolean bl9 = false;
            boolean bl10 = true;
            String string2 = ".dcm";
            String string3 = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            String string4 = null;
            int n = 3;
            int n2 = 6;
            int n3 = stringArray.length;
            boolean bl11 = false;
            if (n3 < n) {
                bl11 = true;
            }
            boolean bl12 = true;
            block56: while (bl12 && n3 > n) {
                switch (string = stringArray[n3 - 1].trim().toUpperCase()) {
                    case "ADDTIFF": {
                        bl = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTADDTIFF": {
                        bl = false;
                        --n3;
                        continue block56;
                    }
                    case "USEBIGTIFF": {
                        bl2 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTUSEBIGTIFF": {
                        bl2 = false;
                        --n3;
                        continue block56;
                    }
                    case "ADDEXTENDEDOFFSETTABLE": {
                        bl3 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTADDEXTENDEDOFFSETTABLE": {
                        bl3 = false;
                        --n3;
                        continue block56;
                    }
                    case "ADDBASICOFFSETTABLE": {
                        bl4 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTADDBASICOFFSETTABLE": {
                        bl4 = false;
                        --n3;
                        continue block56;
                    }
                    case "ALWAYSWSI": {
                        bl5 = true;
                        --n3;
                        continue block56;
                    }
                    case "NOTALWAYSWSI": {
                        bl5 = false;
                        --n3;
                        continue block56;
                    }
                    case "ADDPYRAMID": {
                        bl6 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTADDPYRAMID": {
                        bl6 = false;
                        --n3;
                        continue block56;
                    }
                    case "MERGESTRIPS": {
                        bl7 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTMERGESTRIPS": {
                        bl7 = false;
                        --n3;
                        continue block56;
                    }
                    case "AUTORECOGNIZE": {
                        bl8 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTAUTORECOGNIZE": {
                        bl8 = false;
                        --n3;
                        continue block56;
                    }
                    case "ADDDCMSUFFIX": {
                        string2 = ".dcm";
                        --n3;
                        continue block56;
                    }
                    case "DONOTADDDCMSUFFIX": {
                        string2 = "";
                        --n3;
                        continue block56;
                    }
                    case "INCLUDEFILENAME": {
                        bl9 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTINCLUDEFILENAME": {
                        bl9 = false;
                        --n3;
                        continue block56;
                    }
                    case "INCLUDEIMAGEDESCRIPTION": {
                        bl10 = true;
                        --n3;
                        continue block56;
                    }
                    case "DONOTINCLUDEIMAGEDESCRIPTION": {
                        bl10 = false;
                        --n3;
                        continue block56;
                    }
                }
                if (stringArray[n3 - 2].trim().toUpperCase().equals("CHANNELFILE")) {
                    string3 = stringArray[n3 - 1];
                    n3 -= 2;
                    continue;
                }
                if (stringArray[n3 - 2].trim().toUpperCase().equals("SPACINGMM")) {
                    try {
                        d2 = d = Double.parseDouble(stringArray[n3 - 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("Spacing value is invalid", numberFormatException);
                    }
                    n3 -= 2;
                    continue;
                }
                if (stringArray[n3 - 3].trim().toUpperCase().equals("SPACINGROWCOLMM")) {
                    try {
                        d2 = Double.parseDouble(stringArray[n3 - 2]);
                        d = Double.parseDouble(stringArray[n3 - 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("Spacing value is invalid", numberFormatException);
                    }
                    n3 -= 3;
                    continue;
                }
                if (stringArray[n3 - 2].trim().toUpperCase().equals("THICKNESSMM")) {
                    try {
                        d3 = Double.parseDouble(stringArray[n3 - 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("Thickness value is invalid", numberFormatException);
                    }
                    n3 -= 2;
                    continue;
                }
                if (stringArray[n3 - 2].trim().toUpperCase().equals("UIDFILE")) {
                    string4 = stringArray[n3 - 1];
                    n3 -= 2;
                    continue;
                }
                if (n3 > n2) {
                    slf4jlogger.error("Unrecognized argument {}", string);
                    bl11 = true;
                    bl12 = false;
                    continue;
                }
                bl12 = false;
            }
            if (!bl11) {
                string = stringArray[0];
                String string5 = stringArray[1];
                String string6 = stringArray[2];
                String string7 = null;
                String string8 = null;
                String string9 = null;
                if (n3 >= 4) {
                    string7 = stringArray[3];
                }
                if (n3 >= 5) {
                    string8 = stringArray[4];
                }
                if (n3 >= 6) {
                    string9 = stringArray[5];
                }
                slf4jlogger.debug("modality = {}", string7);
                slf4jlogger.debug("sopClass = {}", string8);
                slf4jlogger.debug("transferSyntax = {}", string9);
                slf4jlogger.debug("channelFileName = {}", string3);
                slf4jlogger.debug("spacingrowmm = {}", d2);
                slf4jlogger.debug("spacingcolmm = {}", d);
                slf4jlogger.debug("thicknessmm = {}", d3);
                slf4jlogger.debug("uidFileName = {}", string4);
                new TIFFToDicom(string, string5, string6, string2, string7, string8, string9, bl, bl2, bl5, bl6, bl7, bl8, string3, bl9, d2, d, d3, bl10, string4, bl3, bl4);
            } else {
                System.err.println("Error: Incorrect number of arguments or bad arguments");
                System.err.println("Usage: TIFFToDicom jsonfile inputFile outputFilePrefix [modality [SOPClass [TransferSyntax]]] [ADDTIFF|DONOTADDTIFF] [USEBIGTIFF|DONOTUSEBIGTIFF] [ADDEXTENDEDOFFSETTABLE|DONOTADDEXTENDEDOFFSETTABLE] [ADDBASICOFFSETTABLE|DONOTADDBASICOFFSETTABLE] [ALWAYSWSI|NOTALWAYSWSI] [ADDPYRAMID|DONOTADDPYRAMID] [MERGESTRIPS|SPLITSTRIPS] [AUTORECOGNIZE|DONOTAUTORECOGNIZE] [ADDDCMSUFFIX|DONOTADDDCMSUFFIX] [INCLUDEFILENAME|DONOTINCLUDEFILENAME] [INCLUDEIMAGEDESCRIPTION|DONOTINCLUDEIMAGEDESCRIPTION] [CHANNELFILE channelfile] [SPACINGMM spacingmm] [SPACINGROWCOLMM spacingrowmm(y) spacingcolmm(x)] [THICKNESSMM thickness] [UIDFILE uidfile]");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class WSIFrameOfReference {
        String uidPyramid;
        String uidOverview;
        String uidLabel;
        int dirNumOfOverview;
        int dirNumOfLabel;
        double mmPerPixelXBaseLayerDefault;
        double mmPerPixelYBaseLayerDefault;
        double mmPerPixelXBaseLayer;
        double mmPerPixelYBaseLayer;
        double mmPerPixelOverviewImage;
        double[] mmPerPixelX;
        double[] mmPerPixelY;
        double objectiveLensPower;
        double objectiveLensNumericalAperture;
        double xOffsetInSlideCoordinateSystemPyramid;
        double yOffsetInSlideCoordinateSystemPyramid;
        double xOffsetInSlideCoordinateSystemOverview;
        double yOffsetInSlideCoordinateSystemOverview;
        String[] channelID;
        String[] channelName;
        SortedMap<String, String> channelNamesByChannelID;
        double sliceThickness;
        int numberOfChannels;
        int numberOfZSections;
        int numberOfTimepoints;
        int[] channelForIFD;
        int[] zSectionForIFD;
        int[] timepointForIFD;

        double getmmPerPixelXForIFD(int n) {
            return this.mmPerPixelX[n];
        }

        double getmmPerPixelYForIFD(int n) {
            return this.mmPerPixelY[n];
        }

        double getObjectiveLensPower() {
            return this.objectiveLensPower;
        }

        double getObjectiveLensNumericalAperture() {
            return this.objectiveLensNumericalAperture;
        }

        double getSliceThickness() {
            return this.sliceThickness;
        }

        double getXOffsetInSlideCoordinateSystemForIFD(int n) {
            return this.dirNumOfOverview != -1 && this.dirNumOfOverview == n ? this.xOffsetInSlideCoordinateSystemOverview : this.xOffsetInSlideCoordinateSystemPyramid;
        }

        double getYOffsetInSlideCoordinateSystemForIFD(int n) {
            return this.dirNumOfOverview != -1 && this.dirNumOfOverview == n ? this.yOffsetInSlideCoordinateSystemOverview : this.yOffsetInSlideCoordinateSystemPyramid;
        }

        String getFrameOfReferenceUIDForIFD(int n) {
            String string = this.uidPyramid;
            if (this.dirNumOfOverview != -1 && this.dirNumOfOverview == n) {
                slf4jlogger.debug("getFrameOfReferenceUIDForIFD(): dirNum {} is dirNumOfOverview", n);
                string = this.uidOverview;
            } else if (this.dirNumOfLabel != -1 && this.dirNumOfLabel == n) {
                slf4jlogger.debug("getFrameOfReferenceUIDForIFD(): dirNum {} is dirNumOfLabel", n);
                string = this.uidLabel;
            }
            slf4jlogger.debug("getFrameOfReferenceUIDForIFD(): For dirnum {} using UID={}", n, string);
            return string;
        }

        String getChannelIDForChannel(int n) {
            return this.channelID == null || n >= this.channelID.length ? null : this.channelID[n];
        }

        String getChannelNameForChannel(int n) {
            return this.channelName == null || n >= this.channelName.length ? null : this.channelName[n];
        }

        int getNumberOfChannels() {
            return this.numberOfChannels;
        }

        int getNumberOfZSections() {
            return this.numberOfZSections;
        }

        int getNumberOfTimepoints() {
            return this.numberOfTimepoints;
        }

        int getChannelForIFD(int n) {
            return this.channelForIFD == null ? -1 : this.channelForIFD[n];
        }

        int getZSectionForIFD(int n) {
            return this.zSectionForIFD == null ? -1 : this.zSectionForIFD[n];
        }

        int getTimepointForIFD(int n) {
            return this.timepointForIFD == null ? -1 : this.timepointForIFD[n];
        }

        SortedMap<String, String> getChannelNamesByChannelID() {
            if (this.channelNamesByChannelID == null && this.channelID != null && this.channelName != null) {
                this.channelNamesByChannelID = new TreeMap<String, String>();
                for (int i = 0; i < this.channelID.length; ++i) {
                    String string = this.channelID[i];
                    String string2 = this.channelName[i];
                    this.channelNamesByChannelID.put(string, string2);
                }
            }
            return this.channelNamesByChannelID;
        }

        WSIFrameOfReference(ArrayList<TIFFImageFileDirectory> arrayList, String[][] stringArray, double d, double d2, double d3) throws DicomException {
            this.uidPyramid = TIFFToDicom.this.u.getAnotherNewUID();
            this.uidLabel = TIFFToDicom.this.u.getAnotherNewUID();
            this.dirNumOfOverview = -1;
            this.dirNumOfLabel = -1;
            this.sliceThickness = d3;
            slf4jlogger.debug("WSIFrameOfReference(): sliceThickness (set to externally supplied thickness)={}", this.sliceThickness);
            if (d2 > 0.0 && d > 0.0) {
                this.mmPerPixelXBaseLayerDefault = d2;
                this.mmPerPixelYBaseLayerDefault = d;
                slf4jlogger.debug("WSIFrameOfReference(): mmPerPixelXBaseLayerDefault (set to externally supplied spacing)={}", this.mmPerPixelXBaseLayerDefault);
                slf4jlogger.debug("WSIFrameOfReference(): mmPerPixelYBaseLayerDefault (set to externally supplied spacing)={}", this.mmPerPixelYBaseLayerDefault);
            } else {
                this.mmPerPixelYBaseLayerDefault = this.mmPerPixelXBaseLayerDefault = 5.0E-4;
                slf4jlogger.debug("WSIFrameOfReference(): mmPerPixelXBaseLayerDefault (assuming 20x)={}", this.mmPerPixelXBaseLayerDefault);
                slf4jlogger.debug("WSIFrameOfReference(): mmPerPixelYBaseLayerDefault (assuming 20x)={}", this.mmPerPixelYBaseLayerDefault);
            }
            this.mmPerPixelXBaseLayer = 0.0;
            this.mmPerPixelYBaseLayer = 0.0;
            this.mmPerPixelX = new double[arrayList.size()];
            this.mmPerPixelY = new double[arrayList.size()];
            this.objectiveLensPower = 0.0;
            this.objectiveLensNumericalAperture = 0.0;
            this.numberOfChannels = 1;
            this.numberOfZSections = 1;
            this.numberOfTimepoints = 1;
            this.channelForIFD = null;
            this.zSectionForIFD = null;
            this.timepointForIFD = null;
            this.channelName = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            double d4 = 0.0;
            double d5 = 0.0;
            int n = arrayList.size();
            int n2 = 0;
            for (TIFFImageFileDirectory tIFFImageFileDirectory : arrayList) {
                slf4jlogger.debug("WSIFrameOfReference(): Directory={}", n2);
                if (stringArray[n2][0].equals("OVERVIEW")) {
                    bl4 = true;
                }
                slf4jlogger.debug("WSIFrameOfReference(): haveOverview already determined from imageFlavorAndDerivation = {}", bl4);
                boolean bl5 = tIFFImageFileDirectory.getSingleNumericValue(254, 0, 0L) == 1L;
                slf4jlogger.debug("WSIFrameOfReference(): based on Subfile Type: reduced-resolution image, downsampled = {}", bl5);
                String[] stringArray2 = tIFFImageFileDirectory.getStringValues(270);
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                if (stringArray2 != null && stringArray2.length > 0) {
                    slf4jlogger.trace("WSIFrameOfReference(): description.length = {}", stringArray2.length);
                    for (String string : stringArray2) {
                        Object object;
                        String string2;
                        Object object2;
                        Object object3;
                        Object object4;
                        slf4jlogger.trace("WSIFrameOfReference(): String = {}", string);
                        if (string.contains("thumbnail")) {
                            bl5 = true;
                            slf4jlogger.debug("WSIFrameOfReference(): setting downsampled indicator since Sunny thumbnail = {}", bl5);
                        }
                        if (string.contains("<DataObject ObjectType=\"DPUfsImport\"")) {
                            slf4jlogger.debug("WSIFrameOfReference(): Parsing DPUfsImport XML metadata");
                            try {
                                object4 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
                                object3 = XPathFactory.newInstance();
                                object2 = (NodeList)((XPathFactory)object3).newXPath().evaluate("//DataObject[@ObjectType='PixelDataRepresentation']", object4, XPathConstants.NODESET);
                                slf4jlogger.debug("WSIFrameOfReference(): have pixelDataRepresentationDataObject length = {}", object2.getLength());
                                if (object2.getLength() <= 0) continue;
                                for (int i = 0; i < object2.getLength(); ++i) {
                                    String string3 = ((XPathFactory)object3).newXPath().evaluate("Attribute[@Name='PIIM_PIXEL_DATA_REPRESENTATION_NUMBER']", object2.item(i));
                                    slf4jlogger.debug("WSIFrameOfReference(): pixelDataRepresentationNumber() = {}", string3);
                                    if (string3 != null && string3.length() > 0) {
                                        try {
                                            int n3 = Integer.parseInt(string3);
                                            slf4jlogger.debug("WSIFrameOfReference(): indexIntoIFD {}", n3);
                                            string2 = ((XPathFactory)object3).newXPath().evaluate("Attribute[@Name='DICOM_PIXEL_SPACING']", object2.item(i));
                                            slf4jlogger.debug("WSIFrameOfReference(): dicomPixelSpacing() = {}", string2);
                                            object = string2.split("[ ]+");
                                            if (object == null || ((String[])object).length != 2) continue;
                                            try {
                                                this.mmPerPixelX[n3] = Double.parseDouble(object[1].replaceAll("\"", ""));
                                                slf4jlogger.debug("WSIFrameOfReference(): set mmPerPixelX[{}}] to {}", n3, this.mmPerPixelX[n3]);
                                                this.mmPerPixelY[n3] = Double.parseDouble(object[0].replaceAll("\"", ""));
                                                slf4jlogger.debug("WSIFrameOfReference(): set mmPerPixelY[{}}] to {}", n3, this.mmPerPixelY[n3]);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                slf4jlogger.error("Failed to parse dicomPixelSpacingArray to double ", numberFormatException);
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            slf4jlogger.error("Failed to parse pixelDataRepresentationNumber to int for indexIntoIFD ", numberFormatException);
                                        }
                                        continue;
                                    }
                                    slf4jlogger.debug("WSIFrameOfReference(): Missing PIIM_PIXEL_DATA_REPRESENTATION_NUMBER in DPUfsImport XML");
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                slf4jlogger.error("Failed to parse DPUfsImport XML metadata in ImageDescription ", exception);
                                continue;
                            }
                        }
                        if (string.contains("<OME")) {
                            slf4jlogger.debug("WSIFrameOfReference(): Parsing OME-TIFF XML metadata");
                            try {
                                object4 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
                                object3 = XPathFactory.newInstance();
                                object2 = ((XPathFactory)object3).newXPath().evaluate("/OME/Image/Pixels/@DimensionOrder", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found dimensionOrder {}", object2);
                                String string4 = ((XPathFactory)object3).newXPath().evaluate("/OME/Image/Pixels/@SizeC", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found sizeC {}", string4);
                                if (string4 != null && string4.length() > 0) {
                                    try {
                                        this.numberOfChannels = Integer.parseInt(string4);
                                        slf4jlogger.debug("WSIFrameOfReference(): found numberOfChannels {}", this.numberOfChannels);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        slf4jlogger.error("Failed to parse sizeC to int ", numberFormatException);
                                    }
                                }
                                string4 = ((XPathFactory)object3).newXPath().evaluate("/OME/Image/Pixels/@SizeT", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found sizeT {}", string4);
                                if (string4 != null && string4.length() > 0) {
                                    try {
                                        this.numberOfTimepoints = Integer.parseInt(string4);
                                        slf4jlogger.debug("WSIFrameOfReference(): found numberOfTimepoints {}", this.numberOfTimepoints);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        slf4jlogger.error("Failed to parse sizeT to int ", numberFormatException);
                                    }
                                }
                                string4 = ((XPathFactory)object3).newXPath().evaluate("/OME/Image/Pixels/@SizeZ", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found sizeZ {}", string4);
                                if (string4 != null && string4.length() > 0) {
                                    try {
                                        this.numberOfZSections = Integer.parseInt(string4);
                                        slf4jlogger.debug("WSIFrameOfReference(): found numberOfZSections {}", this.numberOfZSections);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        slf4jlogger.error("Failed to parse sizeZ to int ", numberFormatException);
                                    }
                                }
                                if (object2 != null) {
                                    try {
                                        if (((String)object2).length() == 5 && ((String)object2).startsWith("XY")) {
                                            char c = ((String)object2).charAt(2);
                                            char c2 = ((String)object2).charAt(3);
                                            char c3 = ((String)object2).charAt(4);
                                            this.channelForIFD = new int[n];
                                            this.zSectionForIFD = new int[n];
                                            this.timepointForIFD = new int[n];
                                            int n4 = 0;
                                            object = null;
                                            switch (c) {
                                                case 'C': {
                                                    object = this.channelForIFD;
                                                    n4 = this.numberOfChannels;
                                                    break;
                                                }
                                                case 'Z': {
                                                    object = this.zSectionForIFD;
                                                    n4 = this.numberOfZSections;
                                                    break;
                                                }
                                                case 'T': {
                                                    object = this.timepointForIFD;
                                                    n4 = this.numberOfTimepoints;
                                                    break;
                                                }
                                                default: {
                                                    slf4jlogger.error("Unrecognized character {} in DimensionOrder {}", Character.valueOf(c), object2);
                                                }
                                            }
                                            int n5 = 0;
                                            int[] nArray = null;
                                            switch (c2) {
                                                case 'C': {
                                                    nArray = this.channelForIFD;
                                                    n5 = this.numberOfChannels;
                                                    break;
                                                }
                                                case 'Z': {
                                                    nArray = this.zSectionForIFD;
                                                    n5 = this.numberOfZSections;
                                                    break;
                                                }
                                                case 'T': {
                                                    nArray = this.timepointForIFD;
                                                    n5 = this.numberOfTimepoints;
                                                    break;
                                                }
                                                default: {
                                                    slf4jlogger.error("Unrecognized character {} in DimensionOrder {}", Character.valueOf(c2), object2);
                                                }
                                            }
                                            int n6 = 0;
                                            int[] nArray2 = null;
                                            switch (c3) {
                                                case 'C': {
                                                    nArray2 = this.channelForIFD;
                                                    n6 = this.numberOfChannels;
                                                    break;
                                                }
                                                case 'Z': {
                                                    nArray2 = this.zSectionForIFD;
                                                    n6 = this.numberOfZSections;
                                                    break;
                                                }
                                                case 'T': {
                                                    nArray2 = this.timepointForIFD;
                                                    n6 = this.numberOfTimepoints;
                                                    break;
                                                }
                                                default: {
                                                    slf4jlogger.error("Unrecognized character {} in DimensionOrder {}", Character.valueOf(c3), object2);
                                                }
                                            }
                                            if (object != null && nArray != null && nArray2 != null) {
                                                int n7 = this.numberOfChannels * this.numberOfZSections * this.numberOfTimepoints;
                                                if (n >= n7) {
                                                    int n8 = 0;
                                                    for (int i = 0; i < n6; ++i) {
                                                        for (int j = 0; j < n5; ++j) {
                                                            for (int k = 0; k < n4; ++k) {
                                                                long[] lArray;
                                                                object[n8] = (String)k;
                                                                nArray[n8] = j;
                                                                nArray2[n8] = i;
                                                                TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = tIFFImageFileDirectory.getEntry(330);
                                                                if (tIFFImageFileDirectoryEntry == null || tIFFImageFileDirectoryEntry.getNumberOfValues() == 0L) {
                                                                    ++n8;
                                                                    continue;
                                                                }
                                                                for (long l5 : lArray = tIFFImageFileDirectoryEntry.getValues().getNumericValues()) {
                                                                    object[++n8] = (String)k;
                                                                    nArray[n8] = j;
                                                                    nArray2[n8] = i;
                                                                }
                                                                ++n8;
                                                            }
                                                        }
                                                    }
                                                    if (slf4jlogger.isDebugEnabled()) {
                                                        for (n8 = 0; n8 < n; ++n8) {
                                                            slf4jlogger.debug("IFD {} Z{}-T{}-C{}", n8, this.zSectionForIFD[n8], this.timepointForIFD[n8], this.channelForIFD[n8]);
                                                        }
                                                    }
                                                } else {
                                                    slf4jlogger.error("Number of IFDs {} does not match or exceed planeCount {} calculated from SizeC, SizeZ and SizeT", n, n7);
                                                    this.channelForIFD = null;
                                                    this.zSectionForIFD = null;
                                                    this.timepointForIFD = null;
                                                }
                                            }
                                        } else {
                                            slf4jlogger.error("DimensionOrder {} is not supported", object2);
                                        }
                                    }
                                    catch (Exception exception) {
                                        slf4jlogger.error("Failed to process DimensionOrder", exception);
                                    }
                                }
                                Object object5 = ((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/@PhysicalSizeX", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found physicalSizeX {}", object5);
                                String string5 = ((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/@PhysicalSizeY", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found PhysicalSizeY {}", string5);
                                Object object6 = ((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/@PhysicalSizeXUnit", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found PhysicalSizeXUnit {}", object6);
                                string2 = ((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/@PhysicalSizeYUnit", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found PhysicalSizeYUnit {}", string2);
                                if (((String)object5).length() > 0 && string5.equals(object5) && ((String)object6).equals("\u00b5m")) {
                                    d6 = Double.parseDouble((String)object5);
                                    slf4jlogger.debug("WSIFrameOfReference(): set micronsPerPixelX to {}", d6);
                                    d7 = Double.parseDouble(string5);
                                    slf4jlogger.debug("WSIFrameOfReference(): set micronsPerPixelY to {}", d7);
                                } else {
                                    slf4jlogger.debug("WSIFrameOfReference(): OME/Image/Pixels PhysicalSizeX,Y attributes not as expected, not used");
                                }
                                object5 = ((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/@PhysicalSizeZ", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found physicalSizeZ {}", object5);
                                string5 = ((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/@PhysicalSizeZUnit", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found PhysicalSizeZUnit {}", string5);
                                if (((String)object5).length() > 0 && string5.equals("\u00b5m")) {
                                    this.sliceThickness = Double.parseDouble((String)object5) / 1000.0;
                                    slf4jlogger.debug("WSIFrameOfReference(): set sliceThickness to {}", this.sliceThickness);
                                } else {
                                    slf4jlogger.debug("WSIFrameOfReference(): OME/Image/Pixels PhysicalSizeZ attributes not as expected, not used");
                                }
                                object5 = ((XPathFactory)object3).newXPath().evaluate("OME/Instrument/Objective/@NominalMagnification", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found nominalMagnification {}", object5);
                                if (((String)object5).length() > 0) {
                                    this.objectiveLensPower = Double.parseDouble((String)object5);
                                }
                                object5 = ((XPathFactory)object3).newXPath().evaluate("OME/Instrument/Objective/@LensNA", object4);
                                slf4jlogger.debug("WSIFrameOfReference(): found lensNA {}", object5);
                                if (((String)object5).length() > 0) {
                                    this.objectiveLensNumericalAperture = Double.parseDouble((String)object5);
                                }
                                if ((object5 = (NodeList)((XPathFactory)object3).newXPath().evaluate("OME/Image/Pixels/Channel", object4, XPathConstants.NODESET)).getLength() == this.numberOfChannels) {
                                    this.channelID = new String[this.numberOfChannels];
                                    this.channelName = new String[this.numberOfChannels];
                                    for (int i = 0; i < object5.getLength(); ++i) {
                                        object6 = object5.item(i);
                                        string2 = ((XPathFactory)object3).newXPath().evaluate("@ID", object6);
                                        this.channelID[i] = string2 == null ? null : string2.replace("Channel:0:", "");
                                        slf4jlogger.debug("WSIFrameOfReference(): for channelNumber {} found channelID {} will actually use {}", i, string2, this.channelID[i]);
                                        this.channelName[i] = ((XPathFactory)object3).newXPath().evaluate("@Name", object6);
                                        slf4jlogger.debug("WSIFrameOfReference(): for channelNumber {} found Channel Name {}", i, this.channelName[i]);
                                    }
                                } else {
                                    slf4jlogger.error("WSIFrameOfReference(): number of channels in OME-TIFF XML metadata {} does not match numberOfChannels {}", object5.getLength(), this.numberOfChannels);
                                }
                                object5 = (NodeList)((XPathFactory)object3).newXPath().evaluate("//OriginalMetadata", object4, XPathConstants.NODESET);
                                if (object5 != null && object5.getLength() > 0) {
                                    for (int i = 0; i < object5.getLength(); ++i) {
                                        object6 = object5.item(i);
                                        string2 = ((XPathFactory)object3).newXPath().evaluate("Key", object6);
                                        object = ((XPathFactory)object3).newXPath().evaluate("Value", object6);
                                        if (string2 != null && string2.length() > 0 && object != null && ((String)object).length() > 0) {
                                            slf4jlogger.trace("WSIFrameOfReference(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Key {} Value {}", string2, object);
                                            if (string2.matches("^Series [0-9]+ Left$")) {
                                                slf4jlogger.debug("WSIFrameOfReference(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Left {}", object);
                                                try {
                                                    d4 = Double.parseDouble((String)object);
                                                    slf4jlogger.debug("WSIFrameOfReference(): found Left {}", d4);
                                                    bl2 = true;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    slf4jlogger.error("Failed to parse Left to double ", numberFormatException);
                                                }
                                                continue;
                                            }
                                            if (!string2.matches("^Series [0-9]+ Top$")) continue;
                                            slf4jlogger.debug("WSIFrameOfReference(): Have OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata Top {}", object);
                                            try {
                                                d5 = Double.parseDouble((String)object);
                                                slf4jlogger.debug("WSIFrameOfReference(): found Top {}", d5);
                                                bl = true;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                slf4jlogger.error("Failed to parse Top to double ", numberFormatException);
                                            }
                                            continue;
                                        }
                                        slf4jlogger.debug("WSIFrameOfReference(): Cannot find Key and Value for OME/StructuredAnnotations/XMLAnnotation/OriginalMetadata ", object6.toString());
                                    }
                                    continue;
                                }
                                slf4jlogger.debug("WSIFrameOfReference(): no OME-TIFF XML OriginalMetadata");
                            }
                            catch (Exception exception) {
                                slf4jlogger.error("Failed to parse OME-TIFF XML metadata in ImageDescription ", exception);
                            }
                            continue;
                        }
                        if (string.contains("Aperio")) {
                            if (string.contains("->")) {
                                bl5 = true;
                                slf4jlogger.debug("WSIFrameOfReference(): found Aperio downsampled indicator = {}", bl5);
                            }
                            slf4jlogger.debug("WSIFrameOfReference(): downsampled = {}", bl5);
                            try {
                                object4 = new BufferedReader(new StringReader(string));
                                object3 = null;
                                while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                                    int n9;
                                    object2 = Pattern.compile(".*[|]MPP[ ]*=[ ]*([0-9][0-9]*[.][0-9][0-9]*)([|].*|$)");
                                    Matcher matcher = ((Pattern)object2).matcher((CharSequence)object3);
                                    if (matcher.matches()) {
                                        slf4jlogger.debug("WSIFrameOfReference(): have MPP match");
                                        n9 = matcher.groupCount();
                                        if (n9 > 1) {
                                            slf4jlogger.debug("WSIFrameOfReference(): have MPP correct groupCount");
                                            try {
                                                double d9 = Double.parseDouble(matcher.group(1));
                                                if (d9 > 0.0 && (d6 == 0.0 || d9 < d6)) {
                                                    d7 = d6 = d9;
                                                    slf4jlogger.debug("WSIFrameOfReference(): found micronsPerPixel (MPP) {}", d6);
                                                } else {
                                                    slf4jlogger.warn("WSIFrameOfReference(): ignoring micronsPerPixel (MPP) {} since already have {}", d9, d6);
                                                }
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                slf4jlogger.error("Failed to parse MPP to double ", numberFormatException);
                                            }
                                        }
                                    }
                                    if ((matcher = ((Pattern)(object2 = Pattern.compile(".*[|]AppMag[ ]*=[ ]*([0-9.][0-9.]*)([|].*|$)"))).matcher((CharSequence)object3)).matches()) {
                                        slf4jlogger.debug("WSIFrameOfReference(): have AppMag match");
                                        n9 = matcher.groupCount();
                                        if (n9 > 1) {
                                            slf4jlogger.debug("WSIFrameOfReference(): have AppMag correct groupCount");
                                            try {
                                                double d10 = Double.parseDouble(matcher.group(1));
                                                if (d10 > 0.0 && (this.objectiveLensPower == 0.0 || d10 >= this.objectiveLensPower)) {
                                                    this.objectiveLensPower = d10;
                                                    slf4jlogger.debug("WSIFrameOfReference(): found objectiveLensPower (AppMag) {}", this.objectiveLensPower);
                                                } else {
                                                    slf4jlogger.warn("WSIFrameOfReference(): ignoring objectiveLensPower (AppMag) {} since already have {}", d10, this.objectiveLensPower);
                                                    if (d10 > 0.0 && this.objectiveLensPower > 0.0) {
                                                        slf4jlogger.warn("WSIFrameOfReference(): setting downsampled flag since lower AppMag {} encountered than earlier {}", d10, this.objectiveLensPower);
                                                        bl5 = true;
                                                    }
                                                }
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                slf4jlogger.error("Failed to parse AppMag to double ", numberFormatException);
                                            }
                                        }
                                    }
                                    if ((matcher = ((Pattern)(object2 = Pattern.compile(".*[|]Left[ ]*=[ ]*([0-9.][0-9.]*)([|].*|$)"))).matcher((CharSequence)object3)).matches()) {
                                        slf4jlogger.debug("WSIFrameOfReference(): have Left match");
                                        n9 = matcher.groupCount();
                                        if (n9 > 1) {
                                            slf4jlogger.debug("WSIFrameOfReference(): have Left correct groupCount");
                                            try {
                                                d4 = Double.parseDouble(matcher.group(1));
                                                slf4jlogger.debug("WSIFrameOfReference(): found Left {}", d4);
                                                bl2 = true;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                slf4jlogger.error("Failed to parse Left to double ", numberFormatException);
                                            }
                                        }
                                    }
                                    if (!(matcher = ((Pattern)(object2 = Pattern.compile(".*[|]Top[ ]*=[ ]*([0-9.][0-9.]*)([|].*|$)"))).matcher((CharSequence)object3)).matches()) continue;
                                    slf4jlogger.debug("WSIFrameOfReference(): have Top match");
                                    n9 = matcher.groupCount();
                                    if (n9 <= 1) continue;
                                    slf4jlogger.debug("WSIFrameOfReference(): have Top correct groupCount");
                                    try {
                                        d5 = Double.parseDouble(matcher.group(1));
                                        slf4jlogger.debug("WSIFrameOfReference(): found Top {}", d5);
                                        bl = true;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        slf4jlogger.error("Failed to parse Top to double ", numberFormatException);
                                    }
                                }
                                continue;
                            }
                            catch (IOException iOException) {
                                slf4jlogger.error("Failed to parse ImageDescription ", iOException);
                                continue;
                            }
                        }
                        if (!string.contains("X scan size")) continue;
                        try {
                            object4 = new BufferedReader(new StringReader(string));
                            object3 = null;
                            while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                                int n10;
                                object2 = Pattern.compile(".*Resolution[ ]*[(]um[)][ ]*=[ ]*([0-9][0-9]*[.][0-9][0-9]*).*");
                                Matcher matcher = ((Pattern)object2).matcher((CharSequence)object3);
                                if (matcher.matches()) {
                                    slf4jlogger.debug("WSIFrameOfReference(): have Resolution (um) match");
                                    n10 = matcher.groupCount();
                                    if (n10 == 1) {
                                        slf4jlogger.debug("WSIFrameOfReference(): have Resolution (um) correct groupCount");
                                        try {
                                            d7 = d6 = Double.parseDouble(matcher.group(1));
                                            slf4jlogger.debug("WSIFrameOfReference(): found Resolution (um) {}", d6);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            slf4jlogger.error("Failed to parse Resolution to double ", numberFormatException);
                                        }
                                    }
                                }
                                if ((matcher = ((Pattern)(object2 = Pattern.compile(".*X offset[ ]*=[ ]*([0-9][0-9]*[.][0-9][0-9]*)[ ]*mm.*"))).matcher((CharSequence)object3)).matches()) {
                                    slf4jlogger.debug("WSIFrameOfReference(): have X offset match");
                                    n10 = matcher.groupCount();
                                    if (n10 == 1) {
                                        slf4jlogger.debug("WSIFrameOfReference(): have X offset correct groupCount");
                                        try {
                                            double d11 = Double.parseDouble(matcher.group(1));
                                            slf4jlogger.debug("WSIFrameOfReference(): found X offset (mm) {}", d11);
                                            this.yOffsetInSlideCoordinateSystemPyramid = d11;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            slf4jlogger.error("Failed to parse X offset to double ", numberFormatException);
                                        }
                                    }
                                }
                                if (!(matcher = ((Pattern)(object2 = Pattern.compile(".*Y offset[ ]*=[ ]*([0-9][0-9]*[.][0-9][0-9]*)[ ]*mm.*"))).matcher((CharSequence)object3)).matches()) continue;
                                slf4jlogger.debug("WSIFrameOfReference(): have Y offset match");
                                n10 = matcher.groupCount();
                                if (n10 != 1) continue;
                                slf4jlogger.debug("WSIFrameOfReference(): have Y offset correct groupCount");
                                try {
                                    double d12 = Double.parseDouble(matcher.group(1));
                                    slf4jlogger.debug("WSIFrameOfReference(): found Y offset (mm) {}", d12);
                                    this.xOffsetInSlideCoordinateSystemPyramid = d12;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    slf4jlogger.error("Failed to parse Y offset to double ", numberFormatException);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            slf4jlogger.error("Failed to parse ImageDescription ", iOException);
                        }
                    }
                    if (!bl5 && d6 != 0.0 && d7 != 0.0) {
                        this.mmPerPixelX[n2] = d6 / 1000.0;
                        this.mmPerPixelY[n2] = d7 / 1000.0;
                        slf4jlogger.debug("WSIFrameOfReference(): mmPerPixelX[{}] set to {} for non-downsampled layer", n2, this.mmPerPixelX[n2]);
                        slf4jlogger.debug("WSIFrameOfReference(): mmPerPixelY[{}] set to {} for non-downsampled layer", n2, this.mmPerPixelY[n2]);
                    }
                } else {
                    slf4jlogger.debug("WSIFrameOfReference(): no ImageDescription");
                }
                slf4jlogger.debug("mmPerPixelX[{}] extracted from descriptionList={}", n2, this.mmPerPixelX[n2]);
                slf4jlogger.debug("mmPerPixelY[{}] extracted from descriptionList={}", n2, this.mmPerPixelY[n2]);
                if (this.mmPerPixelX[n2] == 0.0 || this.mmPerPixelY[n2] == 0.0) {
                    slf4jlogger.debug("mmPerPixelX or Y is zero after parsing descriptionList");
                    d6 = tIFFImageFileDirectory.getSingleRationalValue(282, 0, 0.0);
                    slf4jlogger.debug("xResolution={}", d6);
                    d7 = tIFFImageFileDirectory.getSingleRationalValue(283, 0, 0.0);
                    slf4jlogger.debug("yResolution={}", d7);
                    if (d6 > 72.0 && d7 > 72.0) {
                        if (d6 != d7) {
                            slf4jlogger.warn("using non-square or uncalibrated X/YRESOLUTION for mmPerPixel");
                        }
                        long l6 = tIFFImageFileDirectory.getSingleNumericValue(296, 0, 2L);
                        slf4jlogger.debug("resolutionUnit={}", l6);
                        if (l6 == 2L || l6 == 3L) {
                            double d13 = (l6 == 2L ? 25.4 : 10.0) / d6;
                            double d14 = (l6 == 2L ? 25.4 : 10.0) / d7;
                            if (bl5) {
                                if (this.mmPerPixelXBaseLayer > 0.0 && this.mmPerPixelYBaseLayer > 0.0) {
                                    double d15 = d13 / this.mmPerPixelXBaseLayer;
                                    if (d15 > 1.001) {
                                        slf4jlogger.debug("downsampled and not the same as baselayer, so using value computed from XRESOLUTION for {} for mmPerPixelX", d13);
                                        slf4jlogger.debug("downsampled and not the same as baselayer, so using value computed from YRESOLUTION for {} for mmPerPixelY", d14);
                                        this.mmPerPixelX[n2] = d13;
                                        this.mmPerPixelY[n2] = d14;
                                    } else {
                                        slf4jlogger.debug("downsampled but value computed from XRESOLUTION for {} for mmPerPixelX is too close to value for baselayer {} and presumably wrong so ignoring", d13, this.mmPerPixelXBaseLayer);
                                        slf4jlogger.debug("downsampled but value computed from YRESOLUTION for {} for mmPerPixelY is too close to value for baselayer {} and presumably wrong so ignoring", d14, this.mmPerPixelYBaseLayer);
                                    }
                                } else {
                                    slf4jlogger.debug("downsampled but baselayer value not known, so using value computed from XRESOLUTION for {} for mmPerPixelX", d13);
                                    slf4jlogger.debug("downsampled but baselayer value not known, so using value computed from YRESOLUTION for {} for mmPerPixelY", d14);
                                    this.mmPerPixelX[n2] = d13;
                                    this.mmPerPixelY[n2] = d14;
                                }
                            } else {
                                slf4jlogger.debug("not downsampled so using value computed from XRESOLUTION for {} for mmPerPixelX", d13);
                                slf4jlogger.debug("not downsampled so using value computed from YRESOLUTION for {} for mmPerPixelY", d14);
                                this.mmPerPixelX[n2] = d13;
                                this.mmPerPixelY[n2] = d14;
                            }
                        } else if (l6 == 1L) {
                            slf4jlogger.debug("not using no meaningful RESOLUTIONUNIT for mmPerPixel");
                        } else {
                            slf4jlogger.debug("not using unrecognized RESOLUTIONUNIT {} for mmPerPixel", l6);
                        }
                    } else {
                        slf4jlogger.debug("not using missing or obviously invalid XRESOLUTION of {} for mmPerPixel", d6);
                        slf4jlogger.debug("not using missing or obviously invalid YRESOLUTION of {} for mmPerPixel", d7);
                    }
                    slf4jlogger.debug("mmPerPixel is {} after checking XRESOLUTION and RESOLUTIONUNIT", this.mmPerPixelX[n2]);
                    slf4jlogger.debug("mmPerPixel is {} after checking YRESOLUTION and RESOLUTIONUNIT", this.mmPerPixelY[n2]);
                }
                long l7 = tIFFImageFileDirectory.getSingleNumericValue(256, 0, 0L);
                slf4jlogger.debug("imageWidth={}", l7);
                long l8 = tIFFImageFileDirectory.getSingleNumericValue(257, 0, 0L);
                slf4jlogger.debug("imageLength={}", l8);
                TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = tIFFImageFileDirectory.getEntry(330);
                slf4jlogger.debug("subIFDOffsets is {}", tIFFImageFileDirectoryEntry == null ? "absent" : "present");
                if (n2 == 0) {
                    l2 = l7;
                    l = l7;
                }
                if (this.mmPerPixelX[n2] == 0.0 || this.mmPerPixelY[n2] == 0.0) {
                    slf4jlogger.debug("mmPerPixelX or Y is zero");
                    if (stringArray[n2][0].equals("LABEL")) {
                        slf4jlogger.debug("Setting mmPerPixel for label (LABEL) to zero");
                        this.mmPerPixelX[n2] = 0.0;
                        this.mmPerPixelY[n2] = 0.0;
                        this.dirNumOfLabel = n2;
                    } else if (stringArray[n2][0].equals("OVERVIEW")) {
                        slf4jlogger.debug("computing mmPerPixel for macro (OVERVIEW) from standard slide height");
                        this.mmPerPixelX[n2] = this.mmPerPixelOverviewImage = 25.4 / (double)l8;
                        this.mmPerPixelY[n2] = this.mmPerPixelOverviewImage;
                        this.dirNumOfOverview = n2;
                        bl3 = true;
                        l3 = l7;
                        l4 = l8;
                    } else if (bl5) {
                        slf4jlogger.debug("deriving mmPerPixelX from pixel width {} relative to base layer width {} and pixel spacing {}", l7, l2, this.mmPerPixelXBaseLayer);
                        double d16 = (double)l2 / (double)l7;
                        slf4jlogger.debug("scaleFactorX = {}", d16);
                        this.mmPerPixelX[n2] = this.mmPerPixelXBaseLayer * d16;
                        this.mmPerPixelY[n2] = this.mmPerPixelYBaseLayer * d16;
                    } else if (l7 == l && this.mmPerPixelX[0] != 0.0 && this.mmPerPixelY[0] != 0.0) {
                        slf4jlogger.debug("reusing first IFD {} mmPerPixelX, since not specified, not overview, not downsampled and same width in pixels", this.mmPerPixelX[0]);
                        slf4jlogger.debug("reusing first IFD {} mmPerPixelY, since not specified, not overview, not downsampled and same width in pixels", this.mmPerPixelY[0]);
                        this.mmPerPixelX[n2] = this.mmPerPixelX[0];
                        this.mmPerPixelY[n2] = this.mmPerPixelY[0];
                    } else {
                        slf4jlogger.debug("using default {} mmPerPixelX, since not specified, not overview and not downsampled", this.mmPerPixelXBaseLayerDefault);
                        slf4jlogger.debug("using default {} mmPerPixelY, since not specified, not overview and not downsampled", this.mmPerPixelYBaseLayerDefault);
                        this.mmPerPixelX[n2] = this.mmPerPixelXBaseLayerDefault;
                        this.mmPerPixelY[n2] = this.mmPerPixelYBaseLayerDefault;
                        this.mmPerPixelXBaseLayer = this.mmPerPixelX[n2];
                        this.mmPerPixelYBaseLayer = this.mmPerPixelY[n2];
                    }
                } else if (tIFFImageFileDirectoryEntry != null) {
                    this.mmPerPixelXBaseLayer = this.mmPerPixelX[n2];
                    this.mmPerPixelYBaseLayer = this.mmPerPixelY[n2];
                    slf4jlogger.debug("setting mmPerPixelXBaseLayer={} because has subIFDOffsets", this.mmPerPixelXBaseLayer);
                    slf4jlogger.debug("setting mmPerPixelYBaseLayer={} because has subIFDOffsets", this.mmPerPixelYBaseLayer);
                } else if (n2 == 0) {
                    this.mmPerPixelXBaseLayer = this.mmPerPixelX[n2];
                    this.mmPerPixelYBaseLayer = this.mmPerPixelY[n2];
                    slf4jlogger.debug("setting mmPerPixelXBaseLayer={} because is first IFD", this.mmPerPixelXBaseLayer);
                    slf4jlogger.debug("setting mmPerPixelYBaseLayer={} because is first IFD", this.mmPerPixelYBaseLayer);
                }
                slf4jlogger.debug("Using mmPerPixelX[{}]={}", n2, this.mmPerPixelX[n2]);
                slf4jlogger.debug("Using mmPerPixelY[{}]={}", n2, this.mmPerPixelY[n2]);
                slf4jlogger.debug("Using mmPerPixelXBaseLayer={}", this.mmPerPixelXBaseLayer);
                slf4jlogger.debug("Using mmPerPixelYBaseLayer={}", this.mmPerPixelYBaseLayer);
                ++n2;
            }
            slf4jlogger.debug("haveOverviewPixelSpacing={}", bl3);
            slf4jlogger.debug("haveOverviewRelativeLeft={}", bl2);
            slf4jlogger.debug("haveOverviewRelativeTop={}", bl);
            slf4jlogger.debug("xOffsetInSlideCoordinateSystemPyramid={}", this.xOffsetInSlideCoordinateSystemPyramid);
            slf4jlogger.debug("yOffsetInSlideCoordinateSystemPyramid={}", this.yOffsetInSlideCoordinateSystemPyramid);
            if ((bl3 || !bl4) && bl2 && bl) {
                slf4jlogger.debug("Establishing common frame of reference between OVERVIEW and pyramid");
                this.uidOverview = this.uidPyramid;
                this.xOffsetInSlideCoordinateSystemPyramid = d5;
                this.yOffsetInSlideCoordinateSystemPyramid = this.mmPerPixelOverviewImage * (double)l3 - d4;
                this.xOffsetInSlideCoordinateSystemOverview = this.mmPerPixelOverviewImage * (double)l4;
                this.yOffsetInSlideCoordinateSystemOverview = this.mmPerPixelOverviewImage * (double)l3;
            } else if (this.xOffsetInSlideCoordinateSystemPyramid != 0.0 || this.yOffsetInSlideCoordinateSystemPyramid != 0.0) {
                slf4jlogger.debug("Have explicit X and Y offsets for pyramid frame of reference");
                this.uidOverview = TIFFToDicom.this.u.getAnotherNewUID();
                this.xOffsetInSlideCoordinateSystemOverview = 0.0;
                this.yOffsetInSlideCoordinateSystemOverview = 0.0;
            } else {
                slf4jlogger.debug("Cannot establish common frame of reference between OVERVIEW and pyramid");
                this.uidOverview = TIFFToDicom.this.u.getAnotherNewUID();
                this.xOffsetInSlideCoordinateSystemPyramid = 0.0;
                this.yOffsetInSlideCoordinateSystemPyramid = 0.0;
                this.xOffsetInSlideCoordinateSystemOverview = 0.0;
                this.yOffsetInSlideCoordinateSystemOverview = 0.0;
            }
            slf4jlogger.debug("xOffsetInSlideCoordinateSystemPyramid={}", this.xOffsetInSlideCoordinateSystemPyramid);
            slf4jlogger.debug("yOffsetInSlideCoordinateSystemPyramid={}", this.yOffsetInSlideCoordinateSystemPyramid);
            slf4jlogger.debug("xOffsetInSlideCoordinateSystemOverview={}", this.xOffsetInSlideCoordinateSystemOverview);
            slf4jlogger.debug("yOffsetInSlideCoordinateSystemOverview={}", this.yOffsetInSlideCoordinateSystemOverview);
        }
    }

    public class BitBuffer {
        private int currentByte;
        private int currentBit;
        private byte[] byteBuffer;
        private int eofByte;
        private int[] backMask;
        private int[] frontMask;
        private boolean eofFlag;

        public BitBuffer(byte[] byArray) {
            this.byteBuffer = byArray;
            this.currentByte = 0;
            this.currentBit = 0;
            this.eofByte = byArray.length;
            this.backMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
            this.frontMask = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
        }

        public int getBits(int n) {
            if (n == 0) {
                return 0;
            }
            if (this.eofFlag) {
                return -1;
            }
            int n2 = 0;
            while (n != 0 && !this.eofFlag) {
                int n3;
                if (n >= 8 - this.currentBit) {
                    if (this.currentBit == 0) {
                        n2 <<= 8;
                        n3 = this.byteBuffer[this.currentByte];
                        n2 += n3 < 0 ? 256 + n3 : n3;
                        n -= 8;
                        ++this.currentByte;
                    } else {
                        n2 <<= 8 - this.currentBit;
                        n2 += this.byteBuffer[this.currentByte] & this.backMask[8 - this.currentBit];
                        n -= 8 - this.currentBit;
                        this.currentBit = 0;
                        ++this.currentByte;
                    }
                } else {
                    n2 <<= n;
                    n3 = this.byteBuffer[this.currentByte];
                    n3 = n3 < 0 ? 256 + n3 : n3;
                    n2 += (n3 & 255 - this.frontMask[this.currentBit]) >> 8 - (this.currentBit + n);
                    this.currentBit += n;
                    n = 0;
                }
                if (this.currentByte != this.eofByte) continue;
                this.eofFlag = true;
                return n2;
            }
            return n2;
        }
    }

    private class ByteVector {
        private byte[] data;
        private int size;

        public ByteVector() {
            this.data = new byte[10];
            this.size = 0;
        }

        public ByteVector(int n) {
            this.data = new byte[n];
            this.size = 0;
        }

        public ByteVector(byte[] byArray) {
            this.data = byArray;
            this.size = 0;
        }

        public void add(byte by) {
            if (this.size >= this.data.length) {
                this.doubleCapacity();
                this.add(by);
            } else {
                this.data[this.size++] = by;
            }
        }

        public int size() {
            return this.size;
        }

        public void add(byte[] byArray) {
            int n = byArray.length;
            while (this.data.length - this.size < n) {
                this.doubleCapacity();
            }
            System.arraycopy(byArray, 0, this.data, this.size, n);
            this.size += n;
        }

        void doubleCapacity() {
            byte[] byArray = new byte[this.data.length * 2 + 1];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }

        public void clear() {
            this.size = 0;
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[this.size];
            System.arraycopy(this.data, 0, byArray, 0, this.size);
            return byArray;
        }
    }

    private class UIDMap {
        private Map<String, String> studyInstanceUIDByFileName = new HashMap<String, String>();
        private Map<String, String> seriesInstanceUIDByFileName = new HashMap<String, String>();
        private Map<String, String> specimenUIDByFileName = new HashMap<String, String>();
        private Map<String, String> pyramidUIDByFileName = new HashMap<String, String>();
        private Map<String, String> acquisitionUIDByFileName = new HashMap<String, String>();
        private Map<String, Map<String, String>> sopInstanceUIDsByFileName = new HashMap<String, Map<String, String>>();
        private Map<String, Map<String, String>> frameOfReferenceUIDsByFileName = new HashMap<String, Map<String, String>>();
        private Map<String, Map<String, String>> dimensionOrganizationUIDsByFileName = new HashMap<String, Map<String, String>>();

        UIDMap(String string) {
            slf4jlogger.debug("Using UIDs from UID file {}", string);
            CSV cSV = CSV.separator((char)',').quote('\"').create();
            cSV.read(string, (CSVReadProc)new UIDMapCSVReadProc());
        }

        String getUIDForFileNameAndIFDFromMap(Map<String, Map<String, String>> map, String string, int n, String string2) {
            for (String string3 : map.keySet()) {
                if (!string.endsWith(string3)) continue;
                Map<String, String> map2 = map.get(string3);
                if (map2 != null) {
                    String string4 = Integer.toString(n);
                    slf4jlogger.debug("Looking for {} ifd {} in IFD map for file {}", string2, string4, string);
                    String string5 = map2.get(string4);
                    if (string5 != null && string5.length() > 0) {
                        return string5;
                    }
                    slf4jlogger.error("Could not find {} dirNum {} in IFD map for file {}", string2, n, string);
                    return null;
                }
                slf4jlogger.error("Could not find {} IFD map for file {} in map", string2, string);
                return null;
            }
            slf4jlogger.debug("Could not find {} match for file {} in map", string2, string);
            return null;
        }

        String getUIDForFileNameFromMap(Map<String, String> map, String string, String string2) {
            for (String string3 : map.keySet()) {
                if (!string.endsWith(string3)) continue;
                String string4 = map.get(string3);
                return string4;
            }
            slf4jlogger.debug("Could not find {} match for file {} in map", string2, string);
            return null;
        }

        void replaceUIDs(AttributeList attributeList, String string, int n) throws DicomException {
            UniqueIdentifierAttribute uniqueIdentifierAttribute;
            AttributeList attributeList2;
            Iterator<SequenceItem> iterator;
            Attribute attribute;
            String string2 = this.getUIDForFileNameFromMap(this.studyInstanceUIDByFileName, string, "StudyInstanceUID");
            if (string2 != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied StudyInstanceUID {}", string2);
                attribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            if ((string2 = this.getUIDForFileNameFromMap(this.seriesInstanceUIDByFileName, string, "SeriesInstanceUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied SeriesInstanceUID {}", string2);
                attribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            if ((string2 = this.getUIDForFileNameAndIFDFromMap(this.sopInstanceUIDsByFileName, string, n, "SOPInstanceUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied SOPInstanceUID {}", string2);
                attribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            if ((string2 = this.getUIDForFileNameAndIFDFromMap(this.frameOfReferenceUIDsByFileName, string, n, "FrameOfReferenceUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied FrameOfReferenceUID {}", string2);
                attribute = new UniqueIdentifierAttribute(TagFromName.FrameOfReferenceUID);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            if ((string2 = this.getUIDForFileNameFromMap(this.pyramidUIDByFileName, string, "PyramidUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied PyramidUID {}", string2);
                attribute = new UniqueIdentifierAttribute(TagFromName.PyramidUID);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            if ((string2 = this.getUIDForFileNameFromMap(this.acquisitionUIDByFileName, string, "AcquisitionUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied AcquisitionUID {}", string2);
                attribute = new UniqueIdentifierAttribute(TagFromName.AcquisitionUID);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            if ((string2 = this.getUIDForFileNameFromMap(this.specimenUIDByFileName, string, "SpecimenUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied SpecimenUID {}", string2);
                attribute = (SequenceAttribute)attributeList.get(TagFromName.SpecimenDescriptionSequence);
                if (attribute != null) {
                    iterator = ((SequenceAttribute)attribute).iterator();
                    while (iterator.hasNext()) {
                        attributeList2 = iterator.next().getAttributeList();
                        uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SpecimenUID);
                        ((Attribute)uniqueIdentifierAttribute).addValue(string2);
                        attributeList2.put(uniqueIdentifierAttribute);
                    }
                } else {
                    slf4jlogger.error("Missing SpecimenDescriptionSequence - unable to replace SpecimenUID");
                }
            }
            if ((string2 = this.getUIDForFileNameAndIFDFromMap(this.dimensionOrganizationUIDsByFileName, string, n, "DimensionOrganizationUID")) != null && string2.length() > 0) {
                slf4jlogger.debug("Using supplied DimensionOrganizationUID {}", string2);
                attribute = (SequenceAttribute)attributeList.get(TagFromName.DimensionOrganizationSequence);
                if (attribute != null) {
                    iterator = ((SequenceAttribute)attribute).iterator();
                    while (iterator.hasNext()) {
                        attributeList2 = iterator.next().getAttributeList();
                        uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
                        ((Attribute)uniqueIdentifierAttribute).addValue(string2);
                        attributeList2.put(uniqueIdentifierAttribute);
                    }
                } else {
                    slf4jlogger.error("Missing DimensionOrganizationSequence - unable to replace DimensionOrganizationUID");
                }
                attribute = (SequenceAttribute)attributeList.get(TagFromName.DimensionIndexSequence);
                if (attribute != null) {
                    iterator = ((SequenceAttribute)attribute).iterator();
                    while (iterator.hasNext()) {
                        attributeList2 = iterator.next().getAttributeList();
                        uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
                        ((Attribute)uniqueIdentifierAttribute).addValue(string2);
                        attributeList2.put(uniqueIdentifierAttribute);
                    }
                } else {
                    slf4jlogger.error("Missing aDimensionIndexSequence - unable to replace DimensionOrganizationUID");
                }
            }
        }

        private class UIDMapCSVReadProc
        implements CSVReadProc {
            private String[] columnNames = null;

            private UIDMapCSVReadProc() {
            }

            private void process(String string, String string2, String string3, Map<String, String> map) {
                if (string2 != null && string2.length() > 0) {
                    if (string3 != null && string3.length() > 0) {
                        String string4 = map.get(string2);
                        if (string4 == null) {
                            slf4jlogger.debug("UIDMap.UIDMapCSVReadProc.process(): Adding {} for file {} to {} map", string3, string2, string);
                            map.put(string2, string3);
                        } else if (!string4.equals(string3)) {
                            slf4jlogger.error("Different {} for filename {} {} than previously encountered {} - ignoring", string, string2, string3, string4);
                        }
                    } else {
                        slf4jlogger.error("Missing uid in UID map entry for filename {} for {}", string2, string);
                    }
                } else {
                    slf4jlogger.error("Missing filename in UID map entry");
                }
            }

            private void process(String string, String string2, String string3, String string4, Map<String, Map<String, String>> map) {
                if (string2 != null && string2.length() > 0) {
                    if (string3 != null && string3.length() > 0) {
                        if (string4 != null && string4.length() > 0) {
                            String string5;
                            Map<String, String> map2 = map.get(string2);
                            if (map2 == null) {
                                map2 = new HashMap<String, String>();
                                map.put(string2, map2);
                            }
                            if ((string5 = map2.get(string3)) == null) {
                                slf4jlogger.debug("UIDMap.UIDMapCSVReadProc.process(): Adding {} for file {} IFD {} to {} map", string4, string2, string3, string);
                                map2.put(string3, string4);
                            } else if (!string5.equals(string4)) {
                                slf4jlogger.error("Different {} for filename {} IFD {} {} than previously encountered {} - ignoring", string, string2, string3, string4, string5);
                            }
                        } else {
                            slf4jlogger.error("Missing uid in UID map entry for filename {} IFD {} for {}", string2, string3, string);
                        }
                    } else {
                        slf4jlogger.error("Missing IFD in UID map entry for filename {} for {}", string2, string);
                    }
                } else {
                    slf4jlogger.error("Missing filename in UID map entry");
                }
            }

            public void procRow(int n, String ... stringArray) {
                if (stringArray.length > 0) {
                    if (stringArray[0].contains("Filename")) {
                        this.columnNames = stringArray;
                    } else {
                        String string;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            string = stringArray[i];
                            if (string.length() <= 0) continue;
                            hashMap.put(this.columnNames[i], string);
                        }
                        String string2 = (String)hashMap.get("Filename");
                        string = (String)hashMap.get("IFD");
                        String string3 = (String)hashMap.get("Keyword");
                        String string4 = (String)hashMap.get("UID");
                        if (string3 != null && string3.length() > 0) {
                            if (string3.equals("StudyInstanceUID")) {
                                this.process(string3, string2, string4, UIDMap.this.studyInstanceUIDByFileName);
                            } else if (string3.equals("SeriesInstanceUID")) {
                                this.process(string3, string2, string4, UIDMap.this.seriesInstanceUIDByFileName);
                            } else if (string3.equals("SOPInstanceUID")) {
                                this.process(string3, string2, string, string4, UIDMap.this.sopInstanceUIDsByFileName);
                            } else if (string3.equals("FrameOfReferenceUID")) {
                                this.process(string3, string2, string, string4, UIDMap.this.frameOfReferenceUIDsByFileName);
                            } else if (string3.equals("SpecimenUID")) {
                                this.process(string3, string2, string4, UIDMap.this.specimenUIDByFileName);
                            } else if (string3.equals("DimensionOrganizationUID")) {
                                this.process(string3, string2, string, string4, UIDMap.this.dimensionOrganizationUIDsByFileName);
                            } else if (string3.equals("PyramidUID")) {
                                this.process(string3, string2, string4, UIDMap.this.pyramidUIDByFileName);
                            } else if (string3.equals("AcquisitionUID")) {
                                this.process(string3, string2, string4, UIDMap.this.acquisitionUIDByFileName);
                            }
                        } else {
                            slf4jlogger.error("Missing keyword in UID map entry for filename {} IFD {}", string2, string);
                        }
                    }
                }
            }
        }
    }
}

