/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeModel;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.MapTableBrowser;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DatabaseTreeBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseTreeBrowser.java,v 1.33 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DatabaseTreeBrowser.class);
    private JTree tree;
    private DatabaseTreeModel treeModel;
    private DatabaseInformationModel databaseInformationModel;
    private Map descriptiveNameMap;

    public DatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
        this.databaseInformationModel = databaseInformationModel;
        this.descriptiveNameMap = databaseInformationModel == null ? null : databaseInformationModel.getDescriptiveNameMap();
        this.treeModel = new DatabaseTreeModel(databaseInformationModel);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(4);
        jScrollPane.setViewportView(this.tree);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles());
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    public DatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, JFrame jFrame) throws DicomException {
        this(databaseInformationModel, jFrame.getContentPane());
    }

    public DatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
        this.databaseInformationModel = databaseInformationModel;
        this.descriptiveNameMap = databaseInformationModel == null ? null : databaseInformationModel.getDescriptiveNameMap();
        this.treeModel = new DatabaseTreeModel(databaseInformationModel);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JScrollPane jScrollPane2 = new JScrollPane();
        final JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.7);
        jSplitPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                jSplitPane.setDividerLocation(1.0);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        container.add(jSplitPane);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles());
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    public DatabaseTreeRecord[] getSelectionPaths() {
        Object[] objectArray;
        ArrayList<DatabaseTreeRecord> arrayList = new ArrayList<DatabaseTreeRecord>();
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (treeSelectionModel != null && (objectArray = treeSelectionModel.getSelectionPaths()) != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                Object object2;
                if (object == null || !((object2 = ((TreePath)object).getLastPathComponent()) instanceof DatabaseTreeRecord)) continue;
                DatabaseTreeRecord databaseTreeRecord = (DatabaseTreeRecord)object2;
                arrayList.add(databaseTreeRecord);
            }
        }
        objectArray = new DatabaseTreeRecord[arrayList.size()];
        return (DatabaseTreeRecord[])arrayList.toArray(objectArray);
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedFiles() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DatabaseTreeRecord[] databaseTreeRecordArray = DatabaseTreeBrowser.this.getSelectionPaths();
                if (!DatabaseTreeBrowser.this.doSomethingWithSelections(databaseTreeRecordArray)) {
                    Vector vector = new Vector();
                    for (DatabaseTreeRecord databaseTreeRecord : databaseTreeRecordArray) {
                        DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(databaseTreeRecord, vector);
                    }
                    DatabaseTreeBrowser.this.doSomethingWithSelectedFiles(vector);
                }
            }
        };
    }

    public static void recurseThroughChildrenGatheringFileNames(DatabaseTreeRecord databaseTreeRecord, Vector vector) {
        Object object;
        InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
        if (informationEntity == InformationEntity.INSTANCE && (object = databaseTreeRecord.getLocalFileNameValue()) != null) {
            vector.add(object);
        }
        if ((object = databaseTreeRecord.children()) != null) {
            while (object.hasMoreElements()) {
                DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)object.nextElement();
                if (databaseTreeRecord2 == null) continue;
                DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(databaseTreeRecord2, vector);
            }
        }
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(final JScrollPane jScrollPane) {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DatabaseTreeRecord) {
                    DatabaseTreeRecord databaseTreeRecord = (DatabaseTreeRecord)object;
                    InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
                    String string = databaseTreeRecord.getLocalPrimaryKeyValue();
                    if (informationEntity != null && string != null) {
                        Map map = null;
                        try {
                            map = DatabaseTreeBrowser.this.databaseInformationModel.findAllAttributeValuesForSelectedRecord(informationEntity, string);
                            HashSet hashSet = null;
                            HashSet hashSet2 = DatabaseTreeBrowser.this.databaseInformationModel.getLocalColumnExcludeList();
                            MapTableBrowser mapTableBrowser = new MapTableBrowser(map, DatabaseTreeBrowser.this.descriptiveNameMap, hashSet, hashSet2);
                            mapTableBrowser.setAutoResizeMode(0);
                            mapTableBrowser.setColumnWidths();
                            jScrollPane.setViewportView(mapTableBrowser);
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("", exception);
                        }
                    }
                }
            }
        };
    }

    protected MouseListener buildMouseListenerToDetectDoubleClickEvents() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent != null && mouseEvent.getClickCount() == 2) {
                    DatabaseTreeBrowser.this.doSomethingMoreWithWhateverWasSelected();
                }
            }
        };
    }

    protected boolean doSomethingWithSelections(DatabaseTreeRecord[] databaseTreeRecordArray) {
        if (databaseTreeRecordArray != null) {
            for (DatabaseTreeRecord databaseTreeRecord : databaseTreeRecordArray) {
                if (databaseTreeRecord == null) continue;
                System.err.println("DatabaseTreeBrowser.doSomethingWithSelection(): " + databaseTreeRecord);
            }
        }
        return false;
    }

    protected void doSomethingWithSelectedFiles(Vector vector) {
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                System.err.println("DatabaseTreeBrowser.doSomethingWithSelectedFiles(): " + (String)iterator.next());
            }
        }
    }

    protected void doSomethingMoreWithWhateverWasSelected() {
        System.err.println("DatabaseTreeBrowser.doSomethingMoreWithWhateverWasSelected(): Double click on current selection");
    }
}

