/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class DeleteFromDatabase {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DeleteFromDatabase.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DeleteFromDatabase.class);

    public static void deleteRecordChildrenAndFilesByUniqueKey(DatabaseInformationModel databaseInformationModel, String string, String string2) throws DicomException {
        InformationEntity informationEntity = InformationEntity.fromString(string);
        DeleteFromDatabase.deleteRecordChildrenAndFilesByUniqueKey(databaseInformationModel, informationEntity, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteRecordChildrenAndFilesByUniqueKey(DatabaseInformationModel databaseInformationModel, InformationEntity informationEntity, String string) throws DicomException {
        if (informationEntity == null) throw new DicomException("Unrecognized Information Entity");
        if (databaseInformationModel == null) throw new DicomException("No database");
        String string2 = informationEntity.equals(InformationEntity.PATIENT) ? "PATIENTID" : databaseInformationModel.getUIDColumnNameForInformationEntity(informationEntity);
        String string3 = databaseInformationModel.getLocalPrimaryKeyColumnName(informationEntity);
        ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(informationEntity, string2, string);
        if (arrayList == null || arrayList.size() <= 0) return;
        for (Map map : arrayList) {
            String string4 = (String)map.get(string3);
            slf4jlogger.info("Deleting {} {} {}", informationEntity, string4, string);
            DeleteFromDatabase.deleteRecordChildrenAndFilesByLocalPrimaryKey(databaseInformationModel, informationEntity, string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteRecordChildrenAndFilesByLocalPrimaryKey(DatabaseInformationModel databaseInformationModel, InformationEntity informationEntity, String string) throws DicomException {
        Object object;
        String string2;
        Object object2;
        if (informationEntity == null) throw new DicomException("Unrecognized Information Entity");
        if (databaseInformationModel == null) throw new DicomException("No database");
        if (string == null || string.length() <= 0) throw new DicomException("Missing local primary key");
        if (informationEntity.equals(InformationEntity.INSTANCE) && (object2 = databaseInformationModel.findAllAttributeValuesForSelectedRecord(informationEntity, string)) != null) {
            string2 = (String)object2.get(databaseInformationModel.getLocalFileNameColumnName(informationEntity));
            object = (String)object2.get(databaseInformationModel.getLocalFileReferenceTypeColumnName(informationEntity));
            if (object != null && ((String)object).equals("C")) {
                try {
                    slf4jlogger.info("Deleting file {}", string2);
                    if (!new File(string2).delete()) {
                        slf4jlogger.error("Failed to delete local copy of file {}", string2);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("Failed to delete local copy of file {}", string2, exception);
                }
            }
        }
        if ((object2 = databaseInformationModel.getChildTypeForParent(informationEntity, true)) != null) {
            string2 = databaseInformationModel.getLocalPrimaryKeyColumnName((InformationEntity)object2);
            object = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent((InformationEntity)object2, string);
            if (object == null || object.size() == 0) {
                slf4jlogger.info("No result for {}, so checking without concatenations", object2);
                object2 = databaseInformationModel.getChildTypeForParent(informationEntity, false);
                string2 = databaseInformationModel.getLocalPrimaryKeyColumnName((InformationEntity)object2);
                object = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent((InformationEntity)object2, string);
            }
            if (object != null && object.size() > 0) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    String string3 = (String)map.get(string2);
                    DeleteFromDatabase.deleteRecordChildrenAndFilesByLocalPrimaryKey(databaseInformationModel, (InformationEntity)object2, string3);
                }
            }
        }
        slf4jlogger.info("Deleting {} {}", informationEntity, string);
        databaseInformationModel.deleteRecord(informationEntity, string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 4) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.indexOf(46) == -1) {
                string = "com.pixelmed.database." + string;
            }
            try {
                PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel(string2);
                if (patientStudySeriesConcatenationInstanceModel != null) {
                    DeleteFromDatabase.deleteRecordChildrenAndFilesByUniqueKey((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel, stringArray[2], stringArray[3]);
                    patientStudySeriesConcatenationInstanceModel.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        } else {
            System.err.println("Usage: java com.pixelmed.database.DeleteFromDatabase databaseModelClassName databaseFilePathPrefix databaseFileName path(s)");
        }
    }
}

