/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;

public class AttributeTag
implements Comparable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTag.java,v 1.30 2025/01/29 10:58:06 dclunie Exp $";
    private int group;
    private int element;

    public AttributeTag(int n, int n2) {
        this.group = n;
        this.element = n2;
    }

    public AttributeTag(String string) throws DicomException {
        if (string == null) {
            throw new DicomException("Null string supplied to AttributeTag constructor \"" + string + "\"");
        }
        String[] stringArray = string.trim().replaceFirst("^[(]", "").replaceFirst("[)]$", "").split(",");
        if (stringArray == null || stringArray.length != 2) {
            throw new DicomException("String without pair of group and element numbers supplied to AttributeTag constructor \"" + string + "\"");
        }
        try {
            this.group = Integer.decode(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException("String supplied to AttributeTag constructor contains non-numeric group \"" + string + "\"");
        }
        try {
            this.element = Integer.decode(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException("String supplied to AttributeTag constructor contains non-numeric element \"" + string + "\"");
        }
    }

    public int getGroup() {
        return this.group;
    }

    public int getElement() {
        return this.element;
    }

    public boolean isPrivate() {
        return this.group % 2 != 0;
    }

    public boolean isPrivateCreator() {
        return this.group % 2 != 0 && this.element > 0 && this.element <= 255;
    }

    public boolean isGroupLength() {
        return this.element == 0;
    }

    public boolean isFileMetaInformationGroup() {
        return this.group == 2;
    }

    public boolean isOverlayGroup() {
        int n = this.group & 0xFF00;
        int n2 = this.group & 0xFF;
        return n == 24576 && n2 % 2 == 0 && n2 >= 0 && n2 <= 30;
    }

    public boolean isCurveGroup() {
        int n = this.group & 0xFF00;
        int n2 = this.group & 0xFF;
        return n == 20480 && n2 % 2 == 0 && n2 >= 0 && n2 <= 30;
    }

    public boolean isRepeatingGroup() {
        int n = this.group & 0xFF00;
        int n2 = this.group & 0xFF;
        return (n == 24576 || n == 20480) && n2 % 2 == 0 && n2 >= 0 && n2 <= 30;
    }

    public AttributeTag getTagWithRepeatingGroupBase() {
        return new AttributeTag(this.group & 0xFF00, this.element);
    }

    public String toString(DicomDictionary dicomDictionary) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString());
        if (dicomDictionary != null && (string = dicomDictionary.getNameFromTag(this)) != null) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return AttributeTag.toString(this.group, this.element);
    }

    public static String toString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(0x");
        String string = Integer.toHexString(n);
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append(",0x");
        String string2 = Integer.toHexString(n2);
        for (int i = string2.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        return this.group == ((AttributeTag)object).group ? (this.element == ((AttributeTag)object).element ? 0 : (this.element < ((AttributeTag)object).element ? -1 : 1)) : (this.group < ((AttributeTag)object).group ? -1 : 1);
    }

    public boolean equals(Object object) {
        return this.group == ((AttributeTag)object).group && this.element == ((AttributeTag)object).element;
    }

    public int hashCode() {
        return (this.group << 16) + (this.element & 0xFFFF);
    }

    public static void main(String[] stringArray) {
        int n = 16;
        int n2 = 32;
        AttributeTag attributeTag = new AttributeTag(n, n2);
        System.err.println("Test numeric constructor: " + (attributeTag.getGroup() == n && attributeTag.getElement() == n2 ? "PASS" : "FAIL"));
        String string = attributeTag.toString();
        try {
            AttributeTag attributeTag2 = new AttributeTag(string);
            System.err.println("Test string round trip:   " + (attributeTag.getGroup() == n && attributeTag.getElement() == n2 ? "PASS" : "FAIL"));
        }
        catch (Exception exception) {
            System.err.println("Test string round trip:   FAIL with exception " + exception);
        }
    }
}

