/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTreeRecord;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ValueRepresentation;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AttributeTree
implements TreeModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTree.java,v 1.18 2025/01/29 10:58:06 dclunie Exp $";
    private AttributeTreeRecord root;
    private Vector listeners;

    @Override
    public Object getChild(Object object, int n) {
        return ((AttributeTreeRecord)object).getChildAt(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((AttributeTreeRecord)object).getIndex((AttributeTreeRecord)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object object) {
        return ((AttributeTreeRecord)object).getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((AttributeTreeRecord)object).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners.removeElement(treeModelListener);
        }
    }

    private AttributeTreeRecord processAttributeList(AttributeTreeRecord attributeTreeRecord, AttributeList attributeList, DicomDictionary dicomDictionary) throws DicomException {
        AttributeTreeRecord attributeTreeRecord2 = null;
        for (Attribute attribute : attributeList.values()) {
            AttributeTreeRecord attributeTreeRecord3 = new AttributeTreeRecord(attributeTreeRecord, attribute, dicomDictionary);
            if (attributeTreeRecord2 == null) {
                attributeTreeRecord2 = attributeTreeRecord3;
                if (attributeTreeRecord != null) {
                    attributeTreeRecord.addChild(attributeTreeRecord3);
                }
            } else {
                attributeTreeRecord3.addSibling(attributeTreeRecord3);
            }
            if (!ValueRepresentation.isSequenceVR(attribute.getVR())) continue;
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            int n = 0;
            Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = iterator.next();
                AttributeTreeRecord attributeTreeRecord4 = new AttributeTreeRecord(attributeTreeRecord3, ++n);
                attributeTreeRecord3.addChild(attributeTreeRecord4);
                this.processAttributeList(attributeTreeRecord4, sequenceItem.getAttributeList(), dicomDictionary);
            }
        }
        return attributeTreeRecord2;
    }

    public AttributeTree(AttributeList attributeList) throws DicomException {
        if (attributeList != null) {
            DicomDictionary dicomDictionary = attributeList.getDictionary();
            this.root = new AttributeTreeRecord(null, null, dicomDictionary);
            this.processAttributeList(this.root, attributeList, dicomDictionary);
        }
    }

    private String walkTree(AttributeTreeRecord attributeTreeRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(attributeTreeRecord.toString());
        stringBuffer.append("\n");
        int n = this.getChildCount(attributeTreeRecord);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.walkTree((AttributeTreeRecord)this.getChild(attributeTreeRecord, i)));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.walkTree(this.root);
    }

    private void walkTreeAndSetSortOrder(AttributeTreeRecord attributeTreeRecord, boolean bl) {
        AttributeTreeRecord attributeTreeRecord2;
        attributeTreeRecord.setSortByName(bl);
        Vector<AttributeTreeRecord> vector = new Vector<AttributeTreeRecord>();
        int n = attributeTreeRecord.getChildCount();
        for (int i = 0; i < n; ++i) {
            attributeTreeRecord2 = (AttributeTreeRecord)attributeTreeRecord.getChildAt(i);
            this.walkTreeAndSetSortOrder(attributeTreeRecord2, bl);
            vector.add(attributeTreeRecord2);
        }
        attributeTreeRecord.removeAllChildren();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            attributeTreeRecord2 = (AttributeTreeRecord)enumeration.nextElement();
            attributeTreeRecord.addChild(attributeTreeRecord2);
        }
    }

    public void setSortByName(boolean bl) {
        this.walkTreeAndSetSortOrder(this.root, bl);
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
            }
        }
    }
}

