/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTree;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeModel;

public class AttributeTreeBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTreeBrowser.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AttributeTreeBrowser.class);
    private JTree tree;
    private AttributeTree treeModel;

    public AttributeTreeBrowser(AttributeList attributeList, JScrollPane jScrollPane) throws DicomException {
        this.treeModel = new AttributeTree(attributeList);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        jScrollPane.setViewportView(this.tree);
    }

    public static void setSortByName(JScrollPane jScrollPane, boolean bl) {
        JTree jTree;
        TreeModel treeModel;
        Component component;
        JViewport jViewport;
        if (jScrollPane != null && (jViewport = jScrollPane.getViewport()) != null && (component = jViewport.getView()) != null && component instanceof JTree && (treeModel = (jTree = (JTree)component).getModel()) != null && treeModel instanceof AttributeTree) {
            AttributeTree attributeTree = (AttributeTree)treeModel;
            attributeTree.setSortByName(bl);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        long l = System.currentTimeMillis();
        attributeList.setDecompressPixelData(false);
        try {
            attributeList.read(stringArray[0]);
            slf4jlogger.info("main(): read - done in {} ms", System.currentTimeMillis() - l);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
        ApplicationFrame applicationFrame = new ApplicationFrame();
        JScrollPane jScrollPane = new JScrollPane();
        try {
            AttributeTreeBrowser attributeTreeBrowser = new AttributeTreeBrowser(attributeList, jScrollPane);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
            System.exit(0);
        }
        applicationFrame.getContentPane().add(jScrollPane);
        applicationFrame.pack();
        applicationFrame.setVisible(true);
    }
}

