/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ByteFrameSource;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.UnPackBits;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompressedFrameDecoder {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CompressedFrameDecoder.java,v 1.36 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CompressedFrameDecoder.class);
    private String transferSyntaxUID;
    private byte[][] frames;
    private ByteFrameSource compressedDataFrameSource;
    private int bytesPerSample;
    private int width;
    private int height;
    private int samples;
    private ColorSpace colorSpace;
    private boolean photometricInterpretationIsKnown;
    private boolean photometricInterpretationIsYBR;
    private static boolean haveScannedForCodecs;
    private IIOMetadata[] iioMetadata = null;
    private boolean colorSpaceWillBeConvertedToRGBDuringDecompression = false;
    private String readerWanted;
    private boolean isJPEGFamily = false;
    private boolean isRLE = false;
    private ImageReader reader = null;
    private Set<String> blacklistedReaders = null;
    private int lastFrameDecompressed = -1;
    private IIOMetadata iioMetadataForLastFrameDecompressed = null;
    protected boolean haveProcessedMetaDataForFrameRequest = false;
    protected boolean haveJFIF;
    protected boolean haveAdobe;
    protected boolean areDownsampled;
    protected boolean areNumberedFromOneByOne;

    public static void scanForCodecs() {
        slf4jlogger.debug("scanForCodecs(): Scanning for ImageIO plugin codecs");
        ImageIO.scanForPlugins();
        ImageIO.setUseCache(false);
        haveScannedForCodecs = true;
    }

    public static boolean canDecompress(File file) {
        boolean bl;
        block18: {
            slf4jlogger.debug("canDecompress(): file " + file);
            bl = false;
            AttributeList attributeList = new AttributeList();
            try {
                attributeList.readOnlyMetaInformationHeader(file);
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                slf4jlogger.debug("canDecompress(): transferSyntaxUID {}", string);
                if (string.equals("1.2.840.10008.1.2.5")) {
                    bl = true;
                    break block18;
                }
                TransferSyntax transferSyntax = new TransferSyntax(string);
                slf4jlogger.debug("canDecompress(): {}", transferSyntax.dump());
                int n = 2;
                if (!transferSyntax.isJPEGFamily()) break block18;
                slf4jlogger.debug("canDecompress(): transferSyntaxUID is JPEG family");
                String string2 = null;
                if (string.equals("1.2.840.10008.1.2.4.50")) {
                    string2 = "JPEG";
                    n = 1;
                } else if (string.equals("1.2.840.10008.1.2.4.51")) {
                    string2 = "JPEG";
                } else if (string.equals("1.2.840.10008.1.2.4.55")) {
                    string2 = "JPEG";
                } else if (string.equals("1.2.840.10008.1.2.4.91") || string.equals("1.2.840.10008.1.2.4.90")) {
                    string2 = "JPEG2000";
                } else if (string.equals("1.2.840.10008.1.2.4.57") || string.equals("1.2.840.10008.1.2.4.70")) {
                    string2 = "jpeg-lossless";
                } else if (string.equals("1.2.840.10008.1.2.4.80") || string.equals("1.2.840.10008.1.2.4.81")) {
                    string2 = "jpeg-ls";
                }
                if (string2 == null) break block18;
                slf4jlogger.debug("canDecompress(): readerWanted {}", string2);
                try {
                    ImageReader imageReader = CompressedFrameDecoder.selectReaderFromCodecsAvailable(string2, string, n);
                    if (imageReader != null) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.debug("ignore any exception at this point, since harmless", exception);
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
            }
        }
        slf4jlogger.debug("canDecompress(): returns {}", bl);
        return bl;
    }

    public static boolean canDecompress(String string) {
        return CompressedFrameDecoder.canDecompress(new File(string));
    }

    public boolean getColorSpaceConvertedToRGBDuringDecompression() {
        return this.colorSpaceWillBeConvertedToRGBDuringDecompression;
    }

    private void chooseReaderWantedBasedOnTransferSyntax() {
        TransferSyntax transferSyntax = new TransferSyntax(this.transferSyntaxUID);
        this.isJPEGFamily = transferSyntax.isJPEGFamily();
        this.isRLE = this.transferSyntaxUID.equals("1.2.840.10008.1.2.5");
        this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
        this.readerWanted = null;
        slf4jlogger.debug("chooseReader(): TransferSyntax = {}", this.transferSyntaxUID);
        if (this.isRLE) {
            slf4jlogger.debug("Undefined length encapsulated Pixel Data in RLE");
        } else if (this.isJPEGFamily) {
            if (this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.50") || this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.51") || this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.55")) {
                this.readerWanted = "JPEG";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                slf4jlogger.debug("chooseReader(): Undefined length encapsulated Pixel Data in JPEG Lossy");
            } else if (this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.91")) {
                this.readerWanted = "JPEG2000";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                slf4jlogger.debug("chooseReader(): Undefined length encapsulated Pixel Data in JPEG 2000");
            } else if (this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.90")) {
                this.readerWanted = "JPEG2000";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                slf4jlogger.debug("chooseReader(): Undefined length encapsulated Pixel Data in JPEG 2000");
            } else if (this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.57") || this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.70")) {
                this.readerWanted = "jpeg-lossless";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
                slf4jlogger.debug("chooseReader(): Undefined length encapsulated Pixel Data in JPEG Lossless");
            } else if (this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.80")) {
                this.readerWanted = "jpeg-ls";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
                slf4jlogger.debug("chooseReader(): Undefined length encapsulated Pixel Data in JPEG-LS");
            } else if (this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.81")) {
                this.readerWanted = "jpeg-ls";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
                slf4jlogger.debug("chooseReader(): Undefined length encapsulated Pixel Data in JPEG-LS");
            } else {
                this.readerWanted = "JPEG";
                this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                slf4jlogger.warn("Unrecognized JPEG family Transfer Syntax {} for encapsulated PixelData - guessing {}", this.transferSyntaxUID, this.readerWanted);
            }
        } else {
            slf4jlogger.error("Unrecognized Transfer Syntax {} for encapsulated PixelData - cannot find reader", this.transferSyntaxUID);
        }
        slf4jlogger.debug("chooseReader(): Based on Transfer Syntax, colorSpaceWillBeConvertedToRGBDuringDecompression = {}", this.colorSpaceWillBeConvertedToRGBDuringDecompression);
    }

    public static boolean isStandardJPEGReader(ImageReader imageReader) {
        return imageReader.getOriginatingProvider().getDescription(Locale.US).equals("Standard JPEG Image Reader") && (imageReader.getOriginatingProvider().getVendorName().equals("Sun Microsystems, Inc.") || imageReader.getOriginatingProvider().getVendorName().equals("Oracle Corporation"));
    }

    public static boolean isPixelMedLosslessJPEGReader(ImageReader imageReader) {
        return imageReader.getOriginatingProvider().getDescription(Locale.US).equals("PixelMed JPEG Lossless Image Reader");
    }

    public static ImageReader selectReaderFromCodecsAvailable(String string, String string2, int n, Set<String> set) throws DicomException {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        while (iterator.hasNext()) {
            ImageReader imageReader2 = iterator.next();
            String string3 = imageReader2.getOriginatingProvider().getDescription(Locale.US);
            if (set != null && set.contains(string3)) {
                slf4jlogger.debug("selectReaderFromCodecsAvailable(): Skipping blacklisted reader {}", string3);
                continue;
            }
            if (imageReader == null) {
                imageReader = imageReader2;
                slf4jlogger.debug("selectReaderFromCodecsAvailable(): First reader found is {} {} {}", imageReader.getOriginatingProvider().getDescription(Locale.US), imageReader.getOriginatingProvider().getVendorName(), imageReader.getOriginatingProvider().getVersion());
                continue;
            }
            ImageReader imageReader3 = imageReader2;
            slf4jlogger.debug("selectReaderFromCodecsAvailable(): Found another reader {} {} {}", imageReader3.getOriginatingProvider().getDescription(Locale.US), imageReader3.getOriginatingProvider().getVendorName(), imageReader3.getOriginatingProvider().getVersion());
            if (CompressedFrameDecoder.isStandardJPEGReader(imageReader)) {
                imageReader = imageReader3;
                slf4jlogger.debug("selectReaderFromCodecsAvailable(): Choosing reader {} {} {} over Standard JPEG Image Reader", imageReader.getOriginatingProvider().getDescription(Locale.US), imageReader.getOriginatingProvider().getVendorName(), imageReader.getOriginatingProvider().getVersion());
                continue;
            }
            if (CompressedFrameDecoder.isPixelMedLosslessJPEGReader(imageReader)) {
                slf4jlogger.debug("selectReaderFromCodecsAvailable(): Choosing reader {} {} {} over any other reader", imageReader.getOriginatingProvider().getDescription(Locale.US), imageReader.getOriginatingProvider().getVendorName(), imageReader.getOriginatingProvider().getVersion());
                break;
            }
            if (!CompressedFrameDecoder.isPixelMedLosslessJPEGReader(imageReader3)) continue;
            imageReader = imageReader3;
            slf4jlogger.debug("selectReaderFromCodecsAvailable(): Choosing reader {} {} {} over any other reader", imageReader.getOriginatingProvider().getDescription(Locale.US), imageReader.getOriginatingProvider().getVendorName(), imageReader.getOriginatingProvider().getVersion());
            break;
        }
        if (imageReader != null) {
            if (string2.equals("1.2.840.10008.1.2.4.51") && n > 1 && imageReader.getOriginatingProvider().getDescription(Locale.US).equals("Standard JPEG Image Reader") && (imageReader.getOriginatingProvider().getVendorName().equals("Sun Microsystems, Inc.") || imageReader.getOriginatingProvider().getVendorName().equals("Oracle Corporation"))) {
                throw new DicomException("Reader " + imageReader.getOriginatingProvider().getDescription(Locale.US) + " " + imageReader.getOriginatingProvider().getVendorName() + " " + imageReader.getOriginatingProvider().getVersion() + " does not support extended lossy JPEG Transfer Syntax " + string2 + " other than for 8 bit data");
            }
        } else {
            throw new DicomException("No reader for " + string + " available for Transfer Syntax " + string2);
        }
        slf4jlogger.debug("selectReaderFromCodecsAvailable(): Using reader {} {} {}", imageReader.getOriginatingProvider().getDescription(Locale.US), imageReader.getOriginatingProvider().getVendorName(), imageReader.getOriginatingProvider().getVersion());
        return imageReader;
    }

    public static ImageReader selectReaderFromCodecsAvailable(String string, String string2, int n) throws DicomException {
        return CompressedFrameDecoder.selectReaderFromCodecsAvailable(string, string2, n, null);
    }

    public CompressedFrameDecoder(String string, int n, int n2, int n3, int n4, ColorSpace colorSpace) throws DicomException {
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace);
    }

    public CompressedFrameDecoder(String string, int n, int n2, int n3, int n4, ColorSpace colorSpace, boolean bl) throws DicomException {
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace, true, bl);
    }

    public CompressedFrameDecoder(String string, ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, ColorSpace colorSpace) throws DicomException {
        if (byteFrameSource == null) {
            throw new DicomException("no compressed frame source supplied to decompress");
        }
        this.compressedDataFrameSource = byteFrameSource;
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace);
    }

    public CompressedFrameDecoder(String string, ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, ColorSpace colorSpace, boolean bl) throws DicomException {
        if (byteFrameSource == null) {
            throw new DicomException("no compressed frame source supplied to decompress");
        }
        this.compressedDataFrameSource = byteFrameSource;
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace, true, bl);
    }

    public CompressedFrameDecoder(String string, byte[][] byArray, int n, int n2, int n3, int n4, ColorSpace colorSpace) throws DicomException {
        if (byArray == null) {
            throw new DicomException("no array of compressed data per frame supplied to decompress");
        }
        this.frames = byArray;
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace);
    }

    public CompressedFrameDecoder(String string, byte[][] byArray, int n, int n2, int n3, int n4, ColorSpace colorSpace, boolean bl) throws DicomException {
        if (byArray == null) {
            throw new DicomException("no array of compressed data per frame supplied to decompress");
        }
        this.frames = byArray;
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace, true, bl);
    }

    protected void doCommonConstructorStuff(String string, int n, int n2, int n3, int n4, ColorSpace colorSpace) throws DicomException {
        this.doCommonConstructorStuff(string, n, n2, n3, n4, colorSpace, false, false);
    }

    protected void doCommonConstructorStuff(String string, int n, int n2, int n3, int n4, ColorSpace colorSpace, boolean bl, boolean bl2) throws DicomException {
        this.transferSyntaxUID = string;
        slf4jlogger.debug("CompressedFrameDecoder(): transferSyntaxUID = {}", string);
        this.bytesPerSample = n;
        this.width = n2;
        this.height = n3;
        this.samples = n4;
        this.colorSpace = colorSpace;
        this.photometricInterpretationIsKnown = bl;
        this.photometricInterpretationIsYBR = bl2;
        CompressedFrameDecoder.scanForCodecs();
        this.chooseReaderWantedBasedOnTransferSyntax();
        slf4jlogger.debug("CompressedFrameDecoder(): Based on Transfer Syntax, colorSpaceWillBeConvertedToRGBDuringDecompression = {}", this.colorSpaceWillBeConvertedToRGBDuringDecompression);
        if (this.readerWanted != null) {
            this.reader = CompressedFrameDecoder.selectReaderFromCodecsAvailable(this.readerWanted, string, n);
        } else if (!this.isRLE) {
            slf4jlogger.debug("CompressedFrameDecoder(): Unrecognized Transfer Syntax {} for encapsulated PixelData", string);
            throw new DicomException("Unrecognized Transfer Syntax " + string + " for encapsulated PixelData");
        }
    }

    public BufferedImage getDecompressedFrameAsBufferedImage(int n) throws DicomException, IOException {
        slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): Starting frame {}", n);
        byte[] byArray = null;
        byArray = this.frames != null ? this.frames[n] : this.compressedDataFrameSource.getByteValuesForSelectedFrame(n);
        return this.getDecompressedFrameAsBufferedImage(byArray);
    }

    public BufferedImage getDecompressedFrameAsBufferedImage(byte[] byArray) throws DicomException, IOException {
        BufferedImage bufferedImage = null;
        if (this.isRLE) {
            bufferedImage = this.getDecompressedFrameAsBufferedImageUsingRLE(byArray);
        } else {
            while (bufferedImage == null && this.reader != null) {
                block13: {
                    try {
                        bufferedImage = this.getDecompressedFrameAsBufferedImageUsingImageReader(byArray);
                        slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): on return from getDecompressedFrameAsBufferedImageUsingImageReader, image is {}", bufferedImage);
                    }
                    catch (Exception exception) {
                        block12: {
                            slf4jlogger.error("Failed to read frame using selected reader: ", exception);
                            if (this.blacklistedReaders == null) {
                                this.blacklistedReaders = new HashSet<String>();
                            }
                            String string = this.reader.getOriginatingProvider().getDescription(Locale.US);
                            this.blacklistedReaders.add(string);
                            slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): Adding reader to blacklist {}", string);
                            try {
                                this.reader = null;
                                this.reader = CompressedFrameDecoder.selectReaderFromCodecsAvailable(this.readerWanted, this.transferSyntaxUID, this.bytesPerSample, this.blacklistedReaders);
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): Next reader to try is {}", this.reader);
                            }
                            catch (Exception exception2) {
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): Exception selecting reader: ", exception2);
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): reader after exception is {}", this.reader);
                                if (this.readerWanted.equals("jpeg-lossless")) {
                                    slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): No more readers for jpeg-lossless, so try ordinary jpeg");
                                    this.readerWanted = "jpeg";
                                    try {
                                        this.reader = null;
                                        this.reader = CompressedFrameDecoder.selectReaderFromCodecsAvailable(this.readerWanted, this.transferSyntaxUID, this.bytesPerSample, this.blacklistedReaders);
                                    }
                                    catch (Exception exception3) {
                                        slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): Exception selecting reader to try jpeg after jpeg-lossless: ", exception3);
                                    }
                                    break block12;
                                }
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): No more readers to try and reader wanted is not jpeg-lossless");
                            }
                        }
                        slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): reader after processing reader failure exception is {}", this.reader);
                        if (this.reader != null) break block13;
                        throw new DicomException("No more readers to try");
                    }
                }
                slf4jlogger.debug("getDecompressedFrameAsBufferedImage(): reader before looping is {}", this.reader);
            }
        }
        if (bufferedImage == null) {
            throw new DicomException("Unable to read image - no more readers to try");
        }
        return bufferedImage;
    }

    public BufferedImage getDecompressedFrameAsBufferedImageUsingRLE(int n) throws DicomException, IOException {
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingRLE(): Starting frame {}", n);
        byte[] byArray = null;
        byArray = this.frames != null ? this.frames[n] : this.compressedDataFrameSource.getByteValuesForSelectedFrame(n);
        return this.getDecompressedFrameAsBufferedImageUsingRLE(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferedImage getDecompressedFrameAsBufferedImageUsingRLE(byte[] byArray) throws DicomException, IOException {
        int n;
        BufferedImage bufferedImage = null;
        ByteArrayInputStreamWithOffsetCounterAndOurMethods byteArrayInputStreamWithOffsetCounterAndOurMethods = new ByteArrayInputStreamWithOffsetCounterAndOurMethods(byArray);
        int n2 = this.height * this.width;
        if (this.bytesPerSample == 1) {
            int n3;
            slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingRLE(): bytesPerSample = 1");
            slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingRLE(): pixelsPerFrame = {}", n2);
            byte[] byArray2 = new byte[n2 * this.samples];
            int n4 = (int)byteArrayInputStreamWithOffsetCounterAndOurMethods.readUnsigned32LittleEndian();
            slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Number of segments = {}", n4);
            long[] lArray = new long[15];
            byteArrayInputStreamWithOffsetCounterAndOurMethods.readUnsigned32LittleEndian(lArray, 0, 15);
            for (n3 = 0; n3 < 15; ++n3) {
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Segment [{}] offset = {}", n3, lArray[n3]);
                }
                if (lArray[n3] % 2L == 0L) continue;
                System.err.println("Error: fragment offset for segment " + n3 + " is not even length (" + lArray[n3] + ") but ignoring and using odd offset anyway");
            }
            for (n3 = 0; n3 < this.samples; ++n3) {
                slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Doing sample = {}", n3);
                int n5 = byteArrayInputStreamWithOffsetCounterAndOurMethods.getOffsetOfNextByteToReadFromStartOfFragment();
                slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): At fragment offset {}", n5);
                int n6 = (int)lArray[n3] - n5;
                if (n6 > 0) {
                    byteArrayInputStreamWithOffsetCounterAndOurMethods.skipInsistently(n6);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Skipped {} to segment offset {}", n6, lArray[n3]);
                    }
                } else if (n6 < 0) {
                    throw new DicomException("Already read past start of next segment " + n3 + " - at " + n5 + " need to be at " + lArray[n3]);
                }
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Now at fragment offset {}", byteArrayInputStreamWithOffsetCounterAndOurMethods.getOffsetOfNextByteToReadFromStartOfFragment());
                }
                int n7 = UnPackBits.decode(byteArrayInputStreamWithOffsetCounterAndOurMethods, byArray2, n2 * n3, n2);
                slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): got = {} pixels", n7);
            }
            if (this.samples == 1) {
                ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
                ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
                DataBufferByte dataBufferByte = new DataBufferByte(byArray2, this.width, 0);
                WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
                return new BufferedImage(componentColorModel, writableRaster, true, null);
            }
            if (this.samples != 3) throw new DicomException("Creation of BufferedImage for RLE compressed frame of more samples other than 1 or 3 not supported yet (got " + this.samples + ")");
            ComponentColorModel componentColorModel = new ComponentColorModel(this.colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, this.width, this.height, 1, this.width, new int[]{0, n2, n2 * 2});
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, this.width, 0);
            WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
            return new BufferedImage(componentColorModel, writableRaster, true, null);
        }
        if (this.bytesPerSample != 2) throw new DicomException("RLE of more than 2 bytes per sample not supported (got " + this.bytesPerSample + ")");
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingRLE(): bytesPerSample = 2");
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingRLE(): pixelsPerFrame = {}", n2);
        short[] sArray = new short[n2 * this.samples];
        int n8 = (int)byteArrayInputStreamWithOffsetCounterAndOurMethods.readUnsigned32LittleEndian();
        slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Number of segments = {}", n8);
        long[] lArray = new long[15];
        byteArrayInputStreamWithOffsetCounterAndOurMethods.readUnsigned32LittleEndian(lArray, 0, 15);
        for (n = 0; n < 15; ++n) {
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingRLE(): Segment [{}] offset = {}", n, lArray[n]);
            }
            if (lArray[n] % 2L == 0L) continue;
            System.err.println("Error: fragment offset for segment " + n + " is not even length (" + lArray[n] + ") but ignoring and using odd offset anyway");
        }
        n = 0;
        int n9 = 0;
        for (int i = 0; i < this.samples; ++i) {
            slf4jlogger.trace("Doing sample = {}", i);
            slf4jlogger.trace("Doing firstsegment");
            byte[] byArray3 = new byte[n2];
            int n10 = byteArrayInputStreamWithOffsetCounterAndOurMethods.getOffsetOfNextByteToReadFromStartOfFragment();
            slf4jlogger.trace("At fragment offset {}", n10);
            int n11 = (int)lArray[n9] - n10;
            if (n11 > 0) {
                byteArrayInputStreamWithOffsetCounterAndOurMethods.skipInsistently(n11);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Skipped {} to segment offset {}", n11, lArray[i]);
                }
            } else if (n11 < 0) {
                throw new DicomException("Already read past start of next segment " + i + " - at " + n10 + " need to be at " + lArray[i]);
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("Now at fragment offset {}", byteArrayInputStreamWithOffsetCounterAndOurMethods.getOffsetOfNextByteToReadFromStartOfFragment());
            }
            n10 = UnPackBits.decode(byteArrayInputStreamWithOffsetCounterAndOurMethods, byArray3, n2 * i, n2);
            slf4jlogger.trace("got = {} bytes for first segment", n10);
            slf4jlogger.trace("Doing secondsegment");
            byte[] byArray4 = new byte[n2];
            int n12 = byteArrayInputStreamWithOffsetCounterAndOurMethods.getOffsetOfNextByteToReadFromStartOfFragment();
            slf4jlogger.trace("At fragment offset {}", n12);
            int n13 = (int)lArray[++n9] - n12;
            if (n13 > 0) {
                byteArrayInputStreamWithOffsetCounterAndOurMethods.skipInsistently(n13);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Skipped {} to segment offset {}", n13, lArray[i]);
                }
            } else if (n13 < 0) {
                throw new DicomException("Already read past start of next segment " + i + " - at " + n12 + " need to be at " + lArray[i]);
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("Now at fragment offset {}", byteArrayInputStreamWithOffsetCounterAndOurMethods.getOffsetOfNextByteToReadFromStartOfFragment());
            }
            n10 = UnPackBits.decode(byteArrayInputStreamWithOffsetCounterAndOurMethods, byArray4, n2 * i, n2);
            slf4jlogger.trace("got = {} bytes for second segment", n10);
            for (n12 = 0; n12 < n2; ++n12) {
                sArray[n + n12] = (short)(((byArray3[n12] & 0xFF) << 8) + (byArray4[n12] & 0xFF));
            }
            n += n2;
            ++n9;
        }
        if (this.samples == 1) {
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, this.width, this.height, 1, this.width, new int[]{0});
            DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, this.width, 0);
            WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
            return new BufferedImage(componentColorModel, writableRaster, true, null);
        }
        if (this.samples != 3) throw new DicomException("Creation of BufferedImage for RLE compressed frame of more samples other than 1 or 3 not supported yet (got " + this.samples + ")");
        ComponentColorModel componentColorModel = new ComponentColorModel(this.colorSpace, new int[]{16, 16, 16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, this.width, this.height, 1, this.width, new int[]{0, n2, n2 * 2});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, this.width, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    private static String toString(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(node.getNodeName());
        stringBuffer.append(" = ");
        stringBuffer.append(node.getNodeValue());
        if (node.hasAttributes()) {
            stringBuffer.append(" Attributes: ");
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append("; ");
                stringBuffer.append(CompressedFrameDecoder.toString(node2));
            }
        }
        stringBuffer.append("\n");
        ++n;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(CompressedFrameDecoder.toString(node3, n));
        }
        return stringBuffer.toString();
    }

    private static String toString(Node node) {
        return CompressedFrameDecoder.toString(node, 0);
    }

    public BufferedImage getDecompressedFrameAsBufferedImageUsingImageReader(int n) throws DicomException, IOException {
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): Starting frame {}", n);
        byte[] byArray = null;
        if (this.frames != null) {
            slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): using frames already in memory");
            byArray = this.frames[n];
        } else {
            slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): using frames from disk");
            byArray = this.compressedDataFrameSource.getByteValuesForSelectedFrame(n);
        }
        BufferedImage bufferedImage = this.getDecompressedFrameAsBufferedImageUsingImageReader(byArray);
        this.lastFrameDecompressed = n;
        return bufferedImage;
    }

    public BufferedImage getDecompressedFrameAsBufferedImageUsingImageReader(byte[] byArray) throws DicomException, IOException {
        BufferedImage bufferedImage = null;
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("getDecompressedFrameAsBufferedImageUsingImageReader() frame bytes =\n{}", HexDump.dump(byArray));
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
        this.reader.setInput(imageInputStream, true, true);
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): Calling reader");
        try {
            if (this.samples == 3 && this.transferSyntaxUID.equals("1.2.840.10008.1.2.4.50") && (this.reader.getOriginatingProvider().getVendorName().equals("Sun Microsystems, Inc.") || this.reader.getOriginatingProvider().getVendorName().equals("Oracle Corporation"))) {
                Object object;
                Object object2;
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): checking if we need to handle JPEG YCbCr conversion ourselves");
                if (!this.haveProcessedMetaDataForFrameRequest) {
                    slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): haveProcessedMetaDataForFrameRequest is false");
                    this.haveProcessedMetaDataForFrameRequest = true;
                    this.haveJFIF = false;
                    this.haveAdobe = false;
                    this.areDownsampled = false;
                    this.areNumberedFromOneByOne = true;
                    try {
                        Object object3;
                        object2 = this.reader.getImageMetadata(0);
                        if (slf4jlogger.isDebugEnabled()) {
                            object3 = ((IIOMetadata)object2).getMetadataFormatNames();
                            int n = ((String[])object3).length;
                            for (int i = 0; i < n; ++i) {
                                Object object4 = object3[i];
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): format {} metadata = {}", object4, CompressedFrameDecoder.toString(((IIOMetadata)object2).getAsTree((String)object4)));
                            }
                        }
                        this.haveJFIF = ((IIOMetadataNode)(object3 = (IIOMetadataNode)((IIOMetadata)object2).getAsTree("javax_imageio_jpeg_image_1.0"))).getElementsByTagName("app0JFIF").getLength() > 0;
                        this.haveAdobe = ((IIOMetadataNode)object3).getElementsByTagName("app14Adobe").getLength() > 0;
                        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)((IIOMetadataNode)object3).getElementsByTagName("sof").item(0);
                        object = iIOMetadataNode.getElementsByTagName("componentSpec");
                        for (int i = 0; i < object.getLength(); ++i) {
                            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)object.item(i);
                            int n = Integer.parseInt(iIOMetadataNode2.getAttribute("componentId"));
                            if (n != i + 1) {
                                this.areNumberedFromOneByOne = false;
                            }
                            n = Integer.parseInt(iIOMetadataNode2.getAttribute("HsamplingFactor"));
                            int n2 = Integer.parseInt(iIOMetadataNode2.getAttribute("VsamplingFactor"));
                            if (n == 1 && n2 == 1) continue;
                            this.areDownsampled = true;
                        }
                        if (slf4jlogger.isDebugEnabled() && this.haveAdobe) {
                            try {
                                IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)((IIOMetadataNode)object3).getElementsByTagName("app14Adobe").item(0);
                                int n = Integer.parseInt(iIOMetadataNode3.getAttribute("transform"));
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): app14Adobe transform = {}", n);
                            }
                            catch (Exception exception) {
                                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): Exception getting transform from app14Adobe marker segment", exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("getDecompressedFrameAsBufferedImageUsingImageReader(): Failed to determine whether or not to handle JPEG YCbCr conversion ourselves from IIOMetadata", exception);
                    }
                }
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): haveJFIF = {}", this.haveJFIF);
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): haveAdobe = {}", this.haveAdobe);
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): areDownsampled = {}", this.areDownsampled);
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): areNumberedFromOneByOne = {}", this.areNumberedFromOneByOne);
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): photometricInterpretationIsKnown = {}", this.photometricInterpretationIsKnown);
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): photometricInterpretationIsYBR = {}", this.photometricInterpretationIsYBR);
                if (!(this.haveJFIF || this.haveAdobe || this.areDownsampled || this.areNumberedFromOneByOne || this.photometricInterpretationIsKnown && !this.photometricInterpretationIsYBR)) {
                    slf4jlogger.info("getDecompressedFrameAsBufferedImageUsingImageReader(): Trying to handle JPEG YCbCr conversion ourselves because no JFIF/Adobe APP and not downsampled and components numbered unconventionally");
                    if (this.reader.canReadRaster()) {
                        slf4jlogger.info("getDecompressedFrameAsBufferedImageUsingImageReader(): Handle JPEG YCbCr conversion ourselves by reading Raster");
                        object2 = this.reader.readRaster(0, null);
                        int n = ((Raster)object2).getWidth();
                        int n3 = ((Raster)object2).getHeight();
                        object = (byte[])((Raster)object2).getDataElements(0, 0, n, n3, null);
                        ComponentColorModel componentColorModel = new ComponentColorModel(this.colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
                        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n3, 3, n * 3, new int[]{0, 1, 2});
                        DataBufferByte dataBufferByte = new DataBufferByte((byte[])object, n, 0);
                        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
                        bufferedImage = BufferedImageUtilities.convertYBRToRGB(new BufferedImage(componentColorModel, writableRaster, true, null));
                    } else {
                        slf4jlogger.info("getDecompressedFrameAsBufferedImageUsingImageReader(): reading Raster is not supported ... assuming Reader will leave the color space alone and so we do the YCbCr conversion ourselves");
                        bufferedImage = BufferedImageUtilities.convertYBRToRGB(this.reader.read(0));
                    }
                }
            }
            if (bufferedImage == null) {
                slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): leaving color space conversion (if any) to Reader");
                bufferedImage = this.reader.read(0);
            }
        }
        catch (IIOException iIOException) {
            slf4jlogger.error("", iIOException);
            slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): \"{}\"", iIOException.toString());
        }
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): Back from frame reader.readAll()");
        if (bufferedImage == null) {
            throw new DicomException("Reader " + this.reader.getOriginatingProvider().getDescription(Locale.US) + " " + this.reader.getOriginatingProvider().getVendorName() + " " + this.reader.getOriginatingProvider().getVersion() + " returned null image for Transfer Syntax " + this.transferSyntaxUID);
        }
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): Back from reader.read() BufferedImage={}", bufferedImage);
        bufferedImage = this.makeNewBufferedImageIfNecessary(bufferedImage, this.colorSpace);
        slf4jlogger.debug("getDecompressedFrameAsBufferedImageUsingImageReader(): returning image = {}", bufferedImage);
        return bufferedImage;
    }

    private BufferedImage makeNewBufferedImageIfNecessary(BufferedImage bufferedImage, ColorSpace colorSpace) {
        slf4jlogger.debug("makeNewBufferedImage(): starting with BufferedImage: {}", BufferedImageUtilities.describeImage(bufferedImage));
        BufferedImage bufferedImage2 = bufferedImage;
        Raster raster = bufferedImage.getData();
        if (raster.getTransferType() == 0 && raster.getNumBands() > 1) {
            slf4jlogger.debug("makeNewBufferedImageIfNecessary(): have multiband byte image - making a new image from it");
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            byte[] byArray = (byte[])raster.getDataElements(0, 0, n, n2, null);
            if (byArray != null) {
                ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
                ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 3, n * 3, new int[]{0, 1, 2});
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, 0);
                WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
                bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, true, null);
            }
        }
        slf4jlogger.debug("makeNewBufferedImage(): finishing with BufferedImage: {}", BufferedImageUtilities.describeImage(bufferedImage2));
        return bufferedImage2;
    }

    public void dispose() throws Throwable {
        slf4jlogger.debug("dispose()");
        if (this.reader != null) {
            try {
                slf4jlogger.debug("dispose(): Calling dispose() on reader");
                this.reader.dispose();
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected class ByteArrayInputStreamWithOffsetCounterAndOurMethods
    extends InputStream {
        protected byte[] buf;
        protected int pos;
        protected int count;

        public ByteArrayInputStreamWithOffsetCounterAndOurMethods(byte[] byArray) {
            this.buf = byArray;
            this.pos = 0;
            this.count = byArray.length;
        }

        @Override
        public int read() {
            int n = -1;
            if (this.pos < this.count) {
                n = this.buf[this.pos++] & 0xFF;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            int n3 = this.count - this.pos;
            if (n3 < 0) {
                n2 = -1;
            } else {
                if (n2 > n3) {
                    n2 = n3;
                }
                System.arraycopy(this.buf, this.pos, byArray, n, n2);
                this.pos += n2;
            }
            return n2;
        }

        @Override
        public long skip(long l) {
            long l2 = (long)this.count - (long)this.pos;
            if (l2 < 0L) {
                l = 0L;
            } else if (l > l2) {
                l = l2;
            }
            this.pos += (int)l;
            return l;
        }

        @Override
        public int available() {
            return this.count - this.pos;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        public final long readUnsigned32LittleEndian() {
            byte[] byArray = new byte[4];
            this.read(byArray, 0, 4);
            long l = (long)byArray[0] & 0xFFL;
            long l2 = (long)byArray[1] & 0xFFL;
            long l3 = (long)byArray[2] & 0xFFL;
            long l4 = (long)byArray[3] & 0xFFL;
            return ((l4 << 8 | l3) << 8 | l2) << 8 | l;
        }

        public final void readUnsigned32LittleEndian(long[] lArray, int n, int n2) throws IOException {
            int n3 = n2 * 4;
            byte[] byArray = new byte[n3];
            this.read(byArray, 0, n3);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                long l = (long)byArray[n4++] & 0xFFL;
                long l2 = (long)byArray[n4++] & 0xFFL;
                long l3 = (long)byArray[n4++] & 0xFFL;
                long l4 = (long)byArray[n4++] & 0xFFL;
                lArray[n + i] = ((l4 << 8 | l3) << 8 | l2) << 8 | l;
            }
        }

        public void skipInsistently(long l) throws IOException {
            long l2;
            for (long i = l; i > 0L; i -= l2) {
                l2 = this.skip(i);
                if (l2 > 0L) continue;
                throw new IOException("skip failed with " + i + " bytes remaining to be skipped, wanted " + l);
            }
        }

        public int getOffsetOfNextByteToReadFromStartOfFragment() {
            return this.pos;
        }
    }
}

