/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.FloatFormatter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

public class DecimalStringAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DecimalStringAttribute.java,v 1.27 2025/01/29 10:58:06 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 16;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 16;
    }

    public DecimalStringAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public DecimalStringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public DecimalStringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.DS;
    }

    @Override
    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        if (numberFormat == null) {
            stringArray = super.getStringValues(null);
        } else {
            double[] dArray = this.getDoubleValues();
            if (dArray != null) {
                stringArray = new String[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    stringArray[i] = numberFormat.format(dArray[i]);
                }
            }
        }
        return stringArray;
    }

    @Override
    public void addValue(long l) throws DicomException {
        this.addValue(FloatFormatter.toStringOfFixedMaximumLength(l, 16, false, Locale.US));
    }

    @Override
    public void addValue(float f) throws DicomException {
        this.addValue(FloatFormatter.toStringOfFixedMaximumLength(f, 16, false, Locale.US));
    }

    @Override
    public void addValue(double d) throws DicomException {
        this.addValue(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.US));
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && (Character.isDigit(n) || n == 32 || n == 43 || n == 45 || n == 46 || n == 101 || n == 69);
    }

    @Override
    public boolean repairValues() throws DicomException {
        if (!this.isValid()) {
            this.flushCachedCopies();
            this.originalByteValues = null;
            if (this.originalValues != null && this.originalValues.length > 0) {
                for (int i = 0; i < this.originalValues.length; ++i) {
                    String string = this.originalValues[i];
                    if (string == null || string.length() <= 0) continue;
                    this.originalValues[i] = string.trim();
                    try {
                        double d = Double.parseDouble(this.originalValues[i]);
                        this.originalValues[i] = FloatFormatter.toStringOfFixedMaximumLength(d, 16, false, Locale.US);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.isValid();
    }
}

