/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class EncapsulatedInputStream
extends InputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/EncapsulatedInputStream.java,v 1.37 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(EncapsulatedInputStream.class);
    private BinaryInputStream i;
    private boolean jpegEOIDetection;
    private boolean oneFragmentPerFrame;
    private boolean bigEndian;
    private byte[] buffer;
    private boolean firstTime;
    private byte[] fragment;
    private int fragmentSize;
    private int fragmentOffset;
    private int fragmentRemaining;
    private boolean sequenceDelimiterEncountered;
    private boolean endOfFrameEncountered;
    private boolean currentFragmentContainsEndOfFrame;
    private long bytesRead;
    private List<Long> listOfByteOffsetsOfItemsForCurrentFrame = new ArrayList<Long>();
    private List<Long> listOfItemLengthsForCurrentFrame = new ArrayList<Long>();

    protected long getBytesRead() {
        return this.bytesRead;
    }

    public long[] getByteOffsetsOfItemsForCurrentFrame(long l) {
        long[] lArray = new long[this.listOfByteOffsetsOfItemsForCurrentFrame.size()];
        for (int i = 0; i < this.listOfByteOffsetsOfItemsForCurrentFrame.size(); ++i) {
            lArray[i] = this.listOfByteOffsetsOfItemsForCurrentFrame.get(i) + l;
            slf4jlogger.debug("getByteOffsetsOfItemsForCurrentFrame(): {} for item {}", lArray[i], i);
        }
        return lArray;
    }

    public long[] getItemLengthsForCurrentFrame() {
        long[] lArray = new long[this.listOfItemLengthsForCurrentFrame.size()];
        for (int i = 0; i < this.listOfItemLengthsForCurrentFrame.size(); ++i) {
            lArray[i] = this.listOfItemLengthsForCurrentFrame.get(i);
            slf4jlogger.debug("getItemLengthsForCurrentFrame(): {} for item {}", lArray[i], i);
        }
        return lArray;
    }

    private AttributeTag readAttributeTag() throws IOException {
        int n = this.i.readUnsigned16();
        int n2 = this.i.readUnsigned16();
        slf4jlogger.debug("readAttributeTag(): back from reading group and element");
        this.bytesRead += 4L;
        return new AttributeTag(n, n2);
    }

    private long readItemTag() throws IOException {
        AttributeTag attributeTag = this.readAttributeTag();
        slf4jlogger.debug("readItemTag(): tag={}", attributeTag);
        long l = this.i.readUnsigned32();
        slf4jlogger.debug("readItemTag(): back from reading vl={}", l);
        this.bytesRead += 4L;
        if (attributeTag.equals(TagFromName.SequenceDelimitationItem)) {
            slf4jlogger.debug("readItemTag: SequenceDelimitationItem");
            l = 0L;
            this.sequenceDelimiterEncountered = true;
        } else if (!attributeTag.equals(TagFromName.Item)) {
            slf4jlogger.debug("readItemTag(): not an Item tag - throwing an IOException");
            throw new IOException("Unexpected DICOM tag " + attributeTag + " (vl=" + l + ") in encapsulated data whilst expecting Item or SequenceDelimitationItem");
        }
        slf4jlogger.debug("readItemTag(): length={}", l);
        return l;
    }

    public void readSequenceDelimiter() throws IOException {
        slf4jlogger.debug("readSequenceDelimiter():");
        if (!this.sequenceDelimiterEncountered) {
            slf4jlogger.debug("readSequenceDelimiter(): have not yet encountered SequenceDelimiter ... trying readItemTag()");
            this.readItemTag();
        }
        slf4jlogger.debug("readSequenceDelimiter(): sequenceDelimiterEncountered is " + this.sequenceDelimiterEncountered + " after trying readItemTag()");
        if (!this.sequenceDelimiterEncountered) {
            slf4jlogger.debug("readSequenceDelimiter(): sequenceDelimiterEncountered is false - throwing an IOException");
            throw new IOException("Expected DICOM Sequence Delimitation Item tag in encapsulated data");
        }
    }

    public EncapsulatedInputStream(BinaryInputStream binaryInputStream, boolean bl, boolean bl2) {
        this.i = binaryInputStream;
        this.jpegEOIDetection = bl;
        slf4jlogger.debug("jpegEOIDetection={}", bl);
        this.oneFragmentPerFrame = bl2;
        slf4jlogger.debug("oneFragmentPerFrame={}", bl2);
        this.bigEndian = binaryInputStream.isBigEndian();
        this.buffer = new byte[8];
        this.fragment = null;
        this.firstTime = true;
        this.sequenceDelimiterEncountered = false;
        this.endOfFrameEncountered = false;
    }

    public EncapsulatedInputStream(BinaryInputStream binaryInputStream) {
        this(binaryInputStream, true, false);
    }

    public void nextFrame() {
        slf4jlogger.debug("nextFrame()");
        if (this.fragment == null) {
            slf4jlogger.debug("nextFrame(): fragment already null");
        } else if (this.fragmentOffset == 0) {
            slf4jlogger.debug("nextFrame(): fragment already positioned at start of next fragment");
        } else {
            slf4jlogger.debug("nextFrame(): fragment was not already null or positioned at start of next fragment: fragmentOffset = {}", this.fragmentOffset);
            this.fragment = null;
        }
        this.endOfFrameEncountered = false;
        this.listOfByteOffsetsOfItemsForCurrentFrame.clear();
        this.listOfItemLengthsForCurrentFrame.clear();
    }

    public final void readUnsigned16(short[] sArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2 * 2;
        byte[] byArray = new byte[n4];
        this.read(byArray, 0, n4);
        this.bytesRead += (long)n4;
        int n5 = 0;
        if (this.bigEndian) {
            for (n3 = 0; n3 < n2; ++n3) {
                sArray[n + n3] = (short)((byArray[n5++] << 8) + (byArray[n5++] & 0xFF));
            }
        } else {
            while (n3 < n2) {
                sArray[n + n3] = (short)((byArray[n5++] & 0xFF) + (byArray[n5++] << 8));
                ++n3;
            }
        }
    }

    public final long readUnsigned32LittleEndian() throws IOException {
        byte[] byArray = new byte[4];
        this.read(byArray, 0, 4);
        long l = (long)byArray[0] & 0xFFL;
        long l2 = (long)byArray[1] & 0xFFL;
        long l3 = (long)byArray[2] & 0xFFL;
        long l4 = (long)byArray[3] & 0xFFL;
        return ((l4 << 8 | l3) << 8 | l2) << 8 | l;
    }

    public final void readUnsigned32LittleEndian(long[] lArray, int n, int n2) throws IOException {
        int n3 = n2 * 4;
        byte[] byArray = new byte[n3];
        this.read(byArray, 0, n3);
        this.bytesRead += (long)n3;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            long l = (long)byArray[n4++] & 0xFFL;
            long l2 = (long)byArray[n4++] & 0xFFL;
            long l3 = (long)byArray[n4++] & 0xFFL;
            long l4 = (long)byArray[n4++] & 0xFFL;
            lArray[n + i] = ((l4 << 8 | l3) << 8 | l2) << 8 | l;
        }
    }

    public void skipInsistently(long l) throws IOException {
        long l2;
        for (long i = l; i > 0L; i -= l2) {
            l2 = this.skip(i);
            if (l2 > 0L) continue;
            throw new IOException("skip failed with " + i + " bytes remaining to be skipped, wanted " + l);
        }
    }

    @Override
    public final int read() throws IOException {
        int n = this.read(this.buffer, 0, 1);
        return n == -1 ? -1 : this.buffer[0] & 0xFF;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        slf4jlogger.debug("read(byte []," + n + "," + n2 + ")");
        slf4jlogger.debug("read() at start, fragmentRemaining={}", this.fragmentRemaining);
        slf4jlogger.debug("read() at start, endOfFrameEncountered={}", this.endOfFrameEncountered);
        slf4jlogger.debug("read() at start, currentFragmentContainsEndOfFrame={}", this.currentFragmentContainsEndOfFrame);
        if (this.endOfFrameEncountered) {
            slf4jlogger.debug("read() returning -1 since endOfFrameEncountered");
            return -1;
        }
        int n3 = 0;
        int n4 = n2;
        int n5 = n;
        while (n4 > 0 && !this.sequenceDelimiterEncountered && !this.endOfFrameEncountered) {
            slf4jlogger.debug("read() remainingToDo={}", n4);
            if (this.fragment == null) {
                long l;
                if (this.firstTime) {
                    slf4jlogger.debug("read() firstTime");
                    l = this.readItemTag();
                    if (this.sequenceDelimiterEncountered) {
                        throw new IOException("Expected offset table item tag; got sequence delimiter");
                    }
                    slf4jlogger.debug("read() skipping offsetTableLength={}", l);
                    this.i.skipInsistently(l);
                    this.bytesRead += l;
                    this.firstTime = false;
                }
                slf4jlogger.debug("read() loading a new fragment");
                l = this.readItemTag();
                if (l != 0L) {
                    this.currentFragmentContainsEndOfFrame = false;
                    this.fragmentRemaining = this.fragmentSize = (int)l;
                    if (this.fragment == null || this.fragment.length < this.fragmentSize) {
                        this.fragment = new byte[this.fragmentSize];
                    }
                    slf4jlogger.debug("read() bytesRead at start of frame (ByteOffsetsOfItemsForCurrentFrame)={}", this.bytesRead);
                    this.listOfByteOffsetsOfItemsForCurrentFrame.add(new Long(this.bytesRead));
                    this.i.readInsistently(this.fragment, 0, this.fragmentSize);
                    this.bytesRead += (long)this.fragmentSize;
                    this.fragmentOffset = 0;
                    slf4jlogger.debug("read() fragmentRemaining initially={}", this.fragmentRemaining);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("read() fragment = {}", HexDump.dump(this.fragment));
                    }
                    if (this.jpegEOIDetection) {
                        int n6 = this.fragmentRemaining - 1;
                        while (--n6 > 0) {
                            int n7 = this.fragment[n6] & 0xFF;
                            int n8 = this.fragment[n6 + 1] & 0xFF;
                            if (slf4jlogger.isDebugEnabled()) {
                                slf4jlogger.debug("read() fragment fragment[{}] = 0x{}", n6, Integer.toHexString(n7));
                            }
                            if (slf4jlogger.isDebugEnabled()) {
                                slf4jlogger.debug("read() fragment fragment[{}] = 0x{}", n6 + 1, Integer.toHexString(n8));
                            }
                            if (n7 != 255 || n8 != 217) continue;
                            this.currentFragmentContainsEndOfFrame = true;
                            break;
                        }
                        slf4jlogger.debug("read() positionOfEOI={}", n6);
                        if (n6 > 0) {
                            this.fragmentRemaining = n6 + 2;
                        }
                        slf4jlogger.debug("read() fragmentRemaining after removing trailing padding={}", this.fragmentRemaining);
                        this.listOfItemLengthsForCurrentFrame.add(new Long(this.fragmentRemaining));
                    } else if (this.oneFragmentPerFrame) {
                        this.currentFragmentContainsEndOfFrame = true;
                    }
                }
            }
            int n9 = n4 < this.fragmentRemaining ? n4 : this.fragmentRemaining;
            slf4jlogger.debug("read() amountToCopyFromThisFragment={}", n9);
            if (n9 > 0) {
                System.arraycopy(this.fragment, this.fragmentOffset, byArray, n, n9);
                n += n9;
                this.fragmentOffset += n9;
                this.fragmentRemaining -= n9;
                n4 -= n9;
                n3 += n9;
            }
            if (this.fragmentRemaining > 0) continue;
            this.fragment = null;
            if (!this.currentFragmentContainsEndOfFrame) continue;
            this.endOfFrameEncountered = true;
        }
        slf4jlogger.debug("read() returning count={}", n3);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("read() returning={}", HexDump.dump(byArray, n5, n3));
        }
        return n3 == 0 ? -1 : n3;
    }

    public int getOffsetOfNextByteToReadFromStartOfFragment() {
        return this.fragmentOffset;
    }

    public boolean framesAreSeparated() {
        return this.jpegEOIDetection || this.oneFragmentPerFrame;
    }
}

