/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HierarchicalSOPInstanceReference {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/HierarchicalSOPInstanceReference.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    protected String studyInstanceUID;
    protected String seriesInstanceUID;
    protected String sopInstanceUID;
    protected String sopClassUID;

    public HierarchicalSOPInstanceReference(String string, String string2, String string3, String string4) {
        this.studyInstanceUID = string;
        this.seriesInstanceUID = string2;
        this.sopInstanceUID = string3;
        this.sopClassUID = string4;
    }

    public HierarchicalSOPInstanceReference(HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference) {
        this.studyInstanceUID = hierarchicalSOPInstanceReference.getStudyInstanceUID();
        this.seriesInstanceUID = hierarchicalSOPInstanceReference.getSeriesInstanceUID();
        this.sopInstanceUID = hierarchicalSOPInstanceReference.getSOPInstanceUID();
        this.sopClassUID = hierarchicalSOPInstanceReference.getSOPClassUID();
    }

    public HierarchicalSOPInstanceReference(AttributeList attributeList) {
        this.studyInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyInstanceUID);
        this.seriesInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesInstanceUID);
        this.sopInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
        this.sopClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public static Map<String, HierarchicalSOPInstanceReference> findHierarchicalReferencesToSOPInstancesInStructuredReport(AttributeList attributeList) {
        Attribute attribute;
        HashMap<String, HierarchicalSOPInstanceReference> hashMap = new HashMap<String, HierarchicalSOPInstanceReference>();
        if (attributeList != null && (attribute = attributeList.get(TagFromName.CurrentRequestedProcedureEvidenceSequence)) != null && attribute instanceof SequenceAttribute) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = iterator.next();
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                if (attributeList2 == null) continue;
                String string = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.StudyInstanceUID);
                Attribute attribute2 = attributeList2.get(TagFromName.ReferencedSeriesSequence);
                if (string == null || string.length() <= 0 || attribute2 == null || !(attribute2 instanceof SequenceAttribute)) continue;
                SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attribute2;
                Iterator<SequenceItem> iterator2 = sequenceAttribute2.iterator();
                while (iterator2.hasNext()) {
                    SequenceItem sequenceItem2 = iterator2.next();
                    AttributeList attributeList3 = sequenceItem2.getAttributeList();
                    if (attributeList3 == null) continue;
                    String string2 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.SeriesInstanceUID);
                    Attribute attribute3 = attributeList3.get(TagFromName.ReferencedSOPSequence);
                    if (string2 == null || string2.length() <= 0 || attribute3 == null || !(attribute3 instanceof SequenceAttribute)) continue;
                    SequenceAttribute sequenceAttribute3 = (SequenceAttribute)attribute3;
                    Iterator<SequenceItem> iterator3 = sequenceAttribute3.iterator();
                    while (iterator3.hasNext()) {
                        SequenceItem sequenceItem3 = iterator3.next();
                        AttributeList attributeList4 = sequenceItem3.getAttributeList();
                        String string3 = Attribute.getSingleStringValueOrNull(attributeList4, TagFromName.ReferencedSOPClassUID);
                        String string4 = Attribute.getSingleStringValueOrNull(attributeList4, TagFromName.ReferencedSOPInstanceUID);
                        if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                        hashMap.put(string4, new HierarchicalSOPInstanceReference(string, string2, string4, string3));
                    }
                }
            }
        }
        return hashMap;
    }

    public static Map<String, HierarchicalSOPInstanceReference> findHierarchicalReferencesToSOPInstances(AttributeList attributeList) {
        HashMap<String, HierarchicalSOPInstanceReference> hashMap = new HashMap<String, HierarchicalSOPInstanceReference>();
        HierarchicalSOPInstanceReference.addToHierarchicalReferencesToSOPInstances(attributeList, hashMap);
        return hashMap;
    }

    public static void addToHierarchicalReferencesToSOPInstances(AttributeList attributeList, Map<String, HierarchicalSOPInstanceReference> map) {
        HierarchicalSOPInstanceReference.addToHierarchicalReferencesToSOPInstances(attributeList, map, null, null, true);
    }

    private static void addToHierarchicalReferencesToSOPInstances(AttributeList attributeList, Map<String, HierarchicalSOPInstanceReference> map, String string, String string2, boolean bl) {
        if (attributeList != null) {
            Object object;
            Object object2;
            Object object3;
            String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPClassUID);
            String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPInstanceUID);
            if (!bl) {
                string2 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.SeriesInstanceUID, string2);
                string = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.StudyInstanceUID, string);
            }
            if (string4 != null && string4.length() > 0) {
                Object object4 = string3;
                Object object5 = string2;
                object3 = string;
                object2 = map.get(string4);
                if (object2 != null) {
                    if (object4 == null) {
                        object4 = ((HierarchicalSOPInstanceReference)object2).getSOPClassUID();
                    }
                    if (object5 == null) {
                        object5 = ((HierarchicalSOPInstanceReference)object2).getSeriesInstanceUID();
                    }
                    if (object3 == null) {
                        object3 = ((HierarchicalSOPInstanceReference)object2).getStudyInstanceUID();
                    }
                }
                object = new HierarchicalSOPInstanceReference((String)object3, (String)object5, string4, (String)object4);
                map.put(string4, (HierarchicalSOPInstanceReference)object);
            }
            for (Object object5 : attributeList.values()) {
                if (!(object5 instanceof SequenceAttribute)) continue;
                object3 = (SequenceAttribute)object5;
                object2 = ((SequenceAttribute)object3).iterator();
                while (object2.hasNext()) {
                    object = (SequenceItem)object2.next();
                    AttributeList attributeList2 = ((SequenceItem)object).getAttributeList();
                    if (attributeList2 == null) continue;
                    HierarchicalSOPInstanceReference.addToHierarchicalReferencesToSOPInstances(attributeList2, map, string, string2, false);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Study: ");
        stringBuffer.append(this.studyInstanceUID);
        stringBuffer.append(", ");
        stringBuffer.append("Series: ");
        stringBuffer.append(this.seriesInstanceUID);
        stringBuffer.append(", ");
        stringBuffer.append("Instance: ");
        stringBuffer.append(this.sopInstanceUID);
        stringBuffer.append(", ");
        stringBuffer.append("Class: ");
        stringBuffer.append(this.sopClassUID);
        return stringBuffer.toString();
    }

    public static String toString(Map<String, HierarchicalSOPInstanceReference> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = map.get(string);
            stringBuffer.append(hierarchicalSOPInstanceReference);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0]);
            System.err.println("Result of findHierarchicalReferencesToSOPInstancesInStructuredReport():");
            Map<String, HierarchicalSOPInstanceReference> map = HierarchicalSOPInstanceReference.findHierarchicalReferencesToSOPInstancesInStructuredReport(attributeList);
            System.err.println(HierarchicalSOPInstanceReference.toString(map));
            System.err.println("Result of findHierarchicalReferencesToSOPInstances():");
            map = HierarchicalSOPInstanceReference.findHierarchicalReferencesToSOPInstances(attributeList);
            HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = new HierarchicalSOPInstanceReference(attributeList);
            map.put(hierarchicalSOPInstanceReference.getSOPInstanceUID(), hierarchicalSOPInstanceReference);
            System.err.println(HierarchicalSOPInstanceReference.toString(map));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

