/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.HierarchicalImageReference;
import com.pixelmed.dicom.HierarchicalSOPInstanceReference;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class ImageLibrary {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ImageLibrary.java,v 1.24 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ImageLibrary.class);
    protected Map<String, ImageLibraryEntry> entriesIndexedBySOPInstanceUID = new HashMap<String, ImageLibraryEntry>();
    protected CompositeInstanceContext compositeInstanceContext;

    public ImageLibraryEntry makeImageLibraryEntry(ContentItemFactory.ImageContentItem imageContentItem, Map<String, HierarchicalSOPInstanceReference> map) {
        return new ImageLibraryEntry(imageContentItem, map);
    }

    public ImageLibraryEntry makeImageLibraryEntry(AttributeList attributeList) throws DicomException {
        return new ImageLibraryEntry(attributeList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ImageLibraryEntry imageLibraryEntry : this.entriesIndexedBySOPInstanceUID.values()) {
            stringBuffer.append(imageLibraryEntry);
        }
        return stringBuffer.toString();
    }

    public SequenceAttribute getCommonInstanceReferenceModuleReferencedSeriesSequence(String string) throws DicomException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (ImageLibraryEntry object6 : this.entriesIndexedBySOPInstanceUID.values()) {
            HierarchicalImageReference hierarchicalImageReference = object6.hierarchicalImageReference;
            object5 = hierarchicalImageReference.getStudyInstanceUID();
            if (!string.equals(object5)) continue;
            object4 = hierarchicalImageReference.getSOPInstanceUID();
            object3 = hierarchicalImageReference.getSOPClassUID();
            object2 = hierarchicalImageReference.getSeriesInstanceUID();
            if (object4 != null && ((String)object4).length() > 0 && object3 != null && ((String)object3).length() > 0 && object2 != null && ((String)object2).length() > 0 && object5 != null && ((String)object5).length() > 0) {
                hashSet.add((String)object2);
                object = (HashSet<HierarchicalImageReference>)hashMap.get(object2);
                if (object == null) {
                    object = new HashSet<HierarchicalImageReference>();
                    hashMap.put(object2, object);
                }
                object.add(hierarchicalImageReference);
                continue;
            }
            System.err.println("Cannot find hierarchical information for reference to SOP Instance UID " + (String)object4);
        }
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ReferencedSeriesSequence);
        for (String string2 : hashSet) {
            object5 = new AttributeList();
            sequenceAttribute.addItem((AttributeList)object5);
            object4 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)object4).addValue(string2);
            ((AttributeList)object5).put((Attribute)object4);
            object4 = new SequenceAttribute(TagFromName.ReferencedInstanceSequence);
            ((AttributeList)object5).put((Attribute)object4);
            object3 = (Set)hashMap.get(string2);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (HierarchicalSOPInstanceReference)object2.next();
                AttributeList attributeList = new AttributeList();
                ((SequenceAttribute)object4).addItem(attributeList);
                String string3 = ((HierarchicalSOPInstanceReference)object).getSOPInstanceUID();
                Object object6 = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
                ((Attribute)object6).addValue(string3);
                attributeList.put((Attribute)object6);
                object6 = ((HierarchicalSOPInstanceReference)object).getSOPClassUID();
                UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
                ((Attribute)uniqueIdentifierAttribute).addValue((String)object6);
                attributeList.put(uniqueIdentifierAttribute);
            }
        }
        return sequenceAttribute;
    }

    public SequenceAttribute getHierarchicalEvidenceSequence() throws DicomException {
        Cloneable cloneable;
        HashSet<String> hashSet;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        HashMap<Object, Cloneable> hashMap2 = new HashMap<Object, Cloneable>();
        for (ImageLibraryEntry object5 : this.entriesIndexedBySOPInstanceUID.values()) {
            Object object6 = object5.hierarchicalImageReference;
            object4 = ((HierarchicalSOPInstanceReference)object6).getSOPInstanceUID();
            object3 = ((HierarchicalSOPInstanceReference)object6).getSOPClassUID();
            object2 = ((HierarchicalSOPInstanceReference)object6).getSeriesInstanceUID();
            object = ((HierarchicalSOPInstanceReference)object6).getStudyInstanceUID();
            if (object4 != null && ((String)object4).length() > 0 && object3 != null && ((String)object3).length() > 0 && object2 != null && ((String)object2).length() > 0 && object != null && ((String)object).length() > 0) {
                hashSet = (HashSet<String>)hashMap.get(object);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashMap.put((String)object, hashSet);
                }
                hashSet.add((String)object2);
                cloneable = (HashSet<Object>)hashMap2.get(object2);
                if (cloneable == null) {
                    cloneable = new HashSet<Object>();
                    hashMap2.put(object2, cloneable);
                }
                cloneable.add(object6);
                continue;
            }
            System.err.println("Cannot find hierarchical information for reference to SOP Instance UID " + (String)object4);
        }
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.CurrentRequestedProcedureEvidenceSequence);
        for (Object object6 : hashMap.keySet()) {
            object4 = new AttributeList();
            sequenceAttribute.addItem((AttributeList)object4);
            object3 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)object3).addValue((String)object6);
            ((AttributeList)object4).put((Attribute)object3);
            object3 = new SequenceAttribute(TagFromName.ReferencedSeriesSequence);
            ((AttributeList)object4).put((Attribute)object3);
            object2 = (Set)hashMap.get(object6);
            object = object2.iterator();
            while (object.hasNext()) {
                hashSet = (String)object.next();
                cloneable = new AttributeList();
                ((SequenceAttribute)object3).addItem((AttributeList)cloneable);
                Attribute attribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                attribute.addValue((String)((Object)hashSet));
                ((AttributeList)cloneable).put(attribute);
                attribute = new SequenceAttribute(TagFromName.ReferencedSOPSequence);
                ((AttributeList)cloneable).put(attribute);
                Set set = (Set)hashMap2.get(hashSet);
                for (HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference : set) {
                    AttributeList attributeList = new AttributeList();
                    ((SequenceAttribute)attribute).addItem(attributeList);
                    String string = hierarchicalSOPInstanceReference.getSOPInstanceUID();
                    Object object7 = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
                    ((Attribute)object7).addValue(string);
                    attributeList.put((Attribute)object7);
                    object7 = hierarchicalSOPInstanceReference.getSOPClassUID();
                    UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
                    ((Attribute)uniqueIdentifierAttribute).addValue((String)object7);
                    attributeList.put(uniqueIdentifierAttribute);
                }
            }
        }
        return sequenceAttribute;
    }

    public static ContentItem findImageLibraryContainer(ContentItem contentItem) {
        ContentItem contentItem2 = null;
        if (contentItem != null) {
            if (contentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator("111028", "DCM")) {
                contentItem2 = contentItem;
            } else {
                int n = contentItem.getChildCount();
                for (int i = 0; contentItem2 == null && i < n; ++i) {
                    ContentItem contentItem3 = (ContentItem)contentItem.getChildAt(i);
                    contentItem2 = ImageLibrary.findImageLibraryContainer(contentItem3);
                }
            }
        }
        return contentItem2;
    }

    public ImageLibrary() {
    }

    public ImageLibrary(AttributeList attributeList) throws DicomException {
        StructuredReport structuredReport = new StructuredReport(attributeList);
        ContentItem contentItem = ImageLibrary.findImageLibraryContainer((ContentItem)structuredReport.getRoot());
        if (contentItem == null) {
            throw new DicomException("No Image Library CONTAINER content item in SR");
        }
        this.constructImageLibrary(contentItem, attributeList);
    }

    public ImageLibrary(ContentItem contentItem, AttributeList attributeList) {
        this.constructImageLibrary(contentItem, attributeList);
    }

    protected Map<String, HierarchicalSOPInstanceReference> getHierarchicalSOPInstanceReferencesIndexedBySOPInstanceUID(AttributeList attributeList) {
        HashMap<String, HierarchicalSOPInstanceReference> hashMap = new HashMap<String, HierarchicalSOPInstanceReference>();
        Attribute attribute = attributeList.get(TagFromName.CurrentRequestedProcedureEvidenceSequence);
        if (attribute != null && attribute instanceof SequenceAttribute) {
            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = iterator.next().getAttributeList();
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.StudyInstanceUID);
                Attribute attribute2 = attributeList2.get(TagFromName.ReferencedSeriesSequence);
                if (attribute2 == null || !(attribute2 instanceof SequenceAttribute)) continue;
                Iterator<SequenceItem> iterator2 = ((SequenceAttribute)attribute2).iterator();
                while (iterator2.hasNext()) {
                    AttributeList attributeList3 = iterator2.next().getAttributeList();
                    String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList3, TagFromName.SeriesInstanceUID);
                    Attribute attribute3 = attributeList3.get(TagFromName.ReferencedSOPSequence);
                    if (attribute3 == null || !(attribute3 instanceof SequenceAttribute)) continue;
                    Iterator<SequenceItem> iterator3 = ((SequenceAttribute)attribute3).iterator();
                    while (iterator3.hasNext()) {
                        AttributeList attributeList4 = iterator3.next().getAttributeList();
                        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList4, TagFromName.ReferencedSOPInstanceUID);
                        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList4, TagFromName.ReferencedSOPClassUID);
                        HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = new HierarchicalSOPInstanceReference(string, string2, string3, string4);
                        hashMap.put(string3, hierarchicalSOPInstanceReference);
                    }
                }
            }
        }
        return hashMap;
    }

    protected void constructImageLibrary(ContentItem contentItem, AttributeList attributeList) {
        Map<String, HierarchicalSOPInstanceReference> map = this.getHierarchicalSOPInstanceReferencesIndexedBySOPInstanceUID(attributeList);
        if (contentItem != null) {
            int n = contentItem.getChildCount();
            for (int i = 0; i < n; ++i) {
                ContentItem contentItem2 = (ContentItem)contentItem.getChildAt(i);
                if (contentItem2 == null || !(contentItem2 instanceof ContentItemFactory.ImageContentItem)) continue;
                ContentItemFactory.ImageContentItem imageContentItem = (ContentItemFactory.ImageContentItem)contentItem2;
                String string = imageContentItem.getReferencedSOPInstanceUID();
                ImageLibraryEntry imageLibraryEntry = this.makeImageLibraryEntry(imageContentItem, map);
                this.entriesIndexedBySOPInstanceUID.put(string, imageLibraryEntry);
            }
        }
    }

    public ContentItem getStructuredReportFragment(ContentItem contentItem) throws DicomException {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(contentItem, contentItem == null ? null : "CONTAINS", new CodedSequenceItem("111028", "DCM", "Image Library"), true);
        for (ImageLibraryEntry imageLibraryEntry : this.entriesIndexedBySOPInstanceUID.values()) {
            imageLibraryEntry.getImageContentItem(contentItemFactory, containerContentItem);
        }
        return containerContentItem;
    }

    public StructuredReport getStructuredReport() throws DicomException {
        ContentItemFactory contentItemFactory = new ContentItemFactory();
        ContentItem contentItem = this.getStructuredReportFragment(null);
        return new StructuredReport(contentItem);
    }

    public AttributeList getAttributeList() throws DicomException {
        StructuredReport structuredReport = this.getStructuredReport();
        AttributeList attributeList = structuredReport.getAttributeList();
        SequenceAttribute sequenceAttribute = this.getHierarchicalEvidenceSequence();
        if (sequenceAttribute != null) {
            attributeList.put(sequenceAttribute);
        }
        if (this.compositeInstanceContext != null) {
            attributeList.putAll(this.compositeInstanceContext.getAttributeList());
        }
        UIDGenerator uIDGenerator = new UIDGenerator();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue("3254");
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue("1");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object).addValue("Image Library");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.CompletionFlag);
        ((Attribute)object).addValue("COMPLETE");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.VerificationFlag);
        ((Attribute)object).addValue("UNVERIFIED");
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.88.22");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)object).addValue("SR");
        attributeList.put((Attribute)object);
        object = new Date();
        String string = new SimpleDateFormat("yyyyMMdd").format((Date)object);
        String string2 = new SimpleDateFormat("HHmmss.SSS").format((Date)object);
        Object object2 = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object2).addValue(string2);
        attributeList.put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object2).addValue(string2);
        attributeList.put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)object2).addValue(string2);
        attributeList.put((Attribute)object2);
        object2 = TimeZone.getDefault();
        String string3 = DateTimeAttribute.getTimeZone((TimeZone)object2, (Date)object);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TimezoneOffsetFromUTC);
        if (string4.length() > 0) {
            if (!string3.equals(string4)) {
                slf4jlogger.info("getAttributeList(): Warning - TimezoneOffsetFromUTC from images {} is different from current timezone {} - removing and not adding current", string4, string3);
                attributeList.remove(TagFromName.TimezoneOffsetFromUTC);
            }
        } else {
            ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
            ((Attribute)shortStringAttribute).addValue(string3);
            attributeList.put(shortStringAttribute);
        }
        object2 = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object2).addValue("1.3.6.1.4.1.5962.99.3");
        attributeList.put((Attribute)object2);
        object = attributeList.get(TagFromName.ReferencedPerformedProcedureStepSequence);
        if (object == null) {
            object = new SequenceAttribute(TagFromName.ReferencedPerformedProcedureStepSequence);
        }
        attributeList.put((Attribute)object);
        object = attributeList.get(TagFromName.PerformedProcedureCodeSequence);
        if (object == null) {
            object = new SequenceAttribute(TagFromName.PerformedProcedureCodeSequence);
        }
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        ((Attribute)object).addValue("PixelMed");
        attributeList.put((Attribute)object);
        this.addContributingEquipmentSequence(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        return attributeList;
    }

    protected void addContributingEquipmentSequence(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("250100", "99PMP", "Creation of Image Library SR"), "PixelMed", null, null, null, "OURAETITLE", this.getClass().getCanonicalName(), null, VersionAndConstants.getBuildDate(), "Creation of Image Library SR");
    }

    public void write(String string) throws DicomException, IOException {
        this.write(new File(string));
    }

    public void write(File file) throws DicomException, IOException {
        AttributeList attributeList = this.getAttributeList();
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
    }

    public static ImageLibrary read(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        return new ImageLibrary(attributeList);
    }

    public ImageLibraryEntry addImage(AttributeList attributeList) throws DicomException {
        ImageLibraryEntry imageLibraryEntry = null;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
        if (string.length() > 0) {
            imageLibraryEntry = this.makeImageLibraryEntry(attributeList);
            this.entriesIndexedBySOPInstanceUID.put(string, imageLibraryEntry);
        }
        return imageLibraryEntry;
    }

    public ImageLibrary(Set<File> set) throws IOException, DicomException {
        for (File file : set) {
            if (!DicomFileUtilities.isDicomOrAcrNemaFile(file)) continue;
            AttributeList attributeList = new AttributeList();
            try {
                attributeList.read(file);
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                if (!attributeList.isImage()) continue;
                this.addImage(attributeList);
                if (this.compositeInstanceContext != null) continue;
                this.compositeInstanceContext = new CompositeInstanceContext(attributeList, true);
                AttributeList attributeList2 = this.compositeInstanceContext.getAttributeList();
                Attribute attribute = attributeList2.get(TagFromName.ReferencedPerformedProcedureStepSequence);
                Attribute attribute2 = attributeList2.get(TagFromName.TimezoneOffsetFromUTC);
                this.compositeInstanceContext.removeAllButPatientAndStudy();
                if (attribute != null) {
                    attributeList2.put(attribute);
                }
                if (attribute2 == null) continue;
                attributeList2.put(attribute2);
            }
            catch (Exception exception) {
                slf4jlogger.error("While reading file \"{}\"", file, exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            HashSet<File> hashSet = new HashSet<File>();
            for (int i = 1; i < stringArray.length; ++i) {
                ArrayList<File> arrayList = FileUtilities.listFilesRecursively(new File(stringArray[i]));
                hashSet.addAll(arrayList);
            }
            ImageLibrary imageLibrary = new ImageLibrary(hashSet);
            imageLibrary.write(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static class ImageLibraryEntry {
        protected HierarchicalImageReference hierarchicalImageReference;

        protected ImageLibraryEntry() {
        }

        public ImageLibraryEntry(ContentItemFactory.ImageContentItem imageContentItem, Map<String, HierarchicalSOPInstanceReference> map) {
            String string = imageContentItem.getReferencedSOPInstanceUID();
            String string2 = imageContentItem.getReferencedSOPClassUID();
            HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = map.get(string);
            HierarchicalImageReference hierarchicalImageReference = null;
            hierarchicalImageReference = hierarchicalSOPInstanceReference == null ? new HierarchicalImageReference(null, null, string, string2) : new HierarchicalImageReference(hierarchicalSOPInstanceReference);
            this.constructImageLibraryEntry(hierarchicalImageReference);
        }

        public ImageLibraryEntry(AttributeList attributeList) {
            String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
            String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            if (string.length() > 0 && string2.length() > 0 && string3.length() > 0 && string4.length() > 0) {
                HierarchicalImageReference hierarchicalImageReference = new HierarchicalImageReference(string, string2, string3, string4);
                this.constructImageLibraryEntry(hierarchicalImageReference);
            }
        }

        public ImageLibraryEntry(HierarchicalImageReference hierarchicalImageReference) {
            this.constructImageLibraryEntry(hierarchicalImageReference);
        }

        protected void constructImageLibraryEntry(HierarchicalImageReference hierarchicalImageReference) {
            this.hierarchicalImageReference = hierarchicalImageReference;
        }

        public ContentItem getImageContentItem(ContentItemFactory contentItemFactory, ContentItem contentItem) throws DicomException {
            ContentItemFactory contentItemFactory2 = contentItemFactory;
            contentItemFactory2.getClass();
            ContentItemFactory.ImageContentItem imageContentItem = contentItemFactory2.new ContentItemFactory.ImageContentItem(contentItem, "CONTAINS", null, this.hierarchicalImageReference.getSOPClassUID(), this.hierarchicalImageReference.getSOPInstanceUID(), 0, 0, null, null, null, null);
            return imageContentItem;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Entry:\n");
            stringBuffer.append(this.hierarchicalImageReference);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

