/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.DisplayableConcept;
import com.pixelmed.anatproc.ProjectionXRayAnatomy;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.MammoDemographicAndTechniqueAnnotations;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class MoveDicomFilesIntoHierarchy {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/MoveDicomFilesIntoHierarchy.java,v 1.30 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MoveDicomFilesIntoHierarchy.class);
    protected static String defaultHierarchicalFolderName = "Sorted";
    protected static String defaultDuplicatesFolderNamePrefix = "Duplicates";
    protected static int folderNamingStrategyToUseIfUnspecified = 3;
    protected boolean includeDateTimeInSeriesFolderName = false;
    protected boolean includeInConcatenationNumberWithInstanceNumber = false;
    protected static final AttributeList.ReadTerminationStrategy terminateAfterRelationshipGroup = new OurReadTerminationStrategy();

    protected static void processFilesRecursively(File file, String string) throws SecurityException, IOException, DicomException, NoSuchAlgorithmException {
        if (file != null && file.exists()) {
            File[] fileArray;
            if (file.isFile() && (string == null || string.length() == 0 || file.getName().endsWith(string))) {
                MoveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(file);
            } else if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    MoveDicomFilesIntoHierarchy.processFilesRecursively(fileArray[i], string);
                }
            }
        }
    }

    public String makePatientLabelFromAttributes(AttributeList attributeList, int n) {
        String string;
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID).replaceAll("[^A-Za-z0-9 -]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]", " ");
        if (string2.length() == 0) {
            string2 = "NOID";
        }
        if ((string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName).replaceAll("[^A-Za-z0-9 ^=,.-]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]", " ").replaceAll("^[.]", "_")).length() == 0) {
            string = "NONAME";
        }
        return string + " [" + string2 + "]";
    }

    public String makeStudyLabelFromAttributes(AttributeList attributeList, int n) {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate).replaceAll("[^0-9]", "").trim();
        if (string.length() == 0) {
            string = "19000101";
        }
        while (string.length() < 8) {
            string = string + "0";
        }
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime).replaceFirst("[.].*$", "").replaceAll("[^0-9]", "");
        while (string2.length() < 6) {
            string2 = string2 + "0";
        }
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
        String string5 = "";
        string5 = string3.length() == 0 ? (string4.length() == 0 ? string + " " + string2 : string + " " + string2 + " [ - " + string4 + "]") : (string4.length() == 0 ? string + " " + string2 + " [" + string3 + "]" : string + " " + string2 + " [" + string3 + " - " + string4 + "]");
        return string5;
    }

    public String makeSeriesLabelFromAttributes(AttributeList attributeList, int n) {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).replaceAll("[^0-9]", "");
        while (string.length() < 3) {
            string = "0" + string;
        }
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ").toUpperCase(Locale.US);
        String string4 = "";
        string4 = string3.length() == 0 ? (string2.length() == 0 ? "Series " + string + " []" : "Series " + string + " [ - " + string2 + "]") : (string2.length() == 0 ? "Series " + string + " [" + string3 + "]" : "Series " + string + " [" + string3 + " - " + string2 + "]");
        String string5 = "";
        if (this.includeDateTimeInSeriesFolderName) {
            String string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDate).replaceAll("[^0-9]", "").trim();
            String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesTime).replaceAll("[^0-9]", "").trim();
            if (string6.length() > 0 && string7.length() > 0) {
                while (string6.length() < 8) {
                    string6 = string6 + "0";
                }
                while (string7.length() < 6) {
                    string7 = string7 + "0";
                }
                string5 = string6 + string7;
            } else {
                String string8 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDate).replaceAll("[^0-9]", "").trim();
                String string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionTime).replaceAll("[^0-9]", "").trim();
                if (string8.length() > 0 && string9.length() > 0) {
                    while (string8.length() < 8) {
                        string8 = string8 + "0";
                    }
                    while (string9.length() < 6) {
                        string9 = string9 + "0";
                    }
                    string5 = string8 + string9;
                } else {
                    String string10 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDateTime).replaceAll("[^0-9+-]", "").trim();
                    if (string10.length() > 0) {
                        string5 = string10;
                    }
                }
            }
            if (string5.length() > 0) {
                string4 = string4 + " " + string5;
            }
        }
        return string4;
    }

    private String makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView(AttributeList attributeList) {
        slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView():");
        String string = "";
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber).replaceAll("[^0-9]", "").trim();
        slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView(): instanceNumber = {}", string2);
        String string3 = this.includeInConcatenationNumberWithInstanceNumber ? Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InConcatenationNumber).replaceAll("[^0-9]", "").trim() : "";
        slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView(): includeInConcatenationNumberWithInstanceNumber {} inConcatenationNumber = {}", this.includeInConcatenationNumberWithInstanceNumber, string3);
        if (string2.length() > 0) {
            while (string2.length() < 6) {
                string2 = "0" + string2;
            }
            if (string3.length() > 0) {
                while (string3.length() < 6) {
                    string3 = "0" + string3;
                }
            }
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality);
            if (string7.equals("MG")) {
                string4 = "BREAST";
            } else if (string7.equals("CT") || string7.equals("MR") || string7.equals("PT")) {
                DisplayableAnatomicConcept displayableAnatomicConcept = CTAnatomy.findAnatomicConcept(attributeList);
                if (displayableAnatomicConcept != null) {
                    string4 = displayableAnatomicConcept.getCodeStringEquivalent();
                }
            } else {
                DisplayableConcept displayableConcept;
                DisplayableAnatomicConcept displayableAnatomicConcept = ProjectionXRayAnatomy.findAnatomicConcept(attributeList);
                if (displayableAnatomicConcept != null) {
                    string4 = displayableAnatomicConcept.getCodeMeaning().toUpperCase().replaceAll("[ ]", "").trim();
                    displayableConcept = ProjectionXRayAnatomy.findLaterality(attributeList, displayableAnatomicConcept);
                    if (displayableConcept != null) {
                        string5 = displayableConcept.getCodeStringEquivalent();
                    }
                }
                if ((displayableConcept = ProjectionXRayAnatomy.findView(attributeList)) != null) {
                    string6 = displayableConcept.getCodeStringEquivalent();
                }
            }
            string7 = "";
            if (string5.length() > 0 && string6.length() > 0) {
                string7 = string5 + string6;
            } else {
                string7 = MammoDemographicAndTechniqueAnnotations.getAbbreviationFromImageLateralityViewModifierAndViewModifierCodeSequenceAttributes(attributeList);
                if (string7.length() == 0) {
                    if (string5.length() == 0) {
                        string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ImageLaterality).toUpperCase().replaceAll("[^A-Z0-9]", "").trim();
                    }
                    if (string5.length() == 0) {
                        string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Laterality).toUpperCase().replaceAll("[^A-Z0-9]", "").trim();
                    }
                    if (string6.length() == 0) {
                        string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ViewPosition).toUpperCase().replaceAll("[^A-Z0-9]", "").trim();
                    }
                    string7 = string5 + string6;
                }
            }
            string = string2 + (string3.length() == 0 ? "" : "_" + string3) + (string4.length() == 0 ? "" : "_" + string4) + (string7.length() == 0 ? "" : "_" + string7) + ".dcm";
            slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView(): instanceLabel = {}", string);
        }
        if (string.length() == 0) {
            slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView(): no instanceLabel so using SOPInstanceUID");
            string = this.makeInstanceLabelFromAttributesUsingSOPInstanceUID(attributeList);
        }
        return string;
    }

    private String makeInstanceLabelFromAttributesUsingInstanceNumberOnly(AttributeList attributeList) {
        String string = "";
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber).replaceAll("[^0-9]", "").trim();
        slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberOnly(): instanceNumber = {}", string2);
        String string3 = this.includeInConcatenationNumberWithInstanceNumber ? Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InConcatenationNumber).replaceAll("[^0-9]", "").trim() : "";
        slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberOnly(): includeInConcatenationNumberWithInstanceNumber {} inConcatenationNumber = {}", this.includeInConcatenationNumberWithInstanceNumber, string3);
        if (string2.length() > 0) {
            while (string2.length() < 6) {
                string2 = "0" + string2;
            }
            if (string3.length() > 0) {
                while (string3.length() < 6) {
                    string3 = "0" + string3;
                }
            }
            string = string2 + (string3.length() == 0 ? "" : "_" + string3) + ".dcm";
        }
        if (string.length() == 0) {
            slf4jlogger.debug("makeInstanceLabelFromAttributesUsingInstanceNumberOnly(): no instanceLabel so using SOPInstanceUID");
            string = this.makeInstanceLabelFromAttributesUsingSOPInstanceUID(attributeList);
        }
        return string;
    }

    private String makeInstanceLabelFromAttributesUsingSOPInstanceUID(AttributeList attributeList) {
        String string = "";
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID).replaceAll("[^0-9.]", "").trim();
        if (string2.length() > 0) {
            string = string2 + ".dcm";
        }
        return string;
    }

    private String makeInstanceLabelFromAttributesUsingSOPInstanceUIDUncleaned(AttributeList attributeList) {
        String string = "";
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID).trim();
        if (string2.length() > 0) {
            string = string2 + ".dcm";
        }
        return string;
    }

    public String makeInstanceLabelFromAttributes(AttributeList attributeList, int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.makeInstanceLabelFromAttributesUsingSOPInstanceUID(attributeList);
                break;
            }
            case 1: {
                string = this.makeInstanceLabelFromAttributesUsingInstanceNumberOnly(attributeList);
                break;
            }
            case 2: {
                string = this.makeInstanceLabelFromAttributesUsingInstanceNumberAnatomyLateralityView(attributeList);
                break;
            }
            case 3: {
                string = this.makeInstanceLabelFromAttributesUsingSOPInstanceUIDUncleaned(attributeList);
            }
        }
        return string;
    }

    public String makeHierarchicalPathFromAttributes(AttributeList attributeList, int n) {
        String string = "";
        String string2 = this.makeInstanceLabelFromAttributes(attributeList, n);
        if (string2.length() > 0) {
            string = this.makePatientLabelFromAttributes(attributeList, n) + "/" + this.makeStudyLabelFromAttributes(attributeList, n) + "/" + this.makeSeriesLabelFromAttributes(attributeList, n) + "/" + string2;
        }
        return string;
    }

    public static String makeHierarchicalPathFromAttributes(AttributeList attributeList) {
        MoveDicomFilesIntoHierarchy moveDicomFilesIntoHierarchy = new MoveDicomFilesIntoHierarchy();
        return moveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList, folderNamingStrategyToUseIfUnspecified);
    }

    public String renameFileWithHierarchicalPathFromAttributes(File file, AttributeList attributeList, String string, String string2, int n) throws IOException, DicomException, NoSuchAlgorithmException {
        boolean bl = false;
        File file2 = null;
        String string3 = this.makeHierarchicalPathFromAttributes(attributeList, n);
        if (string3.length() > 0) {
            file2 = new File(string, string3);
            if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
                System.err.println("\"" + file + "\": source and destination same - doing nothing");
            } else {
                int n2 = 0;
                boolean bl2 = false;
                boolean bl3 = false;
                while (!bl2) {
                    File file3 = file2.getParentFile();
                    if (file3 != null && !file3.exists() && !file3.mkdirs()) {
                        System.err.println("\"" + file + "\": parent directory creation failed for \"" + file2 + "\"");
                    }
                    if (file2.exists()) {
                        if (FileUtilities.md5(file.getCanonicalPath()).equals(FileUtilities.md5(file2.getCanonicalPath()))) {
                            System.err.println("\"" + file + "\": destination exists and is identical - not overwriting - removing original \"" + file2 + "\"");
                            if (!file.delete()) {
                                System.err.println("\"" + file + "\": deletion of duplicate original unsuccessful");
                            }
                            bl3 = true;
                            bl2 = true;
                            continue;
                        }
                        System.err.println("\"" + file + "\": destination exists and is different - not overwriting - move duplicate elsewhere \"" + file2 + "\"");
                        boolean bl4 = false;
                        file2 = new File(string2 + "_" + Integer.toString(++n2), string3);
                        continue;
                    }
                    bl2 = true;
                }
                if (!bl3) {
                    if (file.renameTo(file2)) {
                        bl = true;
                        System.err.println("\"" + file + "\" moved to \"" + file2 + "\"");
                    } else {
                        System.err.println("\"" + file + "\": move attempt failed to \"" + file2 + "\"");
                    }
                }
            }
        } else {
            System.err.println("\"" + file + "\": no instance label (may be no SOP Instance UID) - doing nothing");
        }
        return bl ? (file2 == null ? null : file2.getCanonicalPath()) : null;
    }

    public static String renameFileWithHierarchicalPathFromAttributes(File file, AttributeList attributeList, String string, String string2) throws IOException, DicomException, NoSuchAlgorithmException {
        MoveDicomFilesIntoHierarchy moveDicomFilesIntoHierarchy = new MoveDicomFilesIntoHierarchy();
        return moveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(file, attributeList, string, string2, folderNamingStrategyToUseIfUnspecified);
    }

    public static String renameFileWithHierarchicalPathFromAttributes(File file, String string, String string2) throws IOException, DicomException, NoSuchAlgorithmException {
        String string3 = null;
        if (DicomFileUtilities.isDicomOrAcrNemaFile(file)) {
            AttributeList attributeList = new AttributeList();
            attributeList.read(file, terminateAfterRelationshipGroup);
            string3 = MoveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(file, attributeList, string, string2);
        } else {
            System.err.println("\"" + file + "\": not a DICOM file - doing nothing");
        }
        return string3;
    }

    public static String renameFileWithHierarchicalPathFromAttributes(File file) throws IOException, DicomException, NoSuchAlgorithmException {
        return MoveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(file, defaultHierarchicalFolderName, defaultDuplicatesFolderNamePrefix);
    }

    public static String renameFileWithHierarchicalPathFromAttributes(String string) throws IOException, DicomException, NoSuchAlgorithmException {
        return MoveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(new File(string), defaultHierarchicalFolderName, defaultDuplicatesFolderNamePrefix);
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                MoveDicomFilesIntoHierarchy.processFilesRecursively(new File(stringArray[i]), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected static class OurReadTerminationStrategy
    implements AttributeList.ReadTerminationStrategy {
        protected OurReadTerminationStrategy() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.getGroup() > 32;
        }
    }

    public class FolderNamingStrategy {
        public static final int instanceByUID = 0;
        public static final int instanceByNumber = 1;
        public static final int instanceByNumberAnatomyLateralityView = 2;
        public static final int instanceByUIDUncleaned = 3;
    }
}

