/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.ProjectionXRayAnatomy;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.FrameSet;
import com.pixelmed.dicom.HierarchicalImageReference;
import com.pixelmed.dicom.HierarchicalSOPInstanceReference;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MultiFramePixelData;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SOPClassDescriptions;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SetOfFrameSets;
import com.pixelmed.dicom.SignedLongAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.StackOfSlices;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TextAttribute;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.vecmath.Vector3d;

public class MultiFrameImageFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/MultiFrameImageFactory.java,v 1.50 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MultiFrameImageFactory.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    protected static boolean useRandomFrameOrderOption = false;
    protected static boolean doNotEncodeStackInformationOption = false;
    private static Set<AttributeTag> excludeFromCopyingIntoFunctionalGroups = new HashSet<AttributeTag>();
    protected static int nextStackID;
    private static Date farthestFutureDate;

    static void addIfPresentAndNotPerFrame(AttributeList attributeList, AttributeList attributeList2, AttributeTag attributeTag, Set<AttributeTag> set) {
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, null, attributeTag, set);
    }

    static void addIfPresentAndNotPerFrame(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, AttributeTag attributeTag, Set<AttributeTag> set2) {
        Attribute attribute;
        if (!(set2 != null && set2.contains(attributeTag) || (attribute = attributeList2.get(attributeTag)) == null)) {
            attributeList.put(attribute);
            if (set != null) {
                set.add(attributeTag);
            }
        }
    }

    static void addIfPresent(AttributeList attributeList, AttributeList attributeList2, AttributeTag attributeTag) {
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, null, attributeTag, null);
    }

    static void addIfPresent(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, AttributeTag attributeTag) {
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, attributeTag, null);
    }

    static void addIfPresentWithValuesAndNotPerFrame(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, AttributeTag attributeTag, Set<AttributeTag> set2) throws DicomException {
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, attributeTag, attributeTag, set2);
    }

    static void addIfPresentWithValuesAndNotPerFrame(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, AttributeTag attributeTag, AttributeTag attributeTag2, Set<AttributeTag> set2) throws DicomException {
        Attribute attribute;
        if (!(set2 != null && set2.contains(attributeTag) || (attribute = attributeList2.get(attributeTag)) == null || attribute.getVM() <= 0)) {
            if (attribute instanceof StringAttribute) {
                String[] stringArray = attribute.getOriginalStringValues();
                if (stringArray != null && stringArray.length > 0) {
                    Attribute attribute2 = AttributeFactory.newAttribute(attributeTag2);
                    attributeList.put(attribute2);
                    for (String string : stringArray) {
                        attribute2.addValue(string);
                    }
                }
                set.add(attributeTag);
                set.add(attributeTag2);
            } else if (attribute instanceof TextAttribute) {
                String[] stringArray = attribute.getStringValues();
                if (stringArray != null && stringArray.length > 0) {
                    if (stringArray.length > 1) {
                        slf4jlogger.info("addIfPresentWithValuesAndNotPerFrame(): more than one value for TextAttribute for {} of class {}", attributeTag, attribute.getClass());
                    }
                    Attribute attribute3 = AttributeFactory.newAttribute(attributeTag2);
                    attributeList.put(attribute3);
                    for (String string : stringArray) {
                        attribute3.addValue(string);
                    }
                }
                set.add(attributeTag);
                set.add(attributeTag2);
            } else if (attribute instanceof UnsignedShortAttribute || attribute instanceof SignedShortAttribute) {
                short[] sArray = attribute.getShortValues();
                if (sArray != null && sArray.length > 0) {
                    Attribute attribute4 = AttributeFactory.newAttribute(attributeTag2);
                    attributeList.put(attribute4);
                    for (short s : sArray) {
                        attribute4.addValue(s);
                    }
                }
                set.add(attributeTag);
                set.add(attributeTag2);
            } else if (attribute instanceof UnsignedLongAttribute || attribute instanceof SignedLongAttribute) {
                int[] nArray = attribute.getIntegerValues();
                if (nArray != null && nArray.length > 0) {
                    Attribute attribute5 = AttributeFactory.newAttribute(attributeTag2);
                    attributeList.put(attribute5);
                    for (int n : nArray) {
                        attribute5.addValue(n);
                    }
                }
                set.add(attributeTag);
                set.add(attributeTag2);
            } else {
                slf4jlogger.info("addIfPresentWithValuesAndNotPerFrame(): unsupported copy of {} of class {}", attributeTag, attribute.getClass());
            }
        }
    }

    static void addIfPresentWithValues(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, AttributeTag attributeTag) throws DicomException {
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, attributeTag, null);
    }

    static void addIfPresentWithValues(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, AttributeTag attributeTag, AttributeTag attributeTag2) throws DicomException {
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, attributeTag, attributeTag2, null);
    }

    static void addCommonCTMRImageDescriptionMacro(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, boolean bl, String string) throws DicomException {
        Attribute attribute = attributeList2.get(TagFromName.ImageType);
        if (attribute != null) {
            String[] stringArray = attribute.getStringValues();
            if (stringArray != null && stringArray.length > 0) {
                CodeStringAttribute codeStringAttribute = bl ? new CodeStringAttribute(TagFromName.FrameType) : new CodeStringAttribute(TagFromName.ImageType);
                ((Attribute)codeStringAttribute).addValue(stringArray[0]);
                if (stringArray.length > 1) {
                    ((Attribute)codeStringAttribute).addValue("PRIMARY");
                    if (stringArray.length > 2) {
                        if (stringArray[2].length() > 0) {
                            ((Attribute)codeStringAttribute).addValue(stringArray[2]);
                        } else {
                            ((Attribute)codeStringAttribute).addValue("VOLUME");
                        }
                        ((Attribute)codeStringAttribute).addValue("NONE");
                    }
                }
                attributeList.put(codeStringAttribute);
            }
            set.add(TagFromName.ImageType);
        }
        attribute = new CodeStringAttribute(TagFromName.PixelPresentation);
        attribute.addValue("MONOCHROME");
        attributeList.put(attribute);
        attribute = new CodeStringAttribute(TagFromName.VolumetricProperties);
        attribute.addValue("VOLUME");
        attributeList.put(attribute);
        attribute = new CodeStringAttribute(TagFromName.VolumeBasedCalculationTechnique);
        attribute.addValue(string);
        attributeList.put(attribute);
    }

    static void addCommonCTMRImageDescriptionMacro(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, boolean bl) throws DicomException {
        MultiFrameImageFactory.addCommonCTMRImageDescriptionMacro(attributeList, attributeList2, set, bl, "NONE");
    }

    static void addEnhancedCTImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
    }

    static void addEnhancedMRImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("ResonantNucleus"), set2);
        if (attributeList.get(dictionary.getTagFromName("ResonantNucleus")) == null) {
            MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("ImagedNucleus"), dictionary.getTagFromName("ResonantNucleus"), set2);
        }
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("KSpaceFiltering"), set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("MagneticFieldStrength"), set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("ApplicableSafetyStandardAgency"), set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("ApplicableSafetyStandardDescription"), set2);
    }

    static void addEnhancedPETImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
    }

    static void addEnhancedCommonImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2, String string) throws DicomException {
        String string2;
        String string3;
        if (!set2.contains(TagFromName.ImageType)) {
            MultiFrameImageFactory.addCommonCTMRImageDescriptionMacro(attributeList, attributeList2, set, false, string);
        }
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContentQualification, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ImageComments, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.BurnedInAnnotation, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.RecognizableVisualFeatures, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.LossyImageCompression, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.LossyImageCompressionRatio, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.LossyImageCompressionMethod, set2);
        if (!set2.contains(TagFromName.PresentationLUTShape) && (string3 = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.PresentationLUTShape, (string2 = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.PhotometricInterpretation, "MONOCHROME2")).equals("MONOCHROME1") ? "INVERTED" : "IDENTITY")).length() > 0) {
            CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)codeStringAttribute).addValue(string3);
            attributeList.put(codeStringAttribute);
            set.add(TagFromName.PresentationLUTShape);
        }
    }

    static void addEnhancedCommonImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        MultiFrameImageFactory.addEnhancedCommonImageModule(attributeList, attributeList2, set, set2, "NONE");
    }

    static void addImagePixelModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.SamplesPerPixel);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.PhotometricInterpretation);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.Rows);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.Columns);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.BitsAllocated);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.BitsStored);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.HighBit);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.PixelRepresentation);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.PlanarConfiguration);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.PixelAspectRatio);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.SmallestImagePixelValue);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.LargestImagePixelValue);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.RedPaletteColorLookupTableDescriptor);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.GreenPaletteColorLookupTableDescriptor);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.BluePaletteColorLookupTableDescriptor);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.RedPaletteColorLookupTableData);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.GreenPaletteColorLookupTableData);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.BluePaletteColorLookupTableData);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.ICCProfile);
        MultiFrameImageFactory.addIfPresent(attributeList, attributeList2, set, TagFromName.PixelPaddingRangeLimit);
    }

    static void addGeneralModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
    }

    static void addContrastBolusModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusAgent, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusAgentSequence, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusRoute, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusAdministrationRouteSequence, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusVolume, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusStartTime, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusStopTime, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusTotalDose, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastFlowRate, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastFlowDuration, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusIngredient, set2);
        MultiFrameImageFactory.addIfPresentWithValuesAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusIngredientConcentration, set2);
    }

    static void addSecondaryCaptureEquipmentModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        String string;
        if (!set2.contains(TagFromName.ConversionType) && (string = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.ConversionType, "WSD")).length() > 0) {
            CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ConversionType);
            ((Attribute)codeStringAttribute).addValue(string);
            attributeList.put(codeStringAttribute);
            set.add(TagFromName.ConversionType);
        }
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.SecondaryCaptureDeviceID, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.SecondaryCaptureDeviceManufacturer, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.SecondaryCaptureDeviceManufacturerModelName, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.SecondaryCaptureDeviceSoftwareVersions, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.VideoImageFormatAcquired, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.DigitalImageFormatAcquired, set2);
    }

    static void addSecondaryCaptureImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.DateOfSecondaryCapture, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.TimeOfSecondaryCapture, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.NominalScannedPixelSpacing, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.DocumentClassCodeSequence, set2);
    }

    static void addSecondaryCaptureMultiFrameImageModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        String string;
        String string2;
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.BurnedInAnnotation, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.RecognizableVisualFeatures, set2);
        if (!set2.contains(TagFromName.PresentationLUTShape) && ((string2 = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.PhotometricInterpretation, "MONOCHROME2")).equals("MONOCHROME1") || string2.equals("MONOCHROME2")) && (string = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.PresentationLUTShape, string2.equals("MONOCHROME1") ? "INVERTED" : "IDENTITY")).length() > 0) {
            CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)codeStringAttribute).addValue(string);
            attributeList.put(codeStringAttribute);
            set.add(TagFromName.PresentationLUTShape);
        }
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.Illumination, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ReflectedAmbientLight, set2);
        MultiFrameImageFactory.addAppropriateRescaleRelatedAttributes(attributeList, attributeList2, set);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.DigitizingDeviceTransportDirection, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.RotationOfScannedFilm, set2);
    }

    static void addAcquisitionContextModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        if (!set2.contains(TagFromName.AcquisitionContextSequence)) {
            Attribute attribute = attributeList2.get(TagFromName.AcquisitionContextSequence);
            if (attribute == null) {
                attribute = new SequenceAttribute(TagFromName.AcquisitionContextSequence);
            }
            attributeList.put(attribute);
            set.add(TagFromName.AcquisitionContextSequence);
        }
    }

    static void addXRay3DGeneralPositionerMovementMacro(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        double d = Attribute.getSingleDoubleValueOrDefault(attributeList2, dictionary.getTagFromName("TomoAngle"), 0.0);
        if (d > 0.0) {
            FloatSingleAttribute floatSingleAttribute = new FloatSingleAttribute(dictionary.getTagFromName("PrimaryPositionerScanArc"));
            ((Attribute)floatSingleAttribute).addValue(d);
            attributeList.put(floatSingleAttribute);
        }
    }

    static void addXRay3DGeneralSharedAcquisitionMacro(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("FieldOfViewDimensionsInFloat"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("FieldOfViewOrigin"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("FieldOfViewRotation"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("FieldOfViewHorizontalFlip"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("Grid"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("KVP"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("XRayTubeCurrentInmA"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("ExposureTimeInms"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, dictionary.getTagFromName("ExposureInmAs"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusAgent, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList, attributeList2, set, TagFromName.ContrastBolusAgentSequence, set2);
    }

    static void addBreastTomosynthesisAcquisitionModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.XRay3DAcquisitionSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, TagFromName.FieldOfViewShape, set2);
        MultiFrameImageFactory.addXRay3DGeneralSharedAcquisitionMacro(attributeList3, attributeList2, set, set2);
        MultiFrameImageFactory.addXRay3DGeneralPositionerMovementMacro(attributeList3, attributeList2, set, set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("DistanceSourceToDetector"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("DistanceSourceToPatient"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("EstimatedRadiographicMagnificationFactor"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("AnodeTargetMaterial"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("BodyPartThickness"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("ExposureControlMode"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("ExposureControlModeDescription"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("HalfValueLayer"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FocalSpots"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("DetectorBinning"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("DetectorTemperature"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FilterType"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FilterMaterial"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FilterThicknessMinimum"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FilterThicknessMaximum"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FilterBeamPathLengthMinimum"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("FilterBeamPathLengthMaximum"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("CompressionForce"), set2);
        MultiFrameImageFactory.addIfPresentAndNotPerFrame(attributeList3, attributeList2, set, dictionary.getTagFromName("PaddleDescription"), set2);
    }

    static void addBreastViewModule(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Set<AttributeTag> set2) throws DicomException {
        Attribute attribute;
        if (!set2.contains(TagFromName.ViewCodeSequence) && (attribute = attributeList2.get(TagFromName.ViewCodeSequence)) != null) {
            attributeList.put(attribute);
            set.add(TagFromName.ViewCodeSequence);
        }
        if (!set2.contains(dictionary.getTagFromName("BreastImplantPresent")) && (attribute = attributeList2.get(dictionary.getTagFromName("BreastImplantPresent"))) != null) {
            attributeList.put(attribute);
            set.add(dictionary.getTagFromName("BreastImplantPresent"));
        }
        if (!set2.contains(dictionary.getTagFromName("PartialView")) && (attribute = attributeList2.get(dictionary.getTagFromName("PartialView"))) != null) {
            attributeList.put(attribute);
            set.add(dictionary.getTagFromName("PartialView"));
        }
        if (!set2.contains(dictionary.getTagFromName("PartialViewCodeSequence")) && (attribute = attributeList2.get(dictionary.getTagFromName("PartialViewCodeSequence"))) != null) {
            attributeList.put(attribute);
            set.add(dictionary.getTagFromName("PartialViewCodeSequence"));
        }
    }

    static boolean containsAttributesForCTImageFrameTypeFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.ImageType);
    }

    static void addCTImageFrameTypeFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.CTImageFrameTypeSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addCommonCTMRImageDescriptionMacro(attributeList3, attributeList2, set, true);
    }

    static boolean containsAttributesForMRImageFrameTypeFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.ImageType);
    }

    static void addMRImageFrameTypeFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.MRImageFrameTypeSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addCommonCTMRImageDescriptionMacro(attributeList3, attributeList2, set, true);
    }

    static boolean containsAttributesForPETImageFrameTypeFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.ImageType);
    }

    static void addPETImageFrameTypeFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.PETFrameTypeSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addCommonCTMRImageDescriptionMacro(attributeList3, attributeList2, set, true);
    }

    static void addXRay3DImageFrameTypeFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.XRay3DFrameTypeSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addCommonCTMRImageDescriptionMacro(attributeList3, attributeList2, set, true, "TOMOSYNTHESIS");
    }

    static boolean containsAttributesForPixelMeasuresFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.PixelSpacing) || set.contains(TagFromName.SliceThickness) || set.contains(TagFromName.ImagerPixelSpacing);
    }

    static void addPixelMeasuresFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.PixelMeasuresSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.PixelSpacing);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.SliceThickness);
        if (attributeList3.get(TagFromName.PixelSpacing) == null) {
            MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.ImagerPixelSpacing, TagFromName.PixelSpacing);
        }
    }

    static boolean containsAttributesForFrameAnatomyFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.Laterality) || set.contains(TagFromName.ImageLaterality) || set.contains(TagFromName.BodyPartExamined) || set.contains(TagFromName.AnatomicRegionSequence);
    }

    static void addFrameAnatomyFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        Object object;
        Object object2;
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.FrameAnatomySequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.AnatomicRegionSequence);
        if (attributeList3.get(TagFromName.AnatomicRegionSequence) == null) {
            object2 = CTAnatomy.findAnatomicConcept(attributeList2);
            if (object2 == null) {
                object2 = ProjectionXRayAnatomy.findAnatomicConcept(attributeList2);
            }
            if (object2 != null) {
                object = new SequenceAttribute(TagFromName.AnatomicRegionSequence);
                ((SequenceAttribute)object).addItem(((CodedConcept)object2).getCodedSequenceItem().getAttributeList());
                attributeList3.put((Attribute)object);
            }
        }
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.FrameLaterality);
        if (attributeList3.get(TagFromName.FrameLaterality) == null) {
            MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.ImageLaterality, TagFromName.FrameLaterality);
        }
        if (attributeList3.get(TagFromName.FrameLaterality) == null) {
            MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.Laterality, TagFromName.FrameLaterality);
        }
        if (attributeList3.get(TagFromName.FrameLaterality) == null && (object2 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList3, TagFromName.AnatomicRegionSequence)) != null) {
            object = CTAnatomy.getAnatomyConcepts().find((CodedSequenceItem)object2);
            if (object == null) {
                object = ProjectionXRayAnatomy.getAnatomyConcepts().find((CodedSequenceItem)object2);
            }
            if (object != null && object instanceof DisplayableAnatomicConcept && !((DisplayableAnatomicConcept)object).isPairedStructure()) {
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.FrameLaterality);
                ((Attribute)codeStringAttribute).addValue("U");
                attributeList3.put(codeStringAttribute);
            }
        }
    }

    static Date addFrameContentFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, Date date, boolean bl, String string, Set<AttributeTag> set2, boolean bl2) throws DicomException {
        String string2;
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.FrameContentSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.AcquisitionNumber, 0);
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.FrameAcquisitionNumber);
        ((Attribute)unsignedShortAttribute).addValue(n);
        attributeList3.put(unsignedShortAttribute);
        set.add(TagFromName.AcquisitionNumber);
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionDateTime);
        boolean bl3 = set2.contains(TagFromName.AcquisitionDateTime);
        if (string3.length() == 0) {
            string2 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionDate);
            boolean bl4 = bl3 = bl3 || set2.contains(TagFromName.AcquisitionDate);
            if (string2.length() > 0) {
                string3 = string2 + Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionTime);
                bl3 = bl3 || set2.contains(TagFromName.AcquisitionTime);
            }
        } else {
            set.add(TagFromName.AcquisitionDateTime);
        }
        if (string3.length() > 0) {
            if (bl && !string3.contains("+") && !string3.contains("-")) {
                string3 = string3 + string;
            }
            try {
                string2 = null;
                string2 = !string3.contains("+") && !string3.contains("-") ? string3 + "+0000" : string3;
                Date date2 = DateTimeAttribute.getDateFromFormattedString(string2);
                if (date2.before(date)) {
                    date = date2;
                }
                if (bl3) {
                    DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.FrameAcquisitionDateTime);
                    ((Attribute)dateTimeAttribute).addValue(string3);
                    attributeList3.put(dateTimeAttribute);
                } else if (attributeList2.containsKey(TagFromName.TriggerTime) && !attributeList2.containsKey(TagFromName.FrameReferenceDateTime)) {
                    int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.TriggerTime, 0);
                    date2.setTime(date2.getTime() + (long)n2);
                    string3 = DateTimeAttribute.getFormattedString(date2, DateTimeAttribute.getTimeZone(string), bl);
                    DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.FrameAcquisitionDateTime);
                    ((Attribute)dateTimeAttribute).addValue(string3);
                    attributeList3.put(dateTimeAttribute);
                    set.add(TagFromName.TriggerTime);
                } else {
                    DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.FrameAcquisitionDateTime);
                    ((Attribute)dateTimeAttribute).addValue(string3);
                    attributeList3.put(dateTimeAttribute);
                }
            }
            catch (ParseException parseException) {
                slf4jlogger.error("Cannot derive AcquisitionDateTime", parseException);
            }
        }
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.AcquisitionDuration, TagFromName.FrameAcquisitionDuration);
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.TemporalPositionIndex);
        if (!bl2) {
            slf4jlogger.info("addFrameContentFunctionalGroup(): Adding StackID and InStackPositionNumber");
            MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.StackID);
            MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.InStackPositionNumber);
        }
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.ImageComments, TagFromName.FrameComments);
        return date;
    }

    static Date getEarliestContentDateTime(AttributeList attributeList, Date date) {
        try {
            Date date2 = DateTimeAttribute.getDateFromFormattedString(attributeList, TagFromName.ContentDate, TagFromName.ContentTime);
            if (date2.before(date)) {
                date = date2;
            }
        }
        catch (ParseException parseException) {
            slf4jlogger.error("Cannot derive from DateTimeAttribute from ContentDate and ContentTime", parseException);
        }
        catch (DicomException dicomException) {
            slf4jlogger.debug("ContentDate is absent or empty", dicomException);
        }
        return date;
    }

    static boolean containsAttributesForPlanePositionFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.ImagePositionPatient);
    }

    static void addPlanePositionFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.PlanePositionSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.ImagePositionPatient);
    }

    static boolean containsAttributesForPlanePositionFunctionalGroupDerivedFromTomoLayerHeight(Set<AttributeTag> set) {
        return set.contains(dictionary.getTagFromName("TomoLayerHeight"));
    }

    static void addPlanePositionFunctionalGroupDerivedFromTomoLayerHeight(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set, double[] dArray) throws DicomException {
        double d = Attribute.getSingleDoubleValueOrDefault(attributeList2, dictionary.getTagFromName("TomoLayerHeight"), 0.0);
        slf4jlogger.debug("addPlanePositionFunctionalGroupDerivedFromTomoLayerHeight(): have tomo height = {}", d);
        Vector3d vector3d = new Vector3d();
        vector3d.cross(new Vector3d(dArray[0], dArray[1], dArray[2]), new Vector3d(dArray[3], dArray[4], dArray[5]));
        vector3d.normalize();
        double[] dArray2 = new double[3];
        vector3d.get(dArray2);
        slf4jlogger.info("addPlanePositionFunctionalGroupDerivedFromTomoLayerHeight(): normal = {},{},{}", dArray2[0], dArray2[1], dArray2[2]);
        dArray2[0] = dArray2[0] * (d *= -1.0);
        dArray2[1] = dArray2[1] * d;
        dArray2[2] = dArray2[2] * d;
        slf4jlogger.info("addPlanePositionFunctionalGroupDerivedFromTomoLayerHeight(): TLHC = {},{},{}", dArray2[0], dArray2[1], dArray2[2]);
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.PlanePositionSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
        ((Attribute)decimalStringAttribute).addValue(dArray2[0]);
        ((Attribute)decimalStringAttribute).addValue(dArray2[1]);
        ((Attribute)decimalStringAttribute).addValue(dArray2[2]);
        attributeList3.put(decimalStringAttribute);
    }

    static boolean containsAttributesForPlaneOrientationFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.ImageOrientationPatient);
    }

    static void addPlaneOrientationFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.PlaneOrientationSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.ImageOrientationPatient);
    }

    static boolean containsAttributesForPlaneOrientationFunctionalGroupDerivedFromAngle(Set<AttributeTag> set) {
        return set.contains(dictionary.getTagFromName("PositionerPrimaryAngle")) && set.contains(TagFromName.PatientOrientation);
    }

    static boolean isUnitVector(double d, double d2, double d3) {
        return Math.abs(Math.sqrt(d * d + d2 * d2 + d3 * d3) - 1.0) < 1.0E-4;
    }

    static double[] addPlaneOrientationFunctionalGroupDerivedFromAngle(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        Object object;
        double[] dArray = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Attribute attribute = attributeList2.get(TagFromName.PatientOrientation);
        if (attribute != null && attribute.getVM() == 2 && (object = attribute.getStringValues()) != null && ((String[])object).length == 2) {
            String string = object[0];
            if (string.equals("A")) {
                d2 = -1.0;
            } else if (string.equals("P")) {
                d2 = 1.0;
            }
            int n = 0;
            int n2 = 0;
            Object object2 = object[1];
            if (((String)object2).contains("L")) {
                n = 1;
            } else if (((String)object2).contains("R")) {
                n = -1;
            }
            if (((String)object2).contains("H")) {
                n2 = 1;
            } else if (((String)object2).contains("F")) {
                n2 = -1;
            }
            double d7 = Attribute.getSingleDoubleValueOrDefault(attributeList2, dictionary.getTagFromName("PositionerPrimaryAngle"), 0.0);
            d4 = Math.abs(Math.sin(d7)) * (double)n;
            d6 = Math.abs(Math.cos(d7)) * (double)n2;
        }
        if (MultiFrameImageFactory.isUnitVector(d, d2, d3) && MultiFrameImageFactory.isUnitVector(d4, d5, d6)) {
            object = new SequenceAttribute(TagFromName.PlaneOrientationSequence);
            attributeList.put((Attribute)object);
            AttributeList attributeList3 = new AttributeList();
            ((SequenceAttribute)object).addItem(attributeList3);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
            ((Attribute)decimalStringAttribute).addValue(d);
            ((Attribute)decimalStringAttribute).addValue(d2);
            ((Attribute)decimalStringAttribute).addValue(d3);
            ((Attribute)decimalStringAttribute).addValue(d4);
            ((Attribute)decimalStringAttribute).addValue(d5);
            ((Attribute)decimalStringAttribute).addValue(d6);
            attributeList3.put(decimalStringAttribute);
            dArray = new double[]{d, d2, d3, d4, d5, d6};
        }
        return dArray;
    }

    static boolean containsAttributesForFrameVOILUTFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.WindowWidth) || set.contains(TagFromName.WindowCenter) || set.contains(TagFromName.WindowCenterWidthExplanation);
    }

    static void addFrameVOILUTFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.FrameVOILUTSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.WindowWidth);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.WindowCenter);
        MultiFrameImageFactory.addIfPresent(attributeList3, attributeList2, set, TagFromName.WindowCenterWidthExplanation);
    }

    static boolean containsAttributesForPixelValueTransformationFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.RescaleIntercept) || set.contains(TagFromName.RescaleSlope) || set.contains(TagFromName.RescaleType);
    }

    static void addAppropriateRescaleRelatedAttributes(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        Object object;
        boolean bl = false;
        Object object2 = attributeList2.get(TagFromName.RescaleIntercept);
        if (object2 != null) {
            attributeList.put((Attribute)object2);
            set.add(TagFromName.RescaleIntercept);
            bl = true;
        }
        if ((object2 = attributeList2.get(TagFromName.RescaleSlope)) != null) {
            attributeList.put((Attribute)object2);
            set.add(TagFromName.RescaleSlope);
            bl = true;
        }
        if (((String)(object2 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.RescaleType))).length() == 0) {
            object = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.Modality, "");
            if (bl) {
                object2 = "US";
                if (((String)object).equals("CT")) {
                    boolean bl2 = Attribute.getDelimitedStringValuesOrDefault(attributeList2, TagFromName.ImageType, "").contains("LOCALIZER");
                    if (!bl2) {
                        object2 = "HU";
                    }
                } else if (((String)object).equals("PT")) {
                    object2 = Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.Units, "US");
                }
            }
        }
        if (((String)object2).length() > 0) {
            object = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)object).addValue((String)object2);
            attributeList.put((Attribute)object);
            set.add(TagFromName.RescaleType);
        }
    }

    static void addPixelValueTransformationFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.PixelValueTransformationSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addAppropriateRescaleRelatedAttributes(attributeList3, attributeList2, set);
    }

    static boolean containsAttributesForReferencedImageFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.ReferencedImageSequence);
    }

    static void addReferencedImageFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        Attribute attribute = attributeList2.get(TagFromName.ReferencedImageSequence);
        if (attribute != null) {
            attributeList.put(attribute);
            set.add(TagFromName.ReferencedImageSequence);
        }
    }

    static boolean containsAttributesForDerivationImageFunctionalGroup(Set<AttributeTag> set) {
        return set.contains(TagFromName.SourceImageSequence);
    }

    static void addDerivationImageFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        Attribute attribute;
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.DerivationImageSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.DerivationDescription);
        Attribute attribute2 = attributeList2.get(TagFromName.DerivationCodeSequence);
        if (attribute2 != null) {
            attributeList3.put(attribute2);
            set.add(TagFromName.DerivationCodeSequence);
        }
        if ((attribute = attributeList2.get(TagFromName.SourceImageSequence)) != null) {
            attributeList3.put(attribute);
            set.add(TagFromName.SourceImageSequence);
        }
    }

    static void addConversionSourceFunctionalGroup(AttributeList attributeList, AttributeList attributeList2, Set<AttributeTag> set) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ConversionSourceAttributesSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.SOPClassUID, TagFromName.ReferencedSOPClassUID);
        MultiFrameImageFactory.addIfPresentWithValues(attributeList3, attributeList2, set, TagFromName.SOPInstanceUID, TagFromName.ReferencedSOPInstanceUID);
    }

    public static String chooseAppropriateConvertedSOPClassUID(AttributeList attributeList) {
        String string;
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        String string3 = "1.2.840.10008.5.1.4.1.1.66";
        if (string2 != null) {
            if (string2.equals("1.2.840.10008.5.1.4.1.1.2")) {
                string3 = "1.2.840.10008.5.1.4.1.1.2.2";
            } else if (string2.equals("1.2.840.10008.5.1.4.1.1.4")) {
                string3 = "1.2.840.10008.5.1.4.1.1.4.4";
            } else if (string2.equals("1.2.840.10008.5.1.4.1.1.128")) {
                string3 = "1.2.840.10008.5.1.4.1.1.128.1";
            } else if ((string2.equals("1.2.840.10008.5.1.4.1.1.1.2") || string2.equals("1.2.840.10008.5.1.4.1.1.1.2.1")) && (string = Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, "")).contains("SLICE")) {
                string3 = "1.2.840.10008.5.1.4.1.1.13.1.3";
            }
        }
        if (string3.equals("1.2.840.10008.5.1.4.1.1.66")) {
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
            if (string.equals("RGB")) {
                string3 = "1.2.840.10008.5.1.4.1.1.7.4";
            } else if (string.equals("MONOCHROME2") || string.equals("MONOCHROME1")) {
                int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
                if (n == 8) {
                    string3 = "1.2.840.10008.5.1.4.1.1.7.2";
                } else if (n == 16) {
                    string3 = "1.2.840.10008.5.1.4.1.1.7.3";
                }
            }
        }
        return string3;
    }

    public static void addStack(AttributeList attributeList, Map<String, StackOfSlices> map) {
        slf4jlogger.info("addStack():");
        try {
            StackOfSlices stackOfSlices = new StackOfSlices(attributeList);
            if (!stackOfSlices.isValid()) {
                slf4jlogger.warn("addStack(): Could not make a valid stack");
                return;
            }
            String string = null;
            if (map != null) {
                for (String string2 : map.keySet()) {
                    StackOfSlices stackOfSlices2 = map.get(string2);
                    if (!stackOfSlices2.equals(stackOfSlices)) continue;
                    string = string2;
                    stackOfSlices = stackOfSlices2;
                    break;
                }
            }
            if (string == null) {
                string = Integer.toString(nextStackID++);
                if (map != null) {
                    map.put(string, stackOfSlices);
                }
                slf4jlogger.info("addStack(): Making new stack {}", string);
            } else {
                slf4jlogger.info("addStack(): Not replacing existing stack {}", string);
            }
            stackOfSlices.addStackAttributesToExistingFrameContentSequence(attributeList, string);
        }
        catch (DicomException dicomException) {
            slf4jlogger.error("", dicomException);
        }
    }

    public static void addStackIfNotAlreadyPresent(AttributeList attributeList, Map<String, StackOfSlices> map) {
        slf4jlogger.info("addStackIfNotAlreadyPresent():");
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)sequenceAttribute.getItem(0).getAttributeList().get(TagFromName.FrameContentSequence);
        AttributeList attributeList2 = sequenceAttribute2.getItem(0).getAttributeList();
        if (!attributeList2.containsKey(TagFromName.StackID) || !attributeList2.containsKey(TagFromName.InStackPositionNumber)) {
            MultiFrameImageFactory.addStack(attributeList, map);
        } else {
            slf4jlogger.info("addStackIfNotAlreadyPresent(): Not replacing existing stack");
        }
    }

    public static AttributeList createEnhancedImageFromFrameSet(FrameSet frameSet, Map<String, File> map, Map<String, AttributeList> map2, Map<String, HierarchicalImageReference> map3, Map<String, StackOfSlices> map4, boolean bl, boolean bl2) throws DicomException, IOException {
        Object object;
        Iterator<String> iterator;
        Object object2;
        Object object3;
        Object object4;
        slf4jlogger.info(frameSet.toString());
        Set<AttributeTag> set = frameSet.getDistinguishingAttributeTags();
        Set<AttributeTag> set2 = frameSet.getSharedAttributeTags();
        Set<AttributeTag> set3 = frameSet.getPerFrameAttributeTags();
        String string = "";
        Date date = farthestFutureDate;
        Date date2 = farthestFutureDate;
        AttributeList attributeList = new AttributeList();
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.SharedFunctionalGroupsSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        SequenceAttribute sequenceAttribute2 = new SequenceAttribute(TagFromName.PerFrameFunctionalGroupsSequence);
        attributeList.put(sequenceAttribute2);
        MultiFramePixelData multiFramePixelData = null;
        boolean bl3 = false;
        String string2 = null;
        TimeZone timeZone = null;
        List<String> list = frameSet.getSOPInstanceUIDsSortedByFrameOrder();
        if (bl) {
            Collections.shuffle(list);
        }
        double[] dArray = null;
        boolean bl4 = true;
        for (String string3 : list) {
            Object object5 = object4 = map2 == null ? null : map2.get(string3);
            if (object4 == null && (object3 = map.get(string3)) != null) {
                object4 = new AttributeList();
                ((AttributeList)object4).read((File)object3);
            }
            if (object4 != null) {
                object3 = new HashSet();
                if (bl4) {
                    string2 = Attribute.getSingleStringValueOrNull((AttributeList)object4, TagFromName.TimezoneOffsetFromUTC);
                    if (string2 == null || string2.length() == 0) {
                        string2 = "+0000";
                    } else {
                        bl3 = true;
                    }
                    timeZone = DateTimeAttribute.getTimeZone(string2);
                    string = MultiFrameImageFactory.chooseAppropriateConvertedSOPClassUID((AttributeList)object4);
                    int n = Attribute.getSingleIntegerValueOrDefault((AttributeList)object4, TagFromName.Rows, 0);
                    int n2 = Attribute.getSingleIntegerValueOrDefault((AttributeList)object4, TagFromName.Columns, 0);
                    int n3 = Attribute.getSingleIntegerValueOrDefault((AttributeList)object4, TagFromName.SamplesPerPixel, 1);
                    int n4 = frameSet.size();
                    Iterator<AttributeTag> iterator2 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
                    ((Attribute)((Object)iterator2)).addValue(n4);
                    attributeList.put((Attribute)((Object)iterator2));
                    multiFramePixelData = new MultiFramePixelData(n, n2, n3, n4);
                    iterator2 = new CompositeInstanceContext((AttributeList)object4, false);
                    AttributeList attributeList3 = ((CompositeInstanceContext)((Object)iterator2)).getAttributeList();
                    for (AttributeTag attributeTag : attributeList3.keySet()) {
                        if (set3.contains(attributeTag)) continue;
                        MultiFrameImageFactory.addIfPresent(attributeList, attributeList3, (Set<AttributeTag>)object3, attributeTag);
                    }
                    MultiFrameImageFactory.addImagePixelModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3);
                    if (string.equals("1.2.840.10008.5.1.4.1.1.2.2")) {
                        MultiFrameImageFactory.addEnhancedCommonImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addContrastBolusModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addEnhancedCTImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addAcquisitionContextModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                    } else if (string.equals("1.2.840.10008.5.1.4.1.1.4.4")) {
                        MultiFrameImageFactory.addEnhancedCommonImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addContrastBolusModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addEnhancedMRImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addAcquisitionContextModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                    } else if (string.equals("1.2.840.10008.5.1.4.1.1.128.1")) {
                        MultiFrameImageFactory.addEnhancedCommonImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addEnhancedPETImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addAcquisitionContextModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                    } else if (string.equals("1.2.840.10008.5.1.4.1.1.13.1.3")) {
                        MultiFrameImageFactory.addEnhancedCommonImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3, "TOMOSYNTHESIS");
                        MultiFrameImageFactory.addBreastTomosynthesisAcquisitionModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addBreastViewModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addAcquisitionContextModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                    } else if (SOPClass.isMultiframeSecondaryCaptureImageStorage(string)) {
                        MultiFrameImageFactory.addSecondaryCaptureEquipmentModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addSecondaryCaptureImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                        MultiFrameImageFactory.addSecondaryCaptureMultiFrameImageModule(attributeList, (AttributeList)object4, (Set<AttributeTag>)object3, set3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForFrameAnatomyFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForFrameAnatomyFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForFrameAnatomyFunctionalGroup(set))) {
                        MultiFrameImageFactory.addFrameAnatomyFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForPixelMeasuresFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForPixelMeasuresFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForPixelMeasuresFunctionalGroup(set))) {
                        MultiFrameImageFactory.addPixelMeasuresFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForPlanePositionFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForPlanePositionFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForPlanePositionFunctionalGroup(set))) {
                        MultiFrameImageFactory.addPlanePositionFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForPlaneOrientationFunctionalGroup(set3)) {
                        if (MultiFrameImageFactory.containsAttributesForPlaneOrientationFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForPlaneOrientationFunctionalGroup(set)) {
                            MultiFrameImageFactory.addPlaneOrientationFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                        } else if (string.equals("1.2.840.10008.5.1.4.1.1.13.1.3") && (MultiFrameImageFactory.containsAttributesForPlaneOrientationFunctionalGroupDerivedFromAngle(set2) || MultiFrameImageFactory.containsAttributesForPlaneOrientationFunctionalGroupDerivedFromAngle(set))) {
                            dArray = MultiFrameImageFactory.addPlaneOrientationFunctionalGroupDerivedFromAngle(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                        }
                    }
                    if (!MultiFrameImageFactory.containsAttributesForFrameVOILUTFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForFrameVOILUTFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForFrameVOILUTFunctionalGroup(set))) {
                        MultiFrameImageFactory.addFrameVOILUTFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (string.equals("1.2.840.10008.5.1.4.1.1.2.2")) {
                        if (!MultiFrameImageFactory.containsAttributesForCTImageFrameTypeFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForCTImageFrameTypeFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForCTImageFrameTypeFunctionalGroup(set))) {
                            MultiFrameImageFactory.addCTImageFrameTypeFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                        }
                    } else if (string.equals("1.2.840.10008.5.1.4.1.1.4.4")) {
                        if (!MultiFrameImageFactory.containsAttributesForMRImageFrameTypeFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForMRImageFrameTypeFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForMRImageFrameTypeFunctionalGroup(set))) {
                            MultiFrameImageFactory.addMRImageFrameTypeFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                        }
                    } else if (string.equals("1.2.840.10008.5.1.4.1.1.128.1") && !MultiFrameImageFactory.containsAttributesForPETImageFrameTypeFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForPETImageFrameTypeFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForPETImageFrameTypeFunctionalGroup(set))) {
                        MultiFrameImageFactory.addPETImageFrameTypeFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForPixelValueTransformationFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForPixelValueTransformationFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForPixelValueTransformationFunctionalGroup(set))) {
                        MultiFrameImageFactory.addPixelValueTransformationFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForReferencedImageFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForReferencedImageFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForReferencedImageFunctionalGroup(set))) {
                        MultiFrameImageFactory.addReferencedImageFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                    if (!MultiFrameImageFactory.containsAttributesForDerivationImageFunctionalGroup(set3) && (MultiFrameImageFactory.containsAttributesForDerivationImageFunctionalGroup(set2) || MultiFrameImageFactory.containsAttributesForDerivationImageFunctionalGroup(set))) {
                        MultiFrameImageFactory.addDerivationImageFunctionalGroup(attributeList2, (AttributeList)object4, (Set<AttributeTag>)object3);
                    }
                }
                object2 = new AttributeList();
                sequenceAttribute2.addItem((AttributeList)object2);
                iterator = new HashSet<AttributeTag>();
                if (MultiFrameImageFactory.containsAttributesForFrameAnatomyFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addFrameAnatomyFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                if (MultiFrameImageFactory.containsAttributesForPixelMeasuresFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addPixelMeasuresFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                date = MultiFrameImageFactory.addFrameContentFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator, date, bl3, string2, set3, bl2);
                date2 = MultiFrameImageFactory.getEarliestContentDateTime((AttributeList)object4, date2);
                if (MultiFrameImageFactory.containsAttributesForPlaneOrientationFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addPlaneOrientationFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                if (MultiFrameImageFactory.containsAttributesForPlanePositionFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addPlanePositionFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                } else if (string.equals("1.2.840.10008.5.1.4.1.1.13.1.3") && MultiFrameImageFactory.containsAttributesForPlanePositionFunctionalGroupDerivedFromTomoLayerHeight(set3) && dArray != null && dArray.length == 6) {
                    MultiFrameImageFactory.addPlanePositionFunctionalGroupDerivedFromTomoLayerHeight((AttributeList)object2, (AttributeList)object4, iterator, dArray);
                }
                if (MultiFrameImageFactory.containsAttributesForFrameVOILUTFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addFrameVOILUTFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                if (string.equals("1.2.840.10008.5.1.4.1.1.2.2")) {
                    if (MultiFrameImageFactory.containsAttributesForCTImageFrameTypeFunctionalGroup(set3)) {
                        MultiFrameImageFactory.addCTImageFrameTypeFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                    }
                } else if (string.equals("1.2.840.10008.5.1.4.1.1.13.1.3")) {
                    MultiFrameImageFactory.addXRay3DImageFrameTypeFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                if (MultiFrameImageFactory.containsAttributesForPixelValueTransformationFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addPixelValueTransformationFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                if (MultiFrameImageFactory.containsAttributesForReferencedImageFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addReferencedImageFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                if (MultiFrameImageFactory.containsAttributesForDerivationImageFunctionalGroup(set3)) {
                    MultiFrameImageFactory.addDerivationImageFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                }
                MultiFrameImageFactory.addConversionSourceFunctionalGroup((AttributeList)object2, (AttributeList)object4, iterator);
                SequenceAttribute sequenceAttribute3 = new SequenceAttribute(TagFromName.UnassignedPerFrameConvertedAttributesSequence);
                ((AttributeList)object2).put(sequenceAttribute3);
                object = new AttributeList();
                sequenceAttribute3.addItem((AttributeList)object);
                for (AttributeTag attributeTag : set3) {
                    if (iterator.contains(attributeTag) || excludeFromCopyingIntoFunctionalGroups.contains(attributeTag)) continue;
                    MultiFrameImageFactory.addIfPresent((AttributeList)object, (AttributeList)object4, attributeTag);
                }
                if (bl4) {
                    SequenceAttribute sequenceAttribute4 = new SequenceAttribute(TagFromName.UnassignedSharedConvertedAttributesSequence);
                    attributeList2.put(sequenceAttribute4);
                    object = new AttributeList();
                    sequenceAttribute4.addItem((AttributeList)object);
                    for (AttributeTag attributeTag : set2) {
                        if (attributeList.get(attributeTag) != null || object3.contains(attributeTag) || iterator.contains(attributeTag) || excludeFromCopyingIntoFunctionalGroups.contains(attributeTag)) continue;
                        MultiFrameImageFactory.addIfPresent((AttributeList)object, (AttributeList)object4, attributeTag);
                    }
                }
            } else {
                throw new DicomException("Missing File or AttributeList for SOP Instance UID " + string3 + " in FrameSet");
            }
            multiFramePixelData.addFrame(((AttributeList)object4).getPixelData());
            bl4 = false;
        }
        Object object8 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object8).addValue(string);
        attributeList.put((Attribute)object8);
        if (date.before(farthestFutureDate)) {
            object8 = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
            ((Attribute)object8).addValue(DateTimeAttribute.getFormattedString(date, timeZone, bl3));
            attributeList.put((Attribute)object8);
        }
        if (date2.before(farthestFutureDate)) {
            object8 = DateTimeAttribute.getFormattedString(date2, timeZone, false);
            int n = ((String)object8).length();
            if (n >= 8) {
                object4 = new DateAttribute(TagFromName.ContentDate);
                ((Attribute)object4).addValue(((String)object8).substring(0, 8));
                attributeList.put((Attribute)object4);
            }
            if (n > 8) {
                object4 = new TimeAttribute(TagFromName.ContentTime);
                ((Attribute)object4).addValue(((String)object8).substring(8));
                attributeList.put((Attribute)object4);
            }
        }
        if ((object8 = multiFramePixelData.getPixelDataAttribute()) != null) {
            attributeList.put((Attribute)object8);
        }
        object8 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber);
        object4 = "1";
        object3 = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object3).addValue((String)object4);
        attributeList.put((Attribute)object3);
        object3 = new UIDGenerator();
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(((UIDGenerator)object3).getNewSOPInstanceUID((String)object8, string4, (String)object4));
        attributeList.put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object2).addValue(((UIDGenerator)object3).getNewSeriesInstanceUID((String)object8, string4));
        attributeList.put((Attribute)object2);
        object2 = new Date();
        iterator = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)((Object)iterator)).addValue(new SimpleDateFormat("yyyyMMdd").format((Date)object2));
        attributeList.put((Attribute)((Object)iterator));
        iterator = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)((Object)iterator)).addValue(new SimpleDateFormat("HHmmss.SSS").format((Date)object2));
        attributeList.put((Attribute)((Object)iterator));
        if (!bl2) {
            MultiFrameImageFactory.addStackIfNotAlreadyPresent(attributeList, map4);
        }
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109106", "DCM", "Enhanced Multi-frame Conversion Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.dicom.MultiFrameImageFactory", null, "Vers. " + VersionAndConstants.getBuildDate(), "Legacy Enhanced Image created from Classic Images");
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        object8 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
        object4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
        object3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        int n = 1;
        for (String string3 : list) {
            object = new HierarchicalImageReference((String)object8, string4, (String)object4, (String)object3, Integer.toString(n++));
            map3.put(string3, (HierarchicalImageReference)object);
        }
        return attributeList;
    }

    public static AttributeList createEnhancedImageFromFrameSet(FrameSet frameSet, Map<String, File> map, Map<String, AttributeList> map2, Map<String, HierarchicalImageReference> map3, boolean bl, boolean bl2) throws DicomException, IOException {
        return MultiFrameImageFactory.createEnhancedImageFromFrameSet(frameSet, map, map2, map3, null, bl, bl2);
    }

    public static File createEnhancedImageFromFrameSet(FrameSet frameSet, File file, Map<String, File> map, Map<String, HierarchicalImageReference> map2, Map<String, StackOfSlices> map3, boolean bl, boolean bl2) throws DicomException, IOException {
        AttributeList attributeList = MultiFrameImageFactory.createEnhancedImageFromFrameSet(frameSet, map, null, map2, map3, bl, bl2);
        File file2 = new File(file, Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.SOPInstanceUID, "NONAME"));
        attributeList.write(file2, "1.2.840.10008.1.2.1", true, true);
        return file2;
    }

    public static File createEnhancedImageFromFrameSet(FrameSet frameSet, File file, Map<String, File> map, Map<String, HierarchicalImageReference> map2, boolean bl, boolean bl2) throws DicomException, IOException {
        return MultiFrameImageFactory.createEnhancedImageFromFrameSet(frameSet, file, map, map2, null, bl, bl2);
    }

    public static File[] convertImages(Set<File> set, File file) throws DicomException, IOException {
        Object object;
        Serializable serializable2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!file.isDirectory()) {
            throw new DicomException("Output folder " + file + " does not exist");
        }
        HashMap<String, File> hashMap = new HashMap<String, File>();
        SetOfFrameSets setOfFrameSets = new SetOfFrameSets();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashMap<String, HierarchicalSOPInstanceReference> hashMap2 = new HashMap<String, HierarchicalSOPInstanceReference>();
        for (Serializable serializable2 : set) {
            try {
                if (!DicomFileUtilities.isDicomOrAcrNemaFile(serializable2)) continue;
                AttributeList attributeList = new AttributeList();
                attributeList.read((File)serializable2, TagFromName.PixelData);
                Object object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                if (((String)object2).length() > 0 && ((String)object).length() > 0) {
                    hashMap.put((String)object2, (File)serializable2);
                    hashMap2.put((String)object2, new HierarchicalSOPInstanceReference(attributeList));
                    HierarchicalSOPInstanceReference.addToHierarchicalReferencesToSOPInstances(attributeList, hashMap2);
                    if (SOPClass.isImageStorage((String)object) && !attributeList.isEnhanced()) {
                        setOfFrameSets.insertIntoFrameSets(attributeList);
                        continue;
                    }
                    slf4jlogger.info("doCommonConstructorStuff(): Doing nothing to non-image or already enhanced \"{}\" ({})", serializable2, SOPClassDescriptions.getAbbreviationFromUID((String)object));
                    hashSet.add(object2);
                    continue;
                }
                throw new DicomException("Missing SOP Instance or Class UID in file " + serializable2);
            }
            catch (Exception exception) {
                slf4jlogger.error("While reading \"{}\"", serializable2, exception);
            }
        }
        nextStackID = 1;
        TreeMap treeMap = new TreeMap();
        serializable2 = new HashMap();
        for (Object object2 : setOfFrameSets) {
            object = MultiFrameImageFactory.createEnhancedImageFromFrameSet((FrameSet)object2, file, hashMap, (Map<String, HierarchicalImageReference>)((Object)serializable2), (Map<String, StackOfSlices>)treeMap, useRandomFrameOrderOption, doNotEncodeStackInformationOption);
            arrayList.add(object);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] convertImages(File[] fileArray, File file) throws DicomException, IOException {
        HashSet<File> hashSet = new HashSet<File>();
        for (File file2 : fileArray) {
            hashSet.add(file2);
        }
        return MultiFrameImageFactory.convertImages(hashSet, file);
    }

    public static File[] convertImages(String[] stringArray, String string) throws DicomException, IOException {
        HashSet<File> hashSet = new HashSet<File>();
        for (String string2 : stringArray) {
            ArrayList<File> arrayList = FileUtilities.listFilesRecursively(new File(string2));
            hashSet.addAll(arrayList);
        }
        return MultiFrameImageFactory.convertImages(hashSet, new File(string));
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 2) {
                File[] fileArray;
                int n = stringArray.length - 1;
                String string = stringArray[n];
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                for (File file : fileArray = MultiFrameImageFactory.convertImages(stringArray2, string)) {
                    System.err.println("Output file: " + file);
                }
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: MultiFrameImageFactory inputPaths outputPath");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static {
        excludeFromCopyingIntoFunctionalGroups.add(TagFromName.SpecificCharacterSet);
        farthestFutureDate = new Date(Long.MAX_VALUE);
    }
}

