/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherByteAttributeMultipleFrameArrays
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttributeMultipleFrameArrays.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    private byte[][] values;

    public OtherByteAttributeMultipleFrameArrays(AttributeTag attributeTag) {
        super(attributeTag);
    }

    @Override
    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            long l = 0L;
            for (int i = 0; i < this.values.length; ++i) {
                dicomOutputStream.write(this.values[i]);
                l += (long)this.values[i].length;
            }
            long l2 = this.getPaddedVL() - l;
            while (l2-- > 0L) {
                dicomOutputStream.write(0);
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public void setValuesPerFrame(byte[][] byArray) throws DicomException {
        if (byArray == null) {
            this.values = null;
            this.valueMultiplicity = 0;
            this.valueLength = 0L;
        } else {
            int n = 0;
            this.values = new byte[byArray.length][];
            for (int i = 0; i < byArray.length; ++i) {
                this.values[i] = byArray[i];
                if (n == 0) {
                    n = byArray[i].length;
                    continue;
                }
                if (n == byArray[i].length) continue;
                throw new DicomException("Frame byte arrays are not same length - have " + byArray[i].length + " dec bytes for frame " + i + " does not match earlier frame " + n + " dec bytes");
            }
            this.values = byArray;
            this.valueMultiplicity = 1;
            this.valueLength = byArray.length * n;
        }
    }

    public byte[][] getByteValuesPerFrame() throws DicomException {
        byte[][] byArrayArray = new byte[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            byArrayArray[i] = this.values[i];
        }
        return byArrayArray;
    }

    public int getNumberOfFrames() {
        return this.values.length;
    }

    @Override
    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OB;
    }
}

