/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.OtherAttributeOnDisk;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class OtherByteAttributeOnDisk
extends OtherAttributeOnDisk {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttributeOnDisk.java,v 1.21 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OtherByteAttributeOnDisk.class);

    public OtherByteAttributeOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherByteAttributeOnDisk(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream, l2);
    }

    public OtherByteAttributeOnDisk(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, Long l2) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream, l2);
    }

    @Override
    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.valueLength > 0L) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            CopyStream.skipInsistently(bufferedInputStream, this.byteOffset);
            CopyStream.copy(bufferedInputStream, dicomOutputStream, this.valueLength);
            bufferedInputStream.close();
            long l = this.getPaddedVL() - this.valueLength;
            while (l-- > 0L) {
                dicomOutputStream.write(0);
            }
        }
    }

    @Override
    public byte[] getByteValues() throws DicomException {
        byte[] byArray = null;
        if (this.valueLength > 0L) {
            byArray = new byte[(int)this.valueLength];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
                binaryInputStream.skipInsistently(this.byteOffset);
                binaryInputStream.readInsistently(byArray, 0, (int)this.valueLength);
                binaryInputStream.close();
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                throw new DicomException("Failed to read value (length " + this.valueLength + " dec) in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
        return byArray;
    }

    public byte[][] getByteValuesPerFrame(int n) throws DicomException {
        Object object = null;
        if (this.valueLength > 0L) {
            int n2 = (int)(this.valueLength / (long)n);
            object = new byte[n][];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
                binaryInputStream.skipInsistently(this.byteOffset);
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = new byte[n2];
                    object[i] = byArray;
                    binaryInputStream.readInsistently(byArray, 0, n2);
                }
                binaryInputStream.close();
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                throw new DicomException("Failed to read value (length " + this.valueLength + " dec) in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
        return object;
    }

    public byte[] getByteValuesForSelectedFrame(int n, int n2) throws DicomException {
        byte[] byArray = null;
        int n3 = (int)(this.valueLength / (long)n2);
        long l = (long)n3 * (long)n;
        if (l + (long)n3 <= this.valueLength) {
            byArray = new byte[n3];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
                binaryInputStream.skipInsistently(this.byteOffset + l);
                binaryInputStream.readInsistently(byArray, 0, n3);
                binaryInputStream.close();
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read frame " + n + " of " + n2 + " frames, size " + n3 + " dec and offset " + l + " dec bytes in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        } else {
            throw new DicomException("Requested frame " + n + " of " + n2 + " frames, size " + n3 + " dec and offset " + l + " dec bytes to read value exceeds length " + this.valueLength + " dec in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
        }
        return byArray;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OB;
    }
}

