/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherDoubleAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherDoubleAttribute.java,v 1.14 2025/01/29 10:58:07 dclunie Exp $";
    private double[] values;

    public OtherDoubleAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherDoubleAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public OtherDoubleAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.values = null;
        this.valueLength = l;
        if (l > 0L) {
            int n = (int)(l / 8L);
            double[] dArray = new double[n];
            dicomInputStream.readDouble(dArray, n);
            this.setValues(dArray);
        }
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            dicomOutputStream.writeDouble(this.values, this.values.length);
            if (this.getVL() != (long)(this.values.length * 8)) {
                throw new DicomException("Internal error - double array length (" + this.values.length * 8 + ") not equal to expected VL(" + this.getVL() + ")");
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    @Override
    public void setValues(double[] dArray) throws DicomException {
        this.values = dArray;
        this.valueMultiplicity = 1;
        this.valueLength = dArray.length * 8;
    }

    @Override
    public void setValues(byte[] byArray, boolean bl) throws DicomException {
        int n = byArray.length / 8;
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = (long)byArray[n2++] & 0xFFL;
            long l2 = (long)byArray[n2++] & 0xFFL;
            long l3 = (long)byArray[n2++] & 0xFFL;
            long l4 = (long)byArray[n2++] & 0xFFL;
            long l5 = (long)byArray[n2++] & 0xFFL;
            long l6 = (long)byArray[n2++] & 0xFFL;
            long l7 = (long)byArray[n2++] & 0xFFL;
            long l8 = (long)byArray[n2++] & 0xFFL;
            dArray[i] = Double.longBitsToDouble(bl ? ((((((l << 8 | l2) << 8 | l3) << 8 | l4) << 8 | l5) << 8 | l6) << 8 | l7) << 8 | l8 : ((((((l8 << 8 | l7) << 8 | l6) << 8 | l5) << 8 | l4) << 8 | l3) << 8 | l2) << 8 | l);
        }
        this.setValues(dArray);
    }

    @Override
    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public double[] getDoubleValues() throws DicomException {
        return this.values;
    }

    @Override
    public byte[] getByteValues(boolean bl) throws DicomException {
        byte[] byArray;
        block4: {
            byArray = null;
            if (this.values == null) break block4;
            int n = this.values.length;
            byArray = new byte[n * 8];
            int n2 = 0;
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    long l = Double.doubleToRawLongBits(this.values[i]);
                    byArray[n2++] = (byte)(l >> 56);
                    byArray[n2++] = (byte)(l >> 48);
                    byArray[n2++] = (byte)(l >> 40);
                    byArray[n2++] = (byte)(l >> 32);
                    byArray[n2++] = (byte)(l >> 24);
                    byArray[n2++] = (byte)(l >> 16);
                    byArray[n2++] = (byte)(l >> 8);
                    byArray[n2++] = (byte)l;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    long l = Double.doubleToRawLongBits(this.values[i]);
                    byArray[n2++] = (byte)l;
                    byArray[n2++] = (byte)(l >> 8);
                    byArray[n2++] = (byte)(l >> 16);
                    byArray[n2++] = (byte)(l >> 24);
                    byArray[n2++] = (byte)(l >> 32);
                    byArray[n2++] = (byte)(l >> 40);
                    byArray[n2++] = (byte)(l >> 48);
                    byArray[n2++] = (byte)(l >> 56);
                }
            }
        }
        return byArray;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OD;
    }
}

