/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.SingleOverlay;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;

public class Overlay {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/Overlay.java,v 1.21 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(Overlay.class);
    private int numberOfFrames;
    private SingleOverlay[] arrayOfOverlays;
    private SingleOverlay[][] arrayOfOverlaysPerFrame;
    private int[] numberOfOverlaysPerFrame;

    private void constructArrayOfOverlaysPerFrame() {
        slf4jlogger.debug("constructArrayOfOverlaysPerFrame(): numberOfFrames =  {}", this.numberOfFrames);
        if (this.arrayOfOverlaysPerFrame == null) {
            slf4jlogger.debug("constructArrayOfOverlaysPerFrame(): have arrayOfOverlaysPerFrame");
            this.arrayOfOverlaysPerFrame = new SingleOverlay[this.numberOfFrames][];
            this.numberOfOverlaysPerFrame = new int[this.numberOfFrames];
            for (int i = 0; i < this.numberOfFrames; ++i) {
                slf4jlogger.debug("constructArrayOfOverlaysPerFrame(): doing frame {}", i);
                int n = this.arrayOfOverlays.length;
                this.arrayOfOverlaysPerFrame[i] = new SingleOverlay[n];
                for (int j = 0; j < n; ++j) {
                    SingleOverlay singleOverlay = this.arrayOfOverlays[j];
                    if (singleOverlay == null || !singleOverlay.appliesToFrame(i)) continue;
                    this.arrayOfOverlaysPerFrame[i][j] = singleOverlay;
                    int n2 = i;
                    this.numberOfOverlaysPerFrame[n2] = this.numberOfOverlaysPerFrame[n2] + 1;
                }
            }
        }
    }

    public Overlay(SingleOverlay[] singleOverlayArray) {
        this.arrayOfOverlays = singleOverlayArray;
        this.arrayOfOverlaysPerFrame = null;
        this.numberOfOverlaysPerFrame = null;
        this.numberOfFrames = 1;
        for (SingleOverlay singleOverlay : singleOverlayArray) {
            int n = singleOverlay.getFrames();
            int n2 = singleOverlay.getFrameOrigin();
            int n3 = n2 + n;
            if (n3 <= this.numberOfFrames) continue;
            this.numberOfFrames = n3;
        }
    }

    public AttributeList getAttributeList() throws DicomException {
        AttributeList attributeList = new AttributeList();
        SingleOverlay[] singleOverlayArray = new IntegerStringAttribute(TagFromName.NumberOfFrames);
        singleOverlayArray.addValue(this.numberOfFrames);
        attributeList.put((Attribute)singleOverlayArray);
        for (SingleOverlay singleOverlay : this.arrayOfOverlays) {
            short s = singleOverlay.getGroup();
            Attribute attribute = new OtherWordAttribute(new AttributeTag(s, TagFromName.OverlayData.getElement()));
            attribute.setValues(singleOverlay.getData());
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(new AttributeTag(s, TagFromName.OverlayRows.getElement()));
            attribute.addValue(singleOverlay.getRows());
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(new AttributeTag(s, TagFromName.OverlayColumns.getElement()));
            attribute.addValue(singleOverlay.getColumns());
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(new AttributeTag(s, TagFromName.OverlayBitPosition.getElement()));
            attribute.addValue(singleOverlay.getBitPosition());
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(new AttributeTag(s, TagFromName.OverlayBitsAllocated.getElement()));
            attribute.addValue(1);
            attributeList.put(attribute);
            attribute = new SignedShortAttribute(new AttributeTag(s, TagFromName.OverlayOrigin.getElement()));
            attribute.addValue(singleOverlay.getRowOrigin(0) + 1);
            attribute.addValue(singleOverlay.getColumnOrigin(0) + 1);
            attributeList.put(attribute);
            attribute = new CodeStringAttribute(new AttributeTag(s, TagFromName.OverlayType.getElement()));
            attribute.addValue("G");
            attributeList.put(attribute);
        }
        return attributeList;
    }

    public Overlay(AttributeList attributeList) {
        this.arrayOfOverlays = new SingleOverlay[16];
        this.arrayOfOverlaysPerFrame = null;
        this.numberOfOverlaysPerFrame = null;
        this.numberOfFrames = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        for (int n = 0; n < 32; n = (int)((short)(n + 2))) {
            int n2 = n / 2;
            this.arrayOfOverlays[n2] = null;
            short s = (short)(24576 + n);
            Attribute attribute = attributeList.get(new AttributeTag(s, TagFromName.OverlayData.getElement()));
            Attribute attribute2 = attributeList.get(new AttributeTag(s, TagFromName.OverlayRows.getElement()));
            Attribute attribute3 = attributeList.get(new AttributeTag(s, TagFromName.OverlayColumns.getElement()));
            Attribute attribute4 = attributeList.get(new AttributeTag(s, TagFromName.OverlayBitPosition.getElement()));
            if (attribute == null && attribute2 == null && attribute3 == null && attribute4 == null) continue;
            try {
                this.arrayOfOverlays[n2] = new SingleOverlay(attributeList, s);
                continue;
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
    }

    public int getNumberOfOverlays(int n) {
        this.constructArrayOfOverlaysPerFrame();
        return this.numberOfOverlaysPerFrame[n];
    }

    public BufferedImage getOverlayAsBinaryBufferedImage(int n, int n2) {
        this.constructArrayOfOverlaysPerFrame();
        SingleOverlay singleOverlay = this.arrayOfOverlaysPerFrame[n][n2];
        return singleOverlay == null ? null : singleOverlay.getOverlayAsBinaryBufferedImage(n);
    }

    public int getRowOrigin(int n, int n2) {
        this.constructArrayOfOverlaysPerFrame();
        SingleOverlay singleOverlay = this.arrayOfOverlaysPerFrame[n][n2];
        return singleOverlay == null ? 0 : singleOverlay.getRowOrigin(n);
    }

    public int getColumnOrigin(int n, int n2) {
        this.constructArrayOfOverlaysPerFrame();
        SingleOverlay singleOverlay = this.arrayOfOverlaysPerFrame[n][n2];
        return singleOverlay == null ? 0 : singleOverlay.getColumnOrigin(n);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.arrayOfOverlays.length; ++i) {
            if (this.arrayOfOverlays[i] == null) continue;
            stringBuffer.append(this.arrayOfOverlays[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            String string = stringArray[0];
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string);
                Overlay overlay = new Overlay(attributeList);
                System.err.print(overlay);
                System.err.println("getNumberOfOverlays(frame 0) = " + overlay.getNumberOfOverlays(0));
                System.err.println("getOverlayAsBinaryBufferedImage(frame 0,overlay 0) = " + overlay.getOverlayAsBinaryBufferedImage(0, 0));
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

