/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class StackOfSlices {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/StackOfSlices.java,v 1.13 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StackOfSlices.class);
    protected String frameOfReferenceUID;
    protected double[] rowOrientation;
    protected double[] columnOrientation;
    protected SortedMap<Double, SortedSet<Integer>> mapOfDistanceToSetOfSlices;
    protected int[] inStackPositionBySlice;

    /*
     * WARNING - void declaration
     */
    public StackOfSlices(AttributeList attributeList) throws DicomException {
        int n;
        this.frameOfReferenceUID = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID);
        this.mapOfDistanceToSetOfSlices = null;
        GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
        GeometryOfSlice[] geometryOfSliceArray = geometryOfVolumeFromAttributeList.getGeometryOfSlices();
        if (geometryOfSliceArray != null && (n = geometryOfSliceArray.length) > 1 && geometryOfVolumeFromAttributeList.areAllSlicesParallel()) {
            int n2;
            slf4jlogger.info("addStack(): are parallel");
            this.rowOrientation = geometryOfSliceArray[0].getRowArray();
            this.columnOrientation = geometryOfSliceArray[0].getColumnArray();
            this.mapOfDistanceToSetOfSlices = new TreeMap<Double, SortedSet<Integer>>();
            for (n2 = 0; n2 < n; ++n2) {
                void sortedSet;
                Double d = new Double(geometryOfSliceArray[n2].getDistanceAlongNormalFromOrigin());
                SortedSet sortedSet2 = (SortedSet)this.mapOfDistanceToSetOfSlices.get(d);
                if (sortedSet2 == null) {
                    TreeSet treeSet = new TreeSet();
                    this.mapOfDistanceToSetOfSlices.put(d, treeSet);
                }
                sortedSet.add(new Integer(n2));
            }
            this.inStackPositionBySlice = new int[n];
            n2 = 1;
            for (Double d : this.mapOfDistanceToSetOfSlices.keySet()) {
                slf4jlogger.info("addStack(): distance={}", d);
                SortedSet sortedSet = (SortedSet)this.mapOfDistanceToSetOfSlices.get(d);
                for (Integer n3 : sortedSet) {
                    int n4 = n3;
                    if (this.inStackPositionBySlice[n4] != 0) {
                        slf4jlogger.error("addStack(): distance={} inStackPositionBySlice[f] already exists={} frame={}", d, this.inStackPositionBySlice[n4], n4);
                    }
                    this.inStackPositionBySlice[n4] = n2;
                    slf4jlogger.info("addStack(): distance={} inStackPosition={} frame={}", d, n2, n4);
                }
                ++n2;
            }
        }
    }

    boolean isValid() {
        return this.frameOfReferenceUID != null && this.rowOrientation != null && this.mapOfDistanceToSetOfSlices != null && this.columnOrientation != null && this.inStackPositionBySlice != null;
    }

    public void addStackAttributesToExistingFrameContentSequence(AttributeList attributeList, String string) throws DicomException {
        slf4jlogger.info("addStack(): adding stack {}", string);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        for (int i = 0; i < n; ++i) {
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)sequenceAttribute.getItem(i).getAttributeList().get(TagFromName.FrameContentSequence);
            AttributeList attributeList2 = sequenceAttribute2.getItem(0).getAttributeList();
            Attribute attribute = new ShortStringAttribute(TagFromName.StackID);
            attribute.addValue(string);
            attributeList2.put(attribute);
            attribute = new UnsignedLongAttribute(TagFromName.InStackPositionNumber);
            attribute.addValue(this.inStackPositionBySlice[i]);
            attributeList2.put(attribute);
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof StackOfSlices) {
            StackOfSlices stackOfSlices = (StackOfSlices)object;
            bl = this.frameOfReferenceUID.equals(stackOfSlices.frameOfReferenceUID) && this.rowOrientation[0] == stackOfSlices.rowOrientation[0] && this.rowOrientation[1] == stackOfSlices.rowOrientation[1] && this.rowOrientation[2] == stackOfSlices.rowOrientation[2] && this.columnOrientation[0] == stackOfSlices.columnOrientation[0] && this.columnOrientation[1] == stackOfSlices.columnOrientation[1] && this.columnOrientation[2] == stackOfSlices.columnOrientation[2] && this.mapOfDistanceToSetOfSlices.equals(stackOfSlices.mapOfDistanceToSetOfSlices);
        }
        return bl;
    }

    public int hashCode() {
        return this.frameOfReferenceUID.hashCode() + this.mapOfDistanceToSetOfSlices.hashCode();
    }
}

