/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;

public abstract class TextAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TextAttribute.java,v 1.29 2025/01/29 10:58:07 dclunie Exp $";
    protected SpecificCharacterSet specificCharacterSet;
    String[] values;

    public abstract int getMaximumLengthOfEntireValue();

    protected String translateByteArrayToString(byte[] byArray, int n, int n2) {
        return this.specificCharacterSet == null ? new String(byArray, 0, n2) : this.specificCharacterSet.translateByteArrayToString(byArray, 0, n2);
    }

    protected byte[] translateStringToByteArray(String string) throws UnsupportedEncodingException {
        return this.specificCharacterSet == null ? string.getBytes() : this.specificCharacterSet.translateStringToByteArray(string);
    }

    protected TextAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.doCommonConstructorStuff(null);
    }

    protected TextAttribute(AttributeTag attributeTag, SpecificCharacterSet specificCharacterSet) {
        super(attributeTag);
        this.doCommonConstructorStuff(specificCharacterSet);
    }

    protected TextAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, specificCharacterSet);
    }

    protected TextAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, specificCharacterSet);
    }

    private void doCommonConstructorStuff(SpecificCharacterSet specificCharacterSet) {
        this.values = null;
        this.specificCharacterSet = specificCharacterSet;
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        this.doCommonConstructorStuff(specificCharacterSet);
        if (l > 0L) {
            byte[] byArray = new byte[(int)l];
            try {
                dicomInputStream.readInsistently(byArray, 0, (int)l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
            String string = this.translateByteArrayToString(byArray, 0, (int)l);
            l = string.length();
            this.addValue(string);
        }
    }

    @Override
    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    private byte getPadByte() {
        return 32;
    }

    private byte[] getPaddedByteValues() throws DicomException {
        String[] stringArray = this.getStringValues();
        byte[] byArray = null;
        try {
            if (stringArray != null) {
                byArray = this.translateStringToByteArray(stringArray[0]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomException("Unsupported encoding:" + unsupportedEncodingException);
        }
        if (byArray != null) {
            int n = byArray.length;
            if (n % 2 != 0) {
                byte[] byArray2 = new byte[n + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray2[n] = this.getPadByte();
                byArray = byArray2;
            }
            if (this.getPaddedVL() != (long)byArray.length) {
                throw new DicomException("Internal error - byte array length not equal to expected padded VL");
            }
        }
        return byArray;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        byte[] byArray = this.getPaddedByteValues();
        if (byArray != null && byArray.length > 0) {
            dicomOutputStream.write(byArray);
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" <");
        try {
            String[] stringArray = this.getStringValues();
            if (stringArray != null) {
                stringBuffer.append(stringArray[0]);
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    @Override
    public byte[] getByteValues() throws DicomException {
        return this.getPaddedByteValues();
    }

    @Override
    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        return this.values;
    }

    @Override
    public void addValue(String string) throws DicomException {
        if (this.values != null || this.valueMultiplicity > 0) {
            throw new DicomException("No more than one value allowed for text attributes");
        }
        this.values = new String[1];
        this.values[0] = string;
        try {
            this.valueLength = this.translateStringToByteArray(string).length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomException(unsupportedEncodingException.toString());
        }
        ++this.valueMultiplicity;
    }

    @Override
    public void removeValues() throws DicomException {
        this.valueLength = 0L;
        this.valueMultiplicity = 0;
        this.values = null;
    }

    @Override
    public boolean isValid() throws DicomException {
        boolean bl = true;
        if (this.values != null && this.values.length > 0) {
            if (this.values.length > 1) {
                throw new DicomException("Internal error - no more than one value allowed for text attributes");
            }
            String string = this.values[0];
            if (string != null && string.length() > this.getMaximumLengthOfEntireValue()) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean repairValues() throws DicomException {
        String string;
        if (!this.isValid() && this.values != null && this.values.length > 0 && (string = this.values[0]) != null && string.length() > this.getMaximumLengthOfEntireValue()) {
            this.values[0] = string = string.substring(0, this.getMaximumLengthOfEntireValue()).trim();
        }
        return this.isValid();
    }
}

