/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public class TransferSyntax {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TransferSyntax.java,v 1.40 2025/01/29 10:58:07 dclunie Exp $";
    public static final String ImplicitVRLittleEndian = "1.2.840.10008.1.2";
    public static final String ExplicitVRLittleEndian = "1.2.840.10008.1.2.1";
    public static final String ExplicitVRBigEndian = "1.2.840.10008.1.2.2";
    public static final String Default = "1.2.840.10008.1.2";
    public static final String DeflatedExplicitVRLittleEndian = "1.2.840.10008.1.2.1.99";
    public static final String JPEGBaseline = "1.2.840.10008.1.2.4.50";
    public static final String JPEGExtended = "1.2.840.10008.1.2.4.51";
    public static final String JPEGFullProgressionNonHierarchical1012 = "1.2.840.10008.1.2.4.55";
    public static final String JPEGLossless = "1.2.840.10008.1.2.4.57";
    public static final String JPEGLosslessSV1 = "1.2.840.10008.1.2.4.70";
    public static final String JPEGLS = "1.2.840.10008.1.2.4.80";
    public static final String JPEGNLS = "1.2.840.10008.1.2.4.81";
    public static final String JPEG2000Lossless = "1.2.840.10008.1.2.4.90";
    public static final String JPEG2000 = "1.2.840.10008.1.2.4.91";
    public static final String MPEG2MPML = "1.2.840.10008.1.2.4.100";
    public static final String MPEG2MPHL = "1.2.840.10008.1.2.4.101";
    public static final String MPEG4HP41 = "1.2.840.10008.1.2.4.102";
    public static final String MPEG4HP41BD = "1.2.840.10008.1.2.4.103";
    public static final String MPEG4HP422D = "1.2.840.10008.1.2.4.104";
    public static final String MPEG4HP423D = "1.2.840.10008.1.2.4.105";
    public static final String MPEG4HP42ST = "1.2.840.10008.1.2.4.106";
    public static final String RLE = "1.2.840.10008.1.2.5";
    public static final String PixelMedBzip2ExplicitVRLittleEndian = "1.3.6.1.4.1.5962.300.1";
    public static final String PixelMedEncapsulatedRawLittleEndian = "1.3.6.1.4.1.5962.300.2";
    public static final String Papyrus3ImplicitVRLittleEndian = "1.2.840.10008.1.20";
    protected String transferSyntaxUID;
    protected String description;
    protected boolean bigEndian;
    protected boolean explicitVR;
    protected boolean encapsulatedPixelData;
    protected boolean lossy;
    protected boolean recognized;
    protected boolean jpegFamily;
    protected String fileNameExtension;

    public TransferSyntax(String string) {
        this.transferSyntaxUID = string;
        this.description = "Unrecognized";
        this.bigEndian = false;
        this.explicitVR = true;
        this.encapsulatedPixelData = false;
        this.lossy = false;
        this.recognized = false;
        this.fileNameExtension = "unk";
        this.jpegFamily = false;
        if (this.transferSyntaxUID.equals("1.2.840.10008.1.2")) {
            this.description = "Implicit VR Little Endian";
            this.bigEndian = false;
            this.explicitVR = false;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "dat";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(ExplicitVRLittleEndian)) {
            this.description = "Explicit VR Little Endian";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "dat";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(ExplicitVRBigEndian)) {
            this.description = "Explicit VR Big Endian";
            this.bigEndian = true;
            this.explicitVR = true;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "dat";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(PixelMedEncapsulatedRawLittleEndian)) {
            this.description = "PixelMed Encapsulated Raw Little Endian";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "dat";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(JPEGBaseline)) {
            this.description = "JPEG Baseline";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "jpg";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEGExtended)) {
            this.description = "JPEG Extended";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "jpg";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEGFullProgressionNonHierarchical1012)) {
            this.description = "JPEG Full Progression, Non-Hierarchical (Process 10 & 12)";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "jpg";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEG2000Lossless)) {
            this.description = "JPEG 2000 Lossless Only";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "j2k";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEG2000)) {
            this.description = "JPEG 2000";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "j2k";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEGLossless)) {
            this.description = "JPEG Lossless";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "jpl";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEGLosslessSV1)) {
            this.description = "JPEG Lossless SV1";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "jpl";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEGLS)) {
            this.description = "JPEG-LS";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "jls";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(JPEGNLS)) {
            this.description = "JPEG-LS Near-lossless";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "jls";
            this.jpegFamily = true;
        } else if (this.transferSyntaxUID.equals(MPEG2MPML)) {
            this.description = "MPEG2 MPML";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mpg";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(MPEG2MPHL)) {
            this.description = "MPEG2 MPHL";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mpg";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(MPEG4HP41)) {
            this.description = "MPEG4 HP/4.1";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mp4";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(MPEG4HP41BD)) {
            this.description = "MPEG4 HP/4.1 BD";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mp4";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(MPEG4HP422D)) {
            this.description = "MPEG4 HP/4.2 2D";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mp4";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(MPEG4HP423D)) {
            this.description = "MPEG4 HP/4.2 3D";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mp4";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(MPEG4HP42ST)) {
            this.description = "MPEG4 HP/4.2 Stereo";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = true;
            this.recognized = true;
            this.fileNameExtension = "mp4";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(RLE)) {
            this.description = "RLE Lossless";
            this.bigEndian = false;
            this.explicitVR = true;
            this.encapsulatedPixelData = true;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "rle";
            this.jpegFamily = false;
        } else if (this.transferSyntaxUID.equals(Papyrus3ImplicitVRLittleEndian)) {
            this.description = "Papyrus 3 Implicit VR Little Endian";
            this.bigEndian = false;
            this.explicitVR = false;
            this.encapsulatedPixelData = false;
            this.lossy = false;
            this.recognized = true;
            this.fileNameExtension = "dat";
            this.jpegFamily = false;
        }
    }

    public TransferSyntax(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.transferSyntaxUID = string;
        this.description = string2;
        this.explicitVR = bl;
        this.bigEndian = bl2;
        this.encapsulatedPixelData = bl3;
        this.lossy = bl4;
        this.fileNameExtension = null;
    }

    public TransferSyntax(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3) {
        this(string, string2, bl, bl2, bl3, bl4);
        this.fileNameExtension = string3;
    }

    public TransferSyntax(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, boolean bl5) {
        this(string, string2, bl, bl2, bl3, bl4, string3);
        this.jpegFamily = bl5;
    }

    public String getUID() {
        return this.transferSyntaxUID;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRecognized() {
        return this.recognized;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isLittleEndian() {
        return !this.bigEndian;
    }

    public boolean isExplicitVR() {
        return this.explicitVR;
    }

    public boolean isImplicitVR() {
        return !this.explicitVR;
    }

    public boolean isEncapsulated() {
        return this.encapsulatedPixelData;
    }

    public boolean isNotEncapsulated() {
        return !this.encapsulatedPixelData;
    }

    public boolean isLossy() {
        return this.lossy;
    }

    public String getFileNameExtension() {
        return this.fileNameExtension;
    }

    public boolean isJPEGFamily() {
        return this.jpegFamily;
    }

    public boolean isDeflated() {
        return this.transferSyntaxUID.equals(DeflatedExplicitVRLittleEndian);
    }

    public boolean isBzip2ed() {
        return this.transferSyntaxUID.equals(PixelMedBzip2ExplicitVRLittleEndian);
    }

    public String toString() {
        return this.transferSyntaxUID;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Transfer Syntax UID =");
        stringBuffer.append(this.transferSyntaxUID);
        stringBuffer.append("\n");
        stringBuffer.append("\tdescription =");
        stringBuffer.append(this.description);
        stringBuffer.append("\n");
        stringBuffer.append("\tbigEndian =");
        stringBuffer.append(this.bigEndian);
        stringBuffer.append("\n");
        stringBuffer.append("\texplicitVR =");
        stringBuffer.append(this.explicitVR);
        stringBuffer.append("\n");
        stringBuffer.append("\tencapsulatedPixelData =");
        stringBuffer.append(this.encapsulatedPixelData);
        stringBuffer.append("\n");
        stringBuffer.append("\tlossy =");
        stringBuffer.append(this.lossy);
        stringBuffer.append("\n");
        stringBuffer.append("\trecognized =");
        stringBuffer.append(this.recognized);
        stringBuffer.append("\n");
        stringBuffer.append("\tfileNameExtension =");
        stringBuffer.append(this.fileNameExtension);
        stringBuffer.append("\n");
        stringBuffer.append("\tjpegFamily =");
        stringBuffer.append(this.jpegFamily);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static boolean isExplicitVR(String string) {
        return !TransferSyntax.isImplicitVR(string);
    }

    public static boolean isImplicitVR(String string) {
        return string.equals("1.2.840.10008.1.2");
    }

    public static boolean isBigEndian(String string) {
        return string.equals(ExplicitVRBigEndian);
    }

    public static boolean isLittleEndian(String string) {
        return !TransferSyntax.isBigEndian(string);
    }

    public static boolean isEncapsulated(String string) {
        return !TransferSyntax.isNotEncapsulated(string);
    }

    public static boolean isNotEncapsulated(String string) {
        return string.equals("1.2.840.10008.1.2") || string.equals(ExplicitVRLittleEndian) || string.equals(ExplicitVRBigEndian);
    }
}

