/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.utils.MACAddress;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.HashSet;
import java.util.StringTokenizer;

public class UIDGenerator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UIDGenerator.java,v 1.21 2025/01/29 10:58:07 dclunie Exp $";
    private static final String UIDGEN_ANY = "0";
    private static final String UIDGEN_INSTANCE_SOP = "1";
    private static final String UIDGEN_INSTANCE_STUDY = "2";
    private static final String UIDGEN_INSTANCE_SERIES = "3";
    private static final String UIDGEN_FRAMEOFREFERENCE = "4";
    private static final String UIDGEN_INSTANCE_DIR = "5";
    private static final String UIDGEN_DIMENSIONORGANIZATION = "6";
    private static final String UIDGEN_CONCATENATION = "7";
    private String stamp;
    private String longStamp;
    private static final String root = "1.3.6.1.4.1.5962.99.1";
    private static final int maxStampComponentLength = 64 - "1.3.6.1.4.1.5962.99.1".length() - 1 - 3 - 2 - 5 - 5 - 5;
    private static final int maxLongStampComponentLength = 64 - "1.3.6.1.4.1.5962.99.1".length() - 1 - 3 - 2;
    private static VMID vmid = new VMID();
    private static long machineAddress = vmid.isUnique() ? (long)vmid.hashCode() & 0xFFFFFFFFL : new MACAddress().getMACAddress();

    public UIDGenerator() {
        this.newStamp();
    }

    public void newStamp() {
        long l = Math.abs(machineAddress);
        String string = new UID().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = Math.abs(Integer.valueOf(stringTokenizer.nextToken(), 16));
        long l2 = Math.abs(Long.valueOf(stringTokenizer.nextToken(), 16));
        int n2 = Math.abs(Short.valueOf(stringTokenizer.nextToken(), 16) + 32768);
        String string2 = Long.toString(l);
        String string3 = Integer.toString(n);
        String string4 = Long.toString(l2);
        String string5 = Integer.toString(n2);
        while (n > 10000 && string2.length() + string3.length() + string4.length() + string5.length() > maxLongStampComponentLength) {
            string3 = Integer.toString(n /= 10);
        }
        while (l > 0L && string2.length() + string3.length() + string4.length() + string5.length() > maxLongStampComponentLength) {
            string2 = Long.toString(l /= 10L);
        }
        this.longStamp = string2 + "." + string3 + "." + string4 + "." + string5;
        while (n > 10000 && string2.length() + string3.length() + string4.length() + string5.length() > maxStampComponentLength) {
            string3 = Integer.toString(n /= 10);
        }
        while (l > 0L && string2.length() + string3.length() + string4.length() + string5.length() > maxStampComponentLength) {
            string2 = Long.toString(l /= 10L);
        }
        this.stamp = string2 + "." + string3 + "." + string4 + "." + string5;
    }

    public UIDGenerator(String string) {
        this.stamp = string;
    }

    private String getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(String string) {
        String string2 = ".0";
        if (string != null) {
            try {
                long l = Math.abs(Long.parseLong(string));
                if (l > 9999L) {
                    l %= 10000L;
                }
                string2 = "." + Long.toString(l);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string2;
    }

    public String getNewUID() throws DicomException {
        String string = "1.3.6.1.4.1.5962.99.1." + this.longStamp + "." + UIDGEN_ANY;
        UIDGenerator.validateUID(string);
        return string;
    }

    public String getAnotherNewUID() throws DicomException {
        this.newStamp();
        return this.getNewUID();
    }

    public String getNewStudyInstanceUID(String string) throws DicomException {
        String string2 = "1.3.6.1.4.1.5962.99.1." + this.stamp + "." + UIDGEN_INSTANCE_STUDY + this.getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(string);
        UIDGenerator.validateUID(string2);
        return string2;
    }

    public String getNewSeriesInstanceUID(String string, String string2) throws DicomException {
        String string3 = "1.3.6.1.4.1.5962.99.1." + this.stamp + "." + UIDGEN_INSTANCE_SERIES + this.getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(string) + this.getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(string2);
        UIDGenerator.validateUID(string3);
        return string3;
    }

    public String getNewSOPInstanceUID(String string, String string2, String string3) throws DicomException {
        String string4 = "1.3.6.1.4.1.5962.99.1." + this.stamp + "." + UIDGEN_INSTANCE_SOP + this.getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(string) + this.getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(string2) + this.getLimitedLengthNumericPartOfStringOrZeroAsUIDExtension(string3);
        UIDGenerator.validateUID(string4);
        return string4;
    }

    private static final void validateUID(String string) throws DicomException {
        if (string.length() > 64) {
            throw new DicomException("Generated UID exceeds 64 characters");
        }
    }

    public static final void main(String[] stringArray) {
        try {
            int n = Integer.parseInt(stringArray[0]);
            String[] stringArray2 = new String[n];
            long l = System.currentTimeMillis();
            UIDGenerator uIDGenerator = new UIDGenerator();
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = uIDGenerator.getAnotherNewUID();
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            double d = (double)l3 / (double)n;
            System.err.println("count=" + n + ", total time=" + l3 + " ms, time per UID=" + d + " ms, uids/ms=" + 1.0 / d);
            boolean bl = true;
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                if (hashSet.contains(stringArray2[i])) {
                    System.err.println("Error - not unique - \"" + stringArray2[i] + "\"");
                    bl = false;
                    continue;
                }
                hashSet.add(stringArray2[i]);
            }
            System.err.println("Uniqueness check " + (bl ? "passes" : "fails"));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

