/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.LossyImageCompression;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.TextAnnotationPositioned;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FilterInputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;

public class DemographicAndTechniqueAnnotations {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DemographicAndTechniqueAnnotations.java,v 1.34 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DemographicAndTechniqueAnnotations.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    protected static final int NOSPECIAL = 0;
    protected static final int JUSTTIME = 1;
    protected static final int SLICESPACING = 2;
    protected static final int FRAMENUMBER = 3;
    protected static final int IMAGETYPE = 5;
    protected static final int PIXELREPN = 6;
    protected static final int CODEMEANING = 7;
    protected static final int ORIENTLABEL = 8;
    protected static final int ABBREVPHOTO = 9;
    protected static final int LOSSYCOMPRESSED = 10;
    protected static final int TEXTIFYESNO = 11;
    protected static final int CALLFUNCTION = 12;
    protected static final int DIRECTIONVECTOR = 13;
    protected static final int XRAYTUBECURRENT = 14;
    protected static final int EXPOSURETIME = 15;
    protected static final int EXPOSURE = 16;
    protected Vector<AnnotationLayoutConfigurationEntry> layout;
    private int layoutTopLeftRows;
    private int layoutBottomLeftRows;
    private int layoutTopRightRows;
    private int layoutBottomRightRows;
    private boolean swapLeftRight;
    private Vector<TextAnnotationPositioned>[] annotations;
    protected static final String multipleCodeMeaningDelimiter = " ";
    private AttributeList list;
    private GeometryOfVolume geometry;
    private int numberOfFrames;

    protected void initializeDefaultLayout() {
        this.layout = new Vector();
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.InstitutionName, null, null, null, true, true, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.Manufacturer, null, null, null, true, true, 1, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ManufacturerModelName, null, null, null, true, true, 1, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "[", true, true, 2, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientID, null, null, null, true, true, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "] ", true, true, 2, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientName, null, null, null, true, true, 2, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientSex, null, null, null, true, true, 3, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 3, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientBirthDate, null, null, null, true, true, 3, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, " [", true, true, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientAge, null, null, null, true, true, 3, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "]", true, true, 3, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.FrameLaterality, TagFromName.FrameAnatomySequence, null, null, true, true, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("NOTENH", TagFromName.Laterality, null, null, null, true, true, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("NOTENH", TagFromName.ImageLaterality, null, null, null, true, true, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.BodyPartExamined, null, null, null, true, true, 4, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AnatomicRegionSequence, TagFromName.FrameAnatomySequence, null, null, true, true, 4, 5, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AnatomicRegionSequence, null, null, null, true, true, 4, 5, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ViewPosition, null, null, null, true, true, 4, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ViewCodeSequence, null, null, null, true, true, 4, 9, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ViewModifierCodeSequence, null, TagFromName.ViewCodeSequence, null, true, true, 4, 11, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientSpeciesDescription, null, null, null, true, true, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 5, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientSpeciesCodeSequence, null, null, null, true, true, 5, 2, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 5, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ResponsiblePersonRole, null, null, null, true, true, 5, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 5, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ResponsiblePerson, null, null, null, true, true, 5, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 5, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ResponsibleOrganization, null, null, null, true, true, 5, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 5, 9, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientSexNeutered, null, null, null, true, true, 5, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.StudyDescription, null, null, null, false, true, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.SeriesDescription, null, null, null, false, true, 1, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.StudyID, null, null, null, false, true, 2, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, " [", false, true, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AccessionNumber, null, null, null, false, true, 2, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "]", false, true, 2, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.StudyDate, null, null, null, false, true, 3, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "Series #", false, true, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.SeriesNumber, null, null, null, false, true, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.FrameComments, TagFromName.FrameContentSequence, null, null, false, false, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 0, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.FrameType, TagFromName.MRImageFrameTypeSequence, null, null, false, false, 0, 2, null, 5));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", TagFromName.FrameType, TagFromName.CTImageFrameTypeSequence, null, null, false, false, 0, 2, null, 5));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ImageComments, null, null, null, false, false, 1, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ImageType, null, null, null, false, false, 1, 2, null, 5));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.FrameAcquisitionDateTime, TagFromName.FrameContentSequence, null, null, false, false, 2, 0, null, 1));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, multipleCodeMeaningDelimiter, false, false, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AcquisitionDateTime, null, null, null, false, false, 2, 2, null, 1));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 2, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AcquisitionTime, null, null, null, false, false, 2, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 2, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ContentTime, null, null, null, false, false, 2, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, " [", false, false, 2, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.TemporalPositionIndex, TagFromName.FrameContentSequence, null, null, false, false, 2, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, "]", false, false, 2, 9, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "F #", false, false, 3, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, null, false, false, 3, 1, null, 3));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, " I #", false, false, 3, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.InstanceNumber, null, null, null, false, false, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.Columns, null, null, null, false, false, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "x", false, false, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.Rows, null, null, null, false, false, 4, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "x", false, false, 4, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.NumberOfFrames, null, null, null, false, false, 4, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 4, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PixelRepresentation, null, null, null, false, false, 4, 6, null, 6));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.BitsStored, null, null, null, false, false, 4, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 4, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PhotometricInterpretation, null, null, multipleCodeMeaningDelimiter, false, false, 4, 9, null, 9));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 4, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, null, false, false, 4, 11, null, 10));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.DerivationDescription, null, null, null, false, false, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, "[", true, false, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.StackID, TagFromName.FrameContentSequence, null, null, true, false, 0, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, ":", true, false, 0, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.InStackPositionNumber, TagFromName.FrameContentSequence, null, null, true, false, 0, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, "] ", true, false, 0, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.ImagePositionPatient, TagFromName.PlanePositionSequence, null, null, true, false, 0, 5, "###.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", null, null, null, " [", true, false, 0, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", TagFromName.TablePosition, TagFromName.CTPositionSequence, null, null, true, false, 0, 7, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", null, null, null, "]", true, false, 0, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCOLD", null, null, null, " [", true, false, 0, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCOLD", TagFromName.SliceLocation, null, null, null, true, false, 0, 7, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCOLD", null, null, null, "]", true, false, 0, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, " mm", true, false, 0, 9, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.ImageOrientationPatient, TagFromName.PlaneOrientationSequence, null, null, true, false, 1, 0, "#.##", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.ImageOrientationPatient, TagFromName.PlaneOrientationSequence, null, null, true, false, 1, 2, null, 8));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.PixelSpacing, TagFromName.PixelMeasuresSequence, null, null, true, false, 2, 0, "#.###", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, "\\", true, false, 2, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, null, true, false, 2, 3, "#.###", 2));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 2, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.SliceThickness, TagFromName.PixelMeasuresSequence, null, null, true, false, 2, 5, "##.##", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 2, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", dictionary.getTagFromName("ReconstructionDiameter"), TagFromName.CTReconstructionSequence, null, null, true, false, 2, 7, "###.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", dictionary.getTagFromName("ReconstructionFieldOfView"), TagFromName.CTReconstructionSequence, null, null, true, false, 2, 7, "###.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, " mm", true, false, 2, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", dictionary.getTagFromName("FlipAngle"), TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 0, "#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, "\u00b0 ETL ", true, false, 3, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", dictionary.getTagFromName("GradientEchoTrainLength"), TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", null, null, null, "+", true, false, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", dictionary.getTagFromName("RFEchoTrainLength"), TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", null, null, null, "=", true, false, 3, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", dictionary.getTagFromName("EchoTrainLength"), TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " Avg ", true, false, 3, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", dictionary.getTagFromName("NumberOfAverages"), TagFromName.MRAveragesSequence, null, null, true, false, 3, 8, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", dictionary.getTagFromName("KVP"), TagFromName.CTXRayDetailsSequence, null, null, true, false, 3, 0, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, " kVP ", true, false, 3, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", dictionary.getTagFromName("ExposureInmAs"), TagFromName.CTExposureSequence, null, null, true, false, 3, 2, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2", null, null, null, null, true, false, 3, 2, "#.#", 16));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, " mAs", true, false, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, "TE ", true, false, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", dictionary.getTagFromName("EffectiveEchoTime"), TagFromName.MREchoSequence, null, null, true, false, 4, 1, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4", dictionary.getTagFromName("EchoTime"), null, null, null, true, false, 4, 1, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " TR ", true, false, 4, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", dictionary.getTagFromName("RepetitionTime"), TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 4, 3, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " TI ", true, false, 4, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", dictionary.getTagFromName("InversionTimes"), TagFromName.MRModifierSequence, null, null, true, false, 4, 5, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4", dictionary.getTagFromName("InversionTime"), null, null, null, true, false, 4, 5, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " mS", true, false, 4, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " B ", true, false, 4, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", dictionary.getTagFromName("DiffusionBValue"), TagFromName.MRDiffusionSequence, null, null, true, false, 4, 8, "#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 4, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", dictionary.getTagFromName("DiffusionGradientOrientation"), TagFromName.MRDiffusionSequence, dictionary.getTagFromName("DiffusionGradientDirectionSequence"), null, true, false, 4, 11, null, 13));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.AcquisitionType, TagFromName.CTAcquisitionTypeSequence, null, null, true, false, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", dictionary.getTagFromName("SpiralPitchFactor"), TagFromName.CTTableDynamicsSequence, null, null, true, false, 4, 2, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, ":1 ", true, false, 4, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", dictionary.getTagFromName("TableSpeed"), TagFromName.CTTableDynamicsSequence, null, null, true, false, 4, 4, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, " mm/s", true, false, 4, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.AcquisitionContrast, TagFromName.MRImageFrameTypeSequence, null, null, true, false, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", dictionary.getTagFromName("ConvolutionKernel"), TagFromName.CTReconstructionSequence, null, null, true, false, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 5, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", dictionary.getTagFromName("ConvolutionKernelGroup"), TagFromName.CTReconstructionSequence, null, null, true, false, 5, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.ContrastBolusAgentPhase, TagFromName.ContrastBolusUsageSequence, null, null, true, false, 6, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", dictionary.getTagFromName("KVP"), null, null, null, true, false, 0, 0, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, " kVP ", true, false, 0, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, null, true, false, 1, 0, "#.#", 16));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, " mAs", true, false, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, null, true, false, 2, 0, "#.#", 15));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, " ms", true, false, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, null, true, false, 3, 0, "#.#", 14));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XRAYOLD", null, null, null, " mA", true, false, 3, 1, null, 0));
    }

    private static final int getArrayIndexFromLeftTop(boolean bl, boolean bl2) {
        return bl ? (bl2 ? 0 : 1) : (bl2 ? 2 : 3);
    }

    private static final boolean isLeftFromArrayIndex(int n) {
        return n == 0 || n == 1;
    }

    private static final boolean isTopFromArrayIndex(int n) {
        return n == 0 || n == 2;
    }

    private static final String getFormattedValue(Attribute attribute, int n, NumberFormat numberFormat) {
        String string = null;
        if (attribute != null) {
            if (n == 7 && attribute instanceof SequenceAttribute) {
                Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
                while (iterator.hasNext()) {
                    String string2;
                    SequenceItem sequenceItem = iterator.next();
                    AttributeList attributeList = sequenceItem.getAttributeList();
                    if (attributeList == null || (string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.CodeMeaning)) == null || string2.length() <= 0) continue;
                    string = string == null || string.length() == 0 ? string2 : string + multipleCodeMeaningDelimiter + string2;
                }
            } else if (n == 8 && attribute.getVM() == 6) {
                try {
                    double[] dArray = attribute.getDoubleValues();
                    string = DescriptionFactory.makeImageOrientationLabelFromImageOrientationPatient(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            } else if (n == 13) {
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("getFormattedValue(): specialFunction == DIRECTIONVECTOR for attribute {}", attribute);
                }
                try {
                    double[] dArray = attribute.getDoubleValues();
                    string = GeometryOfSlice.getOrientation(dArray);
                    slf4jlogger.debug("getFormattedValue(): specialFunction == DIRECTIONVECTOR value {}", string);
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            } else if (n == 1 && attribute instanceof DateTimeAttribute) {
                try {
                    String[] stringArray = attribute.getOriginalStringValues();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (stringArray != null) {
                        int n2 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string3 = null;
                            if (stringArray[i] != null && stringArray[i].length() > 8) {
                                string3 = stringArray[i].substring(8);
                            }
                            if (n2 != 0) {
                                stringBuffer.append((char)n2);
                            }
                            if (string3 != null) {
                                stringBuffer.append(string3);
                            }
                            n2 = 92;
                        }
                        string = stringBuffer.toString();
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            } else if (n == 5) {
                try {
                    String[] stringArray = attribute.getStringValues();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (stringArray != null) {
                        int n3 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string4 = stringArray[i];
                            if (string4 == null || i == 0 && string4.equals("ORIGINAL") || i == 1 && string4.equals("PRIMARY") || i == 3 && string4.equals("NONE")) continue;
                            if (n3 != 0) {
                                stringBuffer.append((char)n3);
                            }
                            stringBuffer.append(string4);
                            n3 = 92;
                        }
                        string = stringBuffer.toString();
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            } else if (n == 9 && attribute.getTag().equals(TagFromName.PhotometricInterpretation)) {
                string = attribute.getSingleStringValueOrNull();
                if (string != null) {
                    if (string.equals("MONOCHROME2")) {
                        string = "M2";
                    } else if (string.equals("MONOCHROME1")) {
                        string = "M1";
                    } else if (string.equals("PALETTE COLOR")) {
                        string = "PAL";
                    }
                }
            } else {
                string = n == 6 && attribute.getTag().equals(TagFromName.PixelRepresentation) ? (attribute.getSingleIntegerValueOrDefault(0) == 0 ? "+" : "-") : attribute.getDelimitedStringValuesOrNull(numberFormat);
            }
        }
        return string;
    }

    private static final String getOneOfThreeNumericAttributesOrNull(AttributeList attributeList, NumberFormat numberFormat, AttributeTag attributeTag, double d, AttributeTag attributeTag2, double d2, AttributeTag attributeTag3, double d3) {
        double d4;
        String string = null;
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null && attribute.getVM() > 0) {
            d4 = d;
        } else {
            attribute = attributeList.get(attributeTag2);
            if (attribute != null && attribute.getVM() > 0) {
                d4 = d2;
            } else {
                attribute = attributeList.get(attributeTag3);
                d4 = d3;
            }
        }
        if (attribute != null && attribute.getVM() > 0) {
            string = numberFormat.format(attribute.getSingleDoubleValueOrDefault(0.0) * d4);
        }
        return string;
    }

    public DemographicAndTechniqueAnnotations(AttributeList attributeList) {
        this(attributeList, null, false);
    }

    public DemographicAndTechniqueAnnotations(AttributeList attributeList, GeometryOfVolume geometryOfVolume) {
        this(attributeList, geometryOfVolume, false);
    }

    private Vector<TextAnnotationPositioned> createAnnotationsForSpecifiedFrame(int n) {
        slf4jlogger.debug("Doing frame {}", n);
        Vector<TextAnnotationPositioned> vector = null;
        if (this.list != null) {
            vector = new Vector<TextAnnotationPositioned>();
            TreeSet[] treeSetArray = new TreeSet[4];
            for (int i = 0; i < 4; ++i) {
                treeSetArray[i] = new TreeSet();
            }
            SequenceAttribute sequenceAttribute = (SequenceAttribute)this.list.get(TagFromName.SharedFunctionalGroupsSequence);
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)this.list.get(TagFromName.PerFrameFunctionalGroupsSequence);
            String string = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPClassUID);
            if (string != null && this.numberOfFrames > 0) {
                Object object;
                for (AnnotationLayoutConfigurationEntry annotationLayoutConfigurationEntry : this.layout) {
                    Object object2;
                    if (!(annotationLayoutConfigurationEntry.sopClassUID == null || annotationLayoutConfigurationEntry.sopClassUID.equals(string) || annotationLayoutConfigurationEntry.sopClassUID.equals("MRIMAGE") && (string.equals("1.2.840.10008.5.1.4.1.1.4.1") || string.equals("1.2.840.10008.5.1.4.1.1.4")) || annotationLayoutConfigurationEntry.sopClassUID.equals("CTIMAGE") && (string.equals("1.2.840.10008.5.1.4.1.1.2.1") || string.equals("1.2.840.10008.5.1.4.1.1.2")) || annotationLayoutConfigurationEntry.sopClassUID.equals("XCIMAGE") && SOPClass.isEnhancedMultiframeImageWithPlanePositionOrientationAndMeasuresStorage(string) || annotationLayoutConfigurationEntry.sopClassUID.equals("XCENH") && SOPClass.isEnhancedMultiframeImageStorage(string) || annotationLayoutConfigurationEntry.sopClassUID.equals("NOTENH") && !SOPClass.isEnhancedMultiframeImageStorage(string) || annotationLayoutConfigurationEntry.sopClassUID.equals("XCOLD") && (string.equals("1.2.840.10008.5.1.4.1.1.4") || string.equals("1.2.840.10008.5.1.4.1.1.2")) || annotationLayoutConfigurationEntry.sopClassUID.equals("XRAYOLD") && (string.equals("1.2.840.10008.5.1.4.1.1.1") || string.equals("1.2.840.10008.5.1.4.1.1.1.1") || string.equals("1.2.840.10008.5.1.4.1.1.1.1.1") || string.equals("1.2.840.10008.5.1.4.1.1.1.2") || string.equals("1.2.840.10008.5.1.4.1.1.1.2.1") || string.equals("1.2.840.10008.5.1.4.1.1.1.3") || string.equals("1.2.840.10008.5.1.4.1.1.1.3.1") || string.equals("1.2.840.10008.5.1.4.1.1.12.1") || string.equals("1.2.840.10008.5.1.4.1.1.12.2"))) && (!annotationLayoutConfigurationEntry.sopClassUID.equals("XRAYENH") || !string.equals("1.2.840.10008.5.1.4.1.1.12.1.1") && !string.equals("1.2.840.10008.5.1.4.1.1.12.2.1") && !string.equals("1.2.840.10008.5.1.4.1.1.13.1.1") && !string.equals("1.2.840.10008.5.1.4.1.1.13.1.2"))) continue;
                    DecimalFormat decimalFormat = null;
                    if (annotationLayoutConfigurationEntry.decimalFormatPattern != null) {
                        try {
                            decimalFormat = new DecimalFormat(annotationLayoutConfigurationEntry.decimalFormatPattern);
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("", exception);
                            decimalFormat = null;
                        }
                    }
                    String string2 = null;
                    if (annotationLayoutConfigurationEntry.specialFunction == 14) {
                        string2 = DemographicAndTechniqueAnnotations.getOneOfThreeNumericAttributesOrNull(this.list, decimalFormat, dictionary.getTagFromName("XRayTubeCurrentInuA"), 0.001, dictionary.getTagFromName("XRayTubeCurrentInmA"), 1.0, dictionary.getTagFromName("XRayTubeCurrent"), 1.0);
                    } else if (annotationLayoutConfigurationEntry.specialFunction == 15) {
                        string2 = DemographicAndTechniqueAnnotations.getOneOfThreeNumericAttributesOrNull(this.list, decimalFormat, dictionary.getTagFromName("ExposureTimeInuS"), 0.001, dictionary.getTagFromName("ExposureTimeInms"), 1.0, dictionary.getTagFromName("ExposureTime"), 1.0);
                    } else if (annotationLayoutConfigurationEntry.specialFunction == 16) {
                        string2 = DemographicAndTechniqueAnnotations.getOneOfThreeNumericAttributesOrNull(this.list, decimalFormat, dictionary.getTagFromName("ExposureInuAs"), 0.001, dictionary.getTagFromName("ExposureInmAs"), 1.0, dictionary.getTagFromName("Exposure"), 1.0);
                    } else if (annotationLayoutConfigurationEntry.specialFunction == 2) {
                        if (this.geometry != null && this.geometry.isVolumeSampledRegularlyAlongFrameDimension() && (object2 = this.geometry.getGeometryOfSlices()) != null && ((GeometryOfSlice[])object2).length > 0 && (object = (Object)object2[0].getVoxelSpacingArray()) != null && ((Object)object).length == 3) {
                            if (decimalFormat == null) {
                                decimalFormat = new DecimalFormat("###.#");
                            }
                            string2 = decimalFormat.format((double)object[2]);
                        }
                    } else if (annotationLayoutConfigurationEntry.specialFunction == 3) {
                        string2 = Integer.toString(n + 1);
                    } else if (annotationLayoutConfigurationEntry.specialFunction == 10) {
                        string2 = LossyImageCompression.describeLossyCompression(this.list);
                    } else if (annotationLayoutConfigurationEntry.specialFunction == 12) {
                        string2 = this.getValueByCallingFunction(this.list);
                    } else if (annotationLayoutConfigurationEntry.tag == null) {
                        string2 = annotationLayoutConfigurationEntry.text;
                    } else {
                        Object object3;
                        Object object4;
                        Object object5;
                        object2 = null;
                        Object object6 = object = annotationLayoutConfigurationEntry.nestedAttribute == null ? annotationLayoutConfigurationEntry.tag : annotationLayoutConfigurationEntry.nestedAttribute;
                        if (annotationLayoutConfigurationEntry.functionalGroup != null && sequenceAttribute != null && sequenceAttribute2 != null) {
                            object5 = null;
                            object4 = sequenceAttribute.getItem(0);
                            if (object4 != null && (object3 = ((SequenceItem)object4).getAttributeList()) != null) {
                                object5 = (SequenceAttribute)((AttributeList)object3).get(annotationLayoutConfigurationEntry.functionalGroup);
                            }
                            if (object5 == null && (object4 = sequenceAttribute2.getItem(n)) != null && (object3 = ((SequenceItem)object4).getAttributeList()) != null) {
                                object5 = (SequenceAttribute)((AttributeList)object3).get(annotationLayoutConfigurationEntry.functionalGroup);
                            }
                            if (object5 != null) {
                                object2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(object5, (AttributeTag)object);
                            }
                        }
                        if (object2 == null) {
                            object2 = this.list.get((AttributeTag)object);
                        }
                        if (object2 != null) {
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("Looking for and found {}", ((Attribute)object2).getTag());
                            }
                            if (annotationLayoutConfigurationEntry.nestedAttribute != null) {
                                slf4jlogger.debug("Want nestedAttribute " + annotationLayoutConfigurationEntry.nestedAttribute);
                                if (annotationLayoutConfigurationEntry.nestedAttribute.equals(((Attribute)object2).getTag()) && object2 instanceof SequenceAttribute) {
                                    if (slf4jlogger.isDebugEnabled()) {
                                        slf4jlogger.debug("Is the nestedAttribute; now looking for {}", annotationLayoutConfigurationEntry.tag);
                                    }
                                    object5 = (SequenceAttribute)object2;
                                    object4 = ((SequenceAttribute)object5).iterator();
                                    while (object4.hasNext()) {
                                        String string3;
                                        object3 = object4.next();
                                        AttributeList attributeList = ((SequenceItem)object3).getAttributeList();
                                        if (attributeList == null || (object2 = attributeList.get(annotationLayoutConfigurationEntry.tag)) == null) continue;
                                        if (slf4jlogger.isTraceEnabled()) {
                                            slf4jlogger.trace("Looking for and found within item of nestedAttribute {}", ((Attribute)object2).getTag());
                                        }
                                        if ((string3 = DemographicAndTechniqueAnnotations.getFormattedValue((Attribute)object2, annotationLayoutConfigurationEntry.specialFunction, decimalFormat)) == null || string3.length() <= 0) continue;
                                        string2 = string2 == null || string2.length() == 0 ? string3 : string2 + multipleCodeMeaningDelimiter + string3;
                                    }
                                    object2 = null;
                                } else {
                                    slf4jlogger.trace("Was not a sequence attribute");
                                    object2 = null;
                                }
                            }
                            if (object2 != null) {
                                string2 = DemographicAndTechniqueAnnotations.getFormattedValue((Attribute)object2, annotationLayoutConfigurationEntry.specialFunction, decimalFormat);
                            }
                        }
                    }
                    if (string2 == null || string2.length() <= 0) continue;
                    if (annotationLayoutConfigurationEntry.specialFunction == 11) {
                        string2 = string2.toUpperCase(Locale.US).indexOf("Y") == -1 ? "" : annotationLayoutConfigurationEntry.text;
                    }
                    object2 = new AnnotationComponentEntry(string2, annotationLayoutConfigurationEntry.textRow, annotationLayoutConfigurationEntry.orderInRow);
                    treeSetArray[DemographicAndTechniqueAnnotations.getArrayIndexFromLeftTop(annotationLayoutConfigurationEntry.fromLeft, annotationLayoutConfigurationEntry.fromTop)].add(object2);
                }
                for (int i = 0; i < 4; ++i) {
                    boolean bl = DemographicAndTechniqueAnnotations.isLeftFromArrayIndex(i);
                    bl = bl && !this.swapLeftRight || !bl && this.swapLeftRight;
                    boolean bl2 = DemographicAndTechniqueAnnotations.isTopFromArrayIndex(i);
                    int n2 = -1;
                    object = null;
                    for (Object object4 : treeSetArray[i]) {
                        if (((AnnotationComponentEntry)object4).textRow != n2) {
                            if (object != null) {
                                vector.add(new TextAnnotationPositioned(((StringBuffer)object).toString(), bl, bl2, n2));
                            }
                            object = new StringBuffer();
                        }
                        ((StringBuffer)object).append(((AnnotationComponentEntry)object4).string);
                        n2 = ((AnnotationComponentEntry)object4).textRow;
                    }
                    if (object == null) continue;
                    vector.add(new TextAnnotationPositioned(((StringBuffer)object).toString(), bl, bl2, n2));
                }
            }
        }
        return vector;
    }

    public DemographicAndTechniqueAnnotations(AttributeList attributeList, GeometryOfVolume geometryOfVolume, boolean bl) {
        this.swapLeftRight = bl;
        this.list = attributeList;
        this.geometry = geometryOfVolume;
        this.numberOfFrames = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        this.annotations = new Vector[this.numberOfFrames];
        this.initializeDefaultLayout();
    }

    protected String getValueByCallingFunction(AttributeList attributeList) {
        return "";
    }

    public Iterator iterator(int n) {
        Vector<TextAnnotationPositioned> vector = this.annotations[n];
        if (vector == null) {
            this.annotations[n] = vector = this.createAnnotationsForSpecifiedFrame(n);
        }
        return vector.iterator();
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            Object object = new DicomInputStream(new File(stringArray[0]));
            long l = System.currentTimeMillis();
            attributeList.setDecompressPixelData(false);
            attributeList.read((DicomInputStream)object);
            slf4jlogger.info("main(): read - done in {} ms", System.currentTimeMillis() - l);
            ((FilterInputStream)object).close();
            object = null;
            l = System.currentTimeMillis();
            object = new GeometryOfVolumeFromAttributeList(attributeList);
            slf4jlogger.info("main(): geometry - done in {} ms", System.currentTimeMillis() - l);
            l = System.currentTimeMillis();
            new DemographicAndTechniqueAnnotations(attributeList, (GeometryOfVolume)object);
            slf4jlogger.info("main(): annotations - done in {} ms", System.currentTimeMillis() - l);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    private class AnnotationComponentEntry
    implements Comparable {
        String string;
        int textRow;
        int orderInRow;

        AnnotationComponentEntry(String string, int n, int n2) {
            this.string = string;
            this.textRow = n;
            this.orderInRow = n2;
        }

        public int compareTo(Object object) {
            AnnotationComponentEntry annotationComponentEntry = (AnnotationComponentEntry)object;
            if (this.textRow == annotationComponentEntry.textRow) {
                return this.orderInRow - annotationComponentEntry.orderInRow;
            }
            return this.textRow - annotationComponentEntry.textRow;
        }
    }

    protected class AnnotationLayoutConfigurationEntry {
        String sopClassUID;
        AttributeTag tag;
        AttributeTag functionalGroup;
        AttributeTag nestedAttribute;
        String text;
        boolean fromLeft;
        boolean fromTop;
        int textRow;
        int orderInRow;
        String decimalFormatPattern;
        int specialFunction;

        AnnotationLayoutConfigurationEntry(String string, AttributeTag attributeTag, AttributeTag attributeTag2, AttributeTag attributeTag3, String string2, boolean bl, boolean bl2, int n, int n2, String string3, int n3) {
            this.sopClassUID = string;
            this.tag = attributeTag;
            this.functionalGroup = attributeTag2;
            this.nestedAttribute = attributeTag3;
            this.text = string2;
            this.fromLeft = bl;
            this.fromTop = bl2;
            this.textRow = n;
            this.orderInRow = n2;
            this.decimalFormatPattern = string3;
            this.specialFunction = n3;
        }
    }
}

