/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import java.awt.BufferCapabilities;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.geom.AffineTransform;

public class DescribeGraphicsEnvironment {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DescribeGraphicsEnvironment.java,v 1.15 2025/01/29 10:58:07 dclunie Exp $";

    public static String dumpImageCapabilities(ImageCapabilities imageCapabilities, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isAccelerated = ");
        stringBuffer.append(imageCapabilities.isAccelerated());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isTrueVolatile = ");
        stringBuffer.append(imageCapabilities.isTrueVolatile());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String dumpBufferCapabilities(BufferCapabilities bufferCapabilities, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isFullScreenRequired = ");
        stringBuffer.append(bufferCapabilities.isFullScreenRequired());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isMultiBufferAvailable = ");
        stringBuffer.append(bufferCapabilities.isMultiBufferAvailable());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isPageFlipping = ");
        stringBuffer.append(bufferCapabilities.isPageFlipping());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String dumpGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getBounds = ");
        stringBuffer.append(graphicsConfiguration.getBounds());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getColorModel = ");
        stringBuffer.append(graphicsConfiguration.getColorModel());
        stringBuffer.append("\n");
        ImageCapabilities imageCapabilities = graphicsConfiguration.getImageCapabilities();
        stringBuffer.append(DescribeGraphicsEnvironment.dumpImageCapabilities(imageCapabilities, string2 + "ImageCapabilities: ", string2 + "\t"));
        BufferCapabilities bufferCapabilities = graphicsConfiguration.getBufferCapabilities();
        stringBuffer.append(DescribeGraphicsEnvironment.dumpBufferCapabilities(bufferCapabilities, string2 + "BufferCapabilities: ", string2 + "\t"));
        AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
        if (affineTransform != null && !affineTransform.isIdentity()) {
            stringBuffer.append(string2);
            stringBuffer.append("defaultTransform.getScaleX() = ");
            stringBuffer.append(affineTransform.getScaleX());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("defaultTransform.getScaleY() = ");
            stringBuffer.append(affineTransform.getScaleY());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("25.4/72/defaultTransform.getScaleX() = ");
            stringBuffer.append(0.35277777777777775 / affineTransform.getScaleX());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("25.4/72/defaultTransform.getScaleY() = ");
            stringBuffer.append(0.35277777777777775 / affineTransform.getScaleY());
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(string2);
            stringBuffer.append("No defaultTransform or is identity (and hence likely meaningless)\n");
        }
        AffineTransform affineTransform2 = graphicsConfiguration.getNormalizingTransform();
        if (affineTransform2 != null && !affineTransform2.isIdentity()) {
            stringBuffer.append(string2);
            stringBuffer.append("normalizingTransform.getScaleX() = ");
            stringBuffer.append(affineTransform2.getScaleX());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("normalizingTransform.getScaleY() = ");
            stringBuffer.append(affineTransform2.getScaleY());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("25.4/72/normalizingTransform.getScaleX() = ");
            stringBuffer.append(0.35277777777777775 / affineTransform2.getScaleX());
            stringBuffer.append(" mm/pixel horizontal\n");
            stringBuffer.append(string2);
            stringBuffer.append("25.4/72/normalizingTransform.getScaleY() = ");
            stringBuffer.append(0.35277777777777775 / affineTransform2.getScaleY());
            stringBuffer.append(" mm/pixel vertical\n");
        } else {
            stringBuffer.append(string2);
            stringBuffer.append("No normalizingTransform or is identity (and hence likely meaningless)\n");
        }
        if (!(affineTransform == null || affineTransform2 == null || affineTransform.isIdentity() && affineTransform2.isIdentity())) {
            stringBuffer.append(string2);
            stringBuffer.append("defaultTransform.getScaleX()*normalizingTransform.getScaleX() = ");
            stringBuffer.append(affineTransform.getScaleX() * affineTransform2.getScaleX());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("defaultTransform.getScaleY()*normalizingTransform.getScaleY() = ");
            stringBuffer.append(affineTransform.getScaleY() * affineTransform2.getScaleY());
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("25.4/72/(defaultTransform.getScaleX()*normalizingTransform.getScaleX()) = ");
            stringBuffer.append(0.35277777777777775 / (affineTransform.getScaleX() * affineTransform2.getScaleX()));
            stringBuffer.append(" mm/pixel horizontal\n");
            stringBuffer.append(string2);
            stringBuffer.append("25.4/72/(defaultTransform.getScaleY()*normalizingTransform.getScaleY()) = ");
            stringBuffer.append(0.35277777777777775 / (affineTransform.getScaleY() * affineTransform2.getScaleY()));
            stringBuffer.append(" mm/pixel vertical\n");
        }
        return stringBuffer.toString();
    }

    public static String dumpDisplayMode(DisplayMode displayMode, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getBitDepth = ");
        stringBuffer.append(displayMode.getBitDepth());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getHeight = ");
        stringBuffer.append(displayMode.getHeight());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getWidth = ");
        stringBuffer.append(displayMode.getWidth());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getRefreshRate = ");
        stringBuffer.append(displayMode.getRefreshRate());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String dumpGraphicsDevice(GraphicsDevice graphicsDevice, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getIDstring = ");
        stringBuffer.append(graphicsDevice.getIDstring());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getAvailableAcceleratedMemory = ");
        stringBuffer.append(graphicsDevice.getAvailableAcceleratedMemory());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getType = ");
        stringBuffer.append(graphicsDevice.getType());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isDisplayChangeSupported = ");
        stringBuffer.append(graphicsDevice.isDisplayChangeSupported());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isFullScreenSupported = ");
        stringBuffer.append(graphicsDevice.isFullScreenSupported());
        stringBuffer.append("\n");
        stringBuffer.append(DescribeGraphicsEnvironment.dumpDisplayMode(graphicsDevice.getDisplayMode(), string2 + "DisplayMode [Current]:", string2 + "\t"));
        DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
        for (int i = 0; i < displayModeArray.length; ++i) {
            DisplayMode displayMode = displayModeArray[i];
            stringBuffer.append(DescribeGraphicsEnvironment.dumpDisplayMode(displayMode, string2 + "DisplayMode [" + i + "]:", string2 + "\t"));
        }
        stringBuffer.append(DescribeGraphicsEnvironment.dumpGraphicsConfiguration(graphicsDevice.getDefaultConfiguration(), string2 + "GraphicsConfiguration [Default]:", string2 + "\t"));
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration = graphicsConfigurationArray[i];
            stringBuffer.append(DescribeGraphicsEnvironment.dumpGraphicsConfiguration(graphicsConfiguration, string2 + "GraphicsConfiguration [" + i + "]:", string2 + "\t"));
        }
        return stringBuffer.toString();
    }

    public static String dumpGraphicsEnvironment(GraphicsEnvironment graphicsEnvironment, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getCenterPoint = ");
        stringBuffer.append(graphicsEnvironment.getCenterPoint());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("getMaximumWindowBounds = ");
        stringBuffer.append(graphicsEnvironment.getMaximumWindowBounds());
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("isHeadlessInstance = ");
        stringBuffer.append(graphicsEnvironment.isHeadlessInstance());
        stringBuffer.append("\n");
        stringBuffer.append(DescribeGraphicsEnvironment.dumpGraphicsDevice(graphicsEnvironment.getDefaultScreenDevice(), string2 + "GraphicsDevice [Default]:", string2 + "\t"));
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            stringBuffer.append(DescribeGraphicsEnvironment.dumpGraphicsDevice(graphicsDevice, string2 + "GraphicsDevice [" + i + "]:", string2 + "\t"));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        System.err.println(DescribeGraphicsEnvironment.dumpGraphicsEnvironment(graphicsEnvironment, "LocalGraphicsEnvironment:", "\t"));
    }
}

