/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import java.awt.Rectangle;

public class DisplayedAreaSelection
implements Cloneable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DisplayedAreaSelection.java,v 1.23 2025/01/29 10:58:07 dclunie Exp $";
    protected int imageWidth;
    protected int imageHeight;
    protected int tlhcX;
    protected int tlhcY;
    protected int brhcX;
    protected int brhcY;
    protected int selectionWidth;
    protected int selectionHeight;
    protected boolean fitToWindow;
    protected boolean useExplicitPixelMagnificationRatio;
    protected boolean deducePixelMagnificationRatioFromSpacing;
    protected double requestedDisplaySpacing;
    protected double rowSpacing;
    protected double columnSpacing;
    protected double pixelMagnificationRatio;
    protected int horizontalGravity;
    protected int verticalGravity;
    protected boolean crop;

    public void translate(int n, int n2) {
        this.tlhcX += n;
        this.tlhcY += n2;
        this.brhcX += n;
        this.brhcY += n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    DisplayedAreaSelection(int n, int n2) {
        this(n, n2, 0, 0, n - 1, n2 - 1);
    }

    DisplayedAreaSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, true, 0.0, 0.0, 0.0, 0, 0, false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DisplayedAreaSelection:\n");
        stringBuffer.append("\timageWidth = " + this.imageWidth + "\n");
        stringBuffer.append("\timageHeight = " + this.imageHeight + "\n");
        stringBuffer.append("\ttlhcX = " + this.tlhcX + "\n");
        stringBuffer.append("\ttlhcY = " + this.tlhcY + "\n");
        stringBuffer.append("\tbrhcX = " + this.brhcX + "\n");
        stringBuffer.append("\tbrhcY = " + this.brhcY + "\n");
        stringBuffer.append("\tselectionWidth = " + this.selectionWidth + "\n");
        stringBuffer.append("\tselectionHeight = " + this.selectionHeight + "\n");
        stringBuffer.append("\tfitToWindow = " + this.fitToWindow + "\n");
        stringBuffer.append("\tuseExplicitPixelMagnificationRatio = " + this.useExplicitPixelMagnificationRatio + "\n");
        stringBuffer.append("\tdeducePixelMagnificationRatioFromSpacing = " + this.deducePixelMagnificationRatioFromSpacing + "\n");
        stringBuffer.append("\trequestedDisplaySpacing = " + this.requestedDisplaySpacing + "\n");
        stringBuffer.append("\trowSpacing = " + this.rowSpacing + "\n");
        stringBuffer.append("\tcolumnSpacing = " + this.columnSpacing + "\n");
        stringBuffer.append("\tpixelMagnificationRatio = " + this.pixelMagnificationRatio + "\n");
        stringBuffer.append("\thorizontalGravity = " + this.horizontalGravity + "\n");
        stringBuffer.append("\tverticalGravity = " + this.verticalGravity + "\n");
        stringBuffer.append("\tcrop = " + this.crop + "\n");
        return stringBuffer.toString();
    }

    DisplayedAreaSelection(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, double d, double d2, double d3, int n7, int n8, boolean bl2) {
        int n9;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.tlhcX = n3;
        this.tlhcY = n4;
        this.brhcX = n5;
        this.brhcY = n6;
        this.fitToWindow = bl;
        this.deducePixelMagnificationRatioFromSpacing = !bl;
        this.useExplicitPixelMagnificationRatio = false;
        this.pixelMagnificationRatio = 0.0;
        this.requestedDisplaySpacing = d;
        this.rowSpacing = d2;
        this.columnSpacing = d3;
        this.horizontalGravity = n7;
        this.verticalGravity = n8;
        this.crop = bl2;
        if (this.tlhcX > this.brhcX) {
            n9 = this.tlhcX;
            this.tlhcX = this.brhcX;
            this.brhcX = n9;
        }
        if (this.tlhcY > this.brhcY) {
            n9 = this.tlhcY;
            this.tlhcY = this.brhcY;
            this.brhcY = n9;
        }
        this.selectionWidth = n5 - n3 + 1;
        this.selectionHeight = n6 - n4 + 1;
    }

    int getImageWidth() {
        return this.imageWidth;
    }

    int getImageHeight() {
        return this.imageHeight;
    }

    int getSelectionWidth() {
        return this.selectionWidth;
    }

    int getSelectionHeight() {
        return this.selectionHeight;
    }

    int getXOffset() {
        return this.tlhcX;
    }

    int getYOffset() {
        return this.tlhcY;
    }

    boolean getFitToWindow() {
        return this.fitToWindow;
    }

    boolean getUseExplicitPixelMagnificationRatio() {
        return this.useExplicitPixelMagnificationRatio;
    }

    boolean getDeducePixelMagnificationRatioFromSpacing() {
        return this.deducePixelMagnificationRatioFromSpacing;
    }

    double getRequestedDisplaySpacing() {
        return this.requestedDisplaySpacing;
    }

    double getRowSpacing() {
        return this.rowSpacing;
    }

    double getColumnSpacing() {
        return this.columnSpacing;
    }

    double getPixelMagnificationRatio() {
        return this.pixelMagnificationRatio;
    }

    int getHorizontalGravity() {
        return this.horizontalGravity;
    }

    int getVerticalGravity() {
        return this.verticalGravity;
    }

    boolean getCrop() {
        return this.crop;
    }

    public void setPixelMagnificationRatio(double d) {
        this.pixelMagnificationRatio = d;
        this.useExplicitPixelMagnificationRatio = true;
        this.deducePixelMagnificationRatioFromSpacing = false;
        this.fitToWindow = false;
    }

    DisplayedAreaSelection shapeSelectionToMatchAvailableWindow(Rectangle rectangle) {
        int n = this.selectionHeight;
        int n2 = this.selectionWidth;
        int n3 = this.tlhcX;
        int n4 = this.tlhcY;
        if (this.fitToWindow && this.selectionHeight > 0 && this.selectionWidth > 0) {
            double d = (double)this.selectionWidth / (double)rectangle.width;
            double d2 = (double)this.selectionHeight / (double)rectangle.height;
            double d3 = d > d2 ? d : d2;
            n = (int)Math.round(d3 * (double)rectangle.height);
            n2 = (int)Math.round(d3 * (double)rectangle.width);
        } else if (this.deducePixelMagnificationRatioFromSpacing && this.requestedDisplaySpacing > 0.0 && this.rowSpacing > 0.0 && this.columnSpacing > 0.0) {
            n = (int)Math.round(this.requestedDisplaySpacing * (double)rectangle.height / this.rowSpacing);
            n2 = (int)Math.round(this.requestedDisplaySpacing * (double)rectangle.width / this.columnSpacing);
        } else if (this.useExplicitPixelMagnificationRatio && this.pixelMagnificationRatio > 0.0) {
            n = (int)Math.round((double)rectangle.height / this.pixelMagnificationRatio);
            n2 = (int)Math.round((double)rectangle.width / this.pixelMagnificationRatio);
        }
        if (this.horizontalGravity == 0) {
            int n5 = this.tlhcX + this.selectionWidth / 2;
            n3 = n5 - n2 / 2;
        } else if (this.horizontalGravity > 0) {
            n3 = this.brhcX - n2;
        }
        if (this.verticalGravity == 0) {
            int n6 = this.tlhcY + this.selectionHeight / 2;
            n4 = n6 - n / 2;
        } else if (this.verticalGravity > 0) {
            n4 = this.brhcY - n;
        }
        return new DisplayedAreaSelection(this.imageWidth, this.imageHeight, n3, n4, n3 + n2 - 1, n4 + n - 1, this.fitToWindow, this.requestedDisplaySpacing, this.rowSpacing, this.columnSpacing, 0, 0, this.crop);
    }
}

