/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.codec.jpeg.Parse;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.OtherByteAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleFrameArrays;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherWordAttributeMultipleFrameArrays;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.Overlay;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ImageEditUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ImageEditUtilities.java,v 1.44 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ImageEditUtilities.class);
    protected static long usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan = Runtime.getRuntime().maxMemory() / 2L;
    protected static long useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan = -1L;

    private ImageEditUtilities() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File blackoutJPEGBlocks(AttributeList attributeList, Vector vector) throws DicomException, IOException, Exception {
        File file = null;
        Attribute attribute = attributeList.getPixelData();
        if (attribute == null) throw new DicomException("Not an image");
        if (vector == null || vector.size() <= 0) throw new DicomException("No redaction shapes specified");
        if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
            slf4jlogger.debug("blackoutJPEGBlocks(): lossless redaction of JPEG pixels from in memory compressed frames");
            byte[][] byArray = ((OtherByteAttributeMultipleCompressedFrames)attribute).getFrames();
            for (int i = 0; i < byArray.length; ++i) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[i]);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Parse.parse((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream, (Vector)vector);
                byArray[i] = byteArrayOutputStream.toByteArray();
            }
            return file;
        } else {
            if (!(attribute instanceof OtherByteAttributeCompressedSeparateFramesOnDisk)) throw new DicomException("Unable to obtain compressed JPEG bit stream");
            slf4jlogger.debug("blackoutJPEGBlocks(): lossless redaction of JPEG pixels from compressed frames left on disk");
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 0);
            file = File.createTempFile("ImageEditUtilities_blackoutJPEGBlocks", null);
            slf4jlogger.debug("blackoutJPEGBlocks(): temporary file is \"{}\"", file);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            long l = 0L;
            long[][] lArrayArray = new long[n][];
            long[][] lArrayArray2 = new long[n][];
            for (int i = 0; i < n; ++i) {
                byte[] byArray = ((OtherByteAttributeCompressedSeparateFramesOnDisk)attribute).getByteValuesForSelectedFrame(i);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Parse.parse((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream, (Vector)vector);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                int n2 = byArray2.length;
                lArrayArray[i] = new long[1];
                lArrayArray2[i] = new long[1];
                lArrayArray[i][0] = l;
                lArrayArray2[i][0] = n2;
                ((OutputStream)fileOutputStream).write(byArray2);
                l += (long)n2;
            }
            attribute = new OtherByteAttributeCompressedSeparateFramesOnDisk(TagFromName.PixelData, file, lArrayArray, lArrayArray2, true);
            attributeList.put(attribute);
        }
        return file;
    }

    public static void blackoutJPEGBlocks(File file, File file2, Vector vector) throws DicomException, IOException, Exception {
        DicomInputStream dicomInputStream = new DicomInputStream(file);
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        if (!string.equals("1.2.840.10008.1.2.4.50")) {
            throw new DicomException("ImageEditUtilties.blackoutJPEGBlocks() can only be applied to DICOM files in JPEG Baseline TransferSyntax");
        }
        File file3 = ImageEditUtilities.blackoutJPEGBlocks(attributeList, vector);
        attributeList.removeGroupLengthAttributes();
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SourceApplicationEntityTitle);
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, string, string2);
        attributeList.write(file2, string, true, true);
        if (file3 != null && !file3.delete()) {
            slf4jlogger.warn("blackoutJPEGBlocks(): Failed to delete temporary file " + file3);
        }
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector) throws DicomException {
        ImageEditUtilities.blackout(sourceImage, attributeList, vector, false, false, false, 0);
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector, boolean bl) throws DicomException {
        ImageEditUtilities.blackout(sourceImage, attributeList, vector, bl, false, false, 0);
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector, boolean bl, boolean bl2, boolean bl3, int n) throws DicomException {
        Object object;
        int n2;
        slf4jlogger.debug("blackout(): burnInOverlays = {}", bl);
        slf4jlogger.debug("blackout(): Integer.MAX_VALUE {}", Integer.MAX_VALUE);
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, n4 - 1);
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0);
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Object object2 = null;
        Object object3 = null;
        Attribute attribute = null;
        File[] fileArray = null;
        File file = null;
        OutputStream outputStream = null;
        FilterOutputStream filterOutputStream = null;
        boolean bl4 = false;
        boolean bl5 = false;
        Overlay overlay = sourceImage.getOverlay();
        boolean bl6 = sourceImage.isInverted();
        boolean bl7 = sourceImage.isSigned();
        int n11 = sourceImage.getMaskValue();
        boolean bl8 = sourceImage.isYBR();
        int n12 = 0;
        int n13 = sourceImage.getNumberOfBufferedImages();
        for (n2 = 0; n2 < n13; ++n2) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            Object object4;
            Object object5;
            short s;
            short s2;
            object = sourceImage.getBufferedImage(n2);
            slf4jlogger.debug("blackout(): Frame [{}]", n2);
            n10 = ((BufferedImage)object).getWidth();
            slf4jlogger.debug("blackout(): columns = {}", n10);
            n9 = ((BufferedImage)object).getHeight();
            slf4jlogger.debug("blackout(): rows = {}", n9);
            SampleModel sampleModel = ((BufferedImage)object).getSampleModel();
            slf4jlogger.debug("blackout(): srcSampleModel = {}", sampleModel);
            int n23 = sampleModel.getDataType();
            slf4jlogger.debug("blackout(): srcDataType = {}", n23);
            WritableRaster writableRaster = ((BufferedImage)object).getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int n24 = dataBuffer.getDataType();
            slf4jlogger.debug("blackout(): srcDataBufferType = {}", n24);
            int n25 = writableRaster.getNumBands();
            slf4jlogger.debug("blackout(): srcNumBands = {}", n25);
            int n26 = n25;
            int n27 = n10 * n25;
            if (n25 > 1 && sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                n26 = componentSampleModel.getPixelStride();
                n27 = componentSampleModel.getScanlineStride();
                n8 = n26 == n25 ? 0 : 1;
            }
            slf4jlogger.debug("blackout(): srcPixelStride = {}", n26);
            slf4jlogger.debug("blackout(): srcScanlineStride = {}", n27);
            slf4jlogger.debug("blackout(): planarConfiguration = {}", n8);
            int n28 = dataBuffer.getOffset();
            slf4jlogger.debug("blackout(): Frame [{}] srcDataBufferOffset = {}", n2, n28);
            long l5 = (long)n9 * (long)n10 * (long)n25;
            slf4jlogger.debug("blackout(): Frame [{}] srcFrameLength = {}", n2, l5);
            int n29 = dataBuffer.getNumBanks();
            slf4jlogger.debug("blackout(): Frame [{}] srcDataBufferNumBanks = {}", n2, n29);
            if (n29 > 1) {
                throw new DicomException("Unsupported type of image - DataBuffer number of banks is > 1, is " + n29);
            }
            int n30 = n8 == 0 ? n25 : 1;
            int n31 = n8 == 0 ? 1 : n9 * n10;
            slf4jlogger.debug("blackout(): dstPixelStride = {}", n30);
            slf4jlogger.debug("blackout(): dstBandStride = {}", n31);
            if (n24 == 0) {
                int n32;
                int n33;
                int n34;
                slf4jlogger.debug("blackout(): srcDataBufferType = DataBuffer.TYPE_BYTE");
                bl4 = true;
                s2 = (bl3 ? n : (bl2 && sourceImage.isPadded() ? sourceImage.getPadValue() : (bl6 ? (bl7 ? n11 >> 1 : n11) : (bl7 ? (n11 >> 1) + 1 : 0)))) & 0xFF;
                slf4jlogger.debug("blackout(): backgroundValueBasis = {}", s2);
                s = (bl6 ? (bl7 ? (n11 >> 1) + 1 : 0) : (bl7 ? n11 >> 1 : n11)) & 0xFF;
                slf4jlogger.debug("blackout(): foregroundValueBasis = {}", s);
                object5 = new byte[n25];
                byte[] byArray = new byte[n25];
                if (bl8 && n25 >= 3) {
                    object5[0] = (byte)(0.299 * (double)s2 + 0.587 * (double)s2 + 0.114 * (double)s2);
                    object5[1] = (byte)(-0.1687 * (double)s2 - 0.3313 * (double)s2 + 0.5 * (double)s2 + 128.0);
                    object5[2] = (byte)(0.5 * (double)s2 - 0.4187 * (double)s2 - 0.0813 * (double)s2 + 128.0);
                    byArray[0] = (byte)(0.299 * (double)s + 0.587 * (double)s + 0.114 * (double)s);
                    byArray[1] = (byte)(-0.1687 * (double)s - 0.3313 * (double)s + 0.5 * (double)s + 128.0);
                    byArray[2] = (byte)(0.5 * (double)s - 0.4187 * (double)s - 0.0813 * (double)s + 128.0);
                    for (n34 = 3; n34 < n25; ++n34) {
                        object5[n34] = -1;
                        byArray[n34] = -1;
                    }
                } else {
                    for (n34 = 0; n34 < n25; ++n34) {
                        object5[n34] = (byte)s2;
                        byArray[n34] = (byte)s;
                    }
                }
                object4 = null;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_BYTE but not instance of DataBufferByte, is " + dataBuffer.getClass().getName());
                }
                slf4jlogger.debug("blackout(): Frame [{}] DataBufferByte", n2);
                object4 = ((DataBufferByte)dataBuffer).getBankData();
                n22 = object4[0].length;
                slf4jlogger.debug("blackout(): Frame [{}] srcPixelBankLength = {}", n2, n22);
                if (object2 == null && file == null && fileArray == null) {
                    if (n3 > 8) {
                        n3 = 8;
                    }
                    if (n4 > 8) {
                        n4 = 8;
                    }
                    if (n5 > 7) {
                        n5 = 7;
                    }
                    n6 = n25;
                    long l6 = (long)n13 * l5;
                    slf4jlogger.info("blackout(): totalSizeInBytes = {}", l6);
                    if (l6 > usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan && usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan != -1L) {
                        if (n13 > 1 && l6 > useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan && useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan != -1L) {
                            slf4jlogger.info("blackout(): using multiple temporary files, one for each frame, for blacked out pixel data rather than allocating array of frames");
                            fileArray = new File[n13];
                        } else {
                            slf4jlogger.info("blackout(): using a single temporary file for all frames of blacked out pixel data rather than allocating array of frames");
                            try {
                                file = File.createTempFile("ImageEditUtilities_blackout", null);
                                slf4jlogger.debug("blackout(): temporary file is \"{}\"", file);
                                file.deleteOnExit();
                                outputStream = new FileOutputStream(file);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                slf4jlogger.error("", fileNotFoundException);
                                throw new DicomException("Could not find temporary file used during blackout");
                            }
                            catch (IOException iOException) {
                                slf4jlogger.error("", iOException);
                                throw new DicomException("Problem creating temporary file used during blackout");
                            }
                        }
                    }
                    if (file == null && fileArray == null) {
                        slf4jlogger.debug("blackout(): allocating array of frames rather than single contiguous array for all frames of blacked out pixel data");
                        object2 = new byte[n13][];
                        for (int i = 0; i < n13; ++i) {
                            slf4jlogger.debug("blackout(): allocating frame {} length {} bytes", i, l5);
                            if (l5 > Integer.MAX_VALUE) {
                                throw new DicomException("Could not allocate frame size that exceeds Integer.MAX_VALUE bytes");
                            }
                            object2[i] = new byte[(int)l5];
                        }
                        attribute = new OtherByteAttributeMultipleFrameArrays(TagFromName.PixelData);
                        ((OtherByteAttributeMultipleFrameArrays)attribute).setValuesPerFrame((byte[][])object2);
                    }
                }
                byte[] byArray2 = null;
                if (object2 != null) {
                    byArray2 = object2[n2];
                }
                if (byArray2 == null) {
                    if (l5 > Integer.MAX_VALUE) {
                        throw new DicomException("Could not allocate frame size that exceeds Integer.MAX_VALUE bytes");
                    }
                    byArray2 = new byte[(int)l5];
                }
                System.arraycopy(object4[0], n28, byArray2, n12, (int)l5);
                if (bl && overlay != null && overlay.getNumberOfOverlays(n2) > 0) {
                    slf4jlogger.debug("blackout(): Drawing overlays for frame {}", n2);
                    for (n21 = 0; n21 < 16; ++n21) {
                        BufferedImage bufferedImage = overlay.getOverlayAsBinaryBufferedImage(n2, n21);
                        if (bufferedImage == null) continue;
                        slf4jlogger.debug("blackout(): Drawing overlay number {}", n21);
                        int n35 = overlay.getRowOrigin(n2, n21);
                        n20 = overlay.getColumnOrigin(n2, n21);
                        for (n19 = 0; n19 < bufferedImage.getHeight(); ++n19) {
                            for (n18 = 0; n18 < bufferedImage.getWidth(); ++n18) {
                                n17 = bufferedImage.getRGB(n18, n19);
                                if (n17 == 0) continue;
                                n16 = n20 + n18 + 1;
                                n15 = n35 + n19 + 1;
                                if (n16 >= n10 || n15 >= n9) continue;
                                n14 = n15 * n10 + n16;
                                slf4jlogger.trace("blackout(): Drawing overlay -  setting shadow overlay ({},{}) at image ({},{})", n18, n19, n16, n15);
                                for (n33 = 0; n33 < n25; ++n33) {
                                    n32 = n12 + n14 * n30 + n33 * n31;
                                    slf4jlogger.trace("blackout(): frame={} y={} x={} pixelIndexWithinFrame={} bandIndex={} sampleIndex={}", n2, n15, n16, n14, n33, n32);
                                    byArray2[n32] = object5[n33];
                                }
                            }
                        }
                        for (n19 = 0; n19 < bufferedImage.getHeight(); ++n19) {
                            for (n18 = 0; n18 < bufferedImage.getWidth(); ++n18) {
                                n17 = bufferedImage.getRGB(n18, n19);
                                if (n17 == 0) continue;
                                n16 = n20 + n18;
                                n15 = n35 + n19;
                                if (n16 >= n10 || n15 >= n9) continue;
                                n14 = n15 * n10 + n16;
                                slf4jlogger.trace("blackout(): Drawing overlay -  setting foreground overlay ({},{}) at image ({},{})", n18, n19, n16, n15);
                                for (n33 = 0; n33 < n25; ++n33) {
                                    n32 = n12 + n14 * n30 + n33 * n31;
                                    slf4jlogger.trace("blackout(): frame={} y={} x={} pixelIndexWithinFrame={} bandIndex={} sampleIndex={}", n2, n15, n16, n14, n33, n32);
                                    byArray2[n32] = byArray[n33];
                                }
                            }
                        }
                    }
                }
                if (vector != null) {
                    for (Shape shape : vector) {
                        if (!(shape instanceof RectangularShape)) continue;
                        RectangularShape rectangularShape = (RectangularShape)shape;
                        slf4jlogger.debug("blackout(): shape is RectangularShape {}", rectangularShape);
                        n20 = (int)rectangularShape.getX();
                        n19 = (int)rectangularShape.getY();
                        n18 = (int)((double)n20 + rectangularShape.getWidth());
                        n17 = (int)((double)n19 + rectangularShape.getHeight());
                        for (n16 = n19; n16 < n17; ++n16) {
                            n15 = n16 * n10 + n20;
                            slf4jlogger.trace("blackout(): row {} startX {} pixelIndexWithinFrame {}", n16, n20, n15);
                            for (n14 = n20; n14 < n18; ++n14) {
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("blackout(): before set - getRGB({},{})=0x{}", n14, n16, Integer.toHexString(sourceImage.getBufferedImage(n2).getRGB(n14, n16)));
                                }
                                for (n33 = 0; n33 < n25; ++n33) {
                                    n32 = n12 + n15 * n30 + n33 * n31;
                                    slf4jlogger.trace("blackout(): frame={} y={} x={} pixelIndexWithinFrame={} bandIndex={} sampleIndex={}", n2, n16, n14, n15, n33, n32);
                                    byArray2[n32] = object5[n33];
                                }
                                ++n15;
                                if (!slf4jlogger.isTraceEnabled()) continue;
                                slf4jlogger.trace("blackout(): after set - getRGB({},{})=0x{}", n14, n16, Integer.toHexString(sourceImage.getBufferedImage(n2).getRGB(n14, n16)));
                            }
                        }
                    }
                }
                if (file != null) {
                    try {
                        slf4jlogger.debug("blackout(): writing to temporary frame {} length {} bytes", n2, byArray2.length);
                        ((FileOutputStream)outputStream).write(byArray2);
                        continue;
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("", iOException);
                        throw new DicomException("Could not write to temporary file used during blackout");
                    }
                }
                if (fileArray == null) continue;
                slf4jlogger.debug("blackout(): using a temporary file for blacked out pixel data rather than allocating array of frames of blacked out pixel data");
                try {
                    File file2 = File.createTempFile("ImageEditUtilities_blackout", null);
                    slf4jlogger.debug("blackout(): temporary file for frame {} is \"{}\"", n2, file2);
                    file2.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    fileOutputStream.write(byArray2);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileArray[n2] = file2;
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    slf4jlogger.error("", fileNotFoundException);
                    throw new DicomException("Could not find temporary file used during blackout");
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Problem creating or writing to or closing temporary file used during blackout");
                }
            }
            if (n24 == 1 || n24 == 2) {
                slf4jlogger.debug("blackout(): srcDataBufferType = DataBuffer.TYPE_USHORT or DataBuffer.TYPE_SHORT");
                bl5 = true;
                s2 = (short)(bl3 ? n : (bl2 && sourceImage.isPadded() ? sourceImage.getPadValue() : (bl6 ? (bl7 ? n11 >> 1 : n11) : (bl7 ? (n11 >> 1) + 1 : 0))));
                slf4jlogger.debug("blackout(): backgroundValue = {}", s2);
                s = (short)(bl6 ? (bl7 ? (n11 >> 1) + 1 : 0) : (bl7 ? n11 >> 1 : n11));
                slf4jlogger.debug("blackout(): foregroundValue = {}", s);
                object5 = null;
                if (dataBuffer instanceof DataBufferShort) {
                    slf4jlogger.debug("blackout(): Frame [{}] DataBufferShort", n2);
                    object5 = ((DataBufferShort)dataBuffer).getBankData();
                } else if (dataBuffer instanceof DataBufferUShort) {
                    slf4jlogger.debug("blackout(): Frame [{}] DataBufferUShort", n2);
                    object5 = ((DataBufferUShort)dataBuffer).getBankData();
                } else {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_USHORT or TYPE_SHORT but not instance of DataBufferShort, is " + dataBuffer.getClass().getName());
                }
                int n36 = ((byte)object5[0]).length;
                slf4jlogger.debug("blackout(): Frame [{}] srcPixelBankLength = {}", n2, n36);
                if (object3 == null && file == null && fileArray == null) {
                    if (n3 > 16) {
                        n3 = 16;
                    }
                    if (n4 > 16) {
                        n4 = 16;
                    }
                    if (n5 > 15) {
                        n5 = 15;
                    }
                    n6 = n25;
                    long l7 = l5 * (long)n13;
                    slf4jlogger.debug("blackout(): Frame [{}] dstPixelsLength = {}", n2, l7);
                    long l8 = l7 * 2L;
                    slf4jlogger.info("blackout(): totalSizeInBytes = {}", l8);
                    if (l8 > usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan && usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan != -1L) {
                        if (n13 > 1 && l8 > useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan && useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan != -1L) {
                            slf4jlogger.info("blackout(): using multiple temporary files, one for each frame, for blacked out pixel data rather than allocating array of frames");
                            fileArray = new File[n13];
                        } else {
                            slf4jlogger.info("blackout(): using a single temporary file for all frames of blacked out pixel data rather than allocating array of frames");
                            try {
                                file = File.createTempFile("ImageEditUtilities_blackout", null);
                                slf4jlogger.debug("blackout(): temporary file is \"{}\"", file);
                                file.deleteOnExit();
                                outputStream = new FileOutputStream(file);
                                filterOutputStream = new BinaryOutputStream(outputStream, false);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                slf4jlogger.error("", fileNotFoundException);
                                throw new DicomException("Could not find temporary file used during blackout");
                            }
                            catch (IOException iOException) {
                                slf4jlogger.error("", iOException);
                                throw new DicomException("Problem creating temporary file used during blackout");
                            }
                        }
                    }
                    if (file == null && fileArray == null) {
                        slf4jlogger.debug("blackout(): allocating array of frames rather than single contiguous array for all frames of blacked out pixel data");
                        object3 = new short[n13][];
                        for (int i = 0; i < n13; ++i) {
                            slf4jlogger.debug("blackout(): allocating frame {} length {} short", i, l5);
                            if (l5 > Integer.MAX_VALUE) {
                                throw new DicomException("Could not allocate frame size that exceeds Integer.MAX_VALUE shorts");
                            }
                            object3[i] = new short[(int)l5];
                        }
                        attribute = new OtherWordAttributeMultipleFrameArrays(TagFromName.PixelData);
                        ((OtherWordAttributeMultipleFrameArrays)attribute).setValuesPerFrame((short[][])object3);
                    }
                }
                object4 = null;
                if (object3 != null) {
                    object4 = object3[n2];
                }
                if (object4 == null) {
                    if (l5 > Integer.MAX_VALUE) {
                        throw new DicomException("Could not allocate frame size that exceeds Integer.MAX_VALUE shorts");
                    }
                    object4 = new short[(int)l5];
                }
                System.arraycopy(object5[0], n28, object4, n12, (int)l5);
                if (bl && overlay != null && overlay.getNumberOfOverlays(n2) > 0) {
                    slf4jlogger.debug("blackout(): Drawing overlays for frame {}", n2);
                    for (n22 = 0; n22 < 16; ++n22) {
                        int n37;
                        BufferedImage bufferedImage = overlay.getOverlayAsBinaryBufferedImage(n2, n22);
                        if (bufferedImage == null) continue;
                        slf4jlogger.debug("blackout(): Drawing overlay number {}", n22);
                        n21 = overlay.getRowOrigin(n2, n22);
                        int n38 = overlay.getColumnOrigin(n2, n22);
                        for (n37 = 0; n37 < bufferedImage.getHeight(); ++n37) {
                            for (n20 = 0; n20 < bufferedImage.getWidth(); ++n20) {
                                n19 = bufferedImage.getRGB(n20, n37);
                                if (n19 == 0) continue;
                                n18 = n38 + n20 + 1;
                                n17 = n21 + n37 + 1;
                                if (n18 >= n10 || n17 >= n9) continue;
                                n16 = n17 * n10 + n18;
                                slf4jlogger.trace("blackout(): Drawing overlay -  setting shadow overlay ({},{}) at image ({},{})", n20, n37, n18, n17);
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n16 * n30 + n15 * n31;
                                    slf4jlogger.trace("blackout(): frame={} y={} x={} pixelIndexWithinFrame={} bandIndex={} sampleIndex={}", n2, n17, n18, n16, n15, n14);
                                    object4[n14] = (byte[])s2;
                                }
                            }
                        }
                        for (n37 = 0; n37 < bufferedImage.getHeight(); ++n37) {
                            for (n20 = 0; n20 < bufferedImage.getWidth(); ++n20) {
                                n19 = bufferedImage.getRGB(n20, n37);
                                if (n19 == 0) continue;
                                n18 = n38 + n20;
                                n17 = n21 + n37;
                                if (n18 >= n10 || n17 >= n9) continue;
                                n16 = n17 * n10 + n18;
                                slf4jlogger.trace("blackout(): Drawing overlay -  setting foreground overlay ({},{}) at image ({},{})", n20, n37, n18, n17);
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n16 * n30 + n15 * n31;
                                    slf4jlogger.trace("blackout(): frame={} y={} x={} pixelIndexWithinFrame={} bandIndex={} sampleIndex={}", n2, n17, n18, n16, n15, n14);
                                    object4[n14] = (byte[])s;
                                }
                            }
                        }
                    }
                }
                if (vector != null) {
                    for (Shape shape : vector) {
                        if (!(shape instanceof RectangularShape)) continue;
                        RectangularShape rectangularShape = (RectangularShape)shape;
                        slf4jlogger.debug("blackout(): shape is RectangularShape {}", rectangularShape);
                        int n39 = (int)rectangularShape.getX();
                        int n40 = (int)rectangularShape.getY();
                        n20 = (int)((double)n39 + rectangularShape.getWidth());
                        n19 = (int)((double)n40 + rectangularShape.getHeight());
                        for (n18 = n40; n18 < n19; ++n18) {
                            n17 = n18 * n10 + n39;
                            for (n16 = n39; n16 < n20; ++n16) {
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n17 * n30 + n15 * n31;
                                    slf4jlogger.trace("blackout(): frame={} y={} x={} pixelIndexWithinFrame={} bandIndex={} sampleIndex={}", n2, n18, n16, n17, n15, n14);
                                    object4[n14] = (byte[])s2;
                                }
                                ++n17;
                            }
                        }
                    }
                }
                if (file != null) {
                    try {
                        slf4jlogger.debug("blackout(): writing to temporary frame {} length {} words", n2, ((byte[][])object4).length);
                        ((BinaryOutputStream)filterOutputStream).writeUnsigned16((short[])object4, ((byte[][])object4).length);
                        continue;
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("", iOException);
                        throw new DicomException("Could not write to temporary file used during blackout");
                    }
                }
                if (fileArray == null) continue;
                slf4jlogger.debug("blackout(): using a temporary file for blacked out pixel data rather than allocating array of frames");
                try {
                    File file3 = File.createTempFile("ImageEditUtilities_blackout", null);
                    slf4jlogger.debug("blackout(): temporary file for frame {} is \"{}\"", n2, file3);
                    file3.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    BinaryOutputStream binaryOutputStream = new BinaryOutputStream(fileOutputStream, false);
                    binaryOutputStream.writeUnsigned16((short[])object4, ((byte[][])object4).length);
                    binaryOutputStream.flush();
                    binaryOutputStream.close();
                    fileOutputStream.close();
                    fileArray[n2] = file3;
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    slf4jlogger.error("", fileNotFoundException);
                    throw new DicomException("Could not find temporary file used during blackout");
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Problem creating or writing to or closing temporary file used during blackout");
                }
            }
            throw new DicomException("Unsupported pixel data form - DataBufferType = " + n24);
        }
        if (file != null) {
            if (bl4) {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                    slf4jlogger.debug("blackout(): temporary file \"{}\" length {}", file, file.length());
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Could not close temporary file used during blackout before creating Pixel Data Attribute using it");
                }
                attribute = new OtherByteAttributeOnDisk(TagFromName.PixelData);
                ((OtherByteAttributeOnDisk)attribute).deleteFilesWhenNoLongerNeeded();
                try {
                    ((OtherByteAttributeOnDisk)attribute).setFile(file, 0L);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Could not get length of temporary file used during blackout when creating Pixel Data Attribute using it");
                }
            }
            if (bl5) {
                try {
                    filterOutputStream.flush();
                    filterOutputStream.close();
                    ((FileOutputStream)outputStream).close();
                    slf4jlogger.debug("blackout(): temporary file \"{}\" length {}", file, file.length());
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Could not close temporary file used during blackout before creating Pixel Data Attribute using it");
                }
                attribute = new OtherWordAttributeOnDisk(TagFromName.PixelData, false);
                ((OtherWordAttributeOnDisk)attribute).deleteFilesWhenNoLongerNeeded();
                try {
                    ((OtherWordAttributeOnDisk)attribute).setFile(file, 0L);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Could not get length of temporary file used during blackout when creating Pixel Data Attribute using it");
                }
            }
        } else if (fileArray != null) {
            if (bl4) {
                attribute = new OtherByteAttributeMultipleFilesOnDisk(TagFromName.PixelData);
                attribute.deleteFilesWhenNoLongerNeeded();
                try {
                    long[] lArray = new long[n13];
                    object = new long[n13];
                    for (int i = 0; i < n13; ++i) {
                        lArray[i] = 0L;
                        object[i] = fileArray[i].length();
                    }
                    attribute.setFiles(fileArray, lArray, (long[])object);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Could not get lengths of temporary files used during blackout when creating Pixel Data Attribute using it");
                }
            }
            if (bl5) {
                attribute = new OtherWordAttributeMultipleFilesOnDisk(TagFromName.PixelData, false);
                ((OtherWordAttributeMultipleFilesOnDisk)attribute).deleteFilesWhenNoLongerNeeded();
                try {
                    long[] lArray = new long[n13];
                    object = new long[n13];
                    for (int i = 0; i < n13; ++i) {
                        lArray[i] = 0L;
                        object[i] = fileArray[i].length();
                    }
                    ((OtherWordAttributeMultipleFilesOnDisk)attribute).setFiles(fileArray, lArray, (long[])object);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Could not get lengths of temporary files used during blackout when creating Pixel Data Attribute using it");
                }
            }
        }
        if (string.equals("YBR_FULL_422") && !attributeList.getDecompressedPhotometricInterpretation(string).equals("RGB")) {
            slf4jlogger.debug("blackout(): replacing photometricInterpretation of YBR_FULL_422 with YBR_FULL");
            string = "YBR_FULL";
        }
        attributeList.remove(TagFromName.PixelData);
        attributeList.remove(TagFromName.BitsAllocated);
        attributeList.remove(TagFromName.BitsStored);
        attributeList.remove(TagFromName.HighBit);
        attributeList.remove(TagFromName.SamplesPerPixel);
        attributeList.remove(TagFromName.PixelRepresentation);
        attributeList.remove(TagFromName.PhotometricInterpretation);
        attributeList.remove(TagFromName.PlanarConfiguration);
        n2 = attributeList.get(TagFromName.NumberOfFrames) != null ? 1 : 0;
        slf4jlogger.debug("blackout(): numberOfFramesWasPresentBefore = {}", n2 != 0);
        attributeList.remove(TagFromName.NumberOfFrames);
        if (bl) {
            slf4jlogger.debug("blackout(): removeOverlayAttributes");
            attributeList.removeOverlayAttributes();
        }
        attributeList.put(attribute);
        object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object).addValue(n3);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)object).addValue(n4);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)object).addValue(n5);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object).addValue(n9);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object).addValue(n10);
        attributeList.put((Attribute)object);
        if (n13 > 1 || n2 != 0) {
            object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object).addValue(n13);
            attributeList.put((Attribute)object);
        }
        object = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object).addValue(n6);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object).addValue(n7);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        if (n6 > 1) {
            object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object).addValue(n8);
            attributeList.put((Attribute)object);
        }
        long l9 = System.currentTimeMillis();
        slf4jlogger.debug("blackout(): Reconstruct source image");
        sourceImage.constructSourceImage(attributeList);
        slf4jlogger.debug("blackout(): elapsedDrawingTime = {}", l2);
        slf4jlogger.debug("blackout(): elapsedCopyingTime = {}", l3);
        slf4jlogger.debug("blackout(): elapsedReconstructionTime = {}", l4 += System.currentTimeMillis() - l9);
        slf4jlogger.debug("blackout(): total blackout time = {}", System.currentTimeMillis() - l);
        slf4jlogger.debug("blackout(): done");
    }

    public static final int getOffsetIntoMatrix(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = 0;
        if (n6 == 0) {
            n7 = n + n2 * n5 + (bl ? n5 - n3 - 1 : n3);
        } else if (n6 == 90) {
            n7 = n + n3 * n4 + (bl ? n2 : n4 - n2 - 1);
        } else if (n6 == 180) {
            n7 = n + (n4 - n2 - 1) * n5 + (bl ? n3 : n5 - n3 - 1);
        } else if (n6 == 270) {
            n7 = n + (n5 - n3 - 1) * n4 + (bl ? n4 - n2 - 1 : n2);
        }
        return n7;
    }

    public static final int getOffsetIntoMatrix(int n, int n2, int n3, int n4) {
        return ImageEditUtilities.getOffsetIntoMatrix(n, n2, n3, 0, n4, 0, false);
    }

    public static void rotateAndFlip(SourceImage sourceImage, AttributeList attributeList, int n, boolean bl) throws DicomException {
        Object object;
        int n2;
        slf4jlogger.debug("rotate(): requested rotation {}", n);
        if (n % 90 != 0) {
            throw new DicomException("Rotation of " + n + " not supported");
        }
        while (n >= 360) {
            n -= 360;
        }
        while (n < 0) {
            n += 360;
        }
        slf4jlogger.debug("rotate(): actual rotation {}", n);
        slf4jlogger.debug("rotate(): horizontal_flip {}", bl);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, n4 - 1);
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0);
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        byte[] byArray = null;
        short[] sArray = null;
        Attribute attribute = null;
        int n13 = 0;
        int n14 = sourceImage.getNumberOfBufferedImages();
        for (n2 = 0; n2 < n14; ++n2) {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            Object object2;
            int n21;
            object = sourceImage.getBufferedImage(n2);
            n10 = ((BufferedImage)object).getWidth();
            n9 = ((BufferedImage)object).getHeight();
            n12 = n == 90 || n == 270 ? n9 : n10;
            n11 = n == 90 || n == 270 ? n10 : n9;
            SampleModel sampleModel = ((BufferedImage)object).getSampleModel();
            int n22 = sampleModel.getDataType();
            WritableRaster writableRaster = ((BufferedImage)object).getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int n23 = dataBuffer.getDataType();
            int n24 = n21 = writableRaster.getNumBands();
            int n25 = n10 * n21;
            if (n21 > 1 && sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                n24 = componentSampleModel.getPixelStride();
                n25 = componentSampleModel.getScanlineStride();
                n8 = n24 == n21 ? 0 : 1;
            }
            int n26 = dataBuffer.getOffset();
            int n27 = n9 * n10 * n21;
            int n28 = dataBuffer.getNumBanks();
            if (n28 > 1) {
                throw new DicomException("Unsupported type of image - DataBuffer number of banks is > 1, is " + n28);
            }
            slf4jlogger.debug("rotateAndFlip(): srcPixelStride = {}", n24);
            int n29 = n8 == 0 ? 1 : n9 * n10;
            slf4jlogger.debug("rotateAndFlip(): srcBandStride = {}", n29);
            int n30 = n8 == 0 ? n21 : 1;
            slf4jlogger.debug("rotateAndFlip(): dstPixelStride = {}", n30);
            int n31 = n8 == 0 ? 1 : n9 * n10;
            slf4jlogger.debug("rotateAndFlip(): dstBandStride = {}", n31);
            if (n23 == 0) {
                object2 = null;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_BYTE but not instance of DataBufferByte, is " + dataBuffer.getClass().getName());
                }
                object2 = ((DataBufferByte)dataBuffer).getBankData();
                n20 = object2[0].length;
                if (byArray == null) {
                    if (n3 > 8) {
                        n3 = 8;
                    }
                    if (n4 > 8) {
                        n4 = 8;
                    }
                    if (n5 > 7) {
                        n5 = 7;
                    }
                    n6 = n21;
                    n19 = n27 * n14;
                    byArray = new byte[n19];
                    attribute = new OtherByteAttribute(TagFromName.PixelData);
                    attribute.setValues(byArray);
                }
                for (n19 = 0; n19 < n9; ++n19) {
                    for (n18 = 0; n18 < n10; ++n18) {
                        n17 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n10);
                        n16 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n9, n10, n, bl);
                        for (n15 = 0; n15 < n21; ++n15) {
                            byArray[n13 + n16 * n30 + n15 * n31] = object2[0][n26 + n17 * n24 + n15 * n29];
                        }
                    }
                }
                n13 += n27;
                continue;
            }
            if (n23 == 1 || n23 == 2) {
                object2 = null;
                if (dataBuffer instanceof DataBufferShort) {
                    object2 = ((DataBufferShort)dataBuffer).getBankData();
                } else if (dataBuffer instanceof DataBufferUShort) {
                    object2 = ((DataBufferUShort)dataBuffer).getBankData();
                } else {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_USHORT or TYPE_SHORT but not instance of DataBufferShort, is " + dataBuffer.getClass().getName());
                }
                n20 = object2[0].length;
                if (sArray == null) {
                    if (n3 > 16) {
                        n3 = 16;
                    }
                    if (n4 > 16) {
                        n4 = 16;
                    }
                    if (n5 > 15) {
                        n5 = 15;
                    }
                    n6 = n21;
                    n19 = n27 * n14;
                    sArray = new short[n19];
                    attribute = new OtherWordAttribute(TagFromName.PixelData);
                    attribute.setValues(sArray);
                }
                for (n19 = 0; n19 < n9; ++n19) {
                    for (n18 = 0; n18 < n10; ++n18) {
                        n17 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n10);
                        n16 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n9, n10, n, bl);
                        for (n15 = 0; n15 < n21; ++n15) {
                            sArray[n13 + n16 * n30 + n15 * n31] = object2[0][n26 + n17 * n24 + n15 * n29];
                        }
                    }
                }
                n13 += n27;
                continue;
            }
            throw new DicomException("Unsupported pixel data form - DataBufferType = " + n23);
        }
        attributeList.remove(TagFromName.PixelData);
        attributeList.remove(TagFromName.BitsAllocated);
        attributeList.remove(TagFromName.BitsStored);
        attributeList.remove(TagFromName.HighBit);
        attributeList.remove(TagFromName.SamplesPerPixel);
        attributeList.remove(TagFromName.PixelRepresentation);
        attributeList.remove(TagFromName.PhotometricInterpretation);
        attributeList.remove(TagFromName.PlanarConfiguration);
        n2 = attributeList.get(TagFromName.NumberOfFrames) != null ? 1 : 0;
        attributeList.remove(TagFromName.NumberOfFrames);
        attributeList.put(attribute);
        object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object).addValue(n3);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)object).addValue(n4);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)object).addValue(n5);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object).addValue(n11);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object).addValue(n12);
        attributeList.put((Attribute)object);
        if (n14 > 1 || n2 != 0) {
            object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object).addValue(n14);
            attributeList.put((Attribute)object);
        }
        object = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object).addValue(n6);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object).addValue(n7);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        if (n6 > 1) {
            object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object).addValue(n8);
            attributeList.put((Attribute)object);
        }
        sourceImage.constructSourceImage(attributeList);
    }

    static {
        slf4jlogger.info("Using usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan = {}", usePixelDataTemporaryFilesIfPixelDataLengthGreaterThan);
        slf4jlogger.info("Using useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan = {}", useMultiplePixelDataTemporaryFilesIfPixelDataLengthGreaterThan);
    }
}

