/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DisplayShutter;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.Overlay;
import com.pixelmed.dicom.RealWorldValueTransform;
import com.pixelmed.dicom.SUVTransform;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.DisplayedAreaSelection;
import com.pixelmed.display.DrawingUtilities;
import com.pixelmed.display.OrientationAnnotations;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.SuperimposedImage;
import com.pixelmed.display.TextAnnotation;
import com.pixelmed.display.TextAnnotationPositioned;
import com.pixelmed.display.WindowCenterAndWidth;
import com.pixelmed.display.event.ApplyShutterChangeEvent;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.GraphicDisplayChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.display.event.VOIFunctionChangeEvent;
import com.pixelmed.display.event.WindowCenterAndWidthChangeEvent;
import com.pixelmed.display.event.WindowLinearCalculationChangeEvent;
import com.pixelmed.display.event.WindowingAccelerationValueChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ColorUtilities;
import com.pixelmed.utils.FloatFormatter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.IndexColorModel;
import java.awt.image.RescaleOp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SingleImagePanel
extends JComponent
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanel.java,v 1.214 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SingleImagePanel.class);
    SourceImage sImg;
    int currentSrcImageIndex;
    int[] currentSrcImageSortOrder;
    BufferedImage cachedResizedImage;
    BufferedImage cachedResizedSelectedRegionImage;
    BufferedImage cachedPreWindowedImage;
    int offsetDrawingOfResizedSelectedRegionImageX;
    int offsetDrawingOfResizedSelectedRegionImageY;
    Rectangle cachedWindowSize;
    protected Set<SuperimposedImage.AppliedToUnderlyingImage> activeSuperimposedImagesAppliedToUnderlyingImage = new HashSet<SuperimposedImage.AppliedToUnderlyingImage>();
    protected boolean useVOILUTNotFunction;
    protected double windowCenter;
    protected double windowWidth;
    protected double voiLUTIdentityWindowWidth;
    protected double voiLUTIdentityWindowCenter;
    protected int voiLUTNumberOfEntries;
    protected int voiLUTFirstValueMapped;
    protected int voiLUTBitsPerEntry;
    protected short[] voiLUTData;
    protected int voiLUTEntryMin;
    protected int voiLUTEntryMax;
    protected int voiLUTTopOfEntryRange;
    double useSlope;
    double useIntercept;
    double imgMin;
    double imgMax;
    private int largestGray;
    private int firstvalueMapped;
    private int numberOfEntries;
    private int bitsPerEntry;
    private short[] redTable;
    private short[] greenTable;
    private short[] blueTable;
    private boolean signed;
    private boolean inverted;
    private boolean ybr;
    private int signMask;
    private int signBit;
    int pad;
    int padRangeLimit;
    boolean hasPad;
    SUVTransform suvTransform;
    RealWorldValueTransform realWorldValueTransform;
    ModalityTransform modalityTransform;
    VOITransform voiTransform;
    DisplayShutter displayShutter;
    Overlay overlay;
    protected GeometryOfVolume imageGeometry;
    protected Vector<Shape> preDefinedShapes;
    protected Vector<Shape> preDefinedText;
    protected Vector<Shape> localizerShapes;
    protected Vector<Shape> volumeLocalizationShapes;
    protected Vector<Shape> interactiveDrawingShapes;
    protected Vector<Shape> persistentDrawingShapes;
    protected Vector<Shape> selectedDrawingShapes;
    protected Vector<TextAnnotation> persistentDrawingText;
    protected Vector<Shape>[] perFrameDrawingShapes;
    protected Vector<SuperimposedImage> superimposedImages;
    private DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations = null;
    private Color demographicAndTechniqueColor;
    private Font demographicAndTechniqueFont;
    protected OrientationAnnotations orientationAnnotations = null;
    protected Color orientationColor;
    protected Font orientationFont;
    protected boolean showOrientationsLeftSide = false;
    protected String sideAndViewAnnotationString;
    protected int sideAndViewAnnotationVerticalOffset;
    protected Color sideAndViewAnnotationColor;
    protected Font sideAndViewAnnotationFont;
    protected boolean showSideAndViewAnnotationLeftSide = false;
    protected DisplayedAreaSelection originalDisplayedAreaSelection = null;
    private DisplayedAreaSelection useDisplayedAreaSelection = null;
    private AffineTransform preTransformImageRelativeCoordinates = null;
    protected boolean showZoomFactor = false;
    protected boolean showZoomFactorLeftSide = false;
    protected double pixelSpacingInSourceImage = 0.0;
    protected String typeOfPixelSpacing;
    private AffineTransform imageToWindowCoordinateTransform = null;
    private AffineTransform windowToImageCoordinateTransform = null;
    private int useVOIFunction = 0;
    private boolean useWindowLinearExactCalculationInsteadOfDICOMStandardMethod = false;
    private double windowingAccelerationValue = 50.0;
    private boolean showOverlays = true;
    private boolean applyShutter = true;
    private boolean showSuperimposedImages = true;
    EventContext typeOfPanelEventContext;
    int lastx;
    int lasty;
    int currentx;
    int currenty;
    int lastmiddley;
    double windowingMultiplier = 1.0;
    double panningMultiplier = 1.0;
    protected LeftMouseMode leftMouseMode = new LeftMouseMode();
    int currentVOITransformInUse;
    protected double[] currentLocationIn3DSpace = new double[3];
    private OurWindowCenterAndWidthChangeListener ourWindowCenterAndWidthChangeListener;
    private OurFrameSelectionChangeListener ourFrameSelectionChangeListener;
    private OurFrameSortOrderChangeListener ourFrameSortOrderChangeListener;
    private OurVOIFunctionChangeListener ourVOIFunctionChangeListener;
    private OurWindowLinearCalculationChangeListener ourWindowLinearCalculationChangeListener;
    private OurWindowingAccelerationValueChangeListener ourWindowingAccelerationValueChangeListener;
    private OurGraphicDisplayChangeListener ourGraphicDisplayChangeListener;
    private OurApplyShutterChangeListener ourApplyShutterChangeListener;
    private boolean useConvertToMostFavorableImageType;
    private BufferedImageUtilities resampler = null;

    public void dirty() {
        this.dirtySource();
    }

    public void dirtySource() {
        this.cachedResizedImage = null;
        this.cachedResizedSelectedRegionImage = null;
        this.cachedPreWindowedImage = null;
    }

    public void dirty(SourceImage sourceImage) {
        this.dirtySource(sourceImage);
    }

    public void dirtySource(SourceImage sourceImage) {
        this.sImg = sourceImage;
        this.realWorldValueTransform = sourceImage.getRealWorldValueTransform();
        this.modalityTransform = sourceImage.getModalityTransform();
        this.voiTransform = sourceImage.getVOITransform();
        this.displayShutter = sourceImage.getDisplayShutter();
        this.overlay = sourceImage.getOverlay();
        this.cachedResizedImage = null;
        this.cachedResizedSelectedRegionImage = null;
        this.cachedPreWindowedImage = null;
    }

    public void dirtyWindowing() {
        this.cachedPreWindowedImage = null;
    }

    public void dirtyPanned() {
        this.cachedPreWindowedImage = null;
        this.cachedResizedSelectedRegionImage = null;
    }

    public GeometryOfVolume getImageGeometry() {
        return this.imageGeometry;
    }

    public final void setPreDefinedShapes(Vector vector) {
        this.preDefinedShapes = vector;
    }

    public final void setLocalizerShapes(Vector vector) {
        this.localizerShapes = vector;
    }

    public final void setVolumeLocalizationShapes(Vector vector) {
        this.volumeLocalizationShapes = vector;
    }

    public final void setPersistentDrawingShapes(Vector vector) {
        this.persistentDrawingShapes = vector;
    }

    public final Vector getPersistentDrawingShapes() {
        return this.persistentDrawingShapes;
    }

    public final void setSelectedDrawingShapes(Vector vector) {
        this.selectedDrawingShapes = vector;
    }

    public final Vector getSelectedDrawingShapes() {
        return this.selectedDrawingShapes;
    }

    public final void setPerFrameDrawingShapes(Vector<Shape>[] vectorArray) {
        this.perFrameDrawingShapes = vectorArray;
    }

    public final void setSuperimposedImages(Vector<SuperimposedImage> vector) {
        this.superimposedImages = vector;
    }

    public final Vector<SuperimposedImage> getSuperimposedImages() {
        return this.superimposedImages;
    }

    public final void setDemographicAndTechniqueAnnotations(DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations, String string, int n, int n2, Color color) {
        this.demographicAndTechniqueAnnotations = demographicAndTechniqueAnnotations;
        this.demographicAndTechniqueFont = new Font(string, n, n2);
        this.demographicAndTechniqueColor = color;
    }

    public final void setOrientationAnnotations(OrientationAnnotations orientationAnnotations, String string, int n, int n2, Color color) {
        this.setOrientationAnnotations(orientationAnnotations, string, n, n2, color, false);
    }

    public final void setOrientationAnnotations(OrientationAnnotations orientationAnnotations, String string, int n, int n2, Color color, boolean bl) {
        this.orientationAnnotations = orientationAnnotations;
        this.orientationFont = new Font(string, n, n2);
        this.orientationColor = color;
        this.showOrientationsLeftSide = bl;
    }

    public final void setSideAndViewAnnotationString(String string, int n, String string2, int n2, int n3, Color color, boolean bl) {
        this.sideAndViewAnnotationString = string;
        this.sideAndViewAnnotationVerticalOffset = n;
        this.sideAndViewAnnotationFont = new Font(string2, n2, n3);
        this.sideAndViewAnnotationColor = color;
        this.showSideAndViewAnnotationLeftSide = bl;
    }

    public final void setDisplayedAreaSelection(DisplayedAreaSelection displayedAreaSelection) {
        this.originalDisplayedAreaSelection = displayedAreaSelection;
        this.useDisplayedAreaSelection = null;
    }

    public void displayReset() {
        slf4jlogger.debug("displayReset()");
        this.dirtySource();
        this.useDisplayedAreaSelection = null;
        this.establishInitialWindowOrVOILUT();
    }

    public void displaySelectedMagnificationRatio(double d) {
        slf4jlogger.debug("displaySelectedMagnificationRatio(): ratio ={}", d);
        this.dirtySource();
        try {
            this.useDisplayedAreaSelection = (DisplayedAreaSelection)this.originalDisplayedAreaSelection.clone();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            this.useDisplayedAreaSelection = null;
        }
        if (this.useDisplayedAreaSelection != null) {
            this.useDisplayedAreaSelection.setPixelMagnificationRatio(d);
            this.useDisplayedAreaSelection = this.useDisplayedAreaSelection.shapeSelectionToMatchAvailableWindow(this.cachedWindowSize);
        }
    }

    public final void setPreTransformImageRelativeCoordinates(AffineTransform affineTransform) {
        this.preTransformImageRelativeCoordinates = affineTransform;
    }

    public final void setShowZoomFactor(boolean bl, boolean bl2, double d) {
        this.showZoomFactor = bl;
        this.showZoomFactorLeftSide = bl2;
        this.pixelSpacingInSourceImage = d;
    }

    public final void setShowZoomFactor(boolean bl, boolean bl2, double d, String string) {
        this.showZoomFactor = bl;
        this.showZoomFactorLeftSide = bl2;
        this.pixelSpacingInSourceImage = d;
        this.typeOfPixelSpacing = string;
    }

    public final void setPixelSpacingInSourceImage(double d) {
        this.pixelSpacingInSourceImage = d;
    }

    public final void setPixelSpacingInSourceImage(double d, String string) {
        this.pixelSpacingInSourceImage = d;
        this.typeOfPixelSpacing = string;
    }

    public final void setVOIFunctionToLinear() {
        slf4jlogger.debug("setVOIFunctionToLinear()");
        this.useVOIFunction = 0;
    }

    public final void setVOIFunctionToLogistic() {
        slf4jlogger.debug("setVOIFunctionToLogistic()");
        this.useVOIFunction = 1;
    }

    public final void setWindowLinearCalculationToExact() {
        slf4jlogger.debug("setWindowLinearCalculationToExact()");
        this.useWindowLinearExactCalculationInsteadOfDICOMStandardMethod = true;
    }

    public final void setWindowLinearCalculationToDicom() {
        slf4jlogger.debug("setWindowLinearCalculationToDicom()");
        this.useWindowLinearExactCalculationInsteadOfDICOMStandardMethod = false;
    }

    public final void setWindowingAccelerationValue(double d) {
        slf4jlogger.debug("setWindowingAccelerationValue(): to {}", d);
        this.windowingAccelerationValue = d;
    }

    public final void setShowOverlays(boolean bl) {
        slf4jlogger.debug("setShowOverlays(): {}", bl);
        this.showOverlays = bl;
    }

    public final void setApplyShutter(boolean bl) {
        slf4jlogger.debug("setApplyShutter(): {}", bl);
        this.applyShutter = bl;
    }

    public final void setShowSuperimposedImages(boolean bl) {
        slf4jlogger.debug("setShowSuperimposedImages(): {}", bl);
        this.showSuperimposedImages = bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.windowingMultiplier = this.windowingAccelerationValue;
            this.panningMultiplier = 5.0;
        } else if (keyEvent.getKeyCode() == 18) {
            this.leftMouseMode.setPanning();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.windowingMultiplier = 1.0;
            this.panningMultiplier = 1.0;
        } else if (keyEvent.getKeyCode() == 18) {
            this.leftMouseMode.setWindowing();
        } else if (keyEvent.getKeyCode() == 82) {
            this.displayReset();
            this.repaint();
        } else if (keyEvent.getKeyCode() == 83) {
            this.dirtySource();
            this.establishStatisticalWindow();
            this.repaint();
        } else if (keyEvent.getKeyCode() == 49) {
            this.displaySelectedMagnificationRatio(1.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 50) {
            this.displaySelectedMagnificationRatio(2.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 51) {
            this.displaySelectedMagnificationRatio(4.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 52) {
            this.displaySelectedMagnificationRatio(8.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 53) {
            this.displaySelectedMagnificationRatio(16.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 54) {
            this.displaySelectedMagnificationRatio(32.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 55) {
            this.displaySelectedMagnificationRatio(64.0);
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        int n2 = this.currentSrcImageIndex + n;
        if (n2 >= this.sImg.getNumberOfBufferedImages()) {
            n2 = this.sImg.getNumberOfBufferedImages() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != this.currentSrcImageIndex) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(this.typeOfPanelEventContext, n2));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.lastx;
            int n4 = n2 - this.lasty;
            if (n3 != 0 || n4 != 0) {
                this.lastx = n;
                this.lasty = n2;
                if (this.leftMouseMode.isWindowing()) {
                    double d = this.windowWidth + (double)n3 * this.windowingMultiplier;
                    if (this.windowingMultiplier >= 1.0 && d < 1.0) {
                        d = 1.0;
                    }
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    double d2 = this.windowCenter + (double)n4 * this.windowingMultiplier;
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new WindowCenterAndWidthChangeEvent(this.typeOfPanelEventContext, d2, d));
                } else if (this.leftMouseMode.isPanning() && this.useDisplayedAreaSelection != null) {
                    int n5 = (int)((double)(-n3) * this.panningMultiplier);
                    int n6 = (int)((double)(-n4) * this.panningMultiplier);
                    this.useDisplayedAreaSelection.translate(n5, n6);
                    this.dirtyPanned();
                    this.repaint();
                }
            }
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            int n = mouseEvent.getY() - this.lastmiddley;
            int n7 = this.currentSrcImageIndex + n;
            if (n7 >= this.sImg.getNumberOfBufferedImages()) {
                n7 = this.sImg.getNumberOfBufferedImages() - 1;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n7 != this.currentSrcImageIndex) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(this.typeOfPanelEventContext, n7));
            }
            this.lastmiddley = mouseEvent.getY();
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    protected int getSourceImageHeight() {
        return this.sImg.getHeight();
    }

    protected int getSourceImageWidth() {
        return this.sImg.getWidth();
    }

    protected Point2D getImageCoordinateFromWindowCoordinate(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.windowToImageCoordinateTransform != null) {
            int n;
            Point2D point2D = new Point2D.Double(d, d2);
            point2D = this.windowToImageCoordinateTransform.transform(point2D, point2D);
            d3 = point2D.getX();
            d4 = point2D.getY();
            if (d3 < 0.0) {
                d3 = 0.0;
            } else {
                n = this.getSourceImageWidth();
                if (d3 > (double)n) {
                    d3 = n;
                }
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            } else {
                n = this.getSourceImageHeight();
                if (d4 > (double)n) {
                    d4 = n;
                }
            }
        }
        return new Point2D.Double(d3, d4);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.currentx = mouseEvent.getX();
        this.currenty = mouseEvent.getY();
        this.updateStatusBarValues(this.currentx, this.currenty);
    }

    public void updateStatusBarValues(int n, int n2) {
        String string = null;
        if (this.currentSrcImageIndex != -1) {
            Iterator<SuperimposedImage.AppliedToUnderlyingImage> iterator;
            Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
            double d = point2D.getX();
            double d2 = point2D.getY();
            int n3 = this.currentSrcImageSortOrder == null ? this.currentSrcImageIndex : this.currentSrcImageSortOrder[this.currentSrcImageIndex];
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(FloatFormatter.toString(d, Locale.US));
            stringBuffer.append(",");
            stringBuffer.append(FloatFormatter.toString(d2, Locale.US));
            if (this.imageGeometry != null) {
                double[] object2;
                this.imageGeometry.lookupImageCoordinate(this.currentLocationIn3DSpace, d, d2, n3);
                iterator = this.imageGeometry.getGeometryOfSlice(n3);
                if (iterator != null && (Double.isNaN((object2 = ((GeometryOfSlice)((Object)iterator)).lookupImageCoordinate(this.currentLocationIn3DSpace))[0]) || Double.isInfinite(object2[0]) || Math.abs(object2[0] - d) > 0.01 || Double.isNaN(object2[1]) || Double.isInfinite(object2[1]) || Math.abs(object2[1] - d2) > 0.01)) {
                    slf4jlogger.info("Round trip imageGeometry.getGeometryOfSlice().lookupImageCoordinate(): failed (" + d + "," + d2 + ") != (" + object2[0] + "," + object2[1] + ") for 3D (" + this.currentLocationIn3DSpace[0] + "," + this.currentLocationIn3DSpace[1] + "," + this.currentLocationIn3DSpace[2] + ")");
                }
                stringBuffer.append(": ");
                stringBuffer.append(FloatFormatter.toString(this.currentLocationIn3DSpace[0], Locale.US));
                stringBuffer.append(",");
                stringBuffer.append(FloatFormatter.toString(this.currentLocationIn3DSpace[1], Locale.US));
                stringBuffer.append(",");
                stringBuffer.append(FloatFormatter.toString(this.currentLocationIn3DSpace[2], Locale.US));
                for (SuperimposedImage.AppliedToUnderlyingImage appliedToUnderlyingImage : this.activeSuperimposedImagesAppliedToUnderlyingImage) {
                    appliedToUnderlyingImage.notificationOfCurrentLocationIn3DSpace(this.currentLocationIn3DSpace);
                }
            }
            stringBuffer.append(")");
            iterator = this.sImg.getBufferedImage(n3);
            int n4 = (int)d;
            int n5 = (int)d2;
            if (n4 >= 0 && n4 < ((BufferedImage)((Object)iterator)).getWidth() && n5 >= 0 && n5 < ((BufferedImage)((Object)iterator)).getHeight()) {
                double d3;
                if (((BufferedImage)((Object)iterator)).getRaster().getDataBuffer() instanceof DataBufferFloat) {
                    float[] nArray = ((BufferedImage)((Object)iterator)).getSampleModel().getPixel(n4, n5, (float[])null, ((BufferedImage)((Object)iterator)).getRaster().getDataBuffer());
                    d3 = nArray[0];
                } else if (((BufferedImage)((Object)iterator)).getRaster().getDataBuffer() instanceof DataBufferDouble) {
                    double[] dArray = ((BufferedImage)((Object)iterator)).getSampleModel().getPixel(n4, n5, (double[])null, ((BufferedImage)((Object)iterator)).getRaster().getDataBuffer());
                    d3 = dArray[0];
                } else {
                    int[] nArray = ((BufferedImage)((Object)iterator)).getSampleModel().getPixel(n4, n5, (int[])null, ((BufferedImage)((Object)iterator)).getRaster().getDataBuffer());
                    int n6 = nArray[0];
                    if (this.signed && (n6 & this.signBit) != 0) {
                        n6 |= this.signMask;
                    }
                    d3 = n6;
                }
                if (this.realWorldValueTransform != null) {
                    stringBuffer.append(" = ");
                    stringBuffer.append(this.realWorldValueTransform.toString(n3, d3));
                    stringBuffer.append(" [");
                    stringBuffer.append(FloatFormatter.toString(d3, Locale.US));
                    stringBuffer.append("]");
                }
                if (this.suvTransform != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.suvTransform.toString(n3, d3));
                }
            }
            string = stringBuffer.toString();
        } else {
            string = "No frame selected";
        }
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastx = mouseEvent.getX();
            this.lasty = mouseEvent.getY();
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.lastmiddley = mouseEvent.getY();
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.leftMouseMode.isWindowing()) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new WindowCenterAndWidthChangeEvent(this.typeOfPanelEventContext, this.windowCenter, this.windowWidth));
            }
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    public static final BufferedImage applyVOILUT(BufferedImage bufferedImage, double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, double d6, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, int n6, int n7, int n8) {
        return WindowCenterAndWidth.applyVOILUT(bufferedImage, d, d2, d3, d4, bl, bl2, d5, d6, bl3, n, n2, n3, n4, n5, sArray, n6, n7, n8);
    }

    public static final BufferedImage applyWindowCenterAndWidthLogistic(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLogistic(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, boolean bl4) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2, bl4);
    }

    public static final BufferedImage applyWindowCenterAndWidthWithPaletteColor(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, short[] sArray2, short[] sArray3) {
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor():");
        return WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2, n3, n4, n5, sArray, sArray2, sArray3);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinearToColorImage(BufferedImage bufferedImage, double d, double d2) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinearToColorImage(bufferedImage, d, d2);
    }

    protected void establishStatisticalWindow() {
        slf4jlogger.debug("establishStatisticalWindow(): Deriving window statistically");
        slf4jlogger.debug("useSlope {}", this.useSlope);
        slf4jlogger.debug("useIntercept {}", this.useIntercept);
        slf4jlogger.debug("imgMin {}", this.imgMin);
        slf4jlogger.debug("imgMax {}", this.imgMax);
        double d = this.imgMin * this.useSlope + this.useIntercept;
        double d2 = this.imgMax * this.useSlope + this.useIntercept;
        slf4jlogger.debug("ourMin {}", d);
        slf4jlogger.debug("ourMax {}", d2);
        this.windowWidth = d2 - d;
        this.windowCenter = (d2 + d) / 2.0;
        this.currentVOITransformInUse = -1;
        slf4jlogger.debug("establishStatisticalWindow(): Initially using statistically derived center {} and width {}", this.windowCenter, this.windowWidth);
    }

    protected void establishInitialWindowOrVOILUT() {
        this.useVOILUTNotFunction = false;
        this.windowWidth = 0.0;
        this.windowCenter = 0.0;
        this.voiLUTIdentityWindowCenter = 0.0;
        this.voiLUTIdentityWindowWidth = 0.0;
        this.voiLUTNumberOfEntries = 0;
        this.voiLUTFirstValueMapped = 0;
        this.voiLUTBitsPerEntry = 0;
        this.voiLUTData = null;
        this.voiLUTEntryMin = 0;
        this.voiLUTEntryMax = 0;
        this.voiLUTTopOfEntryRange = 0;
        slf4jlogger.debug("establishInitialWindowOrVOILUT(): Looking at voiTransform {}", this.voiTransform);
        if (this.voiTransform != null) {
            int n = this.voiTransform.getNumberOfTransforms(this.currentSrcImageIndex);
            this.currentVOITransformInUse = 0;
            while (this.currentVOITransformInUse < n) {
                if (this.voiTransform.isLUTTransform(this.currentSrcImageIndex, this.currentVOITransformInUse)) {
                    slf4jlogger.debug("doCommonConstructorStuff(): found possible LUT {}", this.currentVOITransformInUse);
                    this.voiLUTNumberOfEntries = this.voiTransform.getNumberOfEntries(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTFirstValueMapped = this.voiTransform.getFirstValueMapped(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTBitsPerEntry = this.voiTransform.getBitsPerEntry(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTData = this.voiTransform.getLUTData(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTEntryMin = this.voiTransform.getEntryMinimum(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTEntryMax = this.voiTransform.getEntryMaximum(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTTopOfEntryRange = this.voiTransform.getTopOfEntryRange(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    if (this.voiLUTData == null || this.voiLUTData.length != this.voiLUTNumberOfEntries) break;
                    this.useVOILUTNotFunction = true;
                    slf4jlogger.debug("establishInitialWindowOrVOILUT(): using good LUT {}", this.currentVOITransformInUse);
                    this.voiLUTIdentityWindowWidth = this.voiLUTNumberOfEntries;
                    this.voiLUTIdentityWindowCenter = this.voiLUTFirstValueMapped + this.voiLUTNumberOfEntries / 2;
                    this.windowWidth = this.voiLUTIdentityWindowWidth;
                    this.windowCenter = this.voiLUTIdentityWindowCenter;
                    break;
                }
                ++this.currentVOITransformInUse;
            }
            if (!this.useVOILUTNotFunction) {
                this.currentVOITransformInUse = 0;
                while (this.currentVOITransformInUse < n) {
                    if (this.voiTransform.isWindowTransform(this.currentSrcImageIndex, this.currentVOITransformInUse)) {
                        this.useVOILUTNotFunction = false;
                        this.windowWidth = this.voiTransform.getWidth(this.currentSrcImageIndex, this.currentVOITransformInUse);
                        this.windowCenter = this.voiTransform.getCenter(this.currentSrcImageIndex, this.currentVOITransformInUse);
                        slf4jlogger.debug("establishInitialWindowOrVOILUT(): Initially using preselected center {} and width {}", this.windowCenter, this.windowWidth);
                        break;
                    }
                    ++this.currentVOITransformInUse;
                }
            }
        }
        if (!this.useVOILUTNotFunction && this.windowWidth <= 0.0) {
            this.establishStatisticalWindow();
        }
    }

    private void doCommonConstructorStuff(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        BufferedImage bufferedImage;
        slf4jlogger.debug("doCommonConstructorStuff():");
        this.sImg = sourceImage;
        boolean bl = false;
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            slf4jlogger.debug("doCommonConstructorStuff(): sImg != null");
            bufferedImage = sourceImage.getBufferedImage(0);
            if (bufferedImage != null && bufferedImage.getRaster().getNumBands() > 1) {
                bl = true;
            }
        }
        slf4jlogger.debug("doCommonConstructorStuff(): convertNonGrayscale = {}", bl);
        try {
            this.useConvertToMostFavorableImageType = bl;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        slf4jlogger.debug("doCommonConstructorStuff(): useConvertToMostFavorableImageType = {}", this.useConvertToMostFavorableImageType);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.currentSrcImageIndex = 0;
        this.currentSrcImageSortOrder = nArray;
        this.dirtySource();
        this.typeOfPanelEventContext = eventContext;
        this.ourWindowCenterAndWidthChangeListener = new OurWindowCenterAndWidthChangeListener(eventContext);
        this.ourFrameSelectionChangeListener = new OurFrameSelectionChangeListener(eventContext);
        this.ourFrameSortOrderChangeListener = new OurFrameSortOrderChangeListener(eventContext);
        this.ourVOIFunctionChangeListener = new OurVOIFunctionChangeListener(eventContext);
        this.ourWindowLinearCalculationChangeListener = new OurWindowLinearCalculationChangeListener(eventContext);
        this.ourWindowingAccelerationValueChangeListener = new OurWindowingAccelerationValueChangeListener(eventContext);
        this.ourGraphicDisplayChangeListener = new OurGraphicDisplayChangeListener(eventContext);
        this.ourApplyShutterChangeListener = new OurApplyShutterChangeListener(eventContext);
        this.largestGray = sourceImage.getPaletteColorLargestGray();
        this.firstvalueMapped = sourceImage.getPaletteColorFirstValueMapped();
        this.numberOfEntries = sourceImage.getPaletteColorNumberOfEntries();
        this.bitsPerEntry = sourceImage.getPaletteColorBitsPerEntry();
        this.redTable = sourceImage.getPaletteColorRedTable();
        this.greenTable = sourceImage.getPaletteColorGreenTable();
        this.blueTable = sourceImage.getPaletteColorBlueTable();
        this.signed = sourceImage.isSigned();
        this.inverted = sourceImage.isInverted();
        this.ybr = sourceImage.isYBR();
        this.hasPad = sourceImage.isPadded();
        this.pad = sourceImage.getPadValue();
        this.padRangeLimit = sourceImage.getPadRangeLimit();
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            bufferedImage = sourceImage.getBufferedImage(0);
            this.imgMin = sourceImage.getMinimum();
            this.imgMax = sourceImage.getMaximum();
            this.signBit = 0;
            this.signMask = 0;
            if (this.signed) {
                slf4jlogger.debug("signed={}", this.signed);
                if (bufferedImage.getSampleModel().getDataType() == 0) {
                    this.signBit = 128;
                    this.signMask = -128;
                } else {
                    this.signBit = 32768;
                    this.signMask = Short.MIN_VALUE;
                }
            }
            slf4jlogger.debug("signMask=0x{}", Integer.toHexString(this.signMask));
            slf4jlogger.debug("signBit=0x{}", Integer.toHexString(this.signBit));
        }
        this.suvTransform = sourceImage.getSUVTransform();
        this.realWorldValueTransform = sourceImage.getRealWorldValueTransform();
        this.modalityTransform = sourceImage.getModalityTransform();
        this.voiTransform = sourceImage.getVOITransform();
        this.displayShutter = sourceImage.getDisplayShutter();
        this.overlay = sourceImage.getOverlay();
        if (this.modalityTransform != null) {
            this.useSlope = this.modalityTransform.getRescaleSlope(this.currentSrcImageIndex);
            this.useIntercept = this.modalityTransform.getRescaleIntercept(this.currentSrcImageIndex);
            slf4jlogger.debug("Initially using preselected rescale slope {} and intercept {}", this.useSlope, this.useIntercept);
        } else {
            this.useSlope = 1.0;
            this.useIntercept = 0.0;
            slf4jlogger.debug("Initially using default rescale slope {} and intercept {}", this.useSlope, this.useIntercept);
        }
        this.establishInitialWindowOrVOILUT();
        slf4jlogger.debug("doCommonConstructorStuff(): setting preDefinedShapes");
        this.preDefinedShapes = vector;
        this.preDefinedText = vector2;
        this.imageGeometry = geometryOfVolume;
    }

    public SingleImagePanel(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        this.doCommonConstructorStuff(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanel(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        this.doCommonConstructorStuff(sourceImage, eventContext, null, null, null, geometryOfVolume);
    }

    public SingleImagePanel(SourceImage sourceImage, EventContext eventContext) {
        this.doCommonConstructorStuff(sourceImage, eventContext, null, null, null, null);
    }

    public SingleImagePanel(SourceImage sourceImage) {
        this.doCommonConstructorStuff(sourceImage, null, null, null, null, null);
    }

    public void deconstruct() {
        slf4jlogger.debug("deconstruct()");
        if (this.ourWindowCenterAndWidthChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourWindowCenterAndWidthChangeListener);
            this.ourWindowCenterAndWidthChangeListener = null;
        }
        if (this.ourFrameSelectionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSelectionChangeListener);
            this.ourFrameSelectionChangeListener = null;
        }
        if (this.ourFrameSortOrderChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSortOrderChangeListener);
            this.ourFrameSortOrderChangeListener = null;
        }
        if (this.ourVOIFunctionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourVOIFunctionChangeListener);
            this.ourVOIFunctionChangeListener = null;
        }
        if (this.ourWindowLinearCalculationChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourWindowLinearCalculationChangeListener);
            this.ourWindowLinearCalculationChangeListener = null;
        }
        if (this.ourWindowingAccelerationValueChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourWindowingAccelerationValueChangeListener);
            this.ourWindowingAccelerationValueChangeListener = null;
        }
        if (this.ourGraphicDisplayChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourGraphicDisplayChangeListener);
            this.ourGraphicDisplayChangeListener = null;
        }
    }

    public static void deconstructAllSingleImagePanelsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        slf4jlogger.debug("deconstructAllSingleImagePanelsInContainer(): deconstructing old SingleImagePanels components.length={}", componentArray.length);
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof SingleImagePanel)) continue;
            ((SingleImagePanel)component).deconstruct();
        }
    }

    protected void finalize() throws Throwable {
        slf4jlogger.debug("finalize()");
        this.deconstruct();
        super.finalize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        slf4jlogger.debug("paintComponent(): start");
        long l = System.currentTimeMillis();
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.currentSrcImageIndex != -1) {
            Object object;
            Object object2;
            Object object3;
            Object object5;
            Object object6;
            int n;
            Object object7;
            int n2 = this.currentSrcImageSortOrder == null ? this.currentSrcImageIndex : this.currentSrcImageSortOrder[this.currentSrcImageIndex];
            slf4jlogger.debug("paintComponent() useSrcImageIndex: {}", n2);
            Object object8 = this.sImg.getBufferedImage(n2);
            slf4jlogger.debug("paintComponent(): useSrcImage BufferedImage: {}", object8);
            slf4jlogger.debug("paintComponent(): useSrcImage is BufferedImage as follows:");
            if (slf4jlogger.isDebugEnabled()) {
                BufferedImageUtilities.describeImage((BufferedImage)object8, System.err);
            }
            if (this.ybr) {
                slf4jlogger.debug("paintComponent(): attempting to convert YBR to RGB for display");
                object7 = BufferedImageUtilities.convertYBRToRGB((BufferedImage)object8);
                if (object7 != null) {
                    slf4jlogger.debug("paintComponent(): YBR to RGB conversion succeeded");
                    object8 = object7;
                    this.dirtySource();
                } else {
                    slf4jlogger.debug("paintComponent(): YBR to RGB conversion failed - just use what we have");
                }
            }
            object7 = this.getBounds();
            slf4jlogger.debug("paintComponent():windowSize = {}", object7);
            if (this.cachedWindowSize != null && ((Rectangle)object7).width != this.cachedWindowSize.width && ((Rectangle)object7).height != this.cachedWindowSize.height) {
                slf4jlogger.debug("paintComponent(): window size changed, so flushing cache and resetting selection to original");
                this.dirtySource();
                this.useDisplayedAreaSelection = null;
            }
            this.cachedWindowSize = object7;
            if (this.useDisplayedAreaSelection == null) {
                if (this.originalDisplayedAreaSelection == null) {
                    this.originalDisplayedAreaSelection = new DisplayedAreaSelection(((BufferedImage)object8).getWidth(), ((BufferedImage)object8).getHeight());
                }
                slf4jlogger.debug("setDisplayedAreaSelection(): originalDisplayedAreaSelection = {}", this.originalDisplayedAreaSelection);
                this.useDisplayedAreaSelection = this.originalDisplayedAreaSelection.shapeSelectionToMatchAvailableWindow((Rectangle)object7);
                slf4jlogger.debug("paintComponent(): useDisplayedAreaSelection (after shapping to match available window size) = {}", this.useDisplayedAreaSelection);
            }
            double d = (double)((Rectangle)object7).width / (double)this.useDisplayedAreaSelection.getSelectionWidth();
            slf4jlogger.debug("paintComponent(): useScaleFactor = {}", d);
            this.imageToWindowCoordinateTransform = AffineTransform.getTranslateInstance((double)(-this.useDisplayedAreaSelection.getXOffset()) * d, (double)(-this.useDisplayedAreaSelection.getYOffset()) * d);
            this.imageToWindowCoordinateTransform.concatenate(AffineTransform.getScaleInstance(d, d));
            if (this.preTransformImageRelativeCoordinates != null) {
                this.imageToWindowCoordinateTransform.concatenate(this.preTransformImageRelativeCoordinates);
            }
            slf4jlogger.debug("paintComponent(): imageToWindowCoordinateTransform = {}", this.imageToWindowCoordinateTransform);
            try {
                this.windowToImageCoordinateTransform = this.imageToWindowCoordinateTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                slf4jlogger.error("", noninvertibleTransformException);
                this.windowToImageCoordinateTransform = null;
            }
            slf4jlogger.debug("paintComponent(): windowToImageCoordinateTransform = {}", this.windowToImageCoordinateTransform);
            if (this.cachedPreWindowedImage == null) {
                slf4jlogger.debug("paintComponent(): cachedPreWindowedImage is null");
                if (this.cachedResizedSelectedRegionImage == null) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    slf4jlogger.debug("paintComponent(): resizing prior to windowing");
                    if (this.cachedResizedImage == null) {
                        if (this.resampler == null) {
                            this.resampler = new BufferedImageUtilities();
                        }
                        long l2 = System.currentTimeMillis();
                        n6 = this.sImg.getBackgroundValue();
                        n5 = ((BufferedImage)object8).getWidth();
                        slf4jlogger.debug("paintComponent(): resizing srcWidth {}", n5);
                        n4 = ((BufferedImage)object8).getHeight();
                        slf4jlogger.debug("paintComponent(): resizing srcHeight {}", n4);
                        n3 = (int)Math.round((double)n5 * d);
                        if (n3 <= 0) {
                            n3 = 1;
                        }
                        slf4jlogger.debug("paintComponent(): resizing dstWidth {}", n3);
                        n = (int)Math.round((double)n4 * d);
                        if (n <= 0) {
                            n = 1;
                        }
                        slf4jlogger.debug("paintComponent(): resizing dstHeight {}", n);
                        this.cachedResizedImage = this.resampler.resample((BufferedImage)object8, n5, n4, 0, 0, n3, n, this.signed, n6);
                        slf4jlogger.debug("paintComponent(): resizing with resampler - done in {} ms", System.currentTimeMillis() - l2);
                        slf4jlogger.debug("paintComponent(): resampled BufferedImage: {}", this.cachedResizedImage);
                        slf4jlogger.debug("paintComponent(): resampled BufferedImage is as follows:");
                        if (slf4jlogger.isDebugEnabled()) {
                            BufferedImageUtilities.describeImage(this.cachedResizedImage, System.err);
                        }
                    }
                    long l3 = System.currentTimeMillis();
                    n6 = (int)Math.round((double)this.useDisplayedAreaSelection.getXOffset() * d);
                    n5 = (int)Math.round((double)this.useDisplayedAreaSelection.getYOffset() * d);
                    n4 = (int)Math.round((double)this.useDisplayedAreaSelection.getSelectionWidth() * d);
                    n3 = (int)Math.round((double)this.useDisplayedAreaSelection.getSelectionHeight() * d);
                    slf4jlogger.debug("paintComponent(): before clipping to image area - scaledSelectionX = {}", n6);
                    slf4jlogger.debug("paintComponent(): before clipping to image area - scaledSelectionY = {}", n5);
                    slf4jlogger.debug("paintComponent(): before clipping to image area - scaledSelectionWidth = {}", n4);
                    slf4jlogger.debug("paintComponent(): before clipping to image area - scaledSelectionHeight = {}", n3);
                    if (n6 < 0) {
                        this.offsetDrawingOfResizedSelectedRegionImageX = -n6;
                        n6 = 0;
                    } else {
                        this.offsetDrawingOfResizedSelectedRegionImageX = 0;
                    }
                    if (n5 < 0) {
                        this.offsetDrawingOfResizedSelectedRegionImageY = -n5;
                        n5 = 0;
                    } else {
                        this.offsetDrawingOfResizedSelectedRegionImageY = 0;
                    }
                    n = this.cachedResizedImage.getWidth();
                    slf4jlogger.debug("paintComponent(): cachedResizedImageWidth = {}", n);
                    if (n6 + n4 > n) {
                        n4 = n - n6;
                    } else if (n6 + n4 < n) {
                        n4 = n - n6;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    int n7 = this.cachedResizedImage.getHeight();
                    slf4jlogger.debug("paintComponent(): cachedResizedImageHeight = {}", n7);
                    if (n5 + n3 > n7) {
                        n3 = n7 - n5;
                    } else if (n5 + n3 < n7) {
                        n3 = n7 - n5;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    slf4jlogger.debug("paintComponent(): after clipping to image area - scaledSelectionX = {}", n6);
                    slf4jlogger.debug("paintComponent(): after clipping to image area - scaledSelectionY = {}", n5);
                    slf4jlogger.debug("paintComponent(): after clipping to image area - scaledSelectionWidth = {}", n4);
                    slf4jlogger.debug("paintComponent(): after clipping to image area - scaledSelectionHeight = {}", n3);
                    slf4jlogger.debug("paintComponent(): offsetDrawingOfResizedSelectedRegionImageX = {}", this.offsetDrawingOfResizedSelectedRegionImageX);
                    slf4jlogger.debug("paintComponent(): offsetDrawingOfResizedSelectedRegionImageY = {}", this.offsetDrawingOfResizedSelectedRegionImageY);
                    this.cachedResizedSelectedRegionImage = n3 > 0 && n4 > 0 ? this.cachedResizedImage.getSubimage(n6, n5, n4, n3) : null;
                    slf4jlogger.debug("paintComponent(): selecting subimage from resized image - done in {} ms", System.currentTimeMillis() - l3);
                }
                if ((object8 = this.cachedResizedSelectedRegionImage) == null) {
                    this.cachedPreWindowedImage = null;
                } else {
                    ColorModel colorModel = ((BufferedImage)object8).getColorModel();
                    int n8 = colorModel.getNumComponents();
                    slf4jlogger.debug("paintComponent(): Before windowing (if needed), getNumComponents() == {}", n8);
                    if (n8 == 1) {
                        slf4jlogger.debug("currentVOITransformInUse {}", this.currentVOITransformInUse);
                        if (this.currentVOITransformInUse != -1 && !this.useVOILUTNotFunction && this.voiTransform != null && this.voiTransform.getNumberOfTransforms(n2) > this.currentVOITransformInUse) {
                            this.windowWidth = this.voiTransform.getWidth(n2, this.currentVOITransformInUse);
                            this.windowCenter = this.voiTransform.getCenter(n2, this.currentVOITransformInUse);
                            slf4jlogger.debug("For new frame {} using preselected center {} and width {}", n2, this.windowCenter, this.windowWidth);
                        } else {
                            slf4jlogger.debug("For new frame {} using user selected center {} and width {}", n2, this.windowCenter, this.windowWidth);
                        }
                        if (this.modalityTransform != null) {
                            this.useSlope = this.modalityTransform.getRescaleSlope(n2);
                            this.useIntercept = this.modalityTransform.getRescaleIntercept(n2);
                            slf4jlogger.debug("For new frame {} using preselected rescale slope {} and intercept {}", n2, this.useSlope, this.useIntercept);
                        } else {
                            this.useSlope = 1.0;
                            this.useIntercept = 0.0;
                            slf4jlogger.debug("For new frame {} using default rescale slope {} and intercept {}", n2, this.useSlope, this.useIntercept);
                        }
                        slf4jlogger.debug("paintComponent() useVOILUTNotFunction = {}", this.useVOILUTNotFunction);
                        slf4jlogger.debug("paintComponent() numberOfEntries = {}", this.numberOfEntries);
                        slf4jlogger.debug("paintComponent() redTable = {}", new Object[]{this.redTable});
                        slf4jlogger.debug("paintComponent() useVOIFunction = {}", this.useVOIFunction);
                        long l4 = System.currentTimeMillis();
                        this.cachedPreWindowedImage = this.useVOILUTNotFunction ? SingleImagePanel.applyVOILUT((BufferedImage)object8, this.windowCenter, this.windowWidth, this.voiLUTIdentityWindowCenter, this.voiLUTIdentityWindowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit, this.voiLUTNumberOfEntries, this.voiLUTFirstValueMapped, this.voiLUTBitsPerEntry, this.voiLUTData, this.voiLUTEntryMin, this.voiLUTEntryMax, this.voiLUTTopOfEntryRange) : (this.numberOfEntries != 0 && this.redTable != null ? SingleImagePanel.applyWindowCenterAndWidthWithPaletteColor((BufferedImage)object8, this.windowCenter, this.windowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit, this.largestGray, this.bitsPerEntry, this.numberOfEntries, this.redTable, this.greenTable, this.blueTable) : (this.useVOIFunction == 1 ? SingleImagePanel.applyWindowCenterAndWidthLogistic((BufferedImage)object8, this.windowCenter, this.windowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit) : SingleImagePanel.applyWindowCenterAndWidthLinear((BufferedImage)object8, this.windowCenter, this.windowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit, this.useWindowLinearExactCalculationInsteadOfDICOMStandardMethod)));
                        slf4jlogger.debug("paintComponent(): VOI/window applied in {} ms", System.currentTimeMillis() - l4);
                    } else if (n8 == 3) {
                        slf4jlogger.debug("paintComponent(): is 3 component");
                        slf4jlogger.debug("currentVOITransformInUse {}", this.currentVOITransformInUse);
                        if (this.currentVOITransformInUse != -1 && this.voiTransform.getNumberOfTransforms(n2) > this.currentVOITransformInUse) {
                            this.windowWidth = this.voiTransform.getWidth(n2, this.currentVOITransformInUse);
                            this.windowCenter = this.voiTransform.getCenter(n2, this.currentVOITransformInUse);
                            slf4jlogger.debug("For new frame {} using preselected center {} and width {}", n2, this.windowCenter, this.windowWidth);
                        } else {
                            slf4jlogger.debug("For new frame {} using user selected center {} and width {}", n2, this.windowCenter, this.windowWidth);
                        }
                        long l5 = System.currentTimeMillis();
                        this.cachedPreWindowedImage = SingleImagePanel.applyWindowCenterAndWidthLinearToColorImage((BufferedImage)object8, this.windowCenter, this.windowWidth);
                        slf4jlogger.debug("paintComponent(): VOI/window applied in {} ms", System.currentTimeMillis() - l5);
                    } else {
                        slf4jlogger.debug("paintComponent(): Not windowing, getNumComponents() = {}, currentVOITransformInUse = {}, useVOILUTNotFunction = {}", n8, this.currentVOITransformInUse, this.useVOILUTNotFunction);
                        slf4jlogger.debug("paintComponent(): Just using unwindowed useSrcImage as cachedPreWindowedImage={}", object8);
                        this.cachedPreWindowedImage = object8;
                    }
                }
                slf4jlogger.debug("paintComponent() mrj.version={}", System.getProperty("mrj.version"));
                if (this.cachedPreWindowedImage != null && this.useConvertToMostFavorableImageType) {
                    long l6 = System.currentTimeMillis();
                    this.cachedPreWindowedImage = BufferedImageUtilities.convertToMostFavorableImageType(this.cachedPreWindowedImage);
                    slf4jlogger.debug("paintComponent(): converted to most favorable done in {} ms", System.currentTimeMillis() - l6);
                }
            } else {
                slf4jlogger.debug("paintComponent(): using cachedPreWindowedImage");
            }
            long l7 = System.currentTimeMillis();
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.cachedPreWindowedImage != null) {
                slf4jlogger.debug("paintComponent(): same size draw");
                slf4jlogger.debug("paintComponent(): applyShutter = {}", this.applyShutter);
                Shape shape = null;
                if (this.applyShutter && this.displayShutter != null) {
                    double d2;
                    double d3;
                    shape = graphics2D.getClip();
                    if (this.displayShutter.isCircularShutter()) {
                        Point2D point2D = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getCircularShutterTLHC(), null);
                        double d4 = point2D.getX();
                        double d5 = point2D.getY();
                        object6 = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getCircularShutterBRHC(), null);
                        d3 = ((Point2D)object6).getX();
                        d2 = ((Point2D)object6).getY();
                        graphics2D.clip(new Ellipse2D.Double(d4, d5, d3 - d4, d2 - d5));
                    }
                    if (this.displayShutter.isRectangularShutter()) {
                        Point2D point2D = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getRectangularShutterTLHC(), null);
                        double d6 = point2D.getX();
                        double d7 = point2D.getY();
                        object6 = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getRectangularShutterBRHC(), null);
                        d3 = ((Point2D)object6).getX();
                        d2 = ((Point2D)object6).getY();
                        graphics2D.clip(new Rectangle2D.Double(d6, d7, d3 - d6, d2 - d7));
                    }
                    if (this.displayShutter.isPolygonalShutter()) {
                        Point2D[] point2DArray = this.displayShutter.getVerticesOfPolygonalShutterAsPoint2D();
                        Polygon polygon = new Polygon();
                        for (n = 0; n < point2DArray.length; ++n) {
                            Point2D point2D = this.imageToWindowCoordinateTransform.transform(point2DArray[n], null);
                            polygon.addPoint((int)point2D.getX(), (int)point2D.getY());
                        }
                        graphics2D.clip(polygon);
                    }
                }
                graphics2D.drawImage((Image)this.cachedPreWindowedImage, this.offsetDrawingOfResizedSelectedRegionImageX, this.offsetDrawingOfResizedSelectedRegionImageY, this);
                if (shape != null) {
                    graphics2D.setClip(shape);
                }
            }
            slf4jlogger.debug("paintComponent(): draw cachedPreWindowedImage into dst image done in {} ms", System.currentTimeMillis() - l7);
            long l8 = System.currentTimeMillis();
            Color color = Color.red;
            Color color2 = Color.green;
            Color color3 = Color.red;
            Color color4 = Color.green;
            object6 = Color.blue;
            Color color5 = Color.yellow;
            Color color6 = Color.red;
            int n9 = 2;
            Font font = new Font("SansSerif", 1, 14);
            Font font2 = new Font("SansSerif", 1, 10);
            if (this.demographicAndTechniqueAnnotations != null) {
                graphics2D.setColor(this.demographicAndTechniqueColor);
                graphics2D.setFont(this.demographicAndTechniqueFont);
                object5 = this.demographicAndTechniqueAnnotations.iterator(n2);
                while (object5.hasNext()) {
                    TextAnnotationPositioned.drawPositionedString((TextAnnotationPositioned)object5.next(), graphics2D, this, 5, 5);
                }
            }
            graphics2D.setColor(this.orientationColor);
            graphics2D.setFont(this.orientationFont);
            if (this.orientationAnnotations != null) {
                String object42;
                object5 = this.orientationAnnotations.getRowOrientation(n2);
                if (object5 != null && ((String)object5).length() > 0) {
                    TextAnnotationPositioned.drawVerticallyCenteredString((String)object5, this.showOrientationsLeftSide, graphics2D, this, 5);
                }
                if ((object42 = this.orientationAnnotations.getColumnOrientation(n2)) != null && object42.length() > 0) {
                    TextAnnotationPositioned.drawHorizontallyCenteredString(object42, false, graphics2D, this, 5);
                }
            }
            if (this.showZoomFactor) {
                double d8 = Math.abs(this.imageToWindowCoordinateTransform.getScaleX());
                object3 = "1:" + FloatFormatter.toString(d8, Locale.US);
                slf4jlogger.debug("paintComponent(): sZoomFactor = {}", object3);
                TextAnnotationPositioned.drawVerticallyCenteredString((String)object3, this.showZoomFactorLeftSide, graphics2D, this, 2, 5);
                object2 = "[" + FloatFormatter.toString(this.pixelSpacingInSourceImage / d8, Locale.US) + "mm]";
                TextAnnotationPositioned.drawVerticallyCenteredString((String)object2, this.showZoomFactorLeftSide, graphics2D, this, 3, 5);
            }
            if (this.sideAndViewAnnotationString != null) {
                graphics2D.setColor(this.sideAndViewAnnotationColor);
                graphics2D.setFont(this.sideAndViewAnnotationFont);
                TextAnnotationPositioned.drawPositionedString(new TextAnnotationPositioned(this.sideAndViewAnnotationString, this.showSideAndViewAnnotationLeftSide, true, 0), graphics2D, this, this.sideAndViewAnnotationVerticalOffset, 5);
            }
            if (this.persistentDrawingText != null) {
                graphics2D.setColor(color2);
                graphics2D.setFont(font2);
                for (TextAnnotation textAnnotation : this.persistentDrawingText) {
                    object3 = textAnnotation.getAnchorPoint();
                    object2 = this.imageToWindowCoordinateTransform.transform((Point2D)object3, null);
                    String string = textAnnotation.getString();
                    int n3 = 5;
                    int n4 = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
                    DrawingUtilities.drawShadowedString(string, this.showOrientationsLeftSide ? n3 : this.getBounds().width - n3 - n4, (int)((Point2D)object2).getY(), graphics2D);
                }
            }
            slf4jlogger.debug("paintComponent(): draw any graphics");
            graphics2D.transform(this.imageToWindowCoordinateTransform);
            graphics2D.setStroke(new BasicStroke((float)((double)n9 / d)));
            this.activeSuperimposedImagesAppliedToUnderlyingImage.clear();
            if (this.showSuperimposedImages && this.superimposedImages != null) {
                for (SuperimposedImage superimposedImage : this.superimposedImages) {
                    slf4jlogger.debug("paintComponent(): Drawing superimposed image {}", superimposedImage);
                    object3 = superimposedImage.getAppliedToUnderlyingImage(this.imageGeometry, n2);
                    if (object3 == null) continue;
                    slf4jlogger.debug("paintComponent(): Drawing superimposed image applied to underlying image {}", object3);
                    object2 = ((SuperimposedImage.AppliedToUnderlyingImage)object3).getBufferedImage();
                    if (object2 == null) continue;
                    this.activeSuperimposedImagesAppliedToUnderlyingImage.add((SuperimposedImage.AppliedToUnderlyingImage)object3);
                    double d2 = ((SuperimposedImage.AppliedToUnderlyingImage)object3).getRowOrigin();
                    double d3 = ((SuperimposedImage.AppliedToUnderlyingImage)object3).getColumnOrigin();
                    object = null;
                    int n5 = ((BufferedImage)object2).getType();
                    if (n5 == 2) {
                        Object[] objectArray;
                        slf4jlogger.debug("paintComponent(): have ARGB superimposed image so can change color and use transparency");
                        int[] nArray = superimposedImage.getIntegerScaledCIELabPCS();
                        float f = 1.0f;
                        float f2 = 1.0f;
                        float f3 = 0.0f;
                        if (nArray != null) {
                            objectArray = ColorUtilities.getSRGBFromIntegerScaledCIELabPCS(nArray);
                            f = (float)objectArray[0] / 255.0f;
                            f2 = (float)objectArray[1] / 255.0f;
                            f3 = (float)objectArray[2] / 255.0f;
                        }
                        objectArray = new float[]{f, f2, f3, 1.0f};
                        float[] fArray = new float[4];
                        object = new RescaleOp((float[])objectArray, fArray, null);
                    } else {
                        slf4jlogger.info("SingleImagePanel.paintComponent(): not ARGB superimposed image so cannot change color and use transparency");
                    }
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    graphics2D.drawImage((BufferedImage)object2, (BufferedImageOp)object, (int)d3, (int)d2);
                }
            }
            if (this.showOverlays && this.overlay != null && this.overlay.getNumberOfOverlays(n2) > 0) {
                slf4jlogger.debug("paintComponent(): Drawing overlays for frame {}", n2);
                for (int i = 0; i < 16; ++i) {
                    BufferedImage bufferedImage = this.overlay.getOverlayAsBinaryBufferedImage(n2, i);
                    if (bufferedImage == null) continue;
                    slf4jlogger.debug("paintComponent(): Drawing overlay number {}", i);
                    int n6 = this.overlay.getRowOrigin(n2, i);
                    int n7 = this.overlay.getColumnOrigin(n2, i);
                    byte[] byArray = new byte[]{0, 0};
                    byte[] byArray2 = new byte[]{0, 0};
                    byte[] byArray3 = new byte[]{0, 0};
                    IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3, 0);
                    object = new BufferedImage(indexColorModel, bufferedImage.getRaster(), false, null);
                    graphics2D.drawImage((BufferedImage)object, null, n7 + 1, n6 + 1);
                    graphics2D.drawImage(bufferedImage, null, n7, n6);
                }
            }
            if (this.interactiveDrawingShapes != null) {
                slf4jlogger.debug("paintComponent(): Draw interactive shapes:");
                graphics2D.setColor(color);
                Iterator<Shape> iterator = this.interactiveDrawingShapes.iterator();
                while (iterator.hasNext()) {
                    DrawingUtilities.drawShadowedShape(iterator.next(), graphics2D);
                }
            }
            if (this.persistentDrawingShapes != null) {
                slf4jlogger.debug("paintComponent(): Draw persistent shapes:");
                graphics2D.setColor(color2);
                Iterator<Shape> iterator = this.persistentDrawingShapes.iterator();
                while (iterator.hasNext()) {
                    DrawingUtilities.drawShadowedShape(iterator.next(), graphics2D);
                }
            }
            if (this.selectedDrawingShapes != null) {
                slf4jlogger.debug("paintComponent(): Draw selected shapes:");
                graphics2D.setColor(color3);
                Iterator<Shape> iterator = this.selectedDrawingShapes.iterator();
                while (iterator.hasNext()) {
                    DrawingUtilities.drawShadowedShape(iterator.next(), graphics2D);
                }
            }
            if (this.volumeLocalizationShapes != null) {
                slf4jlogger.debug("paintComponent(): draw volume localization shapes");
                graphics2D.setColor((Color)object6);
                Iterator<Shape> iterator = this.volumeLocalizationShapes.iterator();
                while (iterator.hasNext()) {
                    DrawingUtilities.drawShadowedShape(iterator.next(), graphics2D);
                }
            }
            if (this.localizerShapes != null) {
                slf4jlogger.debug("paintComponent(): draw localizer shapes");
                graphics2D.setColor(color4);
                Iterator<Shape> iterator = this.localizerShapes.iterator();
                while (iterator.hasNext()) {
                    DrawingUtilities.drawShadowedShape(iterator.next(), graphics2D);
                }
            }
            if (this.preDefinedShapes != null) {
                slf4jlogger.debug("paintComponent(): draw pre-defined shapes");
                graphics2D.setColor(color5);
                Iterator<Shape> iterator = this.preDefinedShapes.iterator();
                while (iterator.hasNext()) {
                    DrawingUtilities.drawShadowedShape(iterator.next(), graphics2D);
                }
            }
            if (this.perFrameDrawingShapes != null && this.perFrameDrawingShapes.length > this.currentSrcImageIndex && this.perFrameDrawingShapes[this.currentSrcImageIndex] != null) {
                slf4jlogger.debug("paintComponent(): draw per-frame shapes");
                Vector<Shape> vector = this.perFrameDrawingShapes[this.currentSrcImageIndex];
                graphics2D.setColor(color6);
                Iterator<Shape> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    graphics2D.draw(iterator.next());
                }
            }
            if (this.preDefinedText != null) {
                graphics2D.setColor(color5);
                graphics2D.setFont(font);
                for (TextAnnotation textAnnotation : this.preDefinedText) {
                    DrawingUtilities.drawShadowedString(textAnnotation.getString(), textAnnotation.getAnchorPointXAsInt(), textAnnotation.getAnchorPointYAsInt(), graphics2D);
                }
            }
            slf4jlogger.debug("paintComponent(): draw annotations done in {} ms", System.currentTimeMillis() - l8);
        } else {
            this.getGraphics().clearRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        this.setCursor(cursor);
        slf4jlogger.debug("paintComponent() elapsed: {} ms", System.currentTimeMillis() - l);
        slf4jlogger.debug("paintComponent(): end");
    }

    public static void main(String[] stringArray) {
        block3: {
            try {
                if (stringArray.length != 1) break block3;
                JFrame jFrame = new JFrame();
                SourceImage sourceImage = new SourceImage(stringArray[0]);
                if (sourceImage.isImage()) {
                    jFrame.add(new SingleImagePanel(sourceImage));
                    jFrame.setBackground(Color.BLACK);
                    jFrame.setSize(512, 512);
                    jFrame.setVisible(true);
                    break block3;
                }
                throw new DicomException("Is not an image or is not an image that can be displayed");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }

    class OurApplyShutterChangeListener
    extends SelfRegisteringListener {
        public OurApplyShutterChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.ApplyShutterChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            ApplyShutterChangeEvent applyShutterChangeEvent = (ApplyShutterChangeEvent)event;
            SingleImagePanel.this.setApplyShutter(applyShutterChangeEvent.applyShutter());
            SingleImagePanel.this.dirtyWindowing();
            SingleImagePanel.this.repaint();
        }
    }

    class OurGraphicDisplayChangeListener
    extends SelfRegisteringListener {
        public OurGraphicDisplayChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.GraphicDisplayChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            GraphicDisplayChangeEvent graphicDisplayChangeEvent = (GraphicDisplayChangeEvent)event;
            SingleImagePanel.this.setShowOverlays(graphicDisplayChangeEvent.showOverlays());
            SingleImagePanel.this.dirtyWindowing();
            SingleImagePanel.this.repaint();
        }
    }

    class OurWindowingAccelerationValueChangeListener
    extends SelfRegisteringListener {
        public OurWindowingAccelerationValueChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.WindowingAccelerationValueChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            WindowingAccelerationValueChangeEvent windowingAccelerationValueChangeEvent = (WindowingAccelerationValueChangeEvent)event;
            SingleImagePanel.this.setWindowingAccelerationValue(windowingAccelerationValueChangeEvent.getValue());
            SingleImagePanel.this.dirtyWindowing();
            SingleImagePanel.this.repaint();
        }
    }

    class OurWindowLinearCalculationChangeListener
    extends SelfRegisteringListener {
        public OurWindowLinearCalculationChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.WindowLinearCalculationChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            WindowLinearCalculationChangeEvent windowLinearCalculationChangeEvent = (WindowLinearCalculationChangeEvent)event;
            if (windowLinearCalculationChangeEvent.isExactCalculation()) {
                SingleImagePanel.this.setWindowLinearCalculationToExact();
            } else if (windowLinearCalculationChangeEvent.isDicomCalculation()) {
                SingleImagePanel.this.setWindowLinearCalculationToDicom();
            }
            SingleImagePanel.this.dirtyWindowing();
            SingleImagePanel.this.repaint();
        }
    }

    class OurVOIFunctionChangeListener
    extends SelfRegisteringListener {
        public OurVOIFunctionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.VOIFunctionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            VOIFunctionChangeEvent vOIFunctionChangeEvent = (VOIFunctionChangeEvent)event;
            if (vOIFunctionChangeEvent.isLinearFunction()) {
                SingleImagePanel.this.setVOIFunctionToLinear();
            } else if (vOIFunctionChangeEvent.isLogisticFunction()) {
                SingleImagePanel.this.setVOIFunctionToLogistic();
            }
            SingleImagePanel.this.dirtyWindowing();
            SingleImagePanel.this.repaint();
        }
    }

    class OurFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            int[] nArray = frameSortOrderChangeEvent.getSortOrder();
            int n = frameSortOrderChangeEvent.getIndex();
            if (SingleImagePanel.this.currentSrcImageIndex != n || SingleImagePanel.this.currentSrcImageSortOrder != nArray || !Arrays.equals(SingleImagePanel.this.currentSrcImageSortOrder, nArray)) {
                SingleImagePanel.this.currentSrcImageIndex = n;
                SingleImagePanel.this.currentSrcImageSortOrder = nArray;
                SingleImagePanel.this.dirtySource();
                SingleImagePanel.this.repaint();
            }
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            int n = frameSelectionChangeEvent.getIndex();
            if (SingleImagePanel.this.currentSrcImageIndex != n) {
                SingleImagePanel.this.currentSrcImageIndex = n;
                SingleImagePanel.this.dirtySource();
                SingleImagePanel.this.repaint();
                SingleImagePanel.this.updateStatusBarValues(SingleImagePanel.this.currentx, SingleImagePanel.this.currenty);
            }
        }
    }

    class OurWindowCenterAndWidthChangeListener
    extends SelfRegisteringListener {
        public OurWindowCenterAndWidthChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.WindowCenterAndWidthChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            WindowCenterAndWidthChangeEvent windowCenterAndWidthChangeEvent = (WindowCenterAndWidthChangeEvent)event;
            double d = windowCenterAndWidthChangeEvent.getWindowCenter();
            double d2 = windowCenterAndWidthChangeEvent.getWindowWidth();
            if (SingleImagePanel.this.windowCenter != d || SingleImagePanel.this.windowWidth != d2) {
                SingleImagePanel.this.windowCenter = d;
                SingleImagePanel.this.windowWidth = d2;
                SingleImagePanel.this.cachedPreWindowedImage = null;
                SingleImagePanel.this.currentVOITransformInUse = -1;
                SingleImagePanel.this.repaint();
            }
        }
    }

    protected class LeftMouseMode {
        public static final int WINDOWING = 1;
        public static final int PANNING = 2;
        protected int mode = 1;

        LeftMouseMode() {
            SingleImagePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void setWindowing() {
            this.mode = 1;
            SingleImagePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void setPanning() {
            this.mode = 2;
            SingleImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public boolean isWindowing() {
            return this.mode == 1;
        }

        public boolean isPanning() {
            return this.mode == 2;
        }
    }
}

