/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SourceImage;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Arrays;

public class SuperimposedImage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SuperimposedImage.java,v 1.18 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SuperimposedImage.class);
    public static final double DEFAULT_CLOSEST_SLICE_TOLERANCE_DISTANCE = 0.125;
    protected SourceImage superimposedSourceImage;
    protected GeometryOfVolume superimposedGeometry;
    protected int[] cieLabScaled;

    public static boolean isSliceCloseEnoughToSuperimpose(GeometryOfSlice geometryOfSlice, GeometryOfSlice geometryOfSlice2, double d) {
        boolean bl;
        double d2;
        double d3 = geometryOfSlice.getDistanceAlongNormalFromOrigin();
        double d4 = d3 - (d2 = geometryOfSlice2.getDistanceAlongNormalFromOrigin());
        double d5 = Math.abs(d4);
        boolean bl2 = bl = d5 <= d;
        if (bl) {
            slf4jlogger.info("isSliceCloseEnoughToSuperimpose(): distance along normal superimposed = {} underlying = {} difference = {} toleranceDistance = {} is close enough", d3, d2, d5, d);
        }
        return bl;
    }

    public static boolean isSliceCloseEnoughToSuperimpose(GeometryOfSlice geometryOfSlice, GeometryOfSlice geometryOfSlice2) {
        return SuperimposedImage.isSliceCloseEnoughToSuperimpose(geometryOfSlice, geometryOfSlice2, 0.125);
    }

    protected SuperimposedImage() {
        this.superimposedSourceImage = null;
        this.superimposedGeometry = null;
    }

    public AppliedToUnderlyingImage getAppliedToUnderlyingImage(GeometryOfVolume geometryOfVolume, int n, double d) {
        return new AppliedToUnderlyingImage(geometryOfVolume, n, d);
    }

    public AppliedToUnderlyingImage getAppliedToUnderlyingImage(GeometryOfVolume geometryOfVolume, int n) {
        return new AppliedToUnderlyingImage(geometryOfVolume, n, 0.125);
    }

    public int[] getIntegerScaledCIELabPCS() {
        return this.cieLabScaled;
    }

    public SuperimposedImage(SourceImage sourceImage, GeometryOfVolume geometryOfVolume, int[] nArray) {
        this.superimposedSourceImage = sourceImage;
        this.superimposedGeometry = geometryOfVolume;
        this.cieLabScaled = nArray;
    }

    public SuperimposedImage(SourceImage sourceImage, GeometryOfVolume geometryOfVolume) {
        this(sourceImage, geometryOfVolume, null);
    }

    public class AppliedToUnderlyingImage {
        private BufferedImage bufferedImage = null;
        private double columnOrigin = 0.0;
        private double rowOrigin = 0.0;
        private GeometryOfSlice geometryOfSuperimposedSlice = null;

        public BufferedImage getBufferedImage() {
            return this.bufferedImage;
        }

        public double getColumnOrigin() {
            return this.columnOrigin;
        }

        public double getRowOrigin() {
            return this.rowOrigin;
        }

        private AppliedToUnderlyingImage(GeometryOfVolume geometryOfVolume, int n, double d) {
            if (geometryOfVolume != null) {
                GeometryOfSlice geometryOfSlice = geometryOfVolume.getGeometryOfSlice(n);
                if (geometryOfSlice != null && SuperimposedImage.this.superimposedGeometry != null) {
                    double[] dArray;
                    double[] dArray2;
                    int n2 = SuperimposedImage.this.superimposedGeometry.findClosestSliceInSamePlane(geometryOfSlice);
                    this.geometryOfSuperimposedSlice = SuperimposedImage.this.superimposedGeometry.getGeometryOfSlice(n2);
                    if (SuperimposedImage.isSliceCloseEnoughToSuperimpose(this.geometryOfSuperimposedSlice, geometryOfSlice, d) && (dArray2 = this.geometryOfSuperimposedSlice.getTLHCArray()) != null && dArray2.length == 3 && (dArray = geometryOfSlice.lookupImageCoordinate(dArray2)) != null && dArray.length == 2) {
                        BufferedImage bufferedImage;
                        this.columnOrigin = dArray[0];
                        this.rowOrigin = dArray[1];
                        if (SuperimposedImage.this.superimposedSourceImage != null && (bufferedImage = SuperimposedImage.this.superimposedSourceImage.getBufferedImage(n2)) != null) {
                            double[] dArray3 = geometryOfSlice.getVoxelSpacingArray();
                            double[] dArray4 = this.geometryOfSuperimposedSlice.getVoxelSpacingArray();
                            double d2 = dArray4[0] / dArray3[0];
                            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.columnOrigin, this.rowOrigin);
                            affineTransform.concatenate(AffineTransform.getScaleInstance(d2, d2));
                            this.bufferedImage = new BufferedImage((int)Math.ceil((double)bufferedImage.getWidth() * d2 + this.columnOrigin), (int)Math.ceil((double)bufferedImage.getHeight() * d2 + this.rowOrigin), 2);
                            Graphics2D graphics2D = this.bufferedImage.createGraphics();
                            graphics2D.transform(affineTransform);
                            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                            ColorModel colorModel = this.bufferedImage.getColorModel();
                            for (int i = 0; i < this.bufferedImage.getHeight(); ++i) {
                                for (int j = 0; j < this.bufferedImage.getWidth(); ++j) {
                                    int n3 = this.bufferedImage.getRGB(j, i);
                                    if (colorModel.getRed(n3) != 0 || colorModel.getGreen(n3) != 0 || colorModel.getBlue(n3) != 0) continue;
                                    this.bufferedImage.setRGB(j, i, 0);
                                }
                            }
                            this.columnOrigin = 0.0;
                            this.rowOrigin = 0.0;
                        }
                    }
                } else {
                    slf4jlogger.error("AppliedToUnderlyingImage(): missing geometryOfUnderlyingSlice or superimposedGeometry");
                }
            } else {
                slf4jlogger.error("SuperimposedImage.AppliedToUnderlyingImage(): missing underlyingGeometry");
            }
        }

        public String toString() {
            return "(bufferedImage=" + (this.bufferedImage == null ? "null" : this.bufferedImage.toString()) + ",columnOrigin=" + this.columnOrigin + ",rowOrigin=" + this.rowOrigin + ")";
        }

        public void notificationOfCurrentLocationIn3DSpace(double[] dArray) {
            int n;
            int n2;
            int n3;
            double[] dArray2 = this.geometryOfSuperimposedSlice.lookupImageCoordinate(dArray);
            if (this.bufferedImage != null && (n3 = this.bufferedImage.getRGB(n2 = (int)dArray2[0], n = (int)dArray2[1])) != 0) {
                slf4jlogger.info("AppliedToUnderlyingImage.notificationOfCurrentLocationIn3DSpace(): Hit on non-zero at 3D ({}) at 2D ({},{})", Arrays.toString(dArray), n2, n);
            }
        }
    }
}

