/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class WindowCenterAndWidth {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/WindowCenterAndWidth.java,v 1.30 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(WindowCenterAndWidth.class);

    protected static void applyPaddingValueRangeToLUT(byte[] byArray, int n, int n2, int n3) {
        int n4 = n & n3;
        int n5 = n2 & n3;
        int n6 = n4 <= n5 ? 1 : -1;
        for (int i = n4; i != n5; i += n6) {
            slf4jlogger.trace("applyPaddingValueRangeToLUT(): LUT index set to zero for pad in range {}", i);
            byArray[i] = 0;
        }
        byArray[n5] = 0;
        slf4jlogger.trace("applyPaddingValueRangeToLUT(): LUT index set to zero for pad in range {}", n5);
    }

    public static final BufferedImage applyWindowCenterAndWidthLogistic(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLogistic(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n);
    }

    public static final BufferedImage applyWindowCenterAndWidthLogistic(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        slf4jlogger.debug("applyWindowCenterAndWidthLogistic(): center={} width={}", d, d2);
        int n6 = 0;
        int n7 = 255;
        byte[] byArray = null;
        int n8 = bufferedImage.getSampleModel().getDataType();
        slf4jlogger.debug("applyWindowCenterAndWidthLogistic(): Data type {}", n8);
        if (n8 == 2 || n8 == 1) {
            slf4jlogger.debug("applyWindowCenterAndWidthLogistic(): Data type is short or ushort and signed is {}", bl);
            n5 = bl ? Short.MIN_VALUE : 0;
            n4 = bl ? 32768 : 65536;
            byArray = new byte[65536];
            n3 = 65535;
        } else if (n8 == 0) {
            slf4jlogger.debug("applyWindowCenterAndWidthLogistic(): Data type is byte and signed is {}", bl);
            n5 = bl ? -128 : 0;
            n4 = bl ? 128 : 256;
            byArray = new byte[256];
            n3 = 255;
        } else {
            throw new IllegalArgumentException();
        }
        int n9 = n7 - n6;
        for (int i = n5; i < n4; ++i) {
            double d5 = (double)i * d3 + d4;
            double d6 = (double)n9 / (1.0 + Math.exp(-4.0 * (d5 - d) / d2)) + (double)n6 + 0.5;
            if (d6 < (double)n6) {
                d6 = n6;
            } else if (d6 > (double)n7) {
                d6 = n7;
            }
            if (bl2) {
                d6 = (byte)((double)n7 - d6);
            }
            byArray[i & n3] = (byte)d6;
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, n3);
        }
        LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        BufferedImage bufferedImage2 = lookupOp.filter(bufferedImage, lookupOp.createCompatibleDestImage(bufferedImage, componentColorModel));
        return bufferedImage2;
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2, false);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, boolean bl4) {
        BufferedImage bufferedImage2;
        block14: {
            DataBuffer dataBuffer;
            SampleModel sampleModel;
            int n3;
            int n4;
            int n5;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            byte by;
            byte by2;
            int n6;
            int n7;
            block15: {
                ComponentColorModel componentColorModel;
                block13: {
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): center={} width={}", d, d2);
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): useExactCalculationInsteadOfDICOMStandardMethod={}", bl4);
                    n7 = 0;
                    n6 = 255;
                    by2 = (byte)n7;
                    by = (byte)n6;
                    d9 = n6 - n7;
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): yrange={}", d9);
                    d8 = bl4 ? d : d - 0.5;
                    d7 = bl4 ? d2 : d2 - 1.0;
                    double d10 = d7 / 2.0;
                    d6 = d8 - d10;
                    d5 = d8 + d10;
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): cmp5={}", d8);
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): wm1={}", d7);
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): halfwm1={}", d10);
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): bottom={}", d6);
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): top={}", d5);
                    int n8 = 0;
                    int n9 = 0;
                    byte[] byArray = null;
                    int n10 = 0;
                    boolean bl5 = true;
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): bottom={} top={}", d6, d5);
                    int n11 = bufferedImage.getSampleModel().getDataType();
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): Data type {}", n11);
                    if (n11 == 2 || n11 == 1) {
                        slf4jlogger.debug("applyWindowCenterAndWidthLinear(): Data type is short or ushort and signed is {}", bl);
                        n8 = bl ? Short.MIN_VALUE : 0;
                        n9 = bl ? 32768 : 65536;
                        byArray = new byte[65536];
                        n10 = 65535;
                    } else if (n11 == 0) {
                        slf4jlogger.debug("applyWindowCenterAndWidthLinear(): Data type is byte and signed is {}", bl);
                        n8 = bl ? -128 : 0;
                        n9 = bl ? 128 : 256;
                        byArray = new byte[256];
                        n10 = 255;
                    } else if (n11 == 4 || n11 == 5) {
                        slf4jlogger.debug("applyWindowCenterAndWidthLinear(): Data type is float or double");
                        bl5 = false;
                    } else {
                        throw new IllegalArgumentException();
                    }
                    componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
                    bufferedImage2 = null;
                    if (!bl5) break block13;
                    for (int i = n8; i < n9; ++i) {
                        double d11 = (double)i * d3 + d4;
                        byte by3 = d11 <= d6 ? by2 : (d11 > d5 ? by : (byte)(((d11 - d8) / d7 + 0.5) * d9 + (double)n7));
                        if (bl2) {
                            by3 = (byte)(n6 - by3);
                        }
                        byArray[i & n10] = by3;
                    }
                    if (bl3) {
                        WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, n10);
                    }
                    LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
                    bufferedImage2 = lookupOp.filter(bufferedImage, lookupOp.createCompatibleDestImage(bufferedImage, componentColorModel));
                    slf4jlogger.debug("applyWindowCenterAndWidthLinear(): BufferedImage out of LookupOp{}", bufferedImage2);
                    break block14;
                }
                n5 = bufferedImage.getWidth();
                n4 = bufferedImage.getHeight();
                n3 = n5 * n4;
                ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n5, n4, 1, n5, new int[]{0});
                DataBufferByte dataBufferByte = new DataBufferByte(n3);
                WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
                bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, true, null);
                byte[] byArray = dataBufferByte.getData();
                sampleModel = bufferedImage.getSampleModel();
                WritableRaster writableRaster2 = bufferedImage.getRaster();
                dataBuffer = writableRaster2.getDataBuffer();
                if (!(dataBuffer instanceof DataBufferDouble)) break block15;
                slf4jlogger.debug("applyWindowCenterAndWidthLinear(): per pixel with DataBufferDouble");
                double[] dArray = null;
                dArray = sampleModel.getPixels(0, 0, n5, n4, dArray, dataBuffer);
                for (int i = 0; i < n3; ++i) {
                    double d12 = dArray[i];
                    double d13 = d12 * d3 + d4;
                    byte by4 = d13 <= d6 ? by2 : (d13 > d5 ? by : (byte)(((d13 - d8) / d7 + 0.5) * d9 + (double)n7));
                    if (bl2) {
                        by4 = (byte)(n6 - by4);
                    }
                    byArray[i] = by4;
                }
                break block14;
            }
            if (!(dataBuffer instanceof DataBufferFloat)) break block14;
            slf4jlogger.debug("applyWindowCenterAndWidthLinear(): per pixel with DataBufferFloat");
            float[] fArray = null;
            fArray = sampleModel.getPixels(0, 0, n5, n4, fArray, dataBuffer);
            for (int i = 0; i < n3; ++i) {
                float f = fArray[i];
                double d14 = (double)f * d3 + d4;
                byte by5 = d14 <= d6 ? by2 : (d14 > d5 ? by : (byte)(((d14 - d8) / d7 + 0.5) * d9 + (double)n7));
                if (bl2) {
                    by5 = (byte)(n6 - by5);
                }
                byArray[i] = by5;
            }
        }
        return bufferedImage2;
    }

    public static final BufferedImage applyWindowCenterAndWidthWithPaletteColor(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, int n3, int n4, short[] sArray, short[] sArray2, short[] sArray3) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n, n2, n3, n4, sArray, sArray2, sArray3);
    }

    public static final BufferedImage applyWindowCenterAndWidthWithPaletteColor(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, short[] sArray2, short[] sArray3) {
        int n6;
        int n7;
        int n8;
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor center={} width={}", d, d2);
        int n9 = 0;
        int n10 = 255;
        byte by = (byte)n9;
        byte by2 = (byte)n10;
        double d5 = n10 - n9;
        double d6 = d - 0.5;
        double d7 = d2 - 1.0;
        double d8 = d7 / 2.0;
        double d9 = d6 - d8;
        double d10 = d6 + d8;
        int n11 = bl ? Short.MIN_VALUE : 0;
        int n12 = bl ? 32768 : 65536;
        byte[] byArray = new byte[65536];
        byte[] byArray2 = new byte[65536];
        byte[] byArray3 = new byte[65536];
        for (n8 = n11; n8 < n12; ++n8) {
            double d11 = (double)n8 * d3 + d4;
            byte by3 = d11 <= d9 ? by : (d11 > d10 ? by2 : (byte)(((d11 - d6) / d7 + 0.5) * d5 + (double)n9));
            if (bl2) {
                by3 = (byte)(n10 - by3);
            }
            byArray[n8 & 0xFFFF] = by3;
            byArray2[n8 & 0xFFFF] = by3;
            byArray3[n8 & 0xFFFF] = by3;
        }
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor(): numberOfEntries = {}", n5);
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor(): redTable.length = {}", sArray.length);
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor(): greenTable.length = {}", sArray2.length);
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor(): blueTable.length = {}", sArray3.length);
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor(): largestGray={}", n3);
        if (n4 <= 8) {
            slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor: LUTs contain 8 bits packed in 16");
            n7 = (n5 - 1) / 2 + 1;
            slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor: half the numberOfEntries rounded = {}", n7);
            if (n7 > sArray.length) {
                slf4jlogger.info("WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor: truncating half the numberOfEntries {} to the actual array size {}", n7, sArray.length);
                n7 = sArray.length;
            }
            n6 = n3 + 1;
            for (n8 = 0; n8 < n7; ++n8) {
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: xi=" + n6 + " i={}", n8);
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: redTable[i]&0xff={}", Integer.toHexString(sArray[n8] & 0xFF));
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: redTable[i]>>8={}", Integer.toHexString(sArray[n8] >> 8 & 0xFF));
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: greenTable[i]&0xff={}", Integer.toHexString(sArray2[n8] & 0xFF));
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: greenTable[i]>>8={}", Integer.toHexString(sArray2[n8] >> 8 & 0xFF));
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: blueTable[i]&0xff={}", Integer.toHexString(sArray3[n8] & 0xFF));
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: blueTable[i]>>8={}", Integer.toHexString(sArray3[n8] >> 8 & 0xFF));
                byArray[n6 & 0xFFFF] = (byte)sArray[n8];
                byArray2[n6 & 0xFFFF] = (byte)sArray2[n8];
                byArray3[n6 & 0xFFFF] = (byte)sArray3[n8];
                byArray[++n6 & 0xFFFF] = (byte)(sArray[n8] >> 8);
                byArray2[n6 & 0xFFFF] = (byte)(sArray2[n8] >> 8);
                byArray3[n6 & 0xFFFF] = (byte)(sArray3[n8] >> 8);
                ++n6;
            }
        } else {
            slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor: LUTs contain 16 bit entries");
            n8 = n4 - 8;
            n7 = n3 + 1;
            for (n6 = 0; n6 < n5; ++n6) {
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: xi=" + n7 + " i={}", n6);
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: redTable[i]={}", sArray[n6]);
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: redTable[i]>>shiftRight={}", sArray[n6] >> n8);
                slf4jlogger.trace("applyWindowCenterAndWidthWithPaletteColor: redTable[i]>>shiftRight={}", Integer.toHexString(sArray[n6] >> n8 & 0xFF));
                byArray[n7 & 0xFFFF] = (byte)(sArray[n6] >> n8);
                byArray2[n7 & 0xFFFF] = (byte)(sArray2[n6] >> n8);
                byArray3[n7 & 0xFFFF] = (byte)(sArray3[n6] >> n8);
                ++n7;
            }
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, 65535);
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray2, n, n2, 65535);
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray3, n, n2, 65535);
        }
        n8 = bufferedImage.getWidth();
        n6 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n13 = writableRaster.getNumBands();
        ColorModel colorModel = BufferedImageUtilities.getMostFavorableColorModel();
        if (colorModel == null) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        }
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(n8, n6);
        DataBuffer dataBuffer2 = writableRaster2.getDataBuffer();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
        SampleModel sampleModel2 = bufferedImage2.getSampleModel();
        int n14 = writableRaster2.getNumBands();
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n8, n6, nArray, dataBuffer);
        int n15 = nArray.length;
        int[] nArray2 = null;
        nArray2 = sampleModel2.getPixels(0, 0, n8, n6, nArray2, dataBuffer2);
        int n16 = nArray2.length;
        slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor: dstNumBands = {}", n14);
        if (n13 == 1 && n14 == 4 && n15 * 4 == n16) {
            slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor: converting gray to RGBA");
            int n17 = 0;
            for (int i = 0; i < n15; ++i) {
                nArray2[n17++] = byArray[nArray[i]];
                nArray2[n17++] = byArray2[nArray[i]];
                nArray2[n17++] = byArray3[nArray[i]];
                nArray2[n17++] = -1;
            }
            sampleModel2.setPixels(0, 0, n8, n6, nArray2, dataBuffer2);
        } else if (n13 == 1 && n14 == 3 && n15 * 3 == n16) {
            slf4jlogger.debug("applyWindowCenterAndWidthWithPaletteColor: converting gray to RGB");
            int n18 = 0;
            for (int i = 0; i < n15; ++i) {
                nArray2[n18++] = byArray[nArray[i]];
                nArray2[n18++] = byArray2[nArray[i]];
                nArray2[n18++] = byArray3[nArray[i]];
            }
            sampleModel2.setPixels(0, 0, n8, n6, nArray2, dataBuffer2);
        }
        return bufferedImage2;
    }

    public static final BufferedImage applyWindowCenterAndWidthLinearToColorImage(BufferedImage bufferedImage, double d, double d2) {
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): center={} width={}", d, d2);
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): BufferedImage src{}", bufferedImage);
        int n = 0;
        int n2 = 255;
        byte by = (byte)n;
        byte by2 = (byte)n2;
        double d3 = n2 - n;
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): yrange={}", d3);
        double d4 = d - 0.5;
        double d5 = d2 - 1.0;
        double d6 = d5 / 2.0;
        double d7 = d4 - d6;
        double d8 = d4 + d6;
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): cmp5={}", d4);
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): wm1={}", d5);
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): halfwm1={}", d6);
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): bottom={}", d7);
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): top={}", d8);
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        int n5 = 0;
        slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): bottom={} top={}", d7, d8);
        boolean bl = true;
        int n6 = bufferedImage.getSampleModel().getDataType();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): Unsupported colorModel " + colorModel.getClass() + ", so doing nothing");
            bl = false;
        } else {
            slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): Data type {}", n6);
            if (n6 == 2 || n6 == 1) {
                slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): Data type is short or ushort");
                n3 = 0;
                n4 = 65536;
                byArray = new byte[65536];
                n5 = 65535;
            } else if (n6 == 0) {
                slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): Data type is byte");
                n3 = 0;
                n4 = 256;
                byArray = new byte[256];
                n5 = 255;
            } else {
                slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): Unsupported data type is " + n6 + ", so doing nothing");
                bl = false;
            }
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            for (int i = n3; i < n4; ++i) {
                double d9 = i;
                byte by3 = d9 <= d7 ? by : (d9 > d8 ? by2 : (byte)(((d9 - d4) / d5 + 0.5) * d3 + (double)n));
                byArray[i & n5] = by3;
            }
            LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
            if (n6 == 0) {
                slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): 8 bit so using lookup.createCompatibleDestImage (src)");
                bufferedImage2 = lookupOp.createCompatibleDestImage(bufferedImage, null);
            } else {
                slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): 16 bit so manually creating an 8 bit dst image");
                int n7 = bufferedImage.getWidth();
                int n8 = bufferedImage.getHeight();
                bufferedImage2 = SourceImage.createPixelInterleavedByteThreeComponentColorImage(n7, n8, new byte[n7 * n8 * 3], 0, bufferedImage.getColorModel().getColorSpace(), false);
                slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): BufferedImage dst for LookupOp {}", bufferedImage2);
            }
            bufferedImage2 = lookupOp.filter(bufferedImage, bufferedImage2);
            slf4jlogger.debug("applyWindowCenterAndWidthLinearToColorImage(): BufferedImage out of LookupOp {}", bufferedImage2);
        }
        return bufferedImage2;
    }

    public static final BufferedImage applyVOILUT(BufferedImage bufferedImage, double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, double d6, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        slf4jlogger.debug("applyVOILUT(): firstValueMapped={}", n4);
        slf4jlogger.debug("applyVOILUT center={} width={}", d, d2);
        int n12 = 0;
        int n13 = 255;
        double d7 = n13 - n12;
        int n14 = 0;
        double d8 = n8 - n14;
        slf4jlogger.debug("applyVOILUT(): bottomOfEntryRange={} topOfEntryRange={} entryRange={}", n14, n8, d8);
        int n15 = sArray[0] & 0xFFFF;
        int n16 = sArray[n3 - 1] & 0xFFFF;
        slf4jlogger.debug("applyVOILUT(): firstLUTValue={} lastLUTValue={}", n15, n16);
        byte by = (byte)((double)(n15 - n14) / d8 * d7 + (double)n12);
        byte by2 = (byte)((double)(n16 - n14) / d8 * d7 + (double)n12);
        slf4jlogger.debug("applyVOILUT(): bymin={} bymax={}", by & 0xFF, by2 & 0xFF);
        byte[] byArray = null;
        int n17 = bufferedImage.getSampleModel().getDataType();
        slf4jlogger.debug("applyVOILUT(): Data type {}", n17);
        if (n17 == 2 || n17 == 1) {
            slf4jlogger.debug("applyVOILUT(): Data type is short or ushort and signed is {}", bl);
            n11 = bl ? Short.MIN_VALUE : 0;
            n10 = bl ? 32768 : 65536;
            byArray = new byte[65536];
            n9 = 65535;
        } else if (n17 == 0) {
            slf4jlogger.debug("applyVOILUT(): Data type is byte and signed is {}", bl);
            n11 = bl ? -128 : 0;
            n10 = bl ? 128 : 256;
            byArray = new byte[256];
            n9 = 255;
        } else {
            throw new IllegalArgumentException();
        }
        for (int i = n11; i < n10; ++i) {
            double d9 = (double)i * d5 + d6;
            int n18 = (int)((d9 - d) / d2 * d4 + d3 - (double)n4);
            byte by3 = n18 < 0 ? by : (n18 > n3 - 1 ? by2 : (byte)((double)(sArray[n18] & 0xFFFF) / d8 * d7 + (double)n12));
            if (bl2) {
                by3 = (byte)(n13 - by3);
            }
            byArray[i & n9] = by3;
        }
        if (bl3) {
            WindowCenterAndWidth.applyPaddingValueRangeToLUT(byArray, n, n2, n9);
        }
        LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, byArray), null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        BufferedImage bufferedImage2 = lookupOp.filter(bufferedImage, lookupOp.createCompatibleDestImage(bufferedImage, componentColorModel));
        slf4jlogger.debug("applyVOILUT(): BufferedImage out of LookupOp{}", bufferedImage2);
        return bufferedImage2;
    }
}

