/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.displaywave;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.displaywave.SourceECG;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;

public class DicomSourceECG
extends SourceECG {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/displaywave/DicomSourceECG.java,v 1.17 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceECG.class);
    private String[] labelsForChannelsExtractedFromCodes;
    private static final String[] scpCodesForLeads = new String[]{"5.6.3-9-1", "5.6.3-9-2", "5.6.3-9-61", "5.6.3-9-62", "5.6.3-9-63", "5.6.3-9-64", "5.6.3-9-3", "5.6.3-9-4", "5.6.3-9-5", "5.6.3-9-6", "5.6.3-9-7", "5.6.3-9-8"};
    private static final String[] labelForSCPCodesForLeads = new String[]{"I", "II", "III", "aVR", "aVL", "aVF", "V1", "V2", "V3", "V4", "V5", "V6"};

    private String getOurLabelForLeadCode(CodedSequenceItem codedSequenceItem) {
        String string = codedSequenceItem.getCodeValue();
        String string2 = codedSequenceItem.getCodingSchemeDesignator();
        if (string2 != null && string2.equals("SCPECG") && string != null) {
            for (int i = 0; i < scpCodesForLeads.length; ++i) {
                if (!string.equals(scpCodesForLeads[i])) continue;
                return labelForSCPCodesForLeads[i];
            }
        }
        return null;
    }

    private void keepTrackOfLeadLabelsForBuildingDisplaySequence(String string, int n) {
        if (this.labelsForChannelsExtractedFromCodes == null) {
            this.labelsForChannelsExtractedFromCodes = new String[this.numberOfChannels];
        }
        this.labelsForChannelsExtractedFromCodes[n] = string;
    }

    private static String buildInstanceTitle(AttributeList attributeList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber));
        stringBuffer.append(":");
        return stringBuffer.toString();
    }

    public DicomSourceECG(BinaryInputStream binaryInputStream) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(binaryInputStream));
        if (attributeList.get(TagFromName.WaveformSequence) != null) {
            this.constructSourceECG(attributeList);
        }
    }

    public DicomSourceECG(DicomInputStream dicomInputStream) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream);
        if (attributeList.get(TagFromName.WaveformSequence) != null) {
            this.constructSourceECG(attributeList);
        }
    }

    public DicomSourceECG(AttributeList attributeList) throws DicomException {
        if (attributeList.get(TagFromName.WaveformSequence) != null) {
            this.constructSourceECG(attributeList);
        }
    }

    private void constructSourceECG(AttributeList attributeList) throws DicomException {
        int n;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.WaveformSequence);
        if (sequenceAttribute != null && (n = sequenceAttribute.getNumberOfItems()) >= 1) {
            AttributeList attributeList2;
            SequenceItem sequenceItem;
            if (n > 1) {
                slf4jlogger.warn("constructSourceECG(): using only the first Multiplex Groups - ignoring the rest (there are {})", n);
            }
            if ((sequenceItem = sequenceAttribute.getItem(0)) != null && (attributeList2 = sequenceItem.getAttributeList()) != null) {
                this.numberOfChannels = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.NumberOfWaveformChannels, 0);
                SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList2.get(TagFromName.ChannelDefinitionSequence);
                if (sequenceAttribute2 != null) {
                    int n2 = sequenceAttribute2.getNumberOfItems();
                    if (n2 > this.numberOfChannels) {
                        this.numberOfChannels = n2;
                    }
                    this.amplitudeScalingFactorInMilliVolts = new float[this.numberOfChannels];
                    this.channelNames = new String[this.numberOfChannels];
                    for (int i = 0; i < this.numberOfChannels; ++i) {
                        AttributeList attributeList3;
                        double d = 1.0;
                        double d2 = 1.0;
                        double d3 = 1.0;
                        SequenceItem sequenceItem2 = sequenceAttribute2.getItem(i);
                        if (sequenceItem2 != null && (attributeList3 = sequenceItem2.getAttributeList()) != null) {
                            String string;
                            String string2;
                            CharSequence charSequence;
                            d = Attribute.getSingleDoubleValueOrDefault(attributeList3, TagFromName.ChannelSensitivity, 1.0);
                            d2 = Attribute.getSingleDoubleValueOrDefault(attributeList3, TagFromName.ChannelSensitivityCorrectionFactor, 1.0);
                            d3 = 1.0;
                            CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList3, TagFromName.ChannelSensitivityUnitsSequence);
                            if (codedSequenceItem != null && codedSequenceItem.getCodingSchemeDesignator().equals("UCUM") && (charSequence = codedSequenceItem.getCodeValue()) != null) {
                                if (((String)charSequence).equals("uV")) {
                                    d3 = 0.001;
                                } else if (((String)charSequence).equals("mV")) {
                                    d3 = 1.0;
                                } else if (((String)charSequence).equals("V")) {
                                    d3 = 1000.0;
                                }
                            }
                            charSequence = new StringBuffer();
                            String string3 = "";
                            CodedSequenceItem codedSequenceItem2 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList3, TagFromName.ChannelSourceSequence);
                            if (codedSequenceItem2 != null) {
                                string2 = this.getOurLabelForLeadCode(codedSequenceItem2);
                                if (string2 != null) {
                                    this.keepTrackOfLeadLabelsForBuildingDisplaySequence(string2, i);
                                    ((StringBuffer)charSequence).append(string3);
                                    ((StringBuffer)charSequence).append(string2);
                                    string3 = " ";
                                } else {
                                    string = codedSequenceItem2.getCodeMeaning();
                                    if (string != null) {
                                        ((StringBuffer)charSequence).append(string3);
                                        ((StringBuffer)charSequence).append(string);
                                        string3 = " ";
                                    }
                                }
                            }
                            if ((string2 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.ChannelLabel)) != null) {
                                ((StringBuffer)charSequence).append(string3);
                                ((StringBuffer)charSequence).append(string2);
                                string3 = " ";
                            }
                            if ((string = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.WaveformChannelNumber)) != null) {
                                ((StringBuffer)charSequence).append(string3);
                                ((StringBuffer)charSequence).append("(");
                                ((StringBuffer)charSequence).append(string);
                                string3 = " ";
                                ((StringBuffer)charSequence).append(")");
                            }
                            this.channelNames[i] = ((StringBuffer)charSequence).toString();
                        }
                        this.amplitudeScalingFactorInMilliVolts[i] = (float)(d * d2 * d3);
                    }
                }
                this.nSamplesPerChannel = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.NumberOfWaveformSamples, 0);
                this.samplingIntervalInMilliSeconds = (float)(1000.0 / Attribute.getSingleDoubleValueOrDefault(attributeList2, TagFromName.SamplingFrequency, 0.0));
                Attribute attribute = attributeList2.get(TagFromName.WaveformData);
                if (attribute != null) {
                    short[] sArray = attribute.getShortValues();
                    this.samples = new short[this.numberOfChannels][];
                    for (int i = 0; i < this.numberOfChannels; ++i) {
                        this.samples[i] = new short[this.nSamplesPerChannel];
                        int n3 = i;
                        for (int j = 0; j < this.nSamplesPerChannel; ++j) {
                            this.samples[i][j] = sArray[n3];
                            n3 += this.numberOfChannels;
                        }
                    }
                }
            }
        }
        this.buildPreferredDisplaySequence(this.labelsForChannelsExtractedFromCodes);
        this.title = DicomSourceECG.buildInstanceTitle(attributeList);
    }
}

