/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;

public class SourceOfDoseInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/SourceOfDoseInformation.java,v 1.14 2025/01/29 10:58:08 dclunie Exp $";
    private String description;
    private String abbreviation;
    public static final SourceOfDoseInformation AUTOMATED_DATA_COLLECTION = new SourceOfDoseInformation("Automated Data Collection", "MOD");
    public static final SourceOfDoseInformation MANUAL_ENTRY = new SourceOfDoseInformation("Manual Entry", "ENTRY");
    public static final SourceOfDoseInformation MPPS_CONTENT = new SourceOfDoseInformation("MPPS Content", "MPPS");
    public static final SourceOfDoseInformation DOSIMETER = new SourceOfDoseInformation("Dosimeter", "DSM");
    public static final SourceOfDoseInformation COPIED_FROM_IMAGE_ATTRIBUTES = new SourceOfDoseInformation("Copied From Image Attributes", "HDR");
    public static final SourceOfDoseInformation COMPUTED_FROM_IMAGE_ATTRIBUTES = new SourceOfDoseInformation("Computed From Image Attributes", "COMP");
    public static final SourceOfDoseInformation DERIVED_FROM_HUMAN_READABLE_REPORTS = new SourceOfDoseInformation("Derived From Human-Readable Reports", "OCR");

    private SourceOfDoseInformation() {
    }

    private SourceOfDoseInformation(String string, String string2) {
        this.description = string;
        this.abbreviation = string2;
    }

    public String toString() {
        return this.description;
    }

    public String toStringAbbreviation() {
        return this.abbreviation;
    }

    public static SourceOfDoseInformation getSourceOfDoseInformation(ContentItem contentItem) {
        String string;
        CodedSequenceItem codedSequenceItem;
        SourceOfDoseInformation sourceOfDoseInformation = null;
        ContentItem contentItem2 = contentItem.getNamedChild("DCM", "113854");
        if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem && (codedSequenceItem = ((ContentItemFactory.CodeContentItem)contentItem2).getConceptCode()) != null && (string = codedSequenceItem.getCodingSchemeDesignator()) != null) {
            String string2;
            if (string.equals("DCM")) {
                String string3 = codedSequenceItem.getCodeValue();
                if (string3 != null) {
                    if (string3.equals("113856")) {
                        sourceOfDoseInformation = AUTOMATED_DATA_COLLECTION;
                    } else if (string3.equals("113857")) {
                        sourceOfDoseInformation = MANUAL_ENTRY;
                    } else if (string3.equals("113858")) {
                        sourceOfDoseInformation = MPPS_CONTENT;
                    } else if (string3.equals("113866")) {
                        sourceOfDoseInformation = COPIED_FROM_IMAGE_ATTRIBUTES;
                    } else if (string3.equals("113867")) {
                        sourceOfDoseInformation = COMPUTED_FROM_IMAGE_ATTRIBUTES;
                    } else if (string3.equals("113868")) {
                        sourceOfDoseInformation = DERIVED_FROM_HUMAN_READABLE_REPORTS;
                    }
                }
            } else if (string.equals("SCT")) {
                String string4 = codedSequenceItem.getCodeValue();
                if (string4 != null && string4.equals("15869005")) {
                    sourceOfDoseInformation = DOSIMETER;
                }
            } else if (string.equals("SRT") && (string2 = codedSequenceItem.getCodeValue()) != null && string2.equals("A-2C090")) {
                sourceOfDoseInformation = DOSIMETER;
            }
        }
        return sourceOfDoseInformation;
    }

    public static CodedSequenceItem getCodedSequenceItem(SourceOfDoseInformation sourceOfDoseInformation) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (sourceOfDoseInformation != null) {
            if (sourceOfDoseInformation.equals(AUTOMATED_DATA_COLLECTION)) {
                codedSequenceItem = new CodedSequenceItem("113856", "DCM", "Automated Data Collection");
            } else if (sourceOfDoseInformation.equals(MANUAL_ENTRY)) {
                codedSequenceItem = new CodedSequenceItem("113857", "DCM", "Manual Entry");
            } else if (sourceOfDoseInformation.equals(MPPS_CONTENT)) {
                codedSequenceItem = new CodedSequenceItem("113858", "DCM", "MPPS Content");
            } else if (sourceOfDoseInformation.equals(DOSIMETER)) {
                codedSequenceItem = new CodedSequenceItem("15869005", "SCT", "Dosimeter");
            } else if (sourceOfDoseInformation.equals(COPIED_FROM_IMAGE_ATTRIBUTES)) {
                codedSequenceItem = new CodedSequenceItem("113866", "DCM", "Copied From Image Attributes");
            } else if (sourceOfDoseInformation.equals(COMPUTED_FROM_IMAGE_ATTRIBUTES)) {
                codedSequenceItem = new CodedSequenceItem("113867", "DCM", "Computed From Image Attributes");
            } else if (sourceOfDoseInformation.equals(DERIVED_FROM_HUMAN_READABLE_REPORTS)) {
                codedSequenceItem = new CodedSequenceItem("113868", "DCM", "Derived From Human-Readable Reports");
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItem() throws DicomException {
        return SourceOfDoseInformation.getCodedSequenceItem(this);
    }
}

