/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.geometry;

import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeometryOfVolume {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/GeometryOfVolume.java,v 1.29 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(GeometryOfVolume.class);
    protected GeometryOfSlice[] frames;
    protected int R = -1;
    protected int C = -1;
    protected int N = -1;
    protected boolean areParallel;
    protected boolean isVolume;

    protected GeometryOfVolume() {
    }

    public GeometryOfVolume(GeometryOfSlice[] geometryOfSliceArray) {
        this.frames = geometryOfSliceArray;
    }

    public final int getNumberOfSlices() {
        return this.frames == null ? 0 : this.frames.length;
    }

    public final GeometryOfSlice[] getGeometryOfSlices() {
        return this.frames;
    }

    public final GeometryOfSlice getGeometryOfSlice(int n) {
        return this.frames != null && n >= 0 && n < this.frames.length ? this.frames[n] : null;
    }

    public final double[] lookupImageCoordinate(int n, int n2, int n3) {
        return this.lookupImageCoordinate((double)n, (double)n2, n3);
    }

    public final void lookupImageCoordinate(double[] dArray, int n, int n2, int n3) {
        this.lookupImageCoordinate(dArray, (double)n, (double)n2, n3);
    }

    public final double[] lookupImageCoordinate(double d, double d2, int n) {
        double[] dArray = null;
        if (this.frames != null && n < this.frames.length && this.frames[n] != null) {
            dArray = this.frames[n].lookupImageCoordinate(d, d2);
        }
        return dArray;
    }

    public final void lookupImageCoordinate(double[] dArray, double d, double d2, int n) {
        if (this.frames != null && n < this.frames.length && this.frames[n] != null) {
            this.frames[n].lookupImageCoordinate(dArray, d, d2);
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        }
    }

    public final double[] lookupImageCoordinate(double[] dArray) {
        double[] dArray2 = new double[3];
        this.lookupImageCoordinate(dArray2, dArray);
        return dArray2;
    }

    protected final void findMaxComponents(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = Math.abs(dArray[i]);
            dArray5[i] = Math.abs(dArray2[i]);
            dArray6[i] = Math.abs(dArray3[i]);
        }
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        for (int i = 0; i < 3; ++i) {
            if (dArray4[i] > d) {
                d = dArray4[i];
                this.R = i;
            }
            if (dArray5[i] > d2) {
                d2 = dArray5[i];
                this.C = i;
            }
            if (!(dArray6[i] > d3)) continue;
            d3 = dArray6[i];
            this.N = i;
        }
        slf4jlogger.debug("maxRowIndex = {}", this.R);
        slf4jlogger.debug("maxColumnIndex = {}", this.C);
        slf4jlogger.debug("maxNormalIndex = {}", this.N);
    }

    public final void lookupImageCoordinate(double[] dArray, double[] dArray2) {
        if (this.isVolume) {
            double[] dArray3 = this.frames[0].getRowArray();
            double[] dArray4 = this.frames[0].getColumnArray();
            double[] dArray5 = this.frames[0].getNormalArray();
            double[] dArray6 = this.frames[0].getTLHCArray();
            double[] dArray7 = this.frames[0].getVoxelSpacingArray();
            if (this.R == -1 || this.C == -1 || this.N == -1) {
                this.findMaxComponents(dArray3, dArray4, dArray5);
            }
            Matrix3d matrix3d = new Matrix3d(dArray3[this.R], dArray4[this.R], dArray5[this.R], dArray3[this.C], dArray4[this.C], dArray5[this.C], dArray3[this.N], dArray4[this.N], dArray5[this.N]);
            matrix3d.invert();
            Vector3d vector3d = new Vector3d(dArray2[this.R] - dArray6[this.R], dArray2[this.C] - dArray6[this.C], dArray2[this.N] - dArray6[this.N]);
            matrix3d.transform((Tuple3d)vector3d);
            vector3d.get(dArray);
            dArray[0] = dArray[0] / dArray7[0];
            dArray[1] = dArray[1] / dArray7[1];
            dArray[2] = dArray[2] / dArray7[2];
            dArray[0] = dArray[0] + 0.5;
            dArray[1] = dArray[1] + 0.5;
        } else {
            slf4jlogger.warn("Cannot look up 2D coordinate from 3D coordinate if not regularly sampled volume");
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            dArray[2] = Double.NaN;
        }
    }

    public final int findClosestSliceInSamePlane(GeometryOfSlice geometryOfSlice) {
        double d = geometryOfSlice.getDistanceAlongNormalFromOrigin();
        int n = -1;
        double d2 = 9.99999999E8;
        for (int i = 0; i < this.frames.length; ++i) {
            double d3 = this.frames[i].getDistanceAlongNormalFromOrigin();
            double d4 = Math.abs(d3 - d);
            if (!(d4 < d2)) continue;
            d2 = d4;
            n = i;
        }
        return n;
    }

    public final double[] getDistanceAlongNormalFromOrigin() {
        double[] dArray = new double[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            dArray[i] = this.frames[i].getDistanceAlongNormalFromOrigin();
        }
        return dArray;
    }

    public final boolean areAllSlicesParallel() {
        return this.areParallel;
    }

    public final boolean isVolumeSampledRegularlyAlongFrameDimension() {
        return this.isVolume;
    }

    public final boolean hasFrameInformation() {
        return this.frames != null;
    }

    public final void checkAndSetVolumeSampledRegularlyAlongFrameDimension() {
        this.areParallel = true;
        if (this.frames != null && this.frames.length > 1) {
            GeometryOfSlice geometryOfSlice = this.frames[0];
            GeometryOfSlice geometryOfSlice2 = this.frames[1];
            double d = geometryOfSlice.getDistanceAlongNormalFromOrigin();
            if (GeometryOfSlice.areSlicesParallel(geometryOfSlice, geometryOfSlice2)) {
                int n;
                double d2 = geometryOfSlice2.getDistanceAlongNormalFromOrigin();
                double d3 = d2 - d;
                d = d2;
                boolean bl = true;
                for (n = 2; n < this.frames.length && bl; ++n) {
                    geometryOfSlice2 = this.frames[n];
                    if (GeometryOfSlice.areSlicesParallel(geometryOfSlice, geometryOfSlice2)) {
                        d2 = geometryOfSlice2.getDistanceAlongNormalFromOrigin();
                        double d4 = d2 - d;
                        if (Math.abs(d4 - d3) >= 0.001) {
                            bl = false;
                            break;
                        }
                    } else {
                        this.areParallel = false;
                        bl = false;
                        break;
                    }
                    d = d2;
                }
                if (bl) {
                    this.isVolume = true;
                    d3 = Math.abs(d3);
                    for (n = 0; n < this.frames.length; ++n) {
                        this.frames[n].setVoxelSpacingBetweenSlices(d3);
                    }
                }
            } else {
                this.areParallel = false;
            }
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.frames.length; ++i) {
            stringBuffer.append("[");
            stringBuffer.append(i);
            stringBuffer.append("] ");
            stringBuffer.append(this.frames[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public final String getRowOrientation(int n, boolean bl) {
        return this.frames != null && n < this.frames.length ? this.frames[n].getRowOrientation(bl) : "";
    }

    public final String getColumnOrientation(int n, boolean bl) {
        return this.frames != null && n < this.frames.length ? this.frames[n].getColumnOrientation(bl) : "";
    }

    public final String getRowOrientation(int n) {
        return this.frames != null && n < this.frames.length ? this.frames[n].getRowOrientation() : "";
    }

    public final String getColumnOrientation(int n) {
        return this.frames != null && n < this.frames.length ? this.frames[n].getColumnOrientation() : "";
    }
}

