/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.geometry;

import com.pixelmed.geometry.IntersectSlice;
import com.pixelmed.geometry.IntersectVolume;
import com.pixelmed.geometry.LocalizerPoster;
import com.pixelmed.geometry.ProjectSlice;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class LocalizerPosterFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/LocalizerPosterFactory.java,v 1.20 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(LocalizerPosterFactory.class);

    private static final String dumpPathSegmentType(int n) {
        String string = null;
        string = n == 4 ? "SEG_CLOSE" : (n == 3 ? "SEG_CUBICTO" : (n == 1 ? "SEG_LINETO" : (n == 0 ? "SEG_MOVETO" : (n == 2 ? "SEG_QUADTO" : Integer.toString(n)))));
        return string;
    }

    private static final String dumpArray(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dArray == null) {
            stringBuffer.append("Shape segment array is null");
        } else {
            String string = "";
            if (dArray != null && dArray.length > 0) {
                for (int i = 0; i < dArray.length; ++i) {
                    stringBuffer.append(string);
                    string = ",";
                    stringBuffer.append(dArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final void dumpShape(Shape shape) {
        if (shape == null) {
            System.err.println("Shape is null");
        } else {
            double[] dArray = new double[6];
            PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                System.err.println("Segment type = " + LocalizerPosterFactory.dumpPathSegmentType(n) + " coords = " + LocalizerPosterFactory.dumpArray(dArray));
                pathIterator.next();
            }
        }
    }

    public static final void dumpShapes(Vector vector) {
        if (vector == null) {
            System.err.println("Shapes is null");
        } else {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                System.err.println("Shape:");
                LocalizerPosterFactory.dumpShape((Shape)iterator.next());
            }
        }
    }

    private LocalizerPosterFactory() {
    }

    public static LocalizerPoster getLocalizerPoster(boolean bl, boolean bl2) {
        LocalizerPoster localizerPoster = null;
        try {
            localizerPoster = bl ? new ProjectSlice() : (bl2 ? new IntersectSlice() : new IntersectVolume());
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            slf4jlogger.error("", noClassDefFoundError);
        }
        return localizerPoster;
    }

    public static void main(String[] stringArray) {
        LocalizerPoster localizerPoster = LocalizerPosterFactory.getLocalizerPoster(true, true);
        localizerPoster.setLocalizerGeometry(new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Point3d(0.0, -127.5, 127.5), (Tuple3d)new Vector3d(0.5, 0.5, 0.0), (Tuple3d)new Vector3d(512.0, 512.0, 1.0));
        Vector vector = localizerPoster.getOutlineOnLocalizerForThisGeometry(new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Point3d(-63.5, -63.5, 0.0), (Tuple3d)new Vector3d(0.5, 0.5, 0.0), 0.0, (Tuple3d)new Vector3d(256.0, 256.0, 1.0));
        LocalizerPosterFactory.dumpShapes(vector);
        vector = localizerPoster.getOutlineOnLocalizerForThisGeometry(new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Point3d(-127.5, -127.5, 0.0), (Tuple3d)new Vector3d(0.5, 0.5, 0.0), 0.0, (Tuple3d)new Vector3d(512.0, 512.0, 1.0));
        LocalizerPosterFactory.dumpShapes(vector);
    }
}

