/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.AAbortPDU;
import com.pixelmed.network.AssociateAcceptPDU;
import com.pixelmed.network.AssociateRejectPDU;
import com.pixelmed.network.AssociateRequestPDU;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContextSelectionPolicy;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.StringUtilities;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;

class AssociationAcceptor
extends Association {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociationAcceptor.java,v 1.41 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AssociationAcceptor.class);
    protected PresentationContextSelectionPolicy presentationContextSelectionPolicy;

    protected AssociationAcceptor(Socket socket, String string, String string2, String string3, int n, int n2, int n3, PresentationContextSelectionPolicy presentationContextSelectionPolicy, int n4) throws DicomNetworkException, IOException {
        this(socket, string, string2, string3, n, n2, n3, presentationContextSelectionPolicy);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    protected AssociationAcceptor(Socket socket, String string, String string2, String string3, int n, int n2, int n3, PresentationContextSelectionPolicy presentationContextSelectionPolicy) throws DicomNetworkException, IOException {
        this.socket = socket;
        this.calledAETitle = string;
        this.callingAETitle = null;
        this.presentationContexts = null;
        this.presentationContextSelectionPolicy = presentationContextSelectionPolicy;
        try {
            LinkedList linkedList;
            AssociateRequestPDU associateRequestPDU;
            this.setSocketOptions(socket, n, n2, n3);
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            byte[] byArray = new byte[6];
            AssociationAcceptor.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
            int n4 = byArray[0] & 0xFF;
            int n5 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("Association[{}]: Them: PDU Type: 0x{} (length 0x{})", this.associationNumber, Integer.toHexString(n4), Integer.toHexString(n5));
            }
            if (n4 == 1) {
                associateRequestPDU = new AssociateRequestPDU(AssociationAcceptor.getRestOfPDU(this.in, byArray, n5));
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, associateRequestPDU.toString());
                }
                this.presentationContexts = associateRequestPDU.getRequestedPresentationContexts();
                this.maximumLengthReceived = associateRequestPDU.getMaximumLengthReceived();
                this.callingAETitle = StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(associateRequestPDU.getCallingAETitle());
                if (!string.equals(StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(associateRequestPDU.getCalledAETitle()))) {
                    AssociateRejectPDU associateRejectPDU = new AssociateRejectPDU(1, 1, 7);
                    this.out.write(associateRejectPDU.getBytes());
                    this.out.flush();
                    socket.close();
                    throw new DicomNetworkException("Called AE title requested (" + associateRequestPDU.getCalledAETitle() + ") doesn't match ours (" + string + ") - rejecting association");
                }
                presentationContextSelectionPolicy.applyPresentationContextSelectionPolicy(this.presentationContexts, this.associationNumber);
                linkedList = AssociateAcceptPDU.sanitizePresentationContextsForAcceptance(this.presentationContexts);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Association[{}]: Presentation contexts for A-ASSOCIATE-AC:\n{}", this.associationNumber, linkedList.toString());
                }
            } else {
                if (n4 == 7) {
                    AAbortPDU aAbortPDU = new AAbortPDU(AssociationAcceptor.getRestOfPDU(this.in, byArray, n5));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, aAbortPDU.toString());
                    }
                    socket.close();
                    throw new DicomNetworkException("A-ABORT indication - " + aAbortPDU.getInfo());
                }
                slf4jlogger.trace("Association[{}]: Aborting");
                AAbortPDU aAbortPDU = new AAbortPDU(0, 0);
                this.out.write(aAbortPDU.getBytes());
                this.out.flush();
                socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - " + aAbortPDU.getInfo());
            }
            slf4jlogger.trace("Association[{}]: OurMaximumLengthReceived={}", this.associationNumber, n);
            LinkedList linkedList2 = associateRequestPDU.getSCUSCPRoleSelections();
            AssociateAcceptPDU associateAcceptPDU = new AssociateAcceptPDU(string, this.callingAETitle, string2, string3, n, linkedList, linkedList2);
            this.out.write(associateAcceptPDU.getBytes());
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DicomNetworkException("A-P-ABORT indication - " + iOException);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    @Override
    public String getCallingAEHostName() {
        return this.getRemoteHostName();
    }

    @Override
    public String getCalledAEHostName() {
        return this.getLocalHostName();
    }

    @Override
    public int getCallingAEPort() {
        return this.getRemotePort();
    }

    @Override
    public int getCalledAEPort() {
        return this.getLocalPort();
    }
}

