/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.CMoveRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.LinkedList;

public class MoveSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/MoveSOPClassSCU.java,v 1.32 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MoveSOPClassSCU.class);
    protected CMoveResponseHandler responseHandler;

    public int getStatus() {
        return this.responseHandler.getStatus();
    }

    public static Association getSuitableAssociation(String string, int n, String string2, String string3, String string4, int n2) throws DicomNetworkException, DicomException, IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        return MoveSOPClassSCU.getSuitableAssociation(string, n, string2, string3, string4);
    }

    public static Association getSuitableAssociation(String string, int n, String string2, String string3, String string4) throws DicomNetworkException, DicomException, IOException {
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        Object object = new LinkedList<String>();
        ((LinkedList)object).add("1.2.840.10008.1.2");
        ((LinkedList)object).add("1.2.840.10008.1.2.1");
        linkedList.add(new PresentationContext(1, string4, (LinkedList)object));
        linkedList.add(new PresentationContext(3, string4, "1.2.840.10008.1.2"));
        linkedList.add(new PresentationContext(5, string4, "1.2.840.10008.1.2.1"));
        object = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(((Association)object).toString());
        }
        return object;
    }

    public void performMove(Association association, String string, String string2, AttributeList attributeList) throws DicomNetworkException, DicomException, IOException, AReleaseException {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("performMove(): request identifier\n{}", attributeList.toString());
        }
        byte by = association.getSuitablePresentationContextID(string2);
        slf4jlogger.trace("Using context ID {}", by);
        byte[] byArray = new CMoveRequestCommandMessage(string2, string).getBytes();
        byte[] byArray2 = new IdentifierMessage(attributeList, association.getTransferSyntaxForPresentationContextID(by)).getBytes();
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("Identifier:\n" + attributeList.toString());
        }
        this.responseHandler = new CMoveResponseHandler();
        association.setReceivedDataHandler(this.responseHandler);
        association.send(by, byArray, null);
        association.send(by, null, byArray2);
        slf4jlogger.trace("performMove(): waiting for PDUs");
        association.waitForPDataPDUsUntilHandlerReportsDone();
        slf4jlogger.trace("performMove(): got PDU");
    }

    public MoveSOPClassSCU(Association association, String string, String string2, AttributeList attributeList, int n) throws DicomNetworkException, DicomException, IOException {
        this(association, string, string2, attributeList);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public MoveSOPClassSCU(Association association, String string, String string2, AttributeList attributeList) throws DicomNetworkException, DicomException, IOException {
        try {
            this.performMove(association, string, string2, attributeList);
        }
        catch (AReleaseException aReleaseException) {
            association = null;
        }
        if (!this.responseHandler.wasSuccessful()) {
            throw new DicomNetworkException("C-MOVE reports failure status 0x" + Integer.toString(this.responseHandler.getStatus() & 0xFFFF, 16));
        }
    }

    public MoveSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, AttributeList attributeList, int n2) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, string5, attributeList);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public MoveSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, AttributeList attributeList) throws DicomNetworkException, DicomException, IOException {
        Association association = MoveSOPClassSCU.getSuitableAssociation(string, n, string2, string3, string5);
        try {
            this.performMove(association, string4, string5, attributeList);
            slf4jlogger.trace("releasing association");
            association.release();
        }
        catch (AReleaseException aReleaseException) {
            association = null;
        }
        if (!this.responseHandler.wasSuccessful()) {
            throw new DicomNetworkException("C-MOVE reports failure status 0x" + Integer.toString(this.responseHandler.getStatus() & 0xFFFF, 16));
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            Object object = TagFromName.QueryRetrieveLevel;
            StringAttribute stringAttribute = new CodeStringAttribute((AttributeTag)object);
            ((Attribute)stringAttribute).addValue(stringArray[5]);
            attributeList.put((AttributeTag)object, stringAttribute);
            object = TagFromName.StudyInstanceUID;
            stringAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
            ((Attribute)stringAttribute).addValue(stringArray[6]);
            attributeList.put((AttributeTag)object, stringAttribute);
            if (stringArray.length > 7) {
                object = TagFromName.SeriesInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
                ((Attribute)stringAttribute).addValue(stringArray[7]);
                attributeList.put((AttributeTag)object, stringAttribute);
            }
            if (stringArray.length > 8) {
                object = TagFromName.SOPInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
                ((Attribute)stringAttribute).addValue(stringArray[8]);
                attributeList.put((AttributeTag)object, stringAttribute);
            }
            object = new MoveSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], stringArray[4], "1.2.840.10008.5.1.4.1.2.2.2", attributeList);
            slf4jlogger.info("final status = 0x{}", Integer.toHexString(((MoveSOPClassSCU)object).getStatus()));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class CMoveResponseHandler
    extends CompositeResponseHandler {
        private int remainingLastTime;
        private int countPendingResponsesWithoutProgress;

        CMoveResponseHandler(int n) {
            this();
            slf4jlogger.warn("CMoveResponseHandler(): Debug level supplied as constructor argument ignored");
        }

        CMoveResponseHandler() {
            this.allowData = true;
            this.remainingLastTime = Integer.MAX_VALUE;
            this.countPendingResponsesWithoutProgress = 0;
        }

        @Override
        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            slf4jlogger.trace("CMoveResponseHandler.evaluateStatusAndSetSuccess:");
            this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CMoveResponseHandler.evaluateStatusAndSetSuccess: status =0x{}", Integer.toHexString(this.status));
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace(attributeList.toString());
            }
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("Move {}", this.status == 65280 ? "pending" : (this.status == 0 ? "success" : "0x" + Integer.toHexString(this.status)));
            }
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFailedSuboperations, 0);
            boolean bl = this.success = this.status == 0;
            if (this.status != 65280) {
                slf4jlogger.info("CMoveResponseHandler.evaluateStatusAndSetSuccess: Stopping because status not pending response");
                this.setDone(true);
            }
            int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfRemainingSuboperations, 0);
            if (this.status == 65280) {
                if (n2 >= this.remainingLastTime) {
                    slf4jlogger.debug("CMoveResponseHandler.evaluateStatusAndSetSuccess: No progress since last pending response ({} remaining)", this.remainingLastTime);
                    ++this.countPendingResponsesWithoutProgress;
                    if (this.countPendingResponsesWithoutProgress > 100) {
                        slf4jlogger.info("CMoveResponseHandler.evaluateStatusAndSetSuccess: Stopping because too many pending responses with no progress");
                        this.setDone(true);
                    }
                } else {
                    this.countPendingResponsesWithoutProgress = 0;
                }
            }
            this.remainingLastTime = n2;
        }

        @Override
        protected void makeUseOfDataSet(AttributeList attributeList) {
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CMoveResponseHandler.makeUseOfDataSet:\n{}", attributeList.toString());
            }
            this.setDone(true);
        }
    }
}

