/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;

public class NetworkUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkUtilities.java,v 1.7 2025/01/29 10:58:08 dclunie Exp $";

    private NetworkUtilities() {
    }

    public static boolean isPortResponding(String string, int n) {
        try {
            new Socket(string, n).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isPortResponding(InetAddress inetAddress, int n) {
        try {
            new Socket(inetAddress, n).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isPortOnLocalHostResponding(int n) throws UnknownHostException {
        return NetworkUtilities.isPortResponding(InetAddress.getLocalHost(), n);
    }

    public static int getRandomUnusedPortToListenOnLocally() throws UnknownHostException {
        int n;
        do {
            if (!NetworkUtilities.isPortOnLocalHostResponding(n = 1025 + new Random().nextInt(10000))) continue;
            n = 0;
        } while (n == 0);
        return n;
    }
}

