/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.SOPClassDescriptions;
import com.pixelmed.dicom.TransferSyntaxFromName;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PresentationContext {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/PresentationContext.java,v 1.22 2025/01/29 10:58:08 dclunie Exp $";
    private byte identifier;
    private byte resultReason;
    private String abstractSyntaxUID;
    private LinkedList transferSyntaxUIDs;

    private void initialize(byte by, byte by2, String string) {
        this.initializeSansLinkedList(by, by2, string);
        this.newTransferSyntaxUIDs();
    }

    private void initializeSansLinkedList(byte by, byte by2, String string) {
        this.identifier = by;
        this.resultReason = by2;
        this.abstractSyntaxUID = string;
    }

    public PresentationContext(byte by) {
        this.initialize(by, (byte)0, null);
    }

    public PresentationContext(byte by, String string) {
        this.initialize(by, (byte)0, string);
    }

    public PresentationContext(byte by, String string, String string2) {
        this.initialize(by, (byte)0, string);
        this.transferSyntaxUIDs.add(string2);
    }

    public PresentationContext(byte by, String string, LinkedList linkedList) {
        this.initializeSansLinkedList(by, (byte)0, string);
        this.transferSyntaxUIDs = linkedList;
    }

    public PresentationContext(byte by, byte by2) {
        this.initialize(by, by2, null);
    }

    public PresentationContext(byte by, byte by2, String string) {
        this.initialize(by, by2, string);
    }

    public PresentationContext(byte by, byte by2, String string, String string2) {
        this.initialize(by, by2, string);
        this.transferSyntaxUIDs.add(string2);
    }

    public PresentationContext(byte by, byte by2, String string, LinkedList linkedList) {
        this.initializeSansLinkedList(by, by2, string);
        this.transferSyntaxUIDs = linkedList;
    }

    public void newTransferSyntaxUIDs() {
        this.transferSyntaxUIDs = new LinkedList();
    }

    public void addTransferSyntaxUID(String string) {
        this.transferSyntaxUIDs.add(string);
    }

    public List getTransferSyntaxUIDs() {
        return this.transferSyntaxUIDs;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUIDs.size() > 0 ? (String)this.transferSyntaxUIDs.getFirst() : null;
    }

    public String getAbstractSyntaxUID() {
        return this.abstractSyntaxUID;
    }

    public void setAbstractSyntaxUID(String string) {
        this.abstractSyntaxUID = string;
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(byte by) {
        this.identifier = by;
    }

    public byte getResultReason() {
        return this.resultReason;
    }

    public void setResultReason(byte by) {
        this.resultReason = by;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Presentation Context ID: 0x");
        stringBuffer.append(Integer.toHexString(this.identifier & 0xFF));
        stringBuffer.append(" (");
        stringBuffer.append(this.identifier & 0xFF);
        stringBuffer.append(" dec) (result 0x");
        stringBuffer.append(Integer.toHexString(this.resultReason & 0xFF));
        stringBuffer.append(" - ");
        if (this.resultReason == 0) {
            stringBuffer.append("acceptance");
        } else if (this.resultReason == 1) {
            stringBuffer.append("user rejection");
        } else if (this.resultReason == 2) {
            stringBuffer.append("no reason (provider rejection)");
        } else if (this.resultReason == 3) {
            stringBuffer.append("abstract syntax not supported (provider rejection)");
        } else if (this.resultReason == 4) {
            stringBuffer.append("transfer syntaxes not supported (provider rejection)");
        } else {
            stringBuffer.append("unrecognized");
        }
        stringBuffer.append(")\n");
        stringBuffer.append("\tAbstract Syntax:\n\t\t");
        stringBuffer.append(this.abstractSyntaxUID);
        if (this.abstractSyntaxUID != null && this.abstractSyntaxUID.length() > 0) {
            stringBuffer.append(" (");
            stringBuffer.append(SOPClassDescriptions.getKeywordFromUID(this.abstractSyntaxUID));
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
        stringBuffer.append("\tTransfer Syntax(es):");
        ListIterator listIterator = this.transferSyntaxUIDs.listIterator();
        while (listIterator.hasNext()) {
            stringBuffer.append("\n\t\t");
            String string = (String)listIterator.next();
            stringBuffer.append(string);
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(" (");
            stringBuffer.append(TransferSyntaxFromName.getKeywordFromUID(string));
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

