/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.HexDump;

public class PresentationDataValue {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/PresentationDataValue.java,v 1.25 2025/01/29 10:58:08 dclunie Exp $";
    private byte[] b;
    private byte[] value;
    private int itemLength;
    private byte presentationContextID;
    private byte messageControlHeader;

    public PresentationDataValue(byte by, byte[] byArray, boolean bl, boolean bl2) throws DicomNetworkException {
        this.value = byArray;
        this.messageControlHeader = (byte)((bl2 ? 1 : 0) << 1 | (bl ? 1 : 0));
        this.b = new byte[6 + byArray.length];
        this.itemLength = byArray.length + 2;
        this.b[0] = (byte)(this.itemLength >> 24);
        this.b[1] = (byte)(this.itemLength >> 16);
        this.b[2] = (byte)(this.itemLength >> 8);
        this.b[3] = (byte)this.itemLength;
        this.b[4] = by;
        this.b[5] = this.messageControlHeader;
        System.arraycopy(byArray, 0, this.b, 6, byArray.length);
    }

    public PresentationDataValue(byte[] byArray, int n, int n2) throws DicomNetworkException {
        this.itemLength = n2;
        this.presentationContextID = byArray[n + 4];
        this.messageControlHeader = byArray[n + 5];
        this.value = n2 >= 2 ? ByteArray.extractBytes(byArray, n + 6, n2 - 2) : null;
        this.b = ByteArray.extractBytes(byArray, n, n2 + 4);
    }

    public byte[] getBytes() {
        return this.b;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean isLastFragment() {
        return (this.messageControlHeader & 2) != 0;
    }

    public boolean isCommand() {
        return (this.messageControlHeader & 1) != 0;
    }

    public byte getPresentationContextID() {
        return this.presentationContextID;
    }

    public String toString() {
        return HexDump.dump(this.b);
    }
}

