/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.network.AnyExplicitStorePresentationContextSelectionPolicy;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationStatusHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContextSelectionPolicy;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCP;
import com.pixelmed.network.UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy;
import com.pixelmed.network.UnencapsulatedExplicitStorePresentationContextSelectionPolicy;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class StorageSOPClassSCPDispatcher
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCPDispatcher.java,v 1.62 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StorageSOPClassSCPDispatcher.class);
    private int timeoutBeforeCheckingForInterrupted = 5000;
    private int port;
    private String calledAETitle;
    private int ourMaximumLengthReceived;
    private int socketReceiveBufferSize;
    private int socketSendBufferSize;
    private File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy;
    private ReceivedObjectHandler receivedObjectHandler;
    private AssociationStatusHandler associationStatusHandler;
    private QueryResponseGeneratorFactory queryResponseGeneratorFactory;
    private RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory;
    private NetworkApplicationInformation networkApplicationInformation;
    private boolean secureTransport;
    private PresentationContextSelectionPolicy presentationContextSelectionPolicy;
    private boolean wantToShutdown;
    private boolean isReady;

    public synchronized boolean isReady() {
        return this.isReady;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, ReceivedObjectHandler receivedObjectHandler) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = StoredFilePathStrategy.getDefaultStrategy();
        this.receivedObjectHandler = receivedObjectHandler;
        this.associationStatusHandler = null;
        this.queryResponseGeneratorFactory = null;
        this.retrieveResponseGeneratorFactory = null;
        this.networkApplicationInformation = null;
        this.secureTransport = false;
        this.presentationContextSelectionPolicy = new UnencapsulatedExplicitStorePresentationContextSelectionPolicy();
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler;
        this.associationStatusHandler = null;
        this.queryResponseGeneratorFactory = null;
        this.retrieveResponseGeneratorFactory = null;
        this.networkApplicationInformation = null;
        this.secureTransport = false;
        this.presentationContextSelectionPolicy = new UnencapsulatedExplicitStorePresentationContextSelectionPolicy();
    }

    public StorageSOPClassSCPDispatcher(int n, String string, int n2, int n3, int n4, File file, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n2;
        this.socketReceiveBufferSize = n3;
        this.socketSendBufferSize = n4;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = StoredFilePathStrategy.getDefaultStrategy();
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.associationStatusHandler = null;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.secureTransport = bl;
        this.presentationContextSelectionPolicy = new UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy();
    }

    public StorageSOPClassSCPDispatcher(int n, String string, int n2, int n3, int n4, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n2;
        this.socketReceiveBufferSize = n3;
        this.socketSendBufferSize = n4;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.associationStatusHandler = null;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.secureTransport = bl;
        this.presentationContextSelectionPolicy = new UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy();
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = this.storedFilePathStrategy == null ? StoredFilePathStrategy.getDefaultStrategy() : this.storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.associationStatusHandler = null;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.secureTransport = bl;
        this.presentationContextSelectionPolicy = new UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy();
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy == null ? StoredFilePathStrategy.getDefaultStrategy() : storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.associationStatusHandler = null;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.secureTransport = bl;
        this.presentationContextSelectionPolicy = new UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy();
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, PresentationContextSelectionPolicy presentationContextSelectionPolicy, boolean bl) throws IOException {
        this(n, string, file, storedFilePathStrategy, receivedObjectHandler, null, queryResponseGeneratorFactory, retrieveResponseGeneratorFactory, networkApplicationInformation, presentationContextSelectionPolicy, bl);
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, AssociationStatusHandler associationStatusHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, PresentationContextSelectionPolicy presentationContextSelectionPolicy, boolean bl) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy == null ? StoredFilePathStrategy.getDefaultStrategy() : storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.associationStatusHandler = associationStatusHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.presentationContextSelectionPolicy = presentationContextSelectionPolicy == null ? new UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy() : presentationContextSelectionPolicy;
        this.secureTransport = bl;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, int n2, int n3, int n4, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, AssociationStatusHandler associationStatusHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, PresentationContextSelectionPolicy presentationContextSelectionPolicy, boolean bl) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n2;
        this.socketReceiveBufferSize = n3;
        this.socketSendBufferSize = n4;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy == null ? StoredFilePathStrategy.getDefaultStrategy() : storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.associationStatusHandler = associationStatusHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.presentationContextSelectionPolicy = presentationContextSelectionPolicy == null ? new UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy() : presentationContextSelectionPolicy;
        this.secureTransport = bl;
    }

    public void shutdown() {
        this.wantToShutdown = true;
    }

    @Override
    public void run() {
        this.wantToShutdown = false;
        this.isReady = false;
        ServerSocket serverSocket = null;
        try {
            Object object;
            Object object2;
            Object object3;
            slf4jlogger.trace("run(): Trying to bind to port {}", this.port);
            if (this.secureTransport) {
                String[] stringArray;
                object3 = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                object2 = (SSLServerSocket)((ServerSocketFactory)object3).createServerSocket(this.port);
                object = Association.getCipherSuitesToEnable(((SSLServerSocket)object2).getSupportedCipherSuites());
                if (object != null) {
                    ((SSLServerSocket)object2).setEnabledCipherSuites((String[])object);
                }
                if ((stringArray = Association.getProtocolsToEnable(((SSLServerSocket)object2).getEnabledProtocols())) != null) {
                    ((SSLServerSocket)object2).setEnabledProtocols(stringArray);
                }
                serverSocket = object2;
            } else {
                serverSocket = new ServerSocket(this.port);
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("run(): serverSocket.isBound() = {}", serverSocket.isBound());
            }
            this.isReady = true;
            serverSocket.setSoTimeout(this.timeoutBeforeCheckingForInterrupted);
            while (!this.wantToShutdown) {
                try {
                    object3 = serverSocket.accept();
                    slf4jlogger.trace("run(): returned from accept");
                    object2 = null;
                    if (this.networkApplicationInformation != null) {
                        object2 = this.networkApplicationInformation.getApplicationEntityMap();
                    }
                    if (object2 == null) {
                        object2 = new ApplicationEntityMap();
                    }
                    if ((object = serverSocket.getInetAddress()) != null && ((TreeMap)object2).get(this.calledAETitle) == null) {
                        ((ApplicationEntityMap)object2).put(this.calledAETitle, new PresentationAddress(((InetAddress)object).getHostAddress(), this.port), "STUDYROOT", null);
                    }
                    slf4jlogger.trace("run(): applicationEntityMap = {}", object2);
                    try {
                        new Thread(new StorageSOPClassSCP((Socket)object3, this.calledAETitle, this.ourMaximumLengthReceived, this.socketReceiveBufferSize, this.socketSendBufferSize, this.savedImagesFolder, this.storedFilePathStrategy, this.receivedObjectHandler, this.associationStatusHandler, this.queryResponseGeneratorFactory, this.retrieveResponseGeneratorFactory, (ApplicationEntityMap)object2, this.presentationContextSelectionPolicy)).start();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    slf4jlogger.trace("run(): timed out in accept");
                }
            }
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
        }
        try {
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        this.isReady = false;
        slf4jlogger.trace("run(): has shutdown and is no longer listening");
    }

    private static File getSavedImagesFolderOrNullIfNoneSpecified(String string) {
        String string2;
        File file = null;
        if (string != null && (string2 = string.trim().replaceAll("^\"(.*)\"$", "\u0001").trim()).length() > 0 && !"-".equals(string2)) {
            file = new File(string2);
        }
        return file;
    }

    public static void main(String[] stringArray) {
        try {
            StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = null;
            File file = null;
            if (stringArray.length == 0) {
                Object object;
                Properties properties = new Properties();
                try {
                    object = ".com.pixelmed.network.StorageSOPClassSCPDispatcher.properties";
                    properties.load(new FileInputStream(FileUtilities.makePathToFileInUsersHomeDirectory((String)object)));
                }
                catch (IOException iOException) {
                    properties.put("Dicom.ListeningPort", "11112");
                    properties.put("Dicom.CalledAETitle", "STORESCP");
                    properties.put("Dicom.CallingAETitle", "STORESCP");
                    properties.put("Dicom.PrimaryDeviceType", "ARCHIVE");
                    properties.put("Application.SavedImagesFolderName", "tmp");
                }
                object = new NetworkApplicationProperties(properties);
                int n = ((NetworkApplicationProperties)object).getListeningPort();
                String string = ((NetworkApplicationProperties)object).getCalledAETitle();
                NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
                networkApplicationInformationFederated.startupAllKnownSourcesAndRegister((NetworkApplicationProperties)object);
                file = new DatabaseApplicationProperties(properties).getSavedImagesFolderCreatingItIfNecessary();
                slf4jlogger.info("main(): listening on port {} AE {} storing into {}", n, string, file);
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, string, file, null, null, null, null, null, null, false);
            } else if (stringArray.length == 3) {
                file = StorageSOPClassSCPDispatcher.getSavedImagesFolderOrNullIfNoneSpecified(stringArray[2]);
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], file, null, null, null, null, null, null, false);
            } else if (stringArray.length == 4) {
                file = StorageSOPClassSCPDispatcher.getSavedImagesFolderOrNullIfNoneSpecified(stringArray[2]);
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], file, null, null, null, null, null, null, stringArray[3].toUpperCase(Locale.US).equals("SECURE"));
            } else if (stringArray.length == 5) {
                if (stringArray[4].matches("^[0-9]+$")) {
                    file = StorageSOPClassSCPDispatcher.getSavedImagesFolderOrNullIfNoneSpecified(stringArray[5]);
                    storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), file, null, null, null, null, null, false);
                } else {
                    file = StorageSOPClassSCPDispatcher.getSavedImagesFolderOrNullIfNoneSpecified(stringArray[2]);
                    storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], file, null, null, null, null, null, stringArray[4].toUpperCase(Locale.US).equals("ANY") ? new AnyExplicitStorePresentationContextSelectionPolicy() : new UnencapsulatedExplicitStorePresentationContextSelectionPolicy(), stringArray[3].toUpperCase(Locale.US).equals("SECURE"));
                }
            } else if (stringArray.length == 7) {
                file = StorageSOPClassSCPDispatcher.getSavedImagesFolderOrNullIfNoneSpecified(stringArray[5]);
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), file, null, null, null, null, null, null, null, stringArray[6].toUpperCase(Locale.US).equals("SECURE"));
            } else if (stringArray.length == 8) {
                file = StorageSOPClassSCPDispatcher.getSavedImagesFolderOrNullIfNoneSpecified(stringArray[5]);
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), file, null, null, null, null, null, null, stringArray[7].toUpperCase(Locale.US).equals("ANY") ? new AnyExplicitStorePresentationContextSelectionPolicy() : new UnencapsulatedExplicitStorePresentationContextSelectionPolicy(), stringArray[6].toUpperCase(Locale.US).equals("SECURE"));
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.network.StorageSOPClassSCPDispatcher [port AET [ maxpdusize recbufsize sendbufsize ] folder [NONSECURE|SECURE [UNCOMPRESSED|ANY]]");
            }
            new Thread(storageSOPClassSCPDispatcher).start();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    private class DefaultReceivedObjectHandler
    extends ReceivedObjectHandler {
        private DefaultReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            slf4jlogger.info("DefaultReceivedObjectHandler.sendReceivedObjectIndication() fileName: {} from {} in {}", string, string3, string2);
        }
    }
}

