/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.TreeMap;

public class Section0
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section0.java,v 1.17 2025/01/29 10:58:09 dclunie Exp $";
    private int[] sectionIDNumbers;
    private long[] sectionLengths;
    private long[] sectionIndexes;

    @Override
    public String getSectionName() {
        return "Pointers to Data Areas";
    }

    public int[] getSectionIDNumbers() {
        return this.sectionIDNumbers;
    }

    public long[] getSectionLengths() {
        return this.sectionLengths;
    }

    public long[] getSectionIndexes() {
        return this.sectionIndexes;
    }

    public Section0(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    @Override
    public long read(BinaryInputStream binaryInputStream) throws IOException {
        if (this.sectionBytesRemaining % 10L != 0L) {
            throw new IOException("Section 0 (Pointer Section) variable data length not a multiple of 10");
        }
        int n = (int)(this.sectionBytesRemaining / 10L);
        this.sectionIDNumbers = new int[n];
        this.sectionLengths = new long[n];
        this.sectionIndexes = new long[n];
        int n2 = 0;
        while (this.sectionBytesRemaining > 0L) {
            this.sectionIDNumbers[n2] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.sectionLengths[n2] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            this.sectionIndexes[n2] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            ++n2;
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sectionIDNumbers != null) {
            stringBuffer.append("Section 0 number of pointers = " + this.sectionIDNumbers.length + "\n");
            for (int i = 0; i < this.sectionIDNumbers.length; ++i) {
                stringBuffer.append("\tSection ID Number = " + this.sectionIDNumbers[i] + " dec (0x" + Integer.toHexString(this.sectionIDNumbers[i]) + ")\n");
                stringBuffer.append("\t\tSection Length = " + this.sectionLengths[i] + " dec (0x" + Long.toHexString(this.sectionLengths[i]) + ")\n");
                stringBuffer.append("\t\tSection Index = " + this.sectionIndexes[i] + " dec (0x" + Long.toHexString(this.sectionIndexes[i]) + ")\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String validate() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!new String(this.header.getReservedBytes()).equals("SCPECG")) {
            stringBuffer.append("Section 0 header reserved bytes not SCPECG\n");
        }
        if (this.sectionIDNumbers == null) {
            stringBuffer.append("Section 0 contains no pointers\n");
        }
        return stringBuffer.toString();
    }

    public String validateAgainstOtherSections(TreeMap treeMap) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        BitSet bitSet = new BitSet(12);
        if (this.sectionIDNumbers != null) {
            for (n = 0; n < this.sectionIDNumbers.length; ++n) {
                Section section = (Section)treeMap.get(new Integer(this.sectionIDNumbers[n]));
                if (this.sectionLengths[n] != 0L) {
                    if (section == null) {
                        stringBuffer.append("Section 0 references Section " + this.sectionIDNumbers[n] + " that does not exist\n");
                    } else {
                        if (this.sectionLengths[n] != section.getSectionHeader().getSectionLength()) {
                            stringBuffer.append("Section 0 reference to Section " + this.sectionIDNumbers[n] + " length mismatch ");
                            stringBuffer.append("Section 0 says " + this.sectionLengths[n]);
                            stringBuffer.append(" but length is actually " + section.getSectionHeader().getSectionLength() + "\n");
                        }
                        if (this.sectionIndexes[n] != section.getSectionHeader().getByteOffset() + 1L) {
                            stringBuffer.append("Section 0 reference to Section " + this.sectionIDNumbers[n] + " index mismatch ");
                            stringBuffer.append("Section 0 says " + this.sectionIndexes[n]);
                            stringBuffer.append(" but index is actually " + (section.getSectionHeader().getByteOffset() + 1L) + "\n");
                        }
                    }
                } else if (this.sectionIndexes[n] != 0L) {
                    stringBuffer.append("Section 0 reference to Section " + this.sectionIDNumbers[n] + " specifies zero length ");
                    stringBuffer.append("but index is not null\n");
                }
                if (this.sectionIDNumbers[n] < 0 || this.sectionIDNumbers[n] > 11) continue;
                bitSet.set(this.sectionIDNumbers[n]);
            }
        }
        if (bitSet.cardinality() != 12) {
            for (n = 0; n <= 11; ++n) {
                if (bitSet.get(n)) continue;
                stringBuffer.append("Section 0 does not reference Section " + n + " even though it is mandatory to do so\n");
            }
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            boolean bl = false;
            for (int i = 0; i < this.sectionIDNumbers.length; ++i) {
                if (this.sectionIDNumbers[i] != n2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuffer.append("Section 0 does not reference Section " + n2 + " even though it is present\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            for (int i = 0; i < this.sectionIDNumbers.length; ++i) {
                new SCPTreeRecord(sCPTreeRecord2, "Section " + Integer.toString(this.sectionIDNumbers[i]), "Length = " + Long.toString(this.sectionLengths[i]) + " dec (0x" + Long.toHexString(this.sectionLengths[i]) + ") Index = " + Long.toString(this.sectionIndexes[i]) + " dec (0x" + Long.toHexString(this.sectionIndexes[i]) + ")");
            }
        }
        return this.tree;
    }
}

