/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Section1
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section1.java,v 1.20 2025/01/29 10:58:09 dclunie Exp $";
    private BinaryInputStream i;
    private FieldDictionaryEntry[] dictionary = new FieldDictionaryEntry[]{new FieldDictionaryEntry("LastName", 0, 2, 1, 64, 40, "Text"), new FieldDictionaryEntry("FirstName", 1, 2, 1, 64, 40, "Text"), new FieldDictionaryEntry("PatientIdentificationNumber", 2, 1, 1, 64, 40, "Text"), new FieldDictionaryEntry("SecondLastName", 3, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("Age", 4, 0, 1, 3, 3, "Age"), new FieldDictionaryEntry("DateOfBirth", 5, 0, 1, 4, 4, "Date"), new FieldDictionaryEntry("Height", 6, 0, 1, 3, 3, "Height"), new FieldDictionaryEntry("Weight", 7, 0, 1, 3, 3, "Weight"), new FieldDictionaryEntry("Sex", 8, 0, 1, 1, 1, "Sex"), new FieldDictionaryEntry("Race", 9, 0, 1, 1, 1, "Race"), new FieldDictionaryEntry("Drugs", 10, 0, 99, 64, 40, "Drug"), new FieldDictionaryEntry("SystolicBloodPressure", 11, 0, 1, 2, 2, "Binary"), new FieldDictionaryEntry("DiastolicBloodPressure", 12, 0, 1, 2, 2, "Binary"), new FieldDictionaryEntry("DiagnosisOrReferralIndication", 13, 0, 99, 80, 80, "Text"), new FieldDictionaryEntry("AcquiringDeviceIdentificationNumber", 14, 1, 1, 64, 40, "MachineID"), new FieldDictionaryEntry("AnalyzingDeviceIdentificationNumber", 15, 2, 1, 64, 40, "MachineID"), new FieldDictionaryEntry("AcquiringInstitutionDescription", 16, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("AnalyzingInstitutionDescription", 17, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("AcquiringDepartmentDescription", 18, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("AnalyzingDepartmentDescription", 19, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("ReferringPhysician", 20, 0, 1, 64, 60, "Text"), new FieldDictionaryEntry("LatestConfirmingPhysician", 21, 0, 1, 64, 60, "Text"), new FieldDictionaryEntry("TechnicianDescription", 22, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("RoomDescription", 23, 0, 1, 64, 40, "Text"), new FieldDictionaryEntry("StatCode", 24, 0, 1, 1, 1, "StatCode"), new FieldDictionaryEntry("DateOfAcquisition", 25, 0, 1, 4, 4, "Date"), new FieldDictionaryEntry("TimeOfAcquisition", 26, 0, 1, 3, 3, "Time"), new FieldDictionaryEntry("BaselineFilter", 27, 0, 1, 2, 2, "Binary"), new FieldDictionaryEntry("LowPassFilter", 28, 0, 1, 2, 2, "Binary"), new FieldDictionaryEntry("FilterBitmap", 29, 0, 1, 1, 1, "FilterBitmap"), new FieldDictionaryEntry("FreeTextField", 30, 0, 99, 80, 80, "Text"), new FieldDictionaryEntry("ECGSequenceNumber", 31, 0, 1, 64, 12, "Text"), new FieldDictionaryEntry("MedicalHistoryCodes", 32, 0, 1, 64, 12, "MedicalHistory"), new FieldDictionaryEntry("ElectrodeConfigurationCode", 33, 0, 1, 2, 2, "Electrode"), new FieldDictionaryEntry("DateTimeZone", 34, 0, 1, 64, 40, "TimeZone"), new FieldDictionaryEntry("FreeTextMedicalHistory", 35, 0, 99, 80, 80, "Text")};
    private HashMap dictionaryFieldByName;
    private FieldDictionaryEntry[] dictionaryFieldByTag;
    private static String[] ageUnitsDescription = new String[]{"Unspecified", "Years", "Months", "Weeks", "Days", "Hours"};
    private static String[] heightUnitsDescription = new String[]{"Unspecified", "Centimeters", "Inches", "Millimeters"};
    private static String[] weightUnitsDescription = new String[]{"Unspecified", "Kilogram", "Gram", "Pound", "Ounce"};
    private static String[] sexDescriptors = new String[]{"Not Known", "Male", "Female", null, null, null, null, null, null, "Unspecified"};
    private static String[] raceDescriptors = new String[]{"Unspecified", "Caucasian", "Black", "Oriental"};
    private static String[] statCodeDescriptors = new String[]{"Routine", "Emergency 1", "Emergency 2", "Emergency 3", "Emergency 4", "Emergency 5", "Emergency 6", "Emergency 7", "Emergency 8", "Emergency 9", "Emergency 10"};
    private static String[] electrodePlacement12LeadDescriptors = new String[]{"Unspecified", "Standard", "Mason-Likar Individual", "Mason-Likar One Pad", "All One Pad", "Derived from Frank XYZ", "Non-standard"};
    private static String[] electrodePlacementXYZLeadDescriptors = new String[]{"Unspecified", "Frank", "McFee-Parungao", "Cube", "Bipolar uncorrected", "Pseudo-orthogonal", "Derived from Standard 12-Lead"};
    private static String[] filterDescriptors = new String[]{"60 Hz Notch", "50 Hz Notch", "Artifact", "Baseline"};
    private static String[] deviceTypeDescriptors = new String[]{"Cart", "System (or Host)"};
    private static String[] manufacturerCodeDescriptors = new String[]{"Unknown", "Burdick", "Cambridge", "Compumed", "Datamed", "Fukuda", "Hewlett-Packard", "Marquette Electronics", "Mortara Instruments", "Nihon Kohden", "Okin", "Quinton", "Siemens", "Spacelabs", "Telemed", "Hellige", "ESA-OTE", "Schiller", "Picker-Schwarzer", "Elettronica-Trentina", "Zw\u00f6nitz"};
    private static String[] mainsFrequencyDescriptors = new String[]{"Unspecified", "50 Hz", "60 Hz"};
    private ArrayList[] fields;

    @Override
    public String getSectionName() {
        return "Patient and ECG Acquisition Data";
    }

    private void loadDictionary() {
        this.dictionaryFieldByName = new HashMap();
        this.dictionaryFieldByTag = new FieldDictionaryEntry[256];
        for (int i = 0; i < this.dictionary.length; ++i) {
            this.dictionaryFieldByName.put(this.dictionary[i].name, this.dictionary[i]);
            this.dictionaryFieldByTag[this.dictionary[i].tag] = this.dictionary[i];
        }
    }

    private void dumpDictionary() {
        int n;
        for (n = 0; n < this.dictionary.length; ++n) {
            System.err.println(this.dictionary[n]);
        }
        for (n = 0; n < 256; ++n) {
            System.err.println("[" + n + "] " + this.getDictionaryFieldByTag(n));
        }
    }

    private FieldDictionaryEntry getDictionaryFieldByName(String string) {
        return (FieldDictionaryEntry)this.dictionaryFieldByName.get(string);
    }

    private FieldDictionaryEntry getDictionaryFieldByTag(int n) {
        return this.dictionaryFieldByTag[n];
    }

    private String getName(int n) {
        FieldDictionaryEntry fieldDictionaryEntry = this.getDictionaryFieldByTag(n);
        return fieldDictionaryEntry == null ? null : fieldDictionaryEntry.name;
    }

    private String getClassName(int n) {
        FieldDictionaryEntry fieldDictionaryEntry = this.getDictionaryFieldByTag(n);
        return fieldDictionaryEntry == null ? null : fieldDictionaryEntry.className;
    }

    private int getMultiplicity(int n) {
        FieldDictionaryEntry fieldDictionaryEntry = this.getDictionaryFieldByTag(n);
        return fieldDictionaryEntry == null ? 1 : fieldDictionaryEntry.multiplicity;
    }

    private String describeFieldBriefly(FieldDictionaryEntry fieldDictionaryEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(fieldDictionaryEntry.tag + " dec ");
        stringBuffer.append(fieldDictionaryEntry.name);
        return stringBuffer.toString();
    }

    private String describeFieldBriefly(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tag ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(this.getName(n));
        return stringBuffer.toString();
    }

    public Section1(SectionHeader sectionHeader) {
        super(sectionHeader);
        this.loadDictionary();
        this.fields = new ArrayList[256];
    }

    @Override
    public long read(BinaryInputStream binaryInputStream) throws IOException {
        this.i = binaryInputStream;
        boolean bl = false;
        while (this.sectionBytesRemaining > 0L) {
            int n = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
            int n2 = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            Field field = null;
            String string = this.getClassName(n);
            if (string != null) {
                if (string.equals("Text")) {
                    field = new TextField(n, n2);
                } else if (string.equals("Age")) {
                    field = new ValueWithUnitsField(n, n2, ageUnitsDescription);
                } else if (string.equals("Date")) {
                    field = new DateField(n, n2);
                } else if (string.equals("Time")) {
                    field = new TimeField(n, n2);
                } else if (string.equals("Height")) {
                    field = new ValueWithUnitsField(n, n2, heightUnitsDescription);
                } else if (string.equals("Weight")) {
                    field = new ValueWithUnitsField(n, n2, weightUnitsDescription);
                } else if (string.equals("Sex")) {
                    field = new SingleCodedValueField(n, n2, sexDescriptors);
                } else if (string.equals("Race")) {
                    field = new SingleCodedValueField(n, n2, raceDescriptors);
                } else if (string.equals("Drug")) {
                    field = new DrugField(n, n2);
                } else if (string.equals("Binary")) {
                    field = new BinaryField(n, n2);
                } else if (string.equals("FilterBitmap")) {
                    field = new BitmapField(n, n2, filterDescriptors);
                } else if (string.equals("MachineID")) {
                    field = new MachineIDField(n, n2);
                } else if (string.equals("StatCode")) {
                    field = new SingleCodedValueField(n, n2, statCodeDescriptors);
                } else if (string.equals("MedicalHistory")) {
                    field = new MedicalHistoryField(n, n2);
                } else if (string.equals("Electrode")) {
                    field = new TwinCodedValueField(n, n2, electrodePlacement12LeadDescriptors, electrodePlacementXYZLeadDescriptors);
                }
                if (string.equals("TimeZone")) {
                    field = new TimeZoneField(n, n2);
                }
            }
            if (field == null) {
                field = new Field(n, n2);
            }
            field.read();
            if (field.isTerminator()) {
                bl = true;
                if (this.sectionBytesRemaining > 1L) {
                    System.err.println("Section 1 Encountered terminator but more than one padding byte in section " + this.sectionBytesRemaining + " dec (0x" + Long.toHexString(this.sectionBytesRemaining) + ") bytes\n");
                }
                this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
                break;
            }
            if (this.fields[field.tag] == null) {
                this.fields[field.tag] = new ArrayList();
            }
            this.fields[field.tag].add(field);
        }
        if (!bl) {
            System.err.println("Section 1 Missing terminator tag\n");
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 256; ++i) {
            ArrayList arrayList = this.fields[i];
            if (arrayList == null) continue;
            for (Field field : arrayList) {
                if (field == null) continue;
                stringBuffer.append(field);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String validate() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 256; ++i) {
            FieldDictionaryEntry fieldDictionaryEntry = this.dictionaryFieldByTag[i];
            ArrayList arrayList = this.fields[i];
            if (arrayList == null) {
                if (fieldDictionaryEntry == null) continue;
                if (fieldDictionaryEntry.requirement == 1) {
                    stringBuffer.append(this.describeFieldBriefly(fieldDictionaryEntry));
                    stringBuffer.append(": Missing required field");
                    stringBuffer.append("\n");
                    continue;
                }
                if (fieldDictionaryEntry.requirement != 2) continue;
                stringBuffer.append(this.describeFieldBriefly(fieldDictionaryEntry));
                stringBuffer.append(": Missing recommended field");
                stringBuffer.append("\n");
                continue;
            }
            if (this.getMultiplicity(i) == 1 && arrayList.size() != 1) {
                stringBuffer.append(this.describeFieldBriefly(i));
                stringBuffer.append(": Allowed only one instance of this field, got ");
                stringBuffer.append(arrayList.size());
                stringBuffer.append("\n");
            }
            for (Field field : arrayList) {
                if (field == null) continue;
                stringBuffer.append(field.validate());
            }
        }
        return stringBuffer.toString();
    }

    public String getConcatenatedStringValuesOfAllOccurencesOfNamedField(String string) {
        String string2 = null;
        FieldDictionaryEntry fieldDictionaryEntry = this.getDictionaryFieldByName(string);
        if (fieldDictionaryEntry != null) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList arrayList = this.fields[fieldDictionaryEntry.tag];
            if (arrayList != null) {
                for (Field field : arrayList) {
                    if (field == null) continue;
                    stringBuffer.append(field.getValueAsString());
                }
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    @Override
    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            for (int i = 0; i < 256; ++i) {
                ArrayList arrayList = this.fields[i];
                if (arrayList == null) continue;
                int n = arrayList.size();
                int n2 = 0;
                for (Field field : arrayList) {
                    if (field != null) {
                        String string = this.getName(i) + " (" + Integer.toString(i) + (n > 1 ? ":" + Integer.toString(n2) : "") + ")";
                        new SCPTreeRecord(sCPTreeRecord2, string, field.getValueAsString());
                    }
                    ++n2;
                }
            }
        }
        return this.tree;
    }

    private class MachineIDField
    extends Field {
        int institutionNumber;
        int departmentNumber;
        int deviceID;
        int deviceType;
        int manufacturerCode;
        byte[] modelDescription;
        int protocolRevisionLevel;
        int protocolCompatibilityLevel;
        int languageSupportCode;
        int capabilitiesCode;
        int mainsFrequency;
        byte[] reserved;
        int analysingProgramRevisionNumberLength;
        byte[] analysingProgramRevisionNumber;

        MachineIDField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            int n = this.length;
            if (n >= 36) {
                this.institutionNumber = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                n -= 2;
                this.departmentNumber = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                n -= 2;
                this.deviceID = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                n -= 2;
                this.deviceType = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.manufacturerCode = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.modelDescription = new byte[6];
                Section1.this.i.readInsistently(this.modelDescription, 0, 6);
                Section1.this.sectionBytesRemaining -= 6L;
                Section1.this.bytesRead += 6L;
                n -= 6;
                this.protocolRevisionLevel = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.protocolCompatibilityLevel = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.languageSupportCode = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.capabilitiesCode = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.mainsFrequency = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                this.reserved = new byte[16];
                Section1.this.i.readInsistently(this.reserved, 0, 16);
                Section1.this.sectionBytesRemaining -= 16L;
                Section1.this.bytesRead += 16L;
                n -= 16;
                this.analysingProgramRevisionNumberLength = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
                if (this.analysingProgramRevisionNumberLength >= 1) {
                    this.analysingProgramRevisionNumber = new byte[this.analysingProgramRevisionNumberLength];
                    Section1.this.i.readInsistently(this.analysingProgramRevisionNumber, 0, this.analysingProgramRevisionNumberLength);
                    Section1.this.sectionBytesRemaining -= (long)this.analysingProgramRevisionNumberLength;
                    Section1.this.bytesRead += (long)this.analysingProgramRevisionNumberLength;
                    n -= this.analysingProgramRevisionNumberLength;
                }
            }
            if (n > 0) {
                this.value = new byte[n];
                Section1.this.i.readInsistently(this.value, 0, n);
                Section1.this.sectionBytesRemaining -= (long)n;
                Section1.this.bytesRead += (long)n;
            }
        }

        @Override
        String validate() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.deviceType >= deviceTypeDescriptors.length || deviceTypeDescriptors[this.deviceType] == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized Device Type value " + this.deviceType + " dec");
                stringBuffer.append("\n");
            }
            if (this.manufacturerCode != 255) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Use of legacy manufacturer code value, expected 255 dec, got " + this.deviceType + " dec");
                stringBuffer.append("\n");
                if (this.manufacturerCode != 100 && (this.manufacturerCode >= manufacturerCodeDescriptors.length || manufacturerCodeDescriptors[this.manufacturerCode] == null)) {
                    stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                    stringBuffer.append(": Unrecognized Device Type value " + this.deviceType + " dec");
                    stringBuffer.append("\n");
                }
            }
            if (this.mainsFrequency >= mainsFrequencyDescriptors.length || mainsFrequencyDescriptors[this.mainsFrequency] == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized Mains Frequency value " + this.deviceType + " dec");
                stringBuffer.append("\n");
            }
            if ((n = this.protocolCompatibilityLevel >> 4 & 0xF) < 9 || n > 12) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized Protocol Compatibility Level 0x" + Integer.toHexString(this.protocolCompatibilityLevel));
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.analysingProgramRevisionNumberLength;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("institutionNumber=");
            stringBuffer.append(this.institutionNumber);
            stringBuffer.append(", departmentNumber=");
            stringBuffer.append(this.departmentNumber);
            stringBuffer.append(", deviceID=");
            stringBuffer.append(this.deviceID);
            stringBuffer.append(", deviceType=");
            stringBuffer.append(this.deviceType);
            stringBuffer.append(", manufacturerCode=");
            stringBuffer.append(this.manufacturerCode);
            stringBuffer.append(", modelDescription=");
            stringBuffer.append(this.modelDescription == null ? "" : new String(this.modelDescription));
            stringBuffer.append(", protocolRevisionLevel=");
            stringBuffer.append(this.protocolRevisionLevel);
            stringBuffer.append(", protocolCompatibilityLevel=");
            stringBuffer.append(Integer.toHexString(this.protocolCompatibilityLevel));
            stringBuffer.append(", languageSupportCode=0x");
            stringBuffer.append(Integer.toHexString(this.languageSupportCode));
            stringBuffer.append(", capabilitiesCode=0x");
            stringBuffer.append(Integer.toHexString(this.capabilitiesCode));
            stringBuffer.append(", mainsFrequency=");
            stringBuffer.append(this.mainsFrequency);
            stringBuffer.append(", analysingProgramRevisionNumberLength=");
            stringBuffer.append(this.analysingProgramRevisionNumberLength);
            stringBuffer.append(", analysingProgramRevisionNumber=");
            stringBuffer.append(this.analysingProgramRevisionNumber == null ? "" : new String(this.analysingProgramRevisionNumber));
            return stringBuffer.toString();
        }
    }

    private class MedicalHistoryField
    extends Field {
        int codeTable;

        MedicalHistoryField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            int n = this.length;
            if (n >= 1) {
                this.codeTable = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
            }
            if (n > 0) {
                this.value = new byte[n];
                Section1.this.i.readInsistently(this.value, 0, n);
                Section1.this.sectionBytesRemaining -= (long)n;
                Section1.this.bytesRead += (long)n;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <codeTable=");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.codeTable);
            for (int i = 0; i < this.value.length; ++i) {
                stringBuffer.append(",");
                stringBuffer.append(this.value[i]);
            }
            return stringBuffer.toString();
        }
    }

    private class DrugField
    extends Field {
        int drugClass;
        int drugCode;
        int textLength;

        DrugField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            int n = this.length;
            if (n >= 1) {
                this.drugClass = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
            }
            if (n >= 1) {
                this.drugCode = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
            }
            if (n >= 1) {
                this.textLength = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                --n;
            }
            if (n > 0) {
                this.value = new byte[n];
                Section1.this.i.readInsistently(this.value, 0, n);
                Section1.this.sectionBytesRemaining -= (long)n;
                Section1.this.bytesRead += (long)n;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.drugClass);
            stringBuffer.append(",");
            stringBuffer.append(this.drugCode);
            stringBuffer.append(",");
            stringBuffer.append(this.textLength);
            stringBuffer.append(",");
            stringBuffer.append(this.value == null ? "" : Section.makeStringFromByteArrayRemovingAnyNulls(this.value));
            return stringBuffer.toString();
        }
    }

    private class BinaryField
    extends Field {
        int bvalue;

        BinaryField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            if (this.length == 2) {
                this.bvalue = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.bvalue);
            return stringBuffer.toString();
        }
    }

    private class TimeField
    extends Field {
        int hh;
        int mm;
        int ss;

        TimeField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            if (this.length == 3) {
                this.hh = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                this.mm = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                this.ss = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.hh < 0 || this.hh > 23) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": hours out of range " + this.hh + " dec");
                stringBuffer.append("\n");
            }
            if (this.mm < 0 || this.mm > 59) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": minutes out of range " + this.mm + " dec");
                stringBuffer.append("\n");
            }
            if (this.ss < 0 || this.ss > 59) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": seconds out of range " + this.ss + " dec");
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.hh);
            stringBuffer.append(":");
            stringBuffer.append(this.mm);
            stringBuffer.append(":");
            stringBuffer.append(this.ss);
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.hh);
            stringBuffer.append(":");
            stringBuffer.append(this.mm);
            stringBuffer.append(":");
            stringBuffer.append(this.ss);
            return stringBuffer.toString();
        }
    }

    private class DateField
    extends Field {
        int yyyy;
        int mm;
        int dd;

        DateField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            if (this.length == 4) {
                this.yyyy = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                this.mm = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                this.dd = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.dd != 0 || this.mm != 0 || this.yyyy != 0) {
                if (this.mm < 1 || this.mm > 12) {
                    stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                    stringBuffer.append(": month out of range " + this.mm + " dec");
                    stringBuffer.append("\n");
                }
                if (this.dd < 1 || this.dd > 31) {
                    stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                    stringBuffer.append(": day out of range " + this.dd + " dec");
                    stringBuffer.append("\n");
                }
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.yyyy);
            stringBuffer.append("/");
            stringBuffer.append(this.mm);
            stringBuffer.append("/");
            stringBuffer.append(this.dd);
            stringBuffer.append(">");
            stringBuffer.append(this.dd != 0 || this.mm != 0 || this.yyyy != 0 ? "" : " Unspecified");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.yyyy);
            stringBuffer.append("/");
            stringBuffer.append(this.mm);
            stringBuffer.append("/");
            stringBuffer.append(this.dd);
            return stringBuffer.toString();
        }
    }

    private class BitmapField
    extends Field {
        int code;
        String[] descriptors;

        BitmapField(int n, int n2, String[] stringArray) {
            this.tag = n;
            this.length = n2;
            this.descriptors = stringArray;
        }

        @Override
        void read() throws IOException {
            if (this.length == 1) {
                this.code = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append("> ");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" 0x");
            stringBuffer.append(Integer.toHexString(this.code));
            stringBuffer.append(" ");
            for (int i = 0; i < 8; ++i) {
                stringBuffer.append("Bit ");
                stringBuffer.append(i);
                if (i < this.descriptors.length && this.descriptors[i] != null) {
                    stringBuffer.append(" (");
                    stringBuffer.append(this.descriptors[i]);
                    stringBuffer.append(")");
                }
                stringBuffer.append(":");
                int n = this.code >> i & 1;
                stringBuffer.append(n);
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }

    private class TwinCodedValueField
    extends Field {
        int code1;
        int code2;
        String[] descriptors1;
        String[] descriptors2;

        TwinCodedValueField(int n, int n2, String[] stringArray, String[] stringArray2) {
            this.tag = n;
            this.length = n2;
            this.descriptors1 = stringArray;
            this.descriptors2 = stringArray2;
        }

        @Override
        void read() throws IOException {
            if (this.length == 2) {
                this.code1 = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
                this.code2 = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.code1 >= this.descriptors1.length || this.descriptors1[this.code1] == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized first code value " + this.code1 + " dec");
                stringBuffer.append("\n");
            }
            if (this.code2 >= this.descriptors2.length || this.descriptors2[this.code2] == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized second code value " + this.code2 + " dec");
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append("> ");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.code1);
            stringBuffer.append(" [");
            stringBuffer.append(this.code1 < this.descriptors1.length ? this.descriptors1[this.code1] : "Unrecognized");
            stringBuffer.append("], ");
            stringBuffer.append(this.code2);
            stringBuffer.append(" [");
            stringBuffer.append(this.code2 < this.descriptors2.length ? this.descriptors2[this.code2] : "Unrecognized");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private class SingleCodedValueField
    extends Field {
        int code;
        String[] descriptors;

        SingleCodedValueField(int n, int n2, String[] stringArray) {
            this.tag = n;
            this.length = n2;
            this.descriptors = stringArray;
        }

        @Override
        void read() throws IOException {
            if (this.length == 1) {
                this.code = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.code >= this.descriptors.length || this.descriptors[this.code] == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized code value " + this.code + " dec");
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append("> ");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.code);
            stringBuffer.append(" [");
            stringBuffer.append(this.code < this.descriptors.length ? this.descriptors[this.code] : "Unrecognized");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private class ValueWithUnitsField
    extends Field {
        int bvalue;
        int units;
        String[] unitDescriptors;

        ValueWithUnitsField(int n, int n2, String[] stringArray) {
            this.tag = n;
            this.length = n2;
            this.unitDescriptors = stringArray;
        }

        @Override
        void read() throws IOException {
            if (this.length == 3) {
                this.bvalue = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                this.units = Section1.this.i.readUnsigned8();
                ++Section1.this.bytesRead;
                --Section1.this.sectionBytesRemaining;
            } else if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.units >= this.unitDescriptors.length || this.unitDescriptors[this.units] == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized units " + this.units + " dec");
                stringBuffer.append("\n");
            }
            if (this.units == 0 && this.bvalue != 0) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": units are unspecified, but value is not zero (" + this.bvalue + " dec)");
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            return this.length;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.bvalue);
            stringBuffer.append(" ");
            stringBuffer.append(this.units < this.unitDescriptors.length ? this.unitDescriptors[this.units] : "Unrecognized");
            return stringBuffer.toString();
        }
    }

    private class TimeZoneField
    extends Field {
        int offset;
        int index;

        TimeZoneField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        void read() throws IOException {
            int n = this.length;
            if (n >= 2) {
                this.offset = Section1.this.i.readSigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                n -= 2;
            }
            if (n >= 2) {
                this.index = Section1.this.i.readUnsigned16();
                Section1.this.bytesRead += 2L;
                Section1.this.sectionBytesRemaining -= 2L;
                n -= 2;
            }
            if (n > 0) {
                this.value = new byte[n];
                Section1.this.i.readInsistently(this.value, 0, n);
                Section1.this.sectionBytesRemaining -= (long)n;
                Section1.this.bytesRead += (long)n;
            }
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            if (this.offset != Short.MAX_VALUE && (this.offset < -780 || this.offset > 780)) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": if specified (not 0x7fff), timezone offset must be +/- 780 minutes (13 hours), got " + this.offset + " dec (0x" + Integer.toHexString(this.offset & 0xFFFF) + ")");
                stringBuffer.append("\n");
            }
            if (this.offset != Short.MAX_VALUE && this.index != 0) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": index must not be used if timezone offset is used (not 0x7fff), got index of " + this.index + " dec");
                stringBuffer.append("\n");
            }
            if (this.offset != Short.MAX_VALUE && this.value != null && this.value.length != 0) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": timezone description must not be used if timezone offset is used (not 0x7fff)");
                stringBuffer.append("\n");
            }
            if (this.value != null && this.value.length == 1 && this.value[0] == 0) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": timezone description is present but undefined (null terminator only)");
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            int n;
            int n2 = n = this.value == null ? 0 : this.value.length;
            if (n != 0 && this.value[n - 1] == 0) {
                --n;
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append(">");
            return stringBuffer.toString();
        }

        @Override
        public String getValueAsString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("offset=");
            stringBuffer.append(this.offset);
            stringBuffer.append(", index=");
            stringBuffer.append(this.index);
            stringBuffer.append(", <");
            stringBuffer.append(this.value == null ? "" : new String(this.value));
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    private class TextField
    extends Field {
        TextField(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        @Override
        String validate() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.validate());
            return stringBuffer.toString();
        }

        @Override
        protected int getValueLengthForPurposeOfValidation() {
            int n;
            int n2 = n = this.value == null ? 0 : this.value.length;
            if (n != 0 && this.value[n - 1] == 0) {
                --n;
            }
            return n;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" <");
            stringBuffer.append(this.value == null ? "" : new String(this.value));
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }

    private class Field {
        int tag;
        int length;
        byte[] value;

        Field() {
        }

        Field(int n, int n2) {
            this.tag = n;
            this.length = n2;
        }

        void read() throws IOException {
            if (this.length > 0) {
                this.value = new byte[this.length];
                Section1.this.i.readInsistently(this.value, 0, this.length);
                Section1.this.sectionBytesRemaining -= (long)this.length;
                Section1.this.bytesRead += (long)this.length;
            }
        }

        boolean isTerminator() {
            return this.tag == 255;
        }

        String validate() {
            FieldDictionaryEntry fieldDictionaryEntry;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isTerminator() && this.length != 0) {
                stringBuffer.append("Terminator should be zero length but has length " + this.length + " dec (0x" + Integer.toHexString(this.length) + ")\n");
            }
            if ((fieldDictionaryEntry = Section1.this.getDictionaryFieldByTag(this.tag)) == null) {
                stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
                stringBuffer.append(": Unrecognized tag");
                stringBuffer.append("\n");
            } else {
                int n = this.getValueLengthForPurposeOfValidation();
                if (n > fieldDictionaryEntry.maximumLength) {
                    stringBuffer.append(Section1.this.describeFieldBriefly(fieldDictionaryEntry));
                    stringBuffer.append(": Length of ");
                    stringBuffer.append(n);
                    stringBuffer.append(" exceeds maximum length of ");
                    stringBuffer.append(fieldDictionaryEntry.maximumLength);
                    stringBuffer.append("\n");
                } else if (n > fieldDictionaryEntry.reasonableLength) {
                    stringBuffer.append(Section1.this.describeFieldBriefly(fieldDictionaryEntry));
                    stringBuffer.append(": Length of ");
                    stringBuffer.append(n);
                    stringBuffer.append(" exceeds reasonable length of ");
                    stringBuffer.append(fieldDictionaryEntry.reasonableLength);
                    stringBuffer.append("\n");
                }
            }
            return stringBuffer.toString();
        }

        protected int getValueLengthForPurposeOfValidation() {
            return this.value == null ? 0 : this.value.length;
        }

        public String toStringBrief() {
            return Section1.this.describeFieldBriefly(this.tag);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Section1.this.describeFieldBriefly(this.tag));
            stringBuffer.append(" Length=");
            stringBuffer.append(this.length);
            return stringBuffer.toString();
        }

        public String getValueAsString() {
            return this.value == null ? "" : Section.makeStringFromByteArrayRemovingAnyNulls(this.value);
        }
    }

    private class FieldDictionaryEntry {
        String name;
        int tag;
        int requirement;
        int multiplicity;
        int maximumLength;
        int reasonableLength;
        String className;

        FieldDictionaryEntry(String string, int n, int n2, int n3, int n4, int n5, String string2) {
            this.name = string;
            this.tag = n;
            this.requirement = n2;
            this.multiplicity = n3;
            this.maximumLength = n4;
            this.reasonableLength = n5;
            this.className = string2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\tTag " + this.tag + " dec (0x" + Integer.toHexString(this.tag) + ")");
            stringBuffer.append("\tName " + this.name);
            return stringBuffer.toString();
        }
    }
}

