/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;

public class Section10
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section10.java,v 1.15 2025/01/29 10:58:09 dclunie Exp $";
    private int numberOfLeads;
    private int manufacturerSpecific;
    private int[] leadID;
    private int[] lengthOfRecord;
    private int[] Pduration;
    private int[] PRInterval;
    private int[] QRSDuration;
    private int[] QTInterval;
    private int[] QDuration;
    private int[] RDuration;
    private int[] SDuration;
    private int[] RPrimeDuration;
    private int[] SPrimeDuration;
    private int[] QAmplitude;
    private int[] RAmplitude;
    private int[] SAmplitude;
    private int[] RPrimeAmplitude;
    private int[] SPrimeAmplitude;
    private int[] JPointAmplitude;
    private int[] PPlusAmplitude;
    private int[] PMinusAmplitude;
    private int[] TPlusAmplitude;
    private int[] TMinusAmplitude;
    private int[] STSlope;
    private int[] PMorphology;
    private int[] TMorphology;
    private int[] isoElectricSegmentAtQRSOnset;
    private int[] isoElectricSegmentAtQRSEnd;
    private int[] intrinsicoidDeflection;
    private int[] qualityCode;
    private int[] STAmplitudeJPointPlus20ms;
    private int[] STAmplitudeJPointPlus60ms;
    private int[] STAmplitudeJPointPlus80ms;
    private int[] STAmplitudeJPointPlusSixteenthAverageRRInterval;
    private int[] STAmplitudeJPointPlusEighthAverageRRInterval;

    @Override
    public String getSectionName() {
        return "Lead Measurement Results";
    }

    public int getNumberOfLeads() {
        return this.numberOfLeads;
    }

    public int getManufacturerSpecific() {
        return this.manufacturerSpecific;
    }

    public int[] getLeadID() {
        return this.leadID;
    }

    public int[] getLengthOfRecord() {
        return this.lengthOfRecord;
    }

    public int[] getPduration() {
        return this.Pduration;
    }

    public int[] getPRInterval() {
        return this.PRInterval;
    }

    public int[] getQRSDuration() {
        return this.QRSDuration;
    }

    public int[] getQTInterval() {
        return this.QTInterval;
    }

    public int[] getQDuration() {
        return this.QDuration;
    }

    public int[] getRDuration() {
        return this.RDuration;
    }

    public int[] getSDuration() {
        return this.SDuration;
    }

    public int[] getRPrimeDuration() {
        return this.RPrimeDuration;
    }

    public int[] getSPrimeDuration() {
        return this.SPrimeDuration;
    }

    public int[] getQAmplitude() {
        return this.QAmplitude;
    }

    public int[] getRAmplitude() {
        return this.RAmplitude;
    }

    public int[] getSAmplitude() {
        return this.SAmplitude;
    }

    public int[] getRPrimeAmplitude() {
        return this.RPrimeAmplitude;
    }

    public int[] getSPrimeAmplitude() {
        return this.SPrimeAmplitude;
    }

    public int[] getJPointAmplitude() {
        return this.JPointAmplitude;
    }

    public int[] getPPlusAmplitude() {
        return this.PPlusAmplitude;
    }

    public int[] getPMinusAmplitude() {
        return this.PMinusAmplitude;
    }

    public int[] getTPlusAmplitude() {
        return this.TPlusAmplitude;
    }

    public int[] getTMinusAmplitude() {
        return this.TMinusAmplitude;
    }

    public int[] getSTSlope() {
        return this.STSlope;
    }

    public int[] getPMorphology() {
        return this.PMorphology;
    }

    public int[] getTMorphology() {
        return this.TMorphology;
    }

    public int[] getIsoElectricSegmentAtQRSOnset() {
        return this.isoElectricSegmentAtQRSOnset;
    }

    public int[] getIsoElectricSegmentAtQRSEnd() {
        return this.isoElectricSegmentAtQRSEnd;
    }

    public int[] getIntrinsicoidDeflection() {
        return this.intrinsicoidDeflection;
    }

    public int[] getQualityCode() {
        return this.qualityCode;
    }

    public int[] getSTAmplitudeJPointPlus20ms() {
        return this.STAmplitudeJPointPlus20ms;
    }

    public int[] getSTAmplitudeJPointPlus60ms() {
        return this.STAmplitudeJPointPlus60ms;
    }

    public int[] getSTAmplitudeJPointPlus80ms() {
        return this.STAmplitudeJPointPlus80ms;
    }

    public int[] getSTAmplitudeJPointPlusSixteenthAverageRRInterval() {
        return this.STAmplitudeJPointPlusSixteenthAverageRRInterval;
    }

    public int[] getSTAmplitudeJPointPlusEighthAverageRRInterval() {
        return this.STAmplitudeJPointPlusEighthAverageRRInterval;
    }

    public Section10(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    @Override
    public long read(BinaryInputStream binaryInputStream) throws IOException {
        int n;
        this.numberOfLeads = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.manufacturerSpecific = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.leadID = new int[this.numberOfLeads];
        this.lengthOfRecord = new int[this.numberOfLeads];
        this.Pduration = new int[this.numberOfLeads];
        this.PRInterval = new int[this.numberOfLeads];
        this.QRSDuration = new int[this.numberOfLeads];
        this.QTInterval = new int[this.numberOfLeads];
        this.QDuration = new int[this.numberOfLeads];
        this.RDuration = new int[this.numberOfLeads];
        this.SDuration = new int[this.numberOfLeads];
        this.RPrimeDuration = new int[this.numberOfLeads];
        this.SPrimeDuration = new int[this.numberOfLeads];
        this.QAmplitude = new int[this.numberOfLeads];
        this.RAmplitude = new int[this.numberOfLeads];
        this.SAmplitude = new int[this.numberOfLeads];
        this.RPrimeAmplitude = new int[this.numberOfLeads];
        this.SPrimeAmplitude = new int[this.numberOfLeads];
        this.JPointAmplitude = new int[this.numberOfLeads];
        this.PPlusAmplitude = new int[this.numberOfLeads];
        this.PMinusAmplitude = new int[this.numberOfLeads];
        this.TPlusAmplitude = new int[this.numberOfLeads];
        this.TMinusAmplitude = new int[this.numberOfLeads];
        this.STSlope = new int[this.numberOfLeads];
        this.PMorphology = new int[this.numberOfLeads];
        this.TMorphology = new int[this.numberOfLeads];
        this.isoElectricSegmentAtQRSOnset = new int[this.numberOfLeads];
        this.isoElectricSegmentAtQRSEnd = new int[this.numberOfLeads];
        this.intrinsicoidDeflection = new int[this.numberOfLeads];
        this.qualityCode = new int[this.numberOfLeads];
        this.STAmplitudeJPointPlus20ms = new int[this.numberOfLeads];
        this.STAmplitudeJPointPlus60ms = new int[this.numberOfLeads];
        this.STAmplitudeJPointPlus80ms = new int[this.numberOfLeads];
        this.STAmplitudeJPointPlusSixteenthAverageRRInterval = new int[this.numberOfLeads];
        this.STAmplitudeJPointPlusEighthAverageRRInterval = new int[this.numberOfLeads];
        for (n = 0; n < this.numberOfLeads; ++n) {
            this.Pduration[n] = 29999;
            this.PRInterval[n] = 29999;
            this.QRSDuration[n] = 29999;
            this.QTInterval[n] = 29999;
            this.QDuration[n] = 29999;
            this.RDuration[n] = 29999;
            this.SDuration[n] = 29999;
            this.RPrimeDuration[n] = 29999;
            this.SPrimeDuration[n] = 29999;
            this.QAmplitude[n] = 29999;
            this.RAmplitude[n] = 29999;
            this.SAmplitude[n] = 29999;
            this.RPrimeAmplitude[n] = 29999;
            this.SPrimeAmplitude[n] = 29999;
            this.JPointAmplitude[n] = 29999;
            this.PPlusAmplitude[n] = 29999;
            this.PMinusAmplitude[n] = 29999;
            this.TPlusAmplitude[n] = 29999;
            this.TMinusAmplitude[n] = 29999;
            this.STSlope[n] = 29999;
            this.PMorphology[n] = 29999;
            this.TMorphology[n] = 29999;
            this.isoElectricSegmentAtQRSOnset[n] = 29999;
            this.isoElectricSegmentAtQRSEnd[n] = 29999;
            this.intrinsicoidDeflection[n] = 29999;
            this.qualityCode[n] = 29999;
            this.STAmplitudeJPointPlus20ms[n] = 29999;
            this.STAmplitudeJPointPlus60ms[n] = 29999;
            this.STAmplitudeJPointPlus80ms[n] = 29999;
            this.STAmplitudeJPointPlusSixteenthAverageRRInterval[n] = 29999;
            this.STAmplitudeJPointPlusEighthAverageRRInterval[n] = 29999;
        }
        for (n = 0; this.sectionBytesRemaining > 0L && n < this.numberOfLeads; ++n) {
            this.leadID[n] = binaryInputStream.readSigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.lengthOfRecord[n] = binaryInputStream.readSigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            int n2 = this.lengthOfRecord[n];
            if (n2 <= 0) {
                System.err.println("Section 10 Length of record for Lead " + n + " invalid, specified as " + this.lengthOfRecord[n] + " dec bytes, so give up on section, though " + this.sectionBytesRemaining + " dec bytes remaining");
                break;
            }
            if ((long)n2 > this.sectionBytesRemaining) {
                System.err.println("Section 10 Length of record for Lead " + n + " is " + n2 + " which is larger than left in section " + this.sectionBytesRemaining + " dec bytes, so give up on section");
                break;
            }
            if (n2 >= 2) {
                this.Pduration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.PRInterval[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.QRSDuration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.QTInterval[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.QDuration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.RDuration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.SDuration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.RPrimeDuration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.SPrimeDuration[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.QAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.RAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.SAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.RPrimeAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.SPrimeAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.JPointAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.PPlusAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.PMinusAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.TPlusAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.TMinusAmplitude[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.STSlope[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.PMorphology[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.TMorphology[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.isoElectricSegmentAtQRSOnset[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.isoElectricSegmentAtQRSEnd[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.intrinsicoidDeflection[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.qualityCode[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.STAmplitudeJPointPlus20ms[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.STAmplitudeJPointPlus60ms[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.STAmplitudeJPointPlus80ms[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.STAmplitudeJPointPlusSixteenthAverageRRInterval[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 >= 2) {
                this.STAmplitudeJPointPlusEighthAverageRRInterval[n] = binaryInputStream.readSigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                n2 -= 2;
            }
            if (n2 <= 0) continue;
            binaryInputStream.skipInsistently(n2);
            this.bytesRead += (long)n2;
            this.sectionBytesRemaining -= (long)n2;
            n2 = 0;
        }
        if (n != this.numberOfLeads) {
            System.err.println("Section 10 Number of leads specified as " + this.numberOfLeads + " but encountered only " + n + " lead measurements");
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Leads:\n");
        for (int i = 0; i < this.numberOfLeads; ++i) {
            stringBuffer.append("\tLead " + i + ":\n");
            stringBuffer.append("\t\t leadID " + this.leadID[i] + "\n");
            stringBuffer.append("\t\t lengthOfRecord " + this.lengthOfRecord[i] + "\n");
            stringBuffer.append("\t\t Pduration " + this.Pduration[i] + " " + Section10.describeMissingValues(this.Pduration[i]) + "\n");
            stringBuffer.append("\t\t PRInterval " + this.PRInterval[i] + " " + Section10.describeMissingValues(this.PRInterval[i]) + "\n");
            stringBuffer.append("\t\t QRSDuration " + this.QRSDuration[i] + " " + Section10.describeMissingValues(this.QRSDuration[i]) + "\n");
            stringBuffer.append("\t\t QTInterval " + this.QTInterval[i] + " " + Section10.describeMissingValues(this.QTInterval[i]) + "\n");
            stringBuffer.append("\t\t QDuration " + this.QDuration[i] + " " + Section10.describeMissingValues(this.QDuration[i]) + "\n");
            stringBuffer.append("\t\t RDuration " + this.RDuration[i] + " " + Section10.describeMissingValues(this.RDuration[i]) + "\n");
            stringBuffer.append("\t\t SDuration " + this.SDuration[i] + " " + Section10.describeMissingValues(this.SDuration[i]) + "\n");
            stringBuffer.append("\t\t RPrimeDuration " + this.RPrimeDuration[i] + " " + Section10.describeMissingValues(this.RPrimeDuration[i]) + "\n");
            stringBuffer.append("\t\t SPrimeDuration " + this.SPrimeDuration[i] + " " + Section10.describeMissingValues(this.SPrimeDuration[i]) + "\n");
            stringBuffer.append("\t\t QAmplitude " + this.QAmplitude[i] + " " + Section10.describeMissingValues(this.QAmplitude[i]) + "\n");
            stringBuffer.append("\t\t RAmplitude " + this.RAmplitude[i] + " " + Section10.describeMissingValues(this.RAmplitude[i]) + "\n");
            stringBuffer.append("\t\t SAmplitude " + this.SAmplitude[i] + " " + Section10.describeMissingValues(this.SAmplitude[i]) + "\n");
            stringBuffer.append("\t\t RPrimeAmplitude " + this.RPrimeAmplitude[i] + " " + Section10.describeMissingValues(this.RPrimeAmplitude[i]) + "\n");
            stringBuffer.append("\t\t SPrimeAmplitude " + this.SPrimeAmplitude[i] + " " + Section10.describeMissingValues(this.SPrimeAmplitude[i]) + "\n");
            stringBuffer.append("\t\t JPointAmplitude " + this.JPointAmplitude[i] + " " + Section10.describeMissingValues(this.JPointAmplitude[i]) + "\n");
            stringBuffer.append("\t\t PPlusAmplitude " + this.PPlusAmplitude[i] + " " + Section10.describeMissingValues(this.PPlusAmplitude[i]) + "\n");
            stringBuffer.append("\t\t PMinusAmplitude " + this.PMinusAmplitude[i] + " " + Section10.describeMissingValues(this.PMinusAmplitude[i]) + "\n");
            stringBuffer.append("\t\t TPlusAmplitude " + this.TPlusAmplitude[i] + " " + Section10.describeMissingValues(this.TPlusAmplitude[i]) + "\n");
            stringBuffer.append("\t\t TMinusAmplitude " + this.TMinusAmplitude[i] + " " + Section10.describeMissingValues(this.TMinusAmplitude[i]) + "\n");
            stringBuffer.append("\t\t STSlope " + this.STSlope[i] + " " + Section10.describeMissingValues(this.STSlope[i]) + "\n");
            stringBuffer.append("\t\t PMorphology " + this.PMorphology[i] + " " + Section10.describeMissingValues(this.PMorphology[i]) + "\n");
            stringBuffer.append("\t\t TMorphology " + this.TMorphology[i] + " " + Section10.describeMissingValues(this.TMorphology[i]) + "\n");
            stringBuffer.append("\t\t isoElectricSegmentAtQRSOnset " + this.isoElectricSegmentAtQRSOnset[i] + " " + Section10.describeMissingValues(this.isoElectricSegmentAtQRSOnset[i]) + "\n");
            stringBuffer.append("\t\t isoElectricSegmentAtQRSEnd " + this.isoElectricSegmentAtQRSEnd[i] + " " + Section10.describeMissingValues(this.isoElectricSegmentAtQRSEnd[i]) + "\n");
            stringBuffer.append("\t\t intrinsicoidDeflection " + this.intrinsicoidDeflection[i] + " " + Section10.describeMissingValues(this.intrinsicoidDeflection[i]) + "\n");
            stringBuffer.append("\t\t qualityCode " + this.qualityCode[i] + " " + Section10.describeMissingValues(this.qualityCode[i]) + "\n");
            stringBuffer.append("\t\t STAmplitudeJPointPlus20ms " + this.STAmplitudeJPointPlus20ms[i] + " " + Section10.describeMissingValues(this.STAmplitudeJPointPlus20ms[i]) + "\n");
            stringBuffer.append("\t\t STAmplitudeJPointPlus60ms " + this.STAmplitudeJPointPlus60ms[i] + " " + Section10.describeMissingValues(this.STAmplitudeJPointPlus60ms[i]) + "\n");
            stringBuffer.append("\t\t STAmplitudeJPointPlus80ms " + this.STAmplitudeJPointPlus80ms[i] + " " + Section10.describeMissingValues(this.STAmplitudeJPointPlus80ms[i]) + "\n");
            stringBuffer.append("\t\t STAmplitudeJPointPlusSixteenthAverageRRInterval " + this.STAmplitudeJPointPlusSixteenthAverageRRInterval[i] + " " + Section10.describeMissingValues(this.STAmplitudeJPointPlusSixteenthAverageRRInterval[i]) + "\n");
            stringBuffer.append("\t\t STAmplitudeJPointPlusEighthAverageRRInterval " + this.STAmplitudeJPointPlusEighthAverageRRInterval[i] + " " + Section10.describeMissingValues(this.STAmplitudeJPointPlusEighthAverageRRInterval[i]) + "\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String validate() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numberOfLeads; ++i) {
            if (this.PMorphology[i] < 0 || this.PMorphology[i] > 8) {
                stringBuffer.append("Section 7 P-Morphology for lead ");
                stringBuffer.append(i);
                stringBuffer.append(" has unrecognized value ");
                stringBuffer.append(this.PMorphology[i]);
                stringBuffer.append(" dec\n");
            }
            if (this.TMorphology[i] >= 0 && this.TMorphology[i] <= 8) continue;
            stringBuffer.append("Section 7 T-Morphology for lead ");
            stringBuffer.append(i);
            stringBuffer.append(" has unrecognized value ");
            stringBuffer.append(this.TMorphology[i]);
            stringBuffer.append(" dec\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            SCPTreeRecord sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord2, "Lead measurements");
            for (int i = 0; i < this.numberOfLeads; ++i) {
                SCPTreeRecord sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Lead", Integer.toString(i + 1));
                Section10.addNodeOfDecimalAndHex(sCPTreeRecord4, "Lead ID", this.leadID[i]);
                Section10.addNodeOfDecimalAndHex(sCPTreeRecord4, "Length of Record", this.lengthOfRecord[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "P Duration", this.Pduration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "PR Interval", this.PRInterval[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "QRS Duration", this.QRSDuration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "QT Interval", this.QTInterval[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "Q Duration", this.QDuration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "R Duration", this.RDuration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "S Duration", this.SDuration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "R Prime Duration", this.RPrimeDuration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "S Prime Duration", this.SPrimeDuration[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "Q Amplitude", this.QAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "R Amplitude", this.RAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "S Amplitude", this.SAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "R Prime Amplitude", this.RPrimeAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "S Prime Amplitude", this.SPrimeAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "J Point Amplitude", this.JPointAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "P(+) Amplitude", this.PPlusAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "P(-) Amplitude", this.PMinusAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "T(+) Amplitude", this.TPlusAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "T(-) Amplitude", this.TMinusAmplitude[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "ST Slope", this.STSlope[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "P Morphology", this.PMorphology[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "T Morphology", this.TMorphology[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "Isoelectric Segment at QRS Onset", this.isoElectricSegmentAtQRSOnset[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "Isoelectric Segment at QRS End", this.isoElectricSegmentAtQRSEnd[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "Intrinsicoid Deflection", this.intrinsicoidDeflection[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "Quality Code", this.qualityCode[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "ST Amplitude JPoint + 20ms", this.STAmplitudeJPointPlus20ms[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "ST Amplitude JPoint + 60ms", this.STAmplitudeJPointPlus60ms[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "ST Amplitude JPoint + 80ms", this.STAmplitudeJPointPlus80ms[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "ST Amplitude JPoint + 1/16th Average RR Interval", this.STAmplitudeJPointPlusSixteenthAverageRRInterval[i]);
                Section10.addNodeOfDecimalWithMissingValues(sCPTreeRecord4, "ST Amplitude JPoint + 1/8th Average RR Interval", this.STAmplitudeJPointPlusEighthAverageRRInterval[i]);
            }
        }
        return this.tree;
    }
}

