/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.server;

import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.RequestTypeServer;
import com.pixelmed.web.WebServerApplicationProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class DicomAndWebStorageServer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/server/DicomAndWebStorageServer.java,v 1.38 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DicomAndWebStorageServer.class);
    protected DatabaseInformationModel databaseInformationModel;

    public DicomAndWebStorageServer(Properties properties) throws IOException, DicomException, DicomNetworkException {
        this.doCommonConstructorStuff(properties, null);
    }

    public DicomAndWebStorageServer(Properties properties, DatabaseInformationModel databaseInformationModel) throws IOException, DicomException, DicomNetworkException {
        this.doCommonConstructorStuff(properties, databaseInformationModel);
    }

    protected void doCommonConstructorStuff(Properties properties, DatabaseInformationModel databaseInformationModel) throws IOException, DicomException, DicomNetworkException {
        DatabaseApplicationProperties databaseApplicationProperties = new DatabaseApplicationProperties(properties);
        File file = databaseApplicationProperties.getSavedImagesFolderCreatingItIfNecessary();
        if (databaseInformationModel == null) {
            slf4jlogger.debug("doCommonConstructorStuff(): No databaseInformationModel specified so using default PatientStudySeriesConcatenationInstanceModel");
            this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(databaseApplicationProperties.getDatabaseFileName(), databaseApplicationProperties.getDatabaseServerName());
        } else {
            this.databaseInformationModel = databaseInformationModel;
        }
        NetworkApplicationProperties networkApplicationProperties = new NetworkApplicationProperties(properties);
        NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
        WebServerApplicationProperties webServerApplicationProperties = new WebServerApplicationProperties(properties);
        networkApplicationInformationFederated.startupAllKnownSourcesAndRegister(networkApplicationProperties, webServerApplicationProperties);
        slf4jlogger.debug("doCommonConstructorStuff(): Starting up DICOM association listener ...");
        int n = networkApplicationProperties.getListeningPort();
        String string = networkApplicationProperties.getCalledAETitle();
        new Thread(new StorageSOPClassSCPDispatcher(n, string, networkApplicationProperties.getAcceptorMaximumLengthReceived(), networkApplicationProperties.getAcceptorSocketReceiveBufferSize(), networkApplicationProperties.getAcceptorSocketSendBufferSize(), file, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, new OurReceivedObjectHandler(), this.databaseInformationModel.getQueryResponseGeneratorFactory(), this.databaseInformationModel.getRetrieveResponseGeneratorFactory(), networkApplicationInformationFederated, false)).start();
        new Thread(new RequestTypeServer(this.databaseInformationModel, webServerApplicationProperties)).start();
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : ".com.pixelmed.server.DicomAndWebStorageServer.properties";
        try {
            Properties properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                properties.put("Dicom.ListeningPort", "11112");
                properties.put("Dicom.CalledAETitle", "STORESCP");
                properties.put("Dicom.CallingAETitle", "STORESCP");
                properties.put("Dicom.PrimaryDeviceType", "ARCHIVE");
                properties.put("Application.SavedImagesFolderName", "tmp");
            }
            slf4jlogger.info("properties=\n{}", properties);
            new DicomAndWebStorageServer(properties);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    DicomAndWebStorageServer.this.databaseInformationModel.insertObject(attributeList, string, "C");
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to insert {} received from {} in {} into database", string, string3, string2, exception);
                }
            }
        }
    }
}

