/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAttributeListReadTerminationStrategy
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";

    public TestAttributeListReadTerminationStrategy(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAttributeListReadTerminationStrategy");
        testSuite.addTest((Test)new TestAttributeListReadTerminationStrategy("TestAttributeListReadTerminationStrategy_SpecificAttribute"));
        testSuite.addTest((Test)new TestAttributeListReadTerminationStrategy("TestAttributeListReadTerminationStrategy_SpecificAttributeWithMetaHeader"));
        testSuite.addTest((Test)new TestAttributeListReadTerminationStrategy("TestAttributeListReadTerminationStrategy_TagRange"));
        testSuite.addTest((Test)new TestAttributeListReadTerminationStrategy("TestAttributeListReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader"));
        testSuite.addTest((Test)new TestAttributeListReadTerminationStrategy("TestAttributeListReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader"));
        testSuite.addTest((Test)new TestAttributeListReadTerminationStrategy("TestAttributeListReadTerminationStrategy_SpecificAttributeWithinSequence"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(string);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(string2);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(string3);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    public void TestAttributeListReadTerminationStrategy_SpecificAttribute() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestAttributeListReadTerminationStrategy_SpecificAttribute", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        OurReadTerminationStrategy_SpecificAttribute ourReadTerminationStrategy_SpecificAttribute = new OurReadTerminationStrategy_SpecificAttribute();
        attributeList.read(file, (AttributeList.ReadTerminationStrategy)ourReadTerminationStrategy_SpecificAttribute);
        Attribute attribute = attributeList.get(TagFromName.StudyDate);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking StudyDate was read", (attribute != null ? 1 : 0) != 0);
        TestAttributeListReadTerminationStrategy.assertEquals((String)"Checking StudyDate value", (String)this.studyDate, (String)attribute.getSingleStringValueOrNull());
        attribute = attributeList.get(TagFromName.PatientAge);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking PatientAge was not read", (attribute == null ? 1 : 0) != 0);
    }

    public void TestAttributeListReadTerminationStrategy_SpecificAttributeWithMetaHeader() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestAttributeListReadTerminationStrategy_SpecificAttributeWithMetaHeader", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        OurReadTerminationStrategy_SpecificAttribute ourReadTerminationStrategy_SpecificAttribute = new OurReadTerminationStrategy_SpecificAttribute();
        attributeList.read(file, (AttributeList.ReadTerminationStrategy)ourReadTerminationStrategy_SpecificAttribute);
        Attribute attribute = attributeList.get(TagFromName.StudyDate);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking StudyDate was read", (attribute != null ? 1 : 0) != 0);
        TestAttributeListReadTerminationStrategy.assertEquals((String)"Checking StudyDate value", (String)this.studyDate, (String)attribute.getSingleStringValueOrNull());
        attribute = attributeList.get(TagFromName.PatientAge);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking PatientAge was not read", (attribute == null ? 1 : 0) != 0);
    }

    public void TestAttributeListReadTerminationStrategy_TagRange() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestAttributeListReadTerminationStrategy_TagRange", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        OurReadTerminationStrategy_TagRange ourReadTerminationStrategy_TagRange = new OurReadTerminationStrategy_TagRange();
        attributeList.read(file, (AttributeList.ReadTerminationStrategy)ourReadTerminationStrategy_TagRange);
        Attribute attribute = attributeList.get(TagFromName.StudyDate);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking StudyDate was read", (attribute != null ? 1 : 0) != 0);
        TestAttributeListReadTerminationStrategy.assertEquals((String)"Checking StudyDate value", (String)this.studyDate, (String)attribute.getSingleStringValueOrNull());
        attribute = attributeList.get(TagFromName.PatientAge);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking PatientAge was not read", (attribute == null ? 1 : 0) != 0);
    }

    public void TestAttributeListReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestAttributeListReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        OurReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader ourReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader = new OurReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader();
        attributeList.read(file, (AttributeList.ReadTerminationStrategy)ourReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader);
        Attribute attribute = attributeList.get(TagFromName.StudyDate);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking StudyDate was read", (attribute != null ? 1 : 0) != 0);
        TestAttributeListReadTerminationStrategy.assertEquals((String)"Checking StudyDate value", (String)this.studyDate, (String)attribute.getSingleStringValueOrNull());
        attribute = attributeList.get(TagFromName.PatientAge);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking PatientAge was not read", (attribute == null ? 1 : 0) != 0);
    }

    public void TestAttributeListReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestAttributeListReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        OurReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader ourReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader = new OurReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader();
        attributeList.read(file, (AttributeList.ReadTerminationStrategy)ourReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader);
        Attribute attribute = attributeList.get(TagFromName.StudyDate);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking StudyDate was read", (attribute != null ? 1 : 0) != 0);
        TestAttributeListReadTerminationStrategy.assertEquals((String)"Checking StudyDate value", (String)this.studyDate, (String)attribute.getSingleStringValueOrNull());
        attribute = attributeList.get(TagFromName.PatientAge);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking PatientAge was not read", (attribute == null ? 1 : 0) != 0);
    }

    public void TestAttributeListReadTerminationStrategy_SpecificAttributeWithinSequence() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestAttributeListReadTerminationStrategy_SpecificAttributeWithinSequence", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new SequenceAttribute(TagFromName.RequestAttributesSequence);
        attributeList.put((Attribute)object);
        Object object2 = new AttributeList();
        ((SequenceAttribute)object).addItem((AttributeList)object2);
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.RequestedProcedureCodeSequence);
        ((AttributeList)object2).put(sequenceAttribute);
        AttributeList attributeList2 = new CodedSequenceItem("43254", "99BLA", "CT Brain").getAttributeList();
        sequenceAttribute.addItem(attributeList2);
        attributeList.put(new SequenceAttribute(TagFromName.RelevantInformationSequence));
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        object = new OurReadTerminationStrategy_SpecificAttributeWithinSequence();
        attributeList.read(file, (AttributeList.ReadTerminationStrategy)object);
        object2 = attributeList.get(TagFromName.StudyDate);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking StudyDate was read", (object2 != null ? 1 : 0) != 0);
        TestAttributeListReadTerminationStrategy.assertEquals((String)"Checking StudyDate value", (String)this.studyDate, (String)((Attribute)object2).getSingleStringValueOrNull());
        object2 = attributeList.get(TagFromName.RelevantInformationSequence);
        TestAttributeListReadTerminationStrategy.assertTrue((String)"Checking Relevant\u200bInformation\u200bSequence was read", (object2 != null ? 1 : 0) != 0);
    }

    private class OurReadTerminationStrategy_SpecificAttributeWithinSequence
    implements AttributeList.ReadTerminationStrategy {
        private OurReadTerminationStrategy_SpecificAttributeWithinSequence() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.equals(TagFromName.CodingSchemeDesignator);
        }
    }

    private class OurReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader
    implements AttributeList.ReadTerminationStrategy {
        private OurReadTerminationStrategy_ByteOffset_PreambleButNoMetaInformationHeader() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return l >= 256L;
        }
    }

    private class OurReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader
    implements AttributeList.ReadTerminationStrategy {
        private OurReadTerminationStrategy_ByteOffset_NoPreambleNoMetaInformationHeader() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return l >= 124L;
        }
    }

    private class OurReadTerminationStrategy_TagRange
    implements AttributeList.ReadTerminationStrategy {
        private OurReadTerminationStrategy_TagRange() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.getGroup() >= TagFromName.PatientID.getGroup();
        }
    }

    private class OurReadTerminationStrategy_SpecificAttribute
    implements AttributeList.ReadTerminationStrategy {
        private OurReadTerminationStrategy_SpecificAttribute() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.equals(TagFromName.PatientID);
        }
    }
}

